<?php

namespace App\Http\Requests\Validators\Finance;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 绩效明细验证器
class WashPerformanceValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '参数类型错误',
            'pri_id.min' => '参数类型错误',
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
            'pewo_service_adm_id.required_if' => '请输入技师id',
            'pewo_service_adm_id.integer' => '参数类型错误',
            'pewo_service_adm_id.min' => '参数类型错误',
            'wor_id.required_if' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'pewo_service_adm_id' => 'required_if:type,2|integer|min:1',
            'wor_id' => 'required_if:type,1|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
