<?php

namespace App\Http\Requests\Validators\BasicManagement;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

class MeritPayValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 绩效管理-列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '参数类型错误',
            'pri_id.min' => '参数类型错误',
            'pema_type.required' => '参数类型错误',
            'pema_type.in' => '参数类型错误',
            'pema_name.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1',//权限id
            'pema_name' => 'sometimes|nullable|max:20',//查询名称
            'pema_type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 新增
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pema_type.required' => '参数类型错误',
            'pema_type.in' => '参数类型错误',
            'pema_service_type_id.required' => '请选择服务类型',
            'pema_service_type_id.integer' => '服务类型参数错误',
            'pema_service_type_id.min' => '参数类型错误',
            'pema_service_type_name.required' => '请选择服务类型',
            'pema_service_type_name.max' => '参数类型错误',
            'pema_name.required' => '请输入异常名称',
            'pema_name.max' => '参数类型错误',
            'pema_remark.max' => '参数类型错误',
            'pema_grpr_id.required' => '请选择职位',
            'pema_grpr_id.integer' => '参数类型错误',
            'pema_grpr_id.min' => '参数类型错误',
            'pema_grle_id.required' => '请选择级别',
            'pema_grle_id.integer' => '参数类型错误',
            'pema_grle_id.min' => '参数类型错误',
            'pema_standard.required' => '请输入标准金额',
            'pema_standard.numeric' => '参数类型错误',
            'pema_standard.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pema_remark' => 'sometimes|nullable|max:255',//备注
            'pema_name' => 'required|max:20',//名称
            'pema_service_type_name' => 'required|max:20',//服务类型名称
            'pema_service_type_id' => 'required|integer|min:1',//服务类型
            'pema_grpr_id' => 'required|integer|min:1',//职位id
            'pema_grle_id' => 'required|integer|min:1',//级别id
            'pema_standard' => 'required|numeric|min:1',//标准金额
            'pema_type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
            'pema_type.required' => '参数类型错误',
            'pema_type.in' => '参数类型错误',
            'pema_service_type_id.required' => '请选择服务类型',
            'pema_service_type_id.integer' => '服务类型参数错误',
            'pema_service_type_id.min' => '参数类型错误',
            'pema_service_type_name.required' => '请选择服务类型',
            'pema_service_type_name.max' => '参数类型错误',
            'pema_id.required' => '参数类型错误',
            'pema_id.integer' => '参数类型错误',
            'pema_id.min' => '参数类型错误',
            'pema_name.required' => '请输入异常名称',
            'pema_name.max' => '参数类型错误',
            'pema_remark.max' => '参数类型错误',
            'pema_grpr_id.required' => '请选择职位',
            'pema_grpr_id.integer' => '参数类型错误',
            'pema_grpr_id.min' => '参数类型错误',
            'pema_grle_id.required' => '请选择级别',
            'pema_grle_id.integer' => '参数类型错误',
            'pema_grle_id.min' => '参数类型错误',
            'pema_standard.required' => '请输入标准金额',
            'pema_standard.numeric' => '参数类型错误',
            'pema_standard.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'pema_id' => 'required|integer|min:1',
            'pema_service_type_name' => 'required|max:20',//服务类型名称
            'pema_service_type_id' => 'required|integer|min:1',//服务类型
            'pema_remark' => 'sometimes|nullable|max:255',//备注
            'pema_name' => 'required|max:20',//名称
            'pema_grpr_id' => 'required|integer|min:1',//职位id
            'pema_grle_id' => 'required|integer|min:1',//级别id
            'pema_standard' => 'required|numeric|min:1',//标准金额
            'pema_type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 启用
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pema_type.required' => '参数类型错误',
            'pema_type.in' => '参数类型错误',
            'pema_id.required' => '参数类型错误',
            'pema_id.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pema_id' => 'required|array',
            'pema_type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 职位职级
    public function getGradeProfessionalValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
