<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ValidateCarTest extends Model
{

    /**
     * 关联到模型的数据表
     *
     * @var string
     */
    protected $table = 'wash_validate_car_manage';
    protected $primaryKey = 'vacm_id';
    protected $guarded = [];
    /**
     * 可以被批量赋值的属性.
     *
     * @var array
     */
    protected $fillable = ['vacm_unusual_name', 'vacm_type', 'vacm_remark', 'vacm_state'];
    public $attributeNames = [
        'vacm_id'=>'编号',
        'vacm_unusual_name'=>'异常名称',
        'vacm_type'=>'类型',
        'vacm_remark'=>'备注',
        'vacm_state'=>'状态值',
        'vacm_delete'=>'是否删除',
        'vacm_create_time'=>'创建时间',
        'vacm_update_time'=>'更新时间'
    ];
    /**
     * 表明模型是否应该被打上时间戳
     *
     * @var bool
     */
    public $timestamps = false;
    /**
     * 模型日期列的存储格式
     *
     * @var string
     */
    //protected $dateFormat = 'U';

    /**
     * The connection name for the models.
     *
     * @var integer $id
     * @var bool $includeSub
     *
     * @return mixed
     */
    //protected $connection = 'connection-name';


    // public function scopeGrprId($query, $grpr_id) {
    //     return $query->where('grle_grpr_id', $grpr_id);
    // }

    public function scopeType($query, $type) {
        return $query->where('vacm_type', $type);
    }
    
    public function scopeName($query, $name) {
        return $query->where('vacm_unusual_name', 'like', '%' . $name . '%');
    }

    public function scopeDelete($query, $delete = 1) {
        return $query->where('vacm_delete', $delete);
    }

    public function getStatusNameAttribute()
    {
        if ($this->getAttribute('vacm_state') == 1) return '启用';
        if ($this->getAttribute('vacm_state') == 2) return '停用';

        return '未知';
    }

    public function getDeleteNameAttribute()
    {
        if ($this->getAttribute('vacm_delete') == 1) return '正常';
        if ($this->getAttribute('vacm_delete') == 2) return '已删除';

        return '未知';
    }

    public function getCreateTimeAttribute()
    {
        $create_time = $this->getAttribute('vacm_create_time');
        $dotExist = strpos($create_time, '.');
        if ($dotExist !== false)
        {
            $dateTime = explode('.', $create_time);

            return $dateTime[0];
        }

        return null;
    }

    public function getUpdateTimeAttribute()
    {
        $update_time = $this->getAttribute('vacm_update_time');
        $dotExist = strpos($update_time, '.');
        if ($dotExist !== false)
        {
            $dateTime = explode('.', $update_time);

            return $dateTime[0];
        }

        return null;
    }


}
