<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MemberVehicles extends Model
{
    //
    protected $table = 'member_car';
    protected $primaryKey = 'meca_id';
    protected $guarded = [];
    /**
     * 可以被批量赋值的属性.
     *
     * @var array
     */
//    protected $fillable = [''];
    public $attributeNames = [
        'meca_id'=>'编号',
        'meca_mem_id'=>'用户ID',
        'meca_car_num'=>'车牌号',
        'meca_car_series'=>'车系',
        'meca_car_model'=>'车型',
        'meca_insure_time'=>'投保时间',
        'meca_insure_company'=>'保险公司',
        'meca_year'=>'年份',
        'meca_car_frame'=>'车架号',
        'meca_create_time'=>'创建时间',
        'meca_update_time'=>'更新时间'
    ];
    /**
     * 表明模型是否应该被打上时间戳
     *
     * @var bool
     */
    public $timestamps = true;
    /**
     * 模型日期列的存储格式
     *
     * @var string
     */
    //protected $dateFormat = 'U';

    /**
     * The connection name for the models.
     *
     * @var integer $id
     * @var bool $includeSub
     *
     * @return mixed
     */
    //protected $connection = 'connection-name';
    const CREATED_AT = 'meca_create_time';
    const UPDATED_AT = 'meca_update_time';

    public function member() {
        return $this->belongsTo(MemberAccount::Class, 'mem_id', 'meca_mem_id');
    }

    public function scopeOwner($query, $memberID) {
        return $query->where('meca_mem_id', '=', $memberID);
    }
}
