<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MemberAccount extends Model
{
    //
    protected $table = 'member';
    protected $primaryKey = 'mem_id';
    protected $guarded = [];
    /**
     * 可以被批量赋值的属性.
     *
     * @var array
     */
//    protected $fillable = [''];
    public $attributeNames = [
        'mem_name' => '姓名',
        'mem_sex' => '性别1.男 2.女',
        'mem_phone' => '联系电话',
        'mem_birthday' => '生日',
        'mem_car_num' => '车牌号',
        'mem_car_series' => '车系',
        'mem_car_model' => '车型',
        'mem_province' => '省',
        'mem_city' => '市',
        'mem_county' => '区县',
        'mem_address' => '地址',
        'mem_consume_money' => '消费总金额(单位：分)',
        'mem_order_all' => '订单总量',
        'mem_retreat_trade' => '退换次数',
        'mem_create_time' => '添加时间',
        'mem_update_time' => '更新时间',
        'mem_bership' => '1正式会员2临时会员'
    ];
    /**
     * 表明模型是否应该被打上时间戳
     *
     * @var bool
     */
    public $timestamps = true;
    /**
     * 模型日期列的存储格式
     *
     * @var string
     */
    //protected $dateFormat = 'U';

    /**
     * The connection name for the models.
     *
     * @return mixed
     * @var bool $includeSub
     *
     * @var integer $id
     */
    //protected $connection = 'connection-name';
    const CREATED_AT = 'mem_create_time';
    const UPDATED_AT = 'mem_update_time';

    public function vehicles()
    {
        return $this->hasMany(MemberVehicles::Class, 'mem_id', 'meca_mem_id');
    }

    public function chargeRecords()
    {
        return $this->hasMany(MemberAccountRecords::Class, 'account_id', 'account_id')
            ->where('type', 1);
    }

    public function payRecords()
    {
        return $this->hasMany(MemberAccountRecords::Class, 'account_id', 'account_id')
            ->where('type', 2);
    }
}
