<?php

namespace App\Models\Business;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class Member extends Model
{

    /**
     * 根据mem_id获取数据
     *
     * @param $id
     * @param $data
     * @return int
     *
     * @author huangyongqi
     *
     * @since 2023-10-24
     */
    public static function getDataByMemId($memId)
    {
        return DB::table("member")->where('mem_id', $memId)->first();
    }

    /**
     * 根据mem_id更新数据
     *
     * @param $id
     * @param $data
     * @return int
     *
     * @author huangyongqi
     *
     * @since 2023-10-24
     */
    public static function updateByMemId($memId, $data)
    {
        return DB::table("member")->where('mem_id', $memId)->update($data);
    }
}
