<?php

namespace App\Models\Business;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class DispatchBill extends Model
{

    /**
     * 根据订单id获取数据
     *
     * @param $id
     * @param $data
     * @return int
     *
     * @author huangyongqi
     *
     * @since 2023-10-24
     */
    public static function getDataByOrderId($orderId)
    {
        return DB::table("dispatch_bill")
            ->where('dego_wor_id', $orderId)
            ->where('dego_type','!=', 3)
            ->orderBy('dego_update_time', 'desc')
            ->limit(1)
            ->first();
    }

    /**
     * 新增数据
     *
     * @param $id
     * @param $data
     * @return int
     *
     * @author huangyongqi
     *
     * @since 2023-10-24
     */
    public static function insert($data)
    {
        return DB::table("dispatch_bill")->insertGetId($data);
    }

    /**
     * 根据dego_id更新数据
     *
     * @param $id
     * @param $data
     * @return int
     *
     * @author huangyongqi
     *
     * @since 2023-10-24
     */
    public static function updateByDegoId($degoId, $data)
    {
        return DB::table("dispatch_bill")->where('dego_id', $degoId)->update($data);
    }
}
