<?php

namespace App\Http\Requests\Validators\WeChatApplet\User;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 微信用户
class WeixinUserValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 登录验证器
    public function loginValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_phone.required' => '请输入手机号',
            'weus_phone.numeric' => '参数类型错误',
            'weus_openid.required' => '请输入openid',
            'weus_openid.max' => '参数类型错误',
            // 'weus_nickmame.required' => '请输入昵称',
            // 'weus_nickmame.max' => '参数类型错误',
            // 'weus_province.max' => '参数类型错误',
            // 'weus_city.max' => '参数类型错误',
            // 'weus_headimgurl.max' => '参数类型错误',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            // 'weus_follow.integer' => '参数类型错误',
            // 'weus_follow.min' => '参数类型错误',
            // 'weus_sex.integer' => '参数类型错误',
            // 'weus_sex.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_phone' => 'required|numeric',//联系电话
            'weus_openid' => 'required|max:50',//openid
            // 'weus_nickmame' => 'required|max:50',//用户昵称
            // 'weus_province' => 'sometimes|nullable|max:50',//省份
            // 'weus_city' => 'sometimes|nullable|max:50',//	城市
            // 'weus_headimgurl' => 'sometimes|nullable|max:255',//头像链接
            'shop_id' => 'sometimes|nullable|integer|min:1',//	门店id
            // 'weus_follow' => 'sometimes|nullable|integer|min:1',//	是否关注1未关注2已关注
            // 'weus_sex' => 'sometimes|nullable|integer|min:0',//性别0未知1男2女
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 登录pc验证器
    public function pcLoginValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shqr_number.required' => '扫码错误',
            'adm_phone.required' => '请输入手机号',
            'adm_phone.numeric' => '参数类型错误',
            'adm_bjfw_openid.required' => '请输入openid',
            'adm_bjfw_openid.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shqr_number' => 'required',//联系电话
            'adm_phone' => 'required|numeric',//联系电话
            'adm_bjfw_openid' => 'required|max:50',//openid
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'weus_nickmame.required' => '请输入昵称',
            'weus_nickmame.max' => '参数类型错误',
            'weus_phone.required' => '请输入联系电话',
            'weus_phone.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'weus_nickmame' => 'required|max:50',//昵称
            'weus_phone' => 'required|numeric',//联系电话
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 生成会员卡二维码验证器
    public function vipQrcodeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'myvi_id.required' => '请选择会员卡',
            'myvi_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'myvi_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 领取积分验证器
    public function claimPointsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'pode_id.required' => '请选择领取的项目',
            'pode_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'pode_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 领取签到礼品验证器
    public function claimSignGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'sigo_id.required' => '请选择领取的项目',
            'sigo_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'sigo_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 获取验证码
    public function getCodeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_phone.required' => '请填写手机号',
            'weus_phone.integer' => '参数类型错误',
            'shop_id.required' => '请选择门店',
            'shop_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_phone' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }
}
