<?php

namespace App\Http\Requests\Validators\WeChatApplet\User;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 用户小程序-门店
class UserShopValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            // 'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            // 'weus_id' => 'required|integer|min:1',
            'weus_id' => 'sometimes|nullable|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 获取分类验证器
    public function getClassificationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
            // return $validator->errors()->messages();
        }
    }

    // 获取验证器
    public function getGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'pait_classify_id.required' => '请选择分类',
            'pait_classify_id.integer' => '参数类型错误',
            'pait_classify_id.min' => '参数类型错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1',
            'pait_classify_id' => 'required|integer|min:0',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
            // return $validator->errors()->messages();
        }
    }

    // 获取验证器
    public function getVipValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
            // return $validator->errors()->messages();
        }
    }

    // 获取验证器
    public function getRecommendGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
            // return $validator->errors()->messages();
        }
    }

    // 获取验证器
    public function getOrderWorkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
            // return $validator->errors()->messages();
        }
    }

    // 商品详情
    public function goodsInfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'pait_id.required' => '请选择商品',
            'pait_id.integer' => '参数类型错误',
            'pait_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1',
            'pait_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
            // return $validator->errors()->messages();
        }
    }

    // 商品案例
    public function goodsOrderWorkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'pait_id.required' => '请选择商品',
            'pait_id.integer' => '参数类型错误',
            'pait_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1',
            'pait_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
            // return $validator->errors()->messages();
        }
    }

    // 会员卡详情
    public function vipCardInfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'vica_id.required' => '请选择会员卡',
            'vica_id.integer' => '参数类型错误',
            'vica_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1',
            'vica_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
            // return $validator->errors()->messages();
        }
    }

    // 数据验证
    public function dataValidationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'name.required' => '请选择方法',
            'id.required' => '请上传id',
            'id.integer' => '参数类型错误',
            'id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'name' => 'required',
            'id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
            // return $validator->errors()->messages();
        }
    }

    // 积分商品详情数据验证
    public function pointGoodsInfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pogg_id.required' => '请上传id',
            'pogg_id.integer' => '参数类型错误',
            'pogg_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pogg_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
            // return $validator->errors()->messages();
        }
    }

    // 积分商品详情数据验证
    public function getAppointNumValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pait_id.required' => '请上传id',
            'pait_id.integer' => '参数类型错误',
            'pait_id.min' => '参数类型错误',
            'day_time.required' => '请上传日期',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pait_id' => 'required|integer|min:1',
            'day_time' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
            // return $validator->errors()->messages();
        }
    }
}
