<?php

namespace App\Http\Requests\Validators\Shop;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 会员卡验证器
class VipCardValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|unique:posts|max:255',
            'body' => 'required',
        ];
    }
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '参数类型错误',
            'pri_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 列表验证器
    public function vipCardIndexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_id.required' => '请选择会员',
            'adm_id.integer' => '参数类型错误',
            'adm_id.min' => '参数类型错误',
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '参数类型错误',
            'pri_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_id' => 'required|integer|min:1',
            'pri_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vica_name.required' => '请输入:会员卡名称',
            'vica_name.max' => '会员卡长度超过最大限制',
            // 'vica_sepr_id.required' => '请输入:联系人姓名',
            // 'vica_sepr_name.required' => '请输入:服务项目',
            // 'vica_sepr_name.max' => '服务项目长度超过最大限制',
            // 'vica_num.required' => '请输入:次数',
            // 'vica_num.integer' => '次数参数错误',
            // 'vica_num.max' => '次数最大99',
            'vica_price.required' => '请输入:零售价格',
            'vica_price.min' => '请输入:价格',
            'vica_shop_price.required' => '请输入:门店价格',
            'vica_shop_price.min' => '请输入:价格',
            'vica_effective_date.required' => '请输入:有效期',
            'vica_long_term.required' => '请输入:有效期',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vica_name' => 'required|max:9', //会员卡
            // 'vica_sepr_id' => 'required', //服务id
            // 'vica_sepr_name' => 'required|max:80', //服务项目
            // 'vica_num' => 'required|integer|max:99',
            'vica_price' => 'required|min:0.01',
            'vica_shop_price' => 'required|min:0.01',
            'vica_effective_date' => 'required',
            'vica_long_term' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 绑定会员卡验证器
    public function addvipcardValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'myvi_name.required' => '请输入:会员卡名称',
            'myvi_name.max' => '会员卡名称长度超过最大限制',
            'myvi_sepr_name.required' => '请输入:服务名称',
            'myvi_sepr_name.max' => '服务名称长度超过最大限制',
            'myvi_sepr_id.required' => '请选择服务项目',
            'vica_id.required' => '请选择会员卡',
            'myvi_all_times.required' => '请输入:次数',
            'myvi_all_times.integer' => '数量：参数错误',
            'vica_price.required' => '请输入:金额',
            'ord_payment_way.required' => '请选择付款方式',
            'ord_payment_way.integer' => '付款方式：参数错误',
            'myvi_effective_date.required' => '请输入:有效期',
            'myvi_effective_date.integer' => '有效期：参数错误',
            'myvi_long_term.required' => '请输入:有效期',
            'myvi_long_term.integer' => '有效期：参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            // 'myvi_sepr_id' => 'required', //服务id
            'vica_id' => 'required', //会员卡id
            // 'myvi_all_times' => 'required|integer', //次数
            'vica_price' => 'required', //金额
            'ord_payment_way' => 'required|integer', //付款方式
            'myvi_effective_date' => 'required', //有效期
            'myvi_long_term' => 'required', //是否长期1是2否
            'myvi_name' => 'required|max:20', //会员卡名称
            // 'myvi_sepr_name' => 'required|max:20', //服务名称
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
            // return $validator->errors()->messages();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vica_name.required' => '请输入:会员卡名称',
            'vica_name.max' => '会员卡长度超过最大限制',
            'vica_sepr_id.required' => '请输入:联系人姓名',
            'vica_sepr_name.required' => '请输入:服务项目',
            'vica_sepr_name.max' => '服务项目长度超过最大限制',
            'vica_num.required' => '请输入:次数',
            'vica_num.integer' => '次数参数错误',
            'vica_price.required' => '请输入:价格',
            'vica_effective_date.required' => '请输入:有效期',
            'vica_long_term.required' => '请输入:有效期',
            'vica_id.required' => '参数错误',
            'vica_id.integer' => '参数错误',
            'vica_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vica_name' => 'required|max:20', //会员卡
            'vica_sepr_id' => 'required', //服务id
            'vica_sepr_name' => 'required|max:80', //服务项目
            'vica_num' => 'required|integer',
            'vica_price' => 'required',
            'vica_effective_date' => 'required',
            'vica_long_term' => 'required',
            'vica_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vica_id.required' => '参数错误',
            'vica_id.integer' => '参数错误',
            'vica_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vica_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }


    // 上架会员卡验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vica_id.required' => '请输入会员卡id',
            'vica_id.array' => '参数类型错误',
            'vica_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vica_id' => 'required|array|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 会员卡使用明细验证器
    public function detailIndexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mem_id.required' => '请输入会员id',
            'mem_id.integer' => '参数类型错误',
            'mem_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mem_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
