<?php

namespace App\Http\Requests\Validators\Shop;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 商品验证器
class PurchaseValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|unique:posts|max:255',
            'body' => 'required',
        ];
    }

    // 列表验证器
    public function getShopGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请选择门店',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 列表验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'npor_fshop_id.required' => '请选择门店',
            'npor_fshop_id.integer' => '参数类型错误',
            'npor_fshop_id.min' => '参数类型错误',
            'npor_fshop_name.required' => '请选择门店',
            'npor_cg_delivertype.required' => '请选择发货方式',
            'npor_cg_delivertype.integer' => '参数类型错误',
            'npor_cg_delivertype.min' => '参数类型错误',
            'npor_settlement_type.required' => '请选择結算方式',
            'npor_settlement_type.integer' => '参数类型错误',
            'goods_data.required' => '请选择商品',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'npor_fshop_id' => 'required|integer|min:1',
            'npor_cg_delivertype' => 'required|integer|min:1',
            'npor_settlement_type' => 'required|integer',
            'npor_fshop_name' => 'required',
            'goods_data' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 接单验证器
    public function receiveValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'npor_id.required' => '请选择采购订单',
            'npor_id.integer' => '参数类型错误',
            'npor_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'npor_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 列表验证器
    public function purchasingPlanValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '参数类型错误',
            'pri_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 详情
    public function planInfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pupl_id.required' => '请输入:排序',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pupl_id' => 'required', //排序
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 编辑分类验证器
    public function editClassificationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'gocl_name.required' => '请输入:分类名称',
            'gocl_sort.required' => '请输入:排序',
            'gocl_name.max' => '分类名称长度超过最大限制',
            'gocl_state.required' => '开启状态错误',
            'gocl_state.in' => '参数错误',
            'gocl_id.required' => '请输入分类id',
            'gocl_id.integer' => '参数类型错误',
            'gocl_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'gocl_name' => 'required|max:6', //商品分类名称
            'gocl_sort' => 'required', //排序
            'gocl_id' => 'required|integer|min:1',
            'gocl_state' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pait_id.required' => '请选择编辑的商品',
            'pait_id.integer' => '商品id参数错误',
            'pait_id.min' => '商品id参数错误',
            'pait_name.required' => '请输入:商品名称',
            'pait_name.max' => '商品名称长度超过最大限制',
            'pait_classify_id.required' => '请输入:分类',
            'pait_classify_id.integer' => '分类参数错误',
            'pait_saleable_quantity.required' => '请输入:可售数量',
            'pait_saleable_quantity.integer' => '可售数量参数错误',
            'pait_pic.required' => '请上传封面图片',
            'pait_shop_price.required' => '请输入:门市价',
            'pait_sell_price.required' => '请输入:零售价',
            'pait_ware_id.required' => '请选择仓库',
            'pait_ware_id.integer' => '仓库参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pait_id' => 'required|integer|min:0', //商品id
            'pait_name' => 'required|max:30', //商品名称
            'pait_classify_id' => 'required|integer', //分类
            // 'pait_ware_id' => 'required|integer', //分类
            'pait_saleable_quantity' => 'required|integer', //可售数量
            'pait_pic' => 'required',
            'pait_shop_price' => 'required',
            'pait_sell_price' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 编辑验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pait_id.required' => '参数错误',
            'pait_id.integer' => '参数错误',
            'pait_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pait_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 编辑验证器
    public function replenishmentValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pait_id.required' => '参数错误',
            'pait_id.integer' => '参数错误',
            'pait_id.min' => '参数错误',
            'number.required' => '请输入补货数量',
            'number.integer' => '参数错误',
            'number.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'number' => 'required|integer|min:1',
            'pait_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }


    // 开启分类
    public function claStartValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'gocl_id.required' => '请输入会员卡id',
            'gocl_id.array' => '参数类型错误',
            'gocl_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'gocl_id' => 'required|array|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 开启分类
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pait_id.required' => '请输入会员卡id',
            'pait_id.array' => '参数类型错误',
            'pait_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pait_id' => 'required|array|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 删除分类验证器
    public function claDeleteValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'gocl_id.required' => '请输入会员卡id',
            'gocl_id.integer' => '参数类型错误',
            'gocl_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'gocl_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 会员卡使用明细验证器
    public function detailIndexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mem_id.required' => '请输入会员id',
            'mem_id.integer' => '参数类型错误',
            'mem_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mem_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 关联套餐
    public function correlationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pait_id.required' => '请选择商品',
            'pait_id.integer' => '参数类型错误',
            'pait_id.min' => '参数类型错误',
            'copa_cpait_id.required' => '请选择商品',
            'copa_cpait_id.integer' => '参数类型错误',
            'copa_cpait_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pait_id' => 'required|integer|min:1',
            'copa_cpait_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 关联套餐
    public function colistValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pait_id.required' => '请选择商品',
            'pait_id.integer' => '参数类型错误',
            'pait_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pait_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }
}
