<?php

namespace App\Http\Requests\Validators\Pay;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 支付验证器
class PayValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '参数类型错误',
            'pri_id.min' => '参数类型错误',
            'rech_type.required' => '参数类型错误',
            'rech_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1',
            'rech_type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rech_type.required' => '参数类型错误',
            'rech_type.in' => '参数类型错误',
            'rech_client_id.required' => '请选择会员',
            'rech_client_id.integer' => '参数类型错误',
            'rech_client_id.min' => '参数类型错误',
            'rech_client_name.required' => '请选择会员',
            'rech_client_name.max' => '参数类型错误',
            'rech_phone.required' => '请输入客户电话',
            'rech_phone.max' => '参数类型错误',
            'rech_money.required' => '请输入充值金额',
            'rech_money.min' => '参数类型错误',
            'rech_car_num.required' => '请输入车牌号',
            'rech_car_vin.required' => '请输入车架号',
            'rech_time_start.required' => '请选择有效期开始时间',
            'rech_time_end.required' => '请选择有效期结束时间',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rech_type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'rech_client_id' => 'required|integer|min:1',
            'rech_client_name' => 'required|max:255',
            'rech_phone' => 'required|max:11',
            'rech_money' => 'required|min:1',
            'rech_car_num' => 'required',
            'rech_car_vin' => 'required',
            'rech_time_start' => 'required',
            'rech_time_end' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑获取数据验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
            'rech_id.required' => '参数类型错误',
            'rech_id.integer' => '参数类型错误',
            'rech_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'rech_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rech_type.required' => '参数类型错误',
            'rech_type.in' => '参数类型错误',
            'rech_id.required' => '参数类型错误',
            'rech_id.integer' => '参数类型错误',
            'rech_id.min' => '参数类型错误',
            'rech_client_id.required' => '请选择会员',
            'rech_client_id.integer' => '参数类型错误',
            'rech_client_id.min' => '参数类型错误',
            'rech_client_name.required' => '请选择会员',
            'rech_client_name.max' => '参数类型错误',
            'rech_phone.required' => '请输入客户电话',
            'rech_phone.max' => '参数类型错误',
            'rech_car_num.required' => '请输入车牌号',
            'rech_car_vin.required' => '请输入车架号',
            'rech_money.required' => '请输入充值金额',
            'rech_money.min' => '参数类型错误',
            'rech_time_start.required' => '请选择有效期开始时间',
            'rech_time_end.required' => '请选择有效期结束时间',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rech_type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'rech_id' => 'required|integer|min:1',
            'rech_client_id' => 'required|integer|min:1',
            'rech_client_name' => 'required|max:255',
            'rech_phone' => 'required|max:11',
            'rech_car_num' => 'required',
            'rech_car_vin' => 'required',
            'rech_money' => 'required|min:1',
            'rech_time_start' => 'required',
            'rech_time_end' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 充值获取数据验证器
    public function rechargeShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
            'rech_id.required' => '参数类型错误',
            'rech_id.integer' => '参数类型错误',
            'rech_id.min' => '参数类型错误'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'rech_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 充值验证器
    public function rechargeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
            'rech_id.required' => '请选择会员',
            'rech_id.integer' => '参数类型错误',
            'rech_id.min' => '参数类型错误',
            'rech_client_id.required' => '请选择会员',
            'rech_client_id.integer' => '参数类型错误',
            'rech_client_id.min' => '参数类型错误',
            'rech_client_name.required' => '请选择会员',
            'rech_client_name.max' => '参数类型错误',
            'rech_phone.required' => '请输入客户电话',
            'rech_phone.max' => '参数类型错误',
            'rech_money.required' => '请输入充值金额',
            'rech_money.min' => '参数类型错误',
            'rech_car_num.required' => '请输入车牌号',
            'rech_car_vin.required' => '请输入车架号',
            'rech_time_start.required' => '请选择有效期开始时间',
            'rech_time_end.required' => '请选择有效期结束时间',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'rech_id' => 'required|integer|min:1',
            'rech_client_id' => 'required|integer|min:1',
            'rech_client_name' => 'required|max:255',
            'rech_phone' => 'required|max:11',
            'rech_car_num' => 'required',
            'rech_car_vin' => 'required',
            'rech_money' => 'required|min:1',
            'rech_time_start' => 'required',
            'rech_time_end' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rech_type.required' => '参数类型错误',
            'rech_type.in' => '参数类型错误',
            'rech_id.required' => '请选择充值记录',
            'rech_id.integer' => '参数类型错误',
            'rech_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rech_type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'rech_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rech_id.required' => '请选择充值记录',
            'rech_id.integer' => '参数类型错误',
            'rech_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rech_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 销户验证器
    public function accountCancellationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rech_id.required' => '请选择充值记录',
            'rech_id.integer' => '参数类型错误',
            'rech_id.min' => '参数类型错误',
            'rech_remark.required' => '参数类型错误',
            'rech_remark.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rech_id' => 'required|integer|min:1',
            'rech_remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
