<?php

namespace App\Http\Requests\Validators\Operation;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 门店验证器
class StoreListValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|unique:posts|max:255',
            'body' => 'required',
        ];
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_versions.required' => '请选择系统版本',
            'shop_versions.in' => '系统版本参数错误',
            'shop_store_name.required' => '请输入:门店名称',
            'shop_store_name.max' => '门店名称长度超过最大限制',
            'shop_name.required' => '请输入:联系人姓名',
            'shop_name.max' => '姓名长度超过最大限制',
            'shop_phone.required' => '请输入:联系人电话',
            'shop_phone.max' => '联系人电话长度超过最大限制',
            'shop_province.required' => '请输入:省',
            'shop_province.max' => '省长度超过最大限制',
            'shop_city.required' => '请输入:市',
            'shop_city.max' => '市长度超过最大限制',
            'shop_county.required' => '请输入:县',
            'shop_county.max' => '县长度超过最大限制',
            'shop_address.required' => '请输入:地址',
            'shop_address.max' => '地址长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_versions' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
            'shop_store_name' => 'required|max:20', //客户姓名
            'shop_name' => 'required|max:20', //车主姓名
            'shop_phone' => 'required|max:11', //车主电话
            'shop_province' => 'required|max:50',
            'shop_city' => 'required|max:50',
            'shop_county' => 'required|max:50',
            'shop_address' => 'required|max:255'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
