<?php

namespace App\Http\Requests\Validators\Business;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 技师服务列表验证器
class WashServiceValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|unique:posts|max:255',
            'body' => 'required',
        ];
    }
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '参数类型错误',
            'pri_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'orcl_name.required' => '请输入:姓名',
            'orcl_name.max' => '姓名长度超过最大限制',
            'orcl_carowner_name.required' => '请输入:车主姓名',
            'orcl_carowner_name.max' => '姓名长度超过最大限制',
            'orcl_carowner_phone.required' => '请输入:车主电话',
            'orcl_carowner_phone.max' => '车主电话长度超过最大限制',
            'ord_payment_way.required' => '请选择结算方式',
            'ord_type.required' => '请选择买家类型',
            // 'orcl_car_num.required_if' => '请输入:车牌号',
            // 'orcl_car_num.max' => '车牌号长度超过最大限制',
            'orcl_province.required' => '请输入:省',
            'orcl_province.max' => '省长度超过最大限制',
            'orcl_city.required' => '请输入:市',
            'orcl_city.max' => '市长度超过最大限制',
            'orcl_county.required' => '请输入:县',
            'orcl_county.max' => '县长度超过最大限制',
            'orcl_address.required' => '请输入:地址',
            'orcl_address.max' => '地址长度超过最大限制',
            // 'ord_province.required' => '请输入:省',
            // 'ord_province.max' => '省长度超过最大限制',
            // 'ord_city.required' => '请输入:市',
            // 'ord_city.max' => '市长度超过最大限制',
            // 'ord_county.required' => '请输入:县',
            // 'ord_county.max' => '县长度超过最大限制',
            'ord_address.required' => '请输入:地址',
            'ord_address.max' => '地址长度超过最大限制',
            'orcl_channel_unit.required_if' => '请输入:客户单位',
            'orcl_channel_unit.max' => '客户单位长度超过最大限制',
            'orcl_check_car_state.required' => '请选择是否验车',
            'orcl_check_car_state.in' => '参数错误',

            'ord_client_id.required' => '请选择客户信息',
            'ord_client_id.integer' => '数据类型不正确',
            'ord_client_id.min' => '参数错误',
            'reli_id.required' => '预约单id',
            'reli_id.integer' => '数据类型不正确',
            'reli_id.min' => '参数错误',
            'add_type.required' => '请输入新增类型',
            'add_type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            // 'ord_payment_way' => [//结算方式1.账期 2.现结 3微信 4支付宝
            //         'required',
            //         Rule::in(config('apisystem.ORDER_PAYMENT_WAY')),
            //     ],
            'ord_type' => [ //读取配置文件数据，买家类型：1会员零售2客户单位
                'required',
                Rule::in(config('apisystem.ORDER_BUYER_TYPE')),
            ],
            'ord_remark' => 'sometimes|nullable|max:255',

            'orcl_name' => 'required|max:20', //客户姓名
            'orcl_carowner_name' => 'required|max:20', //车主姓名
            'orcl_carowner_phone' => 'required|max:11', //车主电话
            // 'orcl_phone' => ['sometimes','regex:/^1[3456789]\d{9}$/'],// 客户手机号
            // 'orcl_car_num' => 'sometimes|required_if:ord_type,1|max:10',//客户车牌号
            // 'ord_province' => 'required|max:50',
            // 'ord_city' => 'required|max:50',
            // 'ord_county' => 'required|max:50',
            'ord_address' => 'required|max:255',
            'orcl_channel_unit' => 'sometimes|required_if:ord_type,2|max:50',
            'ord_client_id' => 'required|integer|min:0',
            'reli_id' => 'sometimes|nullable|integer|min:0',
            // 'orcl_check_car_state' => [//是否验车：1是2否
            //         'required',
            //         Rule::in(['1', '2']),
            //     ],
            'add_type' => [ //新增类型1生成订单2立即派单
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_type.required' => '请选择买家类型',
            'orcl_name.required' => '请输入:姓名',
            'orcl_name.max' => '姓名长度超过最大限制',
            'orcl_carowner_name.required' => '请输入:车主姓名',
            'orcl_carowner_name.max' => '姓名长度超过最大限制',
            'orcl_carowner_phone.required' => '请输入:车主电话',
            'orcl_carowner_phone.max' => '车主电话长度超过最大限制',
            // 'orcl_car_num.required_if' => '请输入:车牌号',
            // 'orcl_car_num.max' => '车牌号长度超过最大限制',
            'orcl_province.required' => '请输入:省',
            'orcl_province.max' => '省长度超过最大限制',
            'orcl_city.required' => '请输入:市',
            'orcl_city.max' => '市长度超过最大限制',
            'orcl_county.required' => '请输入:县',
            'orcl_county.max' => '县长度超过最大限制',
            'orcl_address.required' => '请输入:地址',
            'orcl_address.max' => '地址长度超过最大限制',
            'ord_province.required' => '请输入:省',
            'ord_province.max' => '省长度超过最大限制',
            'ord_city.required' => '请输入:市',
            'ord_city.max' => '市长度超过最大限制',
            'ord_county.required' => '请输入:县',
            'ord_county.max' => '县长度超过最大限制',
            'ord_address.required' => '请输入:地址',
            'ord_address.max' => '地址长度超过最大限制',
            'orcl_channel_unit.required_if' => '请输入:客户单位',
            'orcl_channel_unit.max' => '客户单位长度超过最大限制',
            'orcl_check_car_state.required' => '请选择是否验车',
            'orcl_check_car_state.in' => '参数错误',
            'ord_client_id.required' => '请选择客户信息',
            'ord_client_id.integer' => '数据类型不正确',
            'ord_client_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            // 'ord_payment_way' => [//结算方式1.账期 2.现结 3微信 4支付宝
            //         'required',
            //         Rule::in(config('apisystem.ORDER_PAYMENT_WAY')),
            //     ],
            'ord_type' => [ //读取配置文件数据，买家类型：1会员零售2客户单位
                'required',
                Rule::in(config('apisystem.ORDER_BUYER_TYPE')),
            ],
            'ord_remark' => 'sometimes|nullable|max:255',
            // 'ord_province' => 'required|max:50',
            // 'ord_city' => 'required|max:50',
            // 'ord_county' => 'required|max:50',
            'ord_address' => 'required|max:255',
            'orcl_name' => 'required|max:20', //客户姓名
            'orcl_carowner_name' => 'required|max:20', //车主姓名
            'orcl_carowner_phone' => 'required|max:11', //车主电话
            // 'orcl_phone' => ['sometimes','regex:/^1[3456789]\d{9}$/'],// 客户手机号
            // 'orcl_car_num' => 'sometimes|required_if:ord_type,1|max:10',//客户车牌号
            // 'orcl_province' => 'required|max:50',
            // 'orcl_city' => 'required|max:50',
            // 'orcl_county' => 'required|max:50',
            // 'orcl_address' => 'required|max:255',
            'orcl_channel_unit' => 'sometimes|required_if:ord_type,2|max:50',
            'ord_client_id' => 'required|integer|min:0',
            // 'orcl_check_car_state' => [//是否验车：1是2否
            //         'required',
            //         Rule::in(['1', '2']),
            //     ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 验车查询验证器
    public function validateCarShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'ord_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 验车验证器
    public function validateCarValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'orvc_mileage.required' => '请输入进店里程数',
            'orvc_mileage.integer' => '参数错误',
            'orvc_mileage.min' => '参数错误',
            'orvc_film_roll_number.required' => '请输入膜卷号',
            'orvc_film_roll_number.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'orvc_mileage' => 'required|integer|min:0',
            // 'orvc_film_roll_number' => 'required|max:80',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 后台签字图片提交验证器
    public function pcsignatureSubmitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'img_path.required' => '请传入签字图片路径',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'ord_id' => 'required|integer|min:1',
            'img_path' => 'required|max:300',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 微信用户小程序-列表验证器
    public function indexWashValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 微信用户小程序-详情验证器
    public function infoWashValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 微信用户小程序-详情验证器
    public function reinfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'reli_id.required' => '请输入订单id',
            'reli_id.integer' => '参数类型错误',
            'reli_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'reli_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 微信用户小程序-签字图片提交验证器
    public function signatureSubmitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'img_path.required' => '请传入签字图片路径',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'ord_id' => 'required|integer|min:1',
            'ord_id' => 'required|integer|min:1',
            'img_path' => 'required|max:300',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 备注验证器
    public function remarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'remark.required' => '请输入备注',
            'remark.max' => '超过最大长度255字符',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:0',
            'remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 预约设置验证器
    public function appointmentSetValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'appoint_time.required' => '请选择时间',
            'appoint_time.date' => '参数类型错误',
            'appoint_remark.max' => '超过最大长度255字符',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:0',
            'appoint_time' => 'required|date',
            // nullable 验证的字段可以为 null。例如可以包含空值的字符串和整数。
            'appoint_remark' => 'nullable|max:255',
            // 'vacm_type' => [
            //     'required',
            //     Rule::in([1,2]),
            // ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 添加作品验证器
    public function addOrderWorksValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'orwo_title.required' => '请输入标题',
            'orwo_title.max' => '超过最大长度255字符',
            'orwo_type.required' => '请选择类型',
            'orwo_type.in' => '参数类型错误',
            'orwo_data.required' => '请上传作品',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:0',
            'orwo_title' => 'required|max:255',
            'orwo_data' => 'required',
            // nullable 验证的字段可以为 null。例如可以包含空值的字符串和整数。
            'appoint_remark' => 'sometimes|nullable|max:255',
            'orwo_type' => [
                'required',
                Rule::in([1,2]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 订单作品列表验证器
    public function OrderWorksindexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 订单作品详情验证器
    public function OrderWorksinfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'orwo_id.required' => '请输入订单作品id',
            'orwo_id.integer' => '参数类型错误',
            'orwo_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'orwo_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑作品验证器
    public function OrderWorkseditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'orwo_id.required' => '请输入订单id',
            'orwo_id.integer' => '参数类型错误',
            'orwo_id.min' => '参数类型错误',
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'orwo_title.required' => '请输入标题',
            'orwo_title.max' => '超过最大长度255字符',
            'orwo_type.required' => '请选择类型',
            'orwo_type.in' => '参数类型错误',
            'orwo_data.required' => '请上传作品',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'orwo_id' => 'required|integer|min:0',
            'ord_id' => 'required|integer|min:0',
            'orwo_title' => 'required|max:255',
            'orwo_data' => 'required',
            // nullable 验证的字段可以为 null。例如可以包含空值的字符串和整数。
            'appoint_remark' => 'sometimes|nullable|max:255',
            'orwo_type' => [
                'required',
                Rule::in([1,2]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 订单作品删除验证器
    public function OrderWorksdelValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'orwo_id.required' => '请输入作品id',
            'orwo_id.integer' => '参数类型错误',
            'orwo_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'orwo_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 订单审核修正验证器
    public function auditOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入作品id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'ord_actual_price.required' => '请输入订单金额',
            'ord_actual_price.numeric' => '参数类型错误',
            'ord_actual_price.min' => '参数类型错误',
            // 'orit_service_price.required' => '请输入服务金额',
            // 'orit_service_price.numeric' => '参数类型错误',
            // 'orit_service_price.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:0',
            'ord_actual_price' => 'required|numeric|min:0',
            // 'orit_service_price' => 'required|numeric|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 订单历史验证器
    public function getOrderHistoryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入工单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 搜索商品验证器
    public function searchGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_bra_id.required' => '参数错误',
            'goo_bra_id.integer' => '数据类型不正确',
            'goo_bra_id.min' => '参数错误',
            'goo_cate_id.required' => '参数错误',
            'goo_cate_id.integer' => '数据类型不正确',
            'goo_cate_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_bra_id' => 'sometimes|required|integer|min:0',
            'goo_cate_id' => 'sometimes|required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
