<?php

namespace App\Http\Requests\Validators\Business;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 退换列表验证器
class WashRecedeRecycleValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|unique:posts|max:255',
            'body' => 'required',
        ];
    }

    // 退换验证器
    public function recycleValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rec_id.required' => '参数错误',
            'rec_id.integer' => '数据类型不正确',
            'rec_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rec_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 发货详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rec_id.required' => '参数错误',
            'rec_id.integer' => '数据类型不正确',
            'rec_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rec_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
