<?php

namespace App\Http\Requests\Validators\Business;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 基础版-订单相关验证器
class WashOrderBasicValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|unique:posts|max:255',
            'body' => 'required',
        ];
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'orcl_name.required' => '请输入:姓名',
            'orcl_name.max' => '姓名长度超过最大限制',
            'orcl_carowner_name.required' => '请输入:车主姓名',
            'orcl_carowner_name.max' => '姓名长度超过最大限制',
            'orcl_carowner_phone.required' => '请输入:车主电话',
            'orcl_phone.regex' => '车主电话格式错误',
            'orcl_carowner_phone.max' => '车主电话长度超过最大限制',
            'ord_payment_way.required' => '请选择结算方式',
            'ord_type.required' => '请选择买家类型',
            'ord_address.required' => '请选择施工门店',
            'ord_address_type.required' => '请选择施工门店',
            'ord_address_id.required' => '请选择施工门店',
            'ord_address_id.integer' => '请选择施工门店',
            'ord_address_id.min' => '请选择施工门店',
            'ord_address.max' => '地址长度超过最大限制',
            'ord_client_id.required' => '请选择客户信息',
            'ord_client_id.integer' => '数据类型不正确',
            'ord_client_id.min' => '参数错误',
            'reli_id.required' => '预约单id',
            'reli_id.integer' => '数据类型不正确',
            'reli_id.min' => '参数错误',
            'add_type.required' => '请输入新增类型',
            'add_type.in' => '参数错误',
            'goods_data.required' => '请选择产品或服务',
            'ord_add_work_state.required' => '请选择是否生成工单',
        ];

        $data = array_filter($data);//去除数组中的空值
        // 数据验证
        $validator = Validator::make($data, [
            'ord_type' => [ //读取配置文件数据，买家类型：1会员零售2客户单位
                'sometimes',
                'required',
                Rule::in([0,1,2]),
            ],

            'orcl_name' => 'sometimes|required|max:20', //客户姓名
            'orcl_phone' => ['sometimes', 'required','regex:/^1[3456789]\d{9}$/'],// 客户手机号
            'orcl_carowner_name' => 'sometimes|required|max:20', //车主姓名
            'orcl_carowner_phone' => 'sometimes|required|max:11', //车主电话
            'ord_address' => 'required|max:255',
            'ord_address_type' => 'required|integer|min:1',
            'ord_address_id' => 'required|integer|min:1',
            'ord_client_id' => 'sometimes|required|integer|min:1',
            'ware_id' => 'sometimes|required|integer|min:1',
            'goods_data' => 'required',
            'ord_add_work_state' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }
}
