<?php

namespace App\Http\Requests\Validators\Business;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 售后列表验证器
class WashAfterSalesValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'afsl_id.required' => '请输入售后单id',
            'afsl_id.integer' => '参数类型错误',
            'afsl_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'afsl_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 确认处理验证器
    public function dealWithValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'afsl_id.required' => '请输入售后单id',
            'afsl_id.integer' => '参数类型错误',
            'afsl_id.min' => '参数类型错误',
            'appoint_remark.max' => '超过最大长度255字符',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'afsl_id' => 'required|integer|min:1',
            // nullable 验证的字段可以为 null。例如可以包含空值的字符串和整数。
            'remark' => 'sometimes|nullable|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 备注验证器
    public function remarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'afsl_id.required' => '请输入售后单id',
            'afsl_id.integer' => '参数类型错误',
            'afsl_id.min' => '参数类型错误',
            'remark.required' => '请输入备注',
            'remark.max' => '超过最大长度255字符',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'afsl_id' => 'required|integer|min:1',
            'remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 指派技师
    public function assignTechnicianValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_data.required' => '请选择技师',
            'afsl_id.required' => '请选择售后单',
            'afsl_id.integer' => '参数类型错误',
            'afsl_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'afsl_id' => 'required|integer|min:1',
            'adm_data' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 驳回
    public function auditRejectValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'awlo_id.required' => '请输入售后单id',
            'awlo_id.integer' => '参数类型错误',
            'awlo_id.min' => '参数类型错误',
            'remark.required' => '请输入驳回原因',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'awlo_id' => 'required|integer|min:1',
            // nullable 验证的字段可以为 null。例如可以包含空值的字符串和整数。
            'remark' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
