<?php

namespace App\Http\Requests\Validators\Business;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 预约单验证器
class ReservationValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'reli_id.required' => '请输入预约单id',
            'reli_id.integer' => '参数类型错误',
            'reli_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'reli_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 备注验证器
    public function remarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'reli_id.required' => '请输入预约单id',
            'reli_id.integer' => '参数类型错误',
            'reli_id.min' => '参数类型错误',
            'remark.required' => '请输入备注',
            'remark.max' => '超过最大长度255字符',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'reli_id' => 'required|integer|min:1',
            'remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 取消预约单验证器
    public function cancelValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'reli_id.required' => '请输入预约单id',
            'reli_id.integer' => '参数类型错误',
            'reli_id.min' => '参数类型错误',
            'remark.required' => '请输入备注',
            'remark.max' => '超过最大长度255字符',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'reli_id' => 'required|integer|min:1',
            'remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 新增验证器
    public function getlastReliValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请选择预约门店',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请授权登录',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请选择预约门店',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'sepr_id.required' => '请选择预约项目',
            'sepr_id.integer' => '参数类型错误',
            'sepr_id.min' => '参数类型错误',
            'appoint_time.required' => '请输入预约时间',
            'appoint_time.date' => '参数类型错误',
            'name.required' => '请输入联系人姓名',
            'name.max' => '参数类型错误',
            'phone.required' => '请输入电话',
            'phone.numeric' => '参数类型错误',
            'car_num.max' => '参数类型错误',
            'car_vin.max' => '参数类型错误',
            'car_brand_series.required' => '请选择品牌车系',
            'car_brand_series.max' => '参数类型错误',
            'car_vehicle_type.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            // 'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'sepr_id' => 'required|integer|min:1',
            'appoint_time' => 'required|date',
            'appoint_remark' => 'sometimes|nullable|max:255',
            'name' => 'required|max:20',//	姓名
            'phone' => 'required|numeric',//联系电话
            'car_num' => 'max:10',//车牌号
            'car_vin' => 'sometimes|nullable|max:100',//车架号车辆识别码
            'car_brand_series' => 'required|max:255',//品牌车系
            'car_vehicle_type' => 'sometimes|nullable|max:100',//车型
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 新增验证器
    public function addVipCardValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请选择预约门店',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'ord_payment_way.required' => '请选择支付方式',
            'ord_payment_way.integer' => '参数类型错误',
            'ord_payment_way.min' => '参数类型错误',
            'vica_id.required' => '请选择会员卡',
            'vica_id.integer' => '参数类型错误',
            'vica_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'ord_payment_way' => 'required|integer|min:1',
            'vica_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 新增验证器
    public function addOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '微信id参数类型错误',
            'weus_id.min' => '微信id参数类型错误',
            'shop_id.required' => '请选择预约门店',
            'shop_id.integer' => '门店id参数类型错误',
            'shop_id.min' => '门店id参数类型错误',
            'orcl_name.required' => '请输入联系人姓名',
            'orcl_name.max' => '名称参数参数类型错误',
            'orcl_phone.required' => '请输入电话',
            'orcl_phone.numeric' => '电话参数类型错误',
            'orcl_car_brand_series.required' => '请选择品牌车系',
            'orcl_car_brand_series.max' => '车系参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'orcl_name' => 'required|max:20',//  姓名
            'orcl_phone' => 'required|numeric',//联系电话
            'orcl_car_brand_series' => 'required|max:255',//品牌车系
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 查询会员卡
    public function getmyVipValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请选择预约门店',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'pait_id.required' => '请选择商品',
            'pait_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'pait_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 新增纯商品订单验证器
    public function addGoodsOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请选择预约门店',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            // 'orcl_name.required' => '请输入联系人姓名',
            // 'orcl_name.max' => '参数类型错误',
            // 'orcl_phone.required' => '请输入电话',
            // 'orcl_phone.numeric' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            // 'orcl_name' => 'required|max:20',//  姓名
            // 'orcl_phone' => 'required|numeric',//联系电话
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }
    
    // 预约设置验证器
    public function appointmentSetValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'reli_id.required' => '请输入预约单id',
            'reli_id.integer' => '参数类型错误',
            'reli_id.min' => '参数类型错误',
            'appoint_time.required' => '请选择时间',
            'appoint_time.date' => '参数类型错误',
            'appoint_remark.max' => '超过最大长度255字符',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'reli_id' => 'required|integer|min:1',
            'appoint_time' => 'required|date',
            // nullable 验证的字段可以为 null。例如可以包含空值的字符串和整数。
            'appoint_remark' => 'sometimes|nullable|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
