<?php

namespace App\Http\Requests\Validators\BasicManagement;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 账号表
class AdminValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_name.required' => '请输入姓名',
            'adm_name.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_name' => 'required|max:50',//姓名名称
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 收藏技师验证器
    public function collectionThValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_id.required' => '请选择技师',
            'adm_id.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_id' => 'required|integer',//技师id
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 获取角色数据
    public function getRoleDataValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'rol_id.required' => '请选择角色',
            'rol_id.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'rol_id' => 'required|integer',//角色id
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->messages()->all();
            return $msg[0];
        }
    }

    // 审核新申请创建的员工
    public function ProcessValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adp_id.required' => '请选择审核',
            'adp_state.required' => '请审核',
            'adp_id.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adp_id' => 'required|integer',//审核id
            'adp_state' => 'required',//审核状态
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->messages()->all();
            return $msg[0];
        }
    }

    // 审核新申请创建的员工
    public function getReasonValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'phone.required' => '请选择驳回手机号',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'phone' => 'required',//审核id
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->messages()->all();
            return $msg[0];
        }
    }

    // // 门店经营驾驶舱
    // public function dataCountValidator($data)
    // {
    //     // 自定义错误消息
    //     $messages = [
    //         'phone.required' => '请选择驳回手机号',
    //     ];

    //     // 数据验证
    //     $validator = Validator::make($data, [
    //         'phone' => 'required',//审核id
    //     ], $messages);

    //     // 判断数据验证是否成功
    //     if ($validator->fails()) {
    //         $msg = $validator->messages()->all();
    //         return $msg[0];
    //     }
    // }
}
