<?php
namespace App\Http\Models\Services\WarehouseManage;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\OutinRecord;
use App\Http\Models\Services\WarehouseManage\OutinStockLock;
use App\Http\Models\Api\WarehouseManage\Stocktake;
use App\Http\Models\Api\ReceivableBill;
use App\Http\Models\Api\WorkOrder;

class ReturnWarehousing extends Model
{
    /**
     * technicianRejection 技师拒单、技师终止
     *
     * @param [type] $user_info     用户信息
     * @param [type] $request       提交的数据
     * @param [type] $find_recede   退换入库数据
     * @param [type] $find_order    原始单相关数据
     * @param [type] $rec_ware_type 类型：1固定仓2技师库3移动仓
     * @param [type] $ord_wor_state 查询速电订单状态值是否为撤销状态
     * @param [type] $goo_data      商品数据
     * @return void
     */
    public static function technicianRejection(
        $user_info,
        $request,
        $find_recede,
        $find_order,
        $rec_ware_type,
        $ord_wor_state,
        $goo_data
    ) {
        // wogo_state 商品状态1正常2删除3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
        $work_goods = DB::table('recede_goods')
            ->where('rego_rec_id', $request['rec_id'])
            ->select('rego_goo_id as wogo_goo_id', 'rego_waon_class as wogo_waon_class', 'rego_recycle_number as wogo_goo_amount', 'rego_goo_inventory as wogo_goo_inventory', 'rego_ware_id as wogo_ware_id', 'rego_goo_price as wogo_goo_price', 'rego_wafg_id')
            ->get()->toArray();
        $rec_goo_all_amount = 0; //商品总数量

        if ($rec_ware_type == 1) { //发货从固定仓出库的 返回固定仓 仓位
            // 2.1 删除原来收回单id对应的商品数据
            $del_rego = DB::table('recede_goods')
                ->where('rego_rec_id', $request['rec_id'])
                ->delete();
            $rec_goo = [];
            $new_rego_orgo_id = [];
            $wago_class_goods = [];
            $num = 0;
            foreach ($goo_data as $key => $value) {
                if (!is_numeric($value['goo_id']) || $value['goo_id'] < 0  || !is_numeric($value['goo_price']) || $value['goo_price'] < 0 || !is_numeric($value['goo_amount']) || $value['goo_amount'] < 0 || !is_numeric($value['goo_recycle_amount']) || $value['goo_recycle_amount'] < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'参数类型错误'];
                }
                // 查询固定仓库库存商品信息
                $find_warehouse_goods = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $request['rec_ware_id'])
                    ->where('wago_class', $value['goo_waon_class'])
                    ->where('wago_goo_id', $value['goo_id'])
                    ->select('wago_id', 'wago_goo_id', 'wago_lock_quantity', 'wago_priority_lock_quantity', 'wago_stock_number', 'wago_priority_stock_number', 'wago_freight_stock_number', 'wago_freight_lock_quantity', 'wago_freight_priority_stock_number', 'wago_freight_priority_lock_quantity')
                    ->first();

                if (!empty($value['goo_wafr_id'])) { //仓位
                    // 查询仓位商品库存数据
                    $find_warehouse_freight_goods = DB::table('warehouse_freight_goods')
                        ->where('wafg_ware_id', $find_recede->rec_ware_id)
                        ->where('wafg_class', $value['goo_waon_class'])
                        ->where('wafg_goo_id', $value['goo_id'])
                        ->where('wafg_wafr_id', $value['goo_wafr_id'])
                        ->select('wafg_id', 'wafg_wafr_id', 'wafg_wago_id', 'wafg_ware_id', 'wafg_class', 'wafg_goo_id', 'wafg_stock_number', 'wafg_priority_stock_number')
                        ->first();

                    $goo_recycle_amount[$value['goo_id']] = $value['goo_recycle_amount']; //单个商品回收总数量
                    if (empty($find_warehouse_freight_goods)) {
                        $wafg_add_data['wafg_wafr_id'] = $value['goo_wafr_id'];
                        $wafg_add_data['wafg_wago_id'] = $find_warehouse_goods->wago_id;
                        $wafg_add_data['wafg_ware_id'] = $request['rec_ware_id'];
                        $wafg_add_data['wafg_class'] = $value['goo_waon_class'];
                        $wafg_add_data['wafg_goo_id'] = $value['goo_id'];
                        if ($value['goo_inventory'] == 1) { //良品
                            $wafg_add_data['wafg_stock_number'] = $value['goo_recycle_amount'];
                        }
                        $wafg_id = DB::table('warehouse_freight_goods')->insertGetId($wafg_add_data);
                        $find_warehouse_freight_goods = DB::table('warehouse_freight_goods')
                            ->where('wafg_id', $wafg_id)
                            ->select('wafg_id', 'wafg_wafr_id', 'wafg_wago_id', 'wafg_ware_id', 'wafg_class', 'wafg_goo_id', 'wafg_lock_quantity', 'wafg_priority_lock_quantity', 'wafg_stock_number', 'wafg_priority_stock_number')
                            ->first();

                        $lock_edit_res = true;
                    } else {
                        $wafg_id = $find_warehouse_freight_goods->wafg_id;
                        // 固定仓库商品良品数量增加
                        if ($value['goo_inventory'] == 1) {
                            $lock_wago_edit['wafg_stock_number'] = $find_warehouse_freight_goods->wafg_stock_number + $value['goo_recycle_amount'];
                        } else {
                            // 固定仓库商品优先数量增加
                            $lock_wago_edit['wafg_priority_stock_number'] = $find_warehouse_freight_goods->wafg_priority_stock_number + $value['goo_recycle_amount']; //优先库存数量
                        }
                        $lock_wago_edit['wafg_update_time'] = date('Y-m-d H:i:s');
                        $lock_edit_res = DB::table('warehouse_freight_goods')
                            ->where('wafg_id', $wafg_id)
                            ->update($lock_wago_edit);
                    }

                    // 库存扣除方式1.良品 2.优先
                    if ($value['goo_inventory'] == 1) { //良品
                        // 固定仓库良品锁定总数量增加
                        $lock_wores = DB::table('warehouse_onhand')
                            ->where('waon_ware_id', $find_recede->rec_ware_id)
                            ->where('waon_class', $value['goo_waon_class'])
                            ->increment('waon_stock_fine_amount', $value['goo_recycle_amount']);
                        // 仓位库存数量增加
                        $wafr_lock_res = DB::table('warehouse_freight')
                            ->where('wafr_id', $value['goo_wafr_id'])
                            ->increment('wafr_all_stock', $value['goo_recycle_amount']);
                        // 固定仓的仓位良品库存数量增加
                        $lock_res = DB::table('warehouse_goods')
                            ->where('wago_id', $find_warehouse_freight_goods->wafg_wago_id)
                            ->increment('wago_freight_stock_number', $value['goo_recycle_amount']);
                        //固定仓的良品库存数量(仓库+仓位)增加
                        $lock_all_res = DB::table('warehouse_goods')
                            ->where('wago_id', $find_warehouse_freight_goods->wafg_wago_id)
                            ->increment('wago_stock_number', $value['goo_recycle_amount']);
                        // 固定仓的总库存数量增加
                        $lock_all_amount = DB::table('warehouse_onhand')
                            ->where('waon_ware_id', $find_recede->rec_ware_id)
                            ->where('waon_class', $value['goo_waon_class'])
                            ->increment('waon_all_amount', $value['goo_recycle_amount']);
                    }

                    if (isset($wago_class_goods[$value['goo_inventory']][$value['goo_waon_class']][$value['goo_id']])) {
                        $wago_class_goods[$value['goo_inventory']][$value['goo_waon_class']][$value['goo_id']]['goo_recycle_amount'] = $wago_class_goods[$value['goo_inventory']][$value['goo_waon_class']][$value['goo_id']]['goo_recycle_amount'] + $value['goo_recycle_amount']; //仓库类型对应的商品，出入库记录
                    } else {
                        $wago_class_goods[$value['goo_inventory']][$value['goo_waon_class']][$value['goo_id']] = $value; //仓库类型对应的商品，出入库记录
                    }
                    $rec_goo_all_amount += $value['goo_recycle_amount']; //回收总数量
                    // 回收单商品表重新添加的商品数据
                    if (in_array($value['rego_orgo_id'], $new_rego_orgo_id)) {
                        $old_num = array_search($value['rego_orgo_id'], $new_rego_orgo_id); //已有商品 数组的key
                        $rego_data[$old_num]['rego_recycle_number'] += $value['goo_recycle_amount']; //单个商品回收总数量
                        if ($value['goo_inventory'] == 1) {
                            $rego_data[$old_num]['rego_fine_quantity'] += $value['goo_recycle_amount']; //良品回收数量
                        } elseif ($value['goo_inventory'] == 2) {
                            $rego_data[$old_num]['rego_priority_quantity'] += $value['goo_recycle_amount']; //良品回收数量
                        }
                    } else {
                        // 回收单商品表重新添加的商品数据
                        $rego_data[$num]['rego_rec_id'] = $request['rec_id']; //回收id
                        $rego_data[$num]['rego_ware_id'] = $request['rec_ware_id']; //仓库id
                        $rego_data[$num]['rego_waon_class'] = $value['goo_waon_class']; //仓库类别
                        $rego_data[$num]['rego_wafr_id'] = $value['goo_wafr_id']; //仓位id
                        $rego_data[$num]['rego_goo_id'] = $value['goo_id']; //商品id
                        $rego_data[$num]['rego_goo_name'] = $value['goo_name']; //商品名称
                        $rego_data[$num]['rego_goo_goods_encode'] = $value['goo_goods_encode']; //检索编码
                        $rego_data[$num]['rego_sell_number'] = $value['goo_amount']; //销售数量
                        $rego_data[$num]['rego_recycle_number'] = $value['goo_recycle_amount']; //单个商品回收总数量
                        if ($value['goo_inventory'] == 1) {
                            $rego_data[$num]['rego_fine_quantity'] = $value['goo_recycle_amount']; //良品回收数量
                        } elseif ($value['goo_inventory'] == 2) {
                            $rego_data[$num]['rego_priority_quantity'] = $value['goo_recycle_amount']; //良品回收数量
                        }
                        $rego_data[$num]['rego_wafg_id'] = $wafg_id; //仓位商品id

                        $rego_data[$num]['rego_goo_inventory'] = $value['goo_inventory'];
                        $rego_data[$num]['rego_orgo_id'] = $value['rego_orgo_id']; //仓库商品id
                        $rego_data[$num]['rego_goo_unit'] =  isset($value['rego_goo_unit'])?$value['rego_goo_unit']:''; //单位
                        $rego_data[$num]['rego_goo_unta_id'] =  isset($value['rego_goo_unta_id'])?$value['rego_goo_unta_id']:''; //单位id
                        $new_rego_orgo_id[$num] = $value['rego_orgo_id'];
                        $num++;
                    }
                } else {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'数据错误,请重新上传1'];
                }
                if (!$lock_edit_res || !$lock_res || !$lock_all_amount) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'退换回收：失败55'];
                }
            }
            if (!empty($rego_data)) {
                foreach ($rego_data as $key => $value) {
                    $rego_res = DB::table('recede_goods')->insertGetId($value); //一次插入多条数据，优先商品id会出错
                    if (!$rego_res) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'退换回收：失败5'];
                    }
                }

                // 遍历仓库类型数据，处理固定仓库对应仓库类型的出入库记录
                foreach ($wago_class_goods as $goo_inventory => $new_class_goods_data) {
                    foreach ($new_class_goods_data as $waon_class_key => $class_goods_data) {
                        // 查询仓库类别的进销存计算方式
                        $goo_all_amount = 0;
                        foreach ($class_goods_data as $goo_id_key => $value) {
                            // 出入库记录需要的的商品数组
                            $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_quantity'] = $value['goo_recycle_amount']; //出入库商品数量
                            $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_inventory'] = $value['goo_inventory']; //出入库商品类型，类型1良品2优先
                            $goo_all_amount += $value['goo_recycle_amount'];

                            // 出入库记录需要
                            $oure_goods_id[$goo_id_key] = $value['goo_id']; //出入库商品id
                            $oure_goods_quantity[$goo_id_key] = $value['goo_recycle_amount']; //出入库商品数量
                            $oure_goods_inventory[$goo_id_key] = $value['goo_inventory']; //出入库商品类型，类型1良品2优先
                        }

                        // 查询入库
                        $find_in_ware = DB::table('warehouse_onhand')
                            ->where('waon_ware_id', $find_recede->rec_ware_id)
                            ->where('waon_class', $waon_class_key)
                            ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                            ->first();
                        $oure_goods_data = $oure_goods_dataarray[$waon_class_key];
                        $oure_class_goo_id = array_keys($oure_goods_data);
                        // 新增一条入库记录
                        $oure_in_data = OutinRecord::addition(
                            $user_info, //用户信息
                            $find_order->wor_order_id, //原始单的关联id
                            $find_order->wor_order_number, //原始单的关联单号
                            6, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                            $find_recede->rec_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                            $find_recede->recl_client_id, //选择的客户id,会员id/单位id
                            $find_recede->rec_number, //原始单号
                            $find_recede->rec_ware_id, //入库仓库id
                            0, //出库仓库id
                            $goo_all_amount, //出库的商品总量
                            5, //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库 9.发货单
                            3, //操作类型：1锁定库存2出库3入库4调货5发货
                            $find_in_ware->waon_stock_fine_amount, //良品总库存
                            $find_in_ware->waon_lock_fine_amount, //良品锁定数量
                            $find_in_ware->waon_stock_priority_amount, //优先总库存
                            $find_in_ware->waon_lock_priority_amount, //优先锁定数量
                            $find_in_ware->waon_stock_unchecked_amount, //待检测总库存
                            2, //出入库类型：1出库，2入库
                            $waon_class_key, //仓库类别
                            $oure_goods_id, //数组，商品id
                            $oure_goods_quantity, //数组，商品数量
                            $oure_goods_inventory, //数组，出库类型1良品2优先
                            [], //仓位id
                            $oure_class_goo_id //仓库类别下的商品id
                        );
                        if (!$oure_in_data) {
                            return ['code'=>500, 'msg'=>'error', 'data'=>'退换回收：失败6'];
                        }
                    }
                }

                foreach ($goo_data as $key => $value) {
                    $primary_id = DB::table('recede_goods')
                        ->where('rego_rec_id', $request['rec_id'])
                        ->where('rego_goo_id', $value['goo_id'])
                        ->where('rego_orgo_id', $value['rego_orgo_id'])
                        ->value('rego_id');
                    // 仓位入库记录
                    $outin_recore_res = Stocktake::junkaddition(
                        $user_info,
                        $request['rec_ware_id'], //仓库id
                        $value['goo_waon_class'], //仓库类型
                        $value['goo_wafr_id'], //仓位id
                        6, //6退货入库
                        $request['rec_id'], //原始单id
                        $find_recede->rec_number, //原始单号
                        $primary_id, //关联商品表主键id
                        $value['goo_id'], //商品表主键id
                        2, //出入库类型：1出库2入库
                        $value['goo_recycle_amount'], //商品数量
                        $value['goo_inventory'] //出库类型1良品2优先3待检测
                    );
                    if ($outin_recore_res['code'] == 500) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'退换回收：失败77'];
                    }
                }
            }
        }

        // 3 更改退换回收单表数据
        $update_recycle['rec_amount'] = $rec_goo_all_amount; //回收总数量
        $update_recycle['rec_remark'] = isset($request['rec_remark']) ? $request['rec_remark'] : ''; //备注
        $update_recycle['rec_state'] = 2; //回收状态 1.未回收 2.已回收
        $update_recycle['rec_date'] = $request['rec_date']; //日期
        $update_recycle['rec_ware_id'] = $find_recede->rec_ware_id; //回收仓库
        $update_recycle['rec_record_adm_id'] = $user_info->adm_id; //记录人
        $update_recycle['rec_update_time'] = date("Y-m-d H:i:s"); //更新时间
        $rec_res = DB::table('recede_recycle')
            ->where('rec_id', $request['rec_id'])
            ->update($update_recycle);
        if ($rec_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'退换回收：成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'退换回收：失败3'];
        }
    }

    /**
     * [technicianReduceStock 减少技师库的库存数量]
     * @param  [type] $user_info   [用户信息]
     * @param  [type] $find_recede [退换入库数据]
     * @param  [type] $request     [提交的数据]
     * @return [type]              [description]
     */
    public static function technicianReduceStock(
        $user_info,
        $find_recede,
        $request
    ) {
        // 查询技师退回商品
        $find_goods = DB::table('recede_goods')
            ->where('rego_rec_id', $request['rec_id'])
            ->select('rego_id', 'rego_rec_id', 'rego_ware_id', 'rego_waon_class', 'rego_wago_id', 'rego_goo_id', 'rego_recycle_number', 'rego_goo_inventory', 'rego_wafg_id')
            ->get()->toArray();
        $wago_class_goods = []; //仓库商品数量
        foreach ($find_goods as $key => $value) {
            if (isset($wago_class_goods[$value->rego_goo_inventory][$value->rego_waon_class][$value->rego_goo_id])) {
                $wago_class_goods[$value->rego_goo_inventory][$value->rego_waon_class][$value->rego_goo_id]['rego_recycle_number'] += $value->rego_recycle_number;
            } else {
                $wago_class_goods[$value->rego_goo_inventory][$value->rego_waon_class][$value->rego_goo_id] = (array)$value;
            }
        }
        $wogo_goo_id = array_column($find_goods, 'rego_goo_id');
        $wogo_waon_class = array_unique(array_column($find_goods, 'rego_waon_class'));

        $adm_ware_id = $find_recede->rec_mobile_ware_id;
        $warehouse_goods = DB::table('warehouse_goods')
            ->where('wago_ware_id', $adm_ware_id)
            ->whereIn('wago_goo_id', $wogo_goo_id)
            ->get(['wago_id', 'wago_class', 'wago_stock_number', 'wago_priority_stock_number', 'wago_goo_id'])
            ->toArray();
        if (empty($warehouse_goods)) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'退换回收：失败8'];
        }
        foreach ($warehouse_goods as $key => $value) {
            $warehouse_class_goods[$value->wago_class][$value->wago_goo_id] = (array)$value;
        }
        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $lock_quantity_sql = '';
        $priority_lock_quantity_sql = '';
        $time_sql = '';
        $ids = '';
        $waon_class_fine_quantity = []; //仓库类别对应良品库存总数量
        $waon_class_priority_quantity = []; //仓库类别对应优先库存总数量
        // 技师库要出库的商品
        foreach ($wago_class_goods as $rego_goo_inventory => $new_wago_class) {
            foreach ($new_wago_class as $waon_class => $class_goods_data) {
                foreach ($class_goods_data as $goo_id => $value) {
                    // 商品出库类型，良品出库
                    if ($value['rego_goo_inventory'] == 1) {
                        // 良品剩余库存数量
                        $surplus_quantity = $warehouse_class_goods[$waon_class][$goo_id]['wago_stock_number'] - $value['rego_recycle_number'];
                        if ($surplus_quantity < 0) {
                            return ['code'=>500, 'msg'=>'error', 'data'=>'技师库内商品数量不足3'];
                        }
                        // 更改技师库良品库存数量
                        $lock_quantity_sql = $lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_stock_number` - ' . $value['rego_recycle_number'];

                        if (isset($waon_class_fine_quantity[$waon_class])) {
                            $waon_class_fine_quantity[$waon_class] += $value['rego_recycle_number']; //仓库类别对应良品库存总数量
                        } else {
                            $waon_class_fine_quantity[$waon_class] = $value['rego_recycle_number']; //仓库类别对应良品库存总数量
                        }
                    } else { // 商品出库类型，优先出库
                        // 优先剩余库存数量
                        $surplus_quantity = $warehouse_class_goods[$waon_class][$goo_id]['wago_priority_stock_number'] - $value['rego_recycle_number'];
                        if ($surplus_quantity < 0) {
                            return ['code'=>500, 'msg'=>'error', 'data'=>'技师库内商品数量不足4'];
                        }
                        // 更改技师库优先库存数量
                        $priority_lock_quantity_sql = $priority_lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_stock_number` - ' . $value['rego_recycle_number'];
                        if (isset($waon_class_priority_quantity[$waon_class])) {
                            $waon_class_priority_quantity[$waon_class] += $value['rego_recycle_number']; //仓库类别对应优先库存总数量
                        } else {
                            $waon_class_priority_quantity[$waon_class] = $value['rego_recycle_number']; //仓库类别对应优先库存总数量
                        }
                    }

                    $time_sql = $time_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN "' . date('Y-m-d H:i:s') . '"'; // 更改时间
                    $ids = $ids . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ',';
                }
            }
        }
        // 2.1 移动仓商品表减锁定库存
        if ($lock_quantity_sql) {
            $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $lock_quantity_sql . ' END,';
        }
        if ($priority_lock_quantity_sql) {
            $sql = $sql . ' `wago_priority_stock_number`=  CASE `wago_id` ' . $priority_lock_quantity_sql . ' END,';
        }
        $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $time_sql . ' END'; //修改时间
        $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
        $wago_res = DB::update($sql);

        // 查询仓库总数量仓库的类别对应的id
        $find_waon_data = DB::table('warehouse_onhand')
            ->where('waon_ware_id', $adm_ware_id)
            ->whereIn('waon_class', $wogo_waon_class)
            ->pluck('waon_id', 'waon_class')->toArray();
        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $lock_fine_sql = '';
            $all_amount_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_fine_quantity as $key => $value) {
                // 查询库存数量
                $stock_fine_amount = DB::table('warehouse_onhand')
                    ->where('waon_id', $find_waon_data[$key])
                    ->value('waon_stock_fine_amount');
                if ($stock_fine_amount - $value < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'当前库存数量不足'];
                }
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_stock_fine_amount` - ' . $value;
                $all_amount_sql = $all_amount_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_all_amount` - ' . $value;
                $time_sql = $time_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN "' . date('Y-m-d H:i:s') . '"';

                $ids = $ids . $find_waon_data[$key] . ',';
            }
            $sql = $sql . ' `waon_stock_fine_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_all_amount`=  CASE `waon_id` ' . $all_amount_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_fine_res = DB::update($sql);
        } else {
            $waon_fine_res = true;
        }

        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $lock_fine_sql = '';
            $all_amount_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_priority_quantity as $key => $value) {
                // 查询库存数量
                $stock_priority_amount = DB::table('warehouse_onhand')
                    ->where('waon_id', $find_waon_data[$key])
                    ->value('waon_stock_priority_amount');
                if ($stock_priority_amount - $value < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'当前库存数量不足'];
                }
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_stock_priority_amount` - ' . $value;
                $all_amount_sql = $all_amount_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_all_amount` - ' . $value;
                $time_sql = $time_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN "' . date('Y-m-d H:i:s') . '"';

                $ids = $ids . $find_waon_data[$key] . ',';
            }
            $sql = $sql . ' `waon_stock_priority_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_all_amount`=  CASE `waon_id` ' . $all_amount_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_priority_res = DB::update($sql);
        } else {
            $waon_priority_res = true;
        }
        // 遍历仓库类型数据，处理固定仓库对应仓库类型的出入库记录
        $osld_out_key = 0;
        foreach ($wago_class_goods as $rego_goo_inventory => $new_wago_class) {
            foreach ($new_wago_class as $waon_class_key => $class_goods_data) {
                // 进销存，固定仓库，进销存库存数量减少
                // 查询仓库类别的进销存计算方式
                $goo_all_amount = 0;
                foreach ($class_goods_data as $goo_id_key => $value) {
                    // 出入库记录需要的的商品数组
                    $oure_goods_data[$waon_class_key][$goo_id_key]['goo_quantity'] = $value['rego_recycle_number']; //出入库商品数量
                    $oure_goods_data[$waon_class_key][$goo_id_key]['goo_inventory'] = $value['rego_goo_inventory']; //出入库商品类型，类型1良品2优先
                    $goo_all_amount += $value['rego_recycle_number'];

                    // 出入库记录需要
                    $oure_goods_id[$waon_class_key][$goo_id_key] = $value['rego_goo_id']; //出入库商品id
                    $oure_goods_quantity[$waon_class_key][$goo_id_key] = $value['rego_recycle_number']; //出入库商品数量
                    $oure_goods_inventory[$waon_class_key][$goo_id_key] = $value['rego_goo_inventory']; //出入库商品类型，类型1良品2优先，页面没有用到这个，暂定1

                    // 库存锁定-出入库记录表
                    $osld_goo_data[$osld_out_key]['goo_waon_class'] = $waon_class_key; //仓库类别：1货物仓2非货物仓3旧货仓4临时仓
                    $osld_goo_data[$osld_out_key]['goo_id'] = $value['rego_goo_id']; //商品id
                    $osld_goo_data[$osld_out_key]['goo_number'] = $value['rego_recycle_number']; //商品数量
                    $osld_goo_data[$osld_out_key]['goo_out_in_type'] = 1; //出入库类型：1出库2入库3锁定4取消锁定
                    $osld_goo_data[$osld_out_key]['goo_inventory'] = $value['rego_goo_inventory']; //类型1良品2优先3待检测
                    // 查询仓库商品库存数量
                    $find_wago_data = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $adm_ware_id)
                        ->where('wago_class', $waon_class_key)
                        ->where('wago_goo_id', $value['rego_goo_id'])
                        ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
                        ->first();
                    if ($value['rego_goo_inventory'] == 1) { //良品
                        $osld_goo_data[$osld_out_key]['old_stock_number'] = $find_wago_data->wago_stock_number + $value['rego_recycle_number']; //旧的商品良品库存数量
                        $osld_goo_data[$osld_out_key]['old_priority_number'] = $find_wago_data->wago_priority_stock_number; //旧的商品优先库存数量
                        $osld_goo_data[$osld_out_key]['new_stock_number'] = $find_wago_data->wago_stock_number; //新的商品良品库存数量
                        $osld_goo_data[$osld_out_key]['new_priority_number'] = $find_wago_data->wago_priority_stock_number; //新的商品优先库存数量
                    } else { //优先
                        $osld_goo_data[$osld_out_key]['old_stock_number'] = $find_wago_data->wago_stock_number; //旧的商品良品库存数量
                        $osld_goo_data[$osld_out_key]['old_priority_number'] = $find_wago_data->wago_priority_stock_number + $value['rego_recycle_number']; //旧的商品优先库存数量
                        $osld_goo_data[$osld_out_key]['new_stock_number'] = $find_wago_data->wago_stock_number; //新的商品良品库存数量
                        $osld_goo_data[$osld_out_key]['new_priority_number'] = $find_wago_data->wago_priority_stock_number; //新的商品优先库存数量
                    }
                    $osld_goo_data[$osld_out_key]['old_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //旧的商品良品库存锁定数量
                    $osld_goo_data[$osld_out_key]['old_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //旧的商品优先库存锁定数量
                    $osld_goo_data[$osld_out_key]['old_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //旧的商品待检测库存数量
                    $osld_goo_data[$osld_out_key]['new_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //新的商品良品库存锁定数量
                    $osld_goo_data[$osld_out_key]['new_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //新的商品优先库存锁定数量
                    $osld_goo_data[$osld_out_key]['new_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //新的商品待检测库存数量
                    $osld_goo_data[$osld_out_key]['osld_update_time'] = date('Y-m-d H:i:s'); //更新时间
                    $osld_goo_data[$osld_out_key] = (object)$osld_goo_data[$osld_out_key];
                    $osld_out_key++;
                }
                $find_ware = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $adm_ware_id)
                    ->where('waon_class', $waon_class_key)
                    ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                    ->first();
                // 新增一条出库记录
                $oure_goods_data = $oure_goods_data[$waon_class_key];
                $oure_class_goo_id = array_keys($oure_goods_data);
                // 根据原始单id,查询到订单id
                $find_order = DB::table('work_order')
                    ->where('wor_id', $find_recede->rec_ord_id)
                    ->select('wor_order_id', 'wor_order_number')
                    ->first();
                $oure_res = OutinRecord::addition(
                    $user_info, //用户信息
                    $find_order->wor_order_id, //原始单的关联id
                    $find_order->wor_order_number, //原始单的关联单号
                    1, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                    $find_recede->rec_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    $find_recede->recl_client_id, //选择的客户id,会员id/单位id
                    $find_recede->rec_number, //原始单号
                    0, //入库仓库id
                    $adm_ware_id, //出库仓库id
                    $goo_all_amount, //出库的商品总量
                    10, //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库 9.发货单
                    2, //操作类型：1锁定库存2出库3入库4调货5发货
                    $find_ware->waon_stock_fine_amount, //良品总库存
                    $find_ware->waon_lock_fine_amount, //良品锁定数量
                    $find_ware->waon_stock_priority_amount, //优先总库存
                    $find_ware->waon_lock_priority_amount, //优先锁定数量
                    $find_ware->waon_stock_unchecked_amount, //待检测总库存
                    1, //出入库类型：1出库，2入库
                    $waon_class_key, //数组，出库类型1良品2优先
                    $oure_goods_id[$waon_class_key], //数组，商品id
                    $oure_goods_quantity[$waon_class_key], //数组，商品数量
                    $oure_goods_inventory[$waon_class_key], //数组，出库类型1良品2优先
                    $oure_class_goo_id //仓库类别下的商品id
                );
                // 库存锁定-出入库记录
                $oslr_res = OutinStockLock::addition(
                    $user_info, //用户信息
                    $find_order->wor_order_id, //原始单的关联id
                    $find_order->wor_order_number, //原始单的关联单号
                    1, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                    $find_recede->rec_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    $find_recede->recl_client_id, //选择的客户id,会员id/单位id
                    $find_recede->rec_number, //原始单号
                    $adm_ware_id, //出库/入库的仓库id
                    $goo_all_amount, //出库/入库总数量
                    10, //类型：1锁定库存2取消锁定3调拨单4旧货回收单5退换回收单6订单出库7部分入库8部分出库9发货单10移动仓出库11换货出库12换货入库13退货入库14退货出库15盘库单
                    $find_ware->waon_stock_fine_amount, //良品总库存
                    $find_ware->waon_lock_fine_amount, //良品锁定数量
                    $find_ware->waon_stock_priority_amount, //优先总库存
                    $find_ware->waon_lock_priority_amount, //优先锁定数量
                    $find_ware->waon_stock_unchecked_amount, //待检测总库存
                    1, //出入库类型：1出库，2入库
                    $osld_goo_data
                );
                unset($osld_goo_data);
                if (!$oure_res || !$oslr_res) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'退换回收：失败9'];
                }
            }
        }
        if ($wago_res && $waon_priority_res && $waon_fine_res) {
            return ['code'=>200, 'msg'=>'error', 'data'=>'技师库库存减少成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'退换回收：失败10'];
        }
    }

    /**
     * [returnOrder 工作总台生成退货单]
     * @param  [type] $user_info   [用户信息]
     * @param  [type] $find_recede [退换入库数据]
     * @param  [type] $request     [提交的数据]
     * @return [type]              [description]
     */
    public static function returnOrder(
        $user_info,
        $find_recede,
        $request,
        $goo_data,
        $find_order,
        $rec_ware_type
    ) {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        //查询原有数据
        $old_data = DB::table('recede_goods')
            ->where('rego_rec_id', $request['rec_id'])
            ->get()->toArray();
        if($old_data){
            foreach ($old_data as $key => $value){
                $old_recede_goods[$value->rego_goo_id] = $value;
            }
        }
        // 2.1 删除原来收回单id对应的商品数据
        $del_rego = DB::table('recede_goods')
            ->where('rego_rec_id', $request['rec_id'])
            ->delete();

        $voucher_cost = 0;
        $rec_goo_all_amount = 0; //回收商品总数量
        $rec_goo_all_price = 0; //回收商品总金额
        $new_rego_orgo_id = [];
        $wago_class_goods = [];
        $num = 0;
        //处理商品数量
        foreach ($goo_data as $go_key => &$go_value){
            if(isset($go_value['rego_goo_unta_id'])){
                $unta_id =  isset($go_value['rego_goo_unta_id'])?$go_value['rego_goo_unta_id']:''; //单位id
            }else{
                $unta_id =  $old_recede_goods[$go_value['goo_id']]->rego_goo_unta_id;
            }
            $goo_unit_conversion = Db::table('goods')
                ->where('goo_id', $go_value['goo_id'])
                ->value('goo_unit_conversion');
            $go_value['new_goo_recycle_amount'] = $go_value['goo_recycle_amount'];//回收数量是1卷
        }
        foreach ($goo_data as $key => $value) {
            if (!is_numeric($value['goo_id']) || $value['goo_id'] < 0 || !is_numeric($value['goo_amount']) || $value['goo_amount'] < 0 || !is_numeric($value['goo_recycle_amount']) || $value['goo_recycle_amount'] < 0) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'参数类型错误'];
            }

            // 出入库记录需要的的商品数租
            if (isset($wago_class_goods[$value['goo_inventory']][$value['goo_waon_class']][$value['goo_id']])) {
                $wago_class_goods[$value['goo_inventory']][$value['goo_waon_class']][$value['goo_id']]['goo_recycle_amount'] = $wago_class_goods[$value['goo_inventory']][$value['goo_waon_class']][$value['goo_id']]['goo_recycle_amount'] + $value['goo_recycle_amount']; //仓库类型对应的商品，出入库记录
            } else {
                $wago_class_goods[$value['goo_inventory']][$value['goo_waon_class']][$value['goo_id']] = $value; //仓库类型对应的商品，出入库记录
            }

            $wago_class = $value['goo_waon_class']; //仓库类别

            // 4. 仓库商品表
            // 4.1 查询仓库商品库存数量
            $warehouse_goods = DB::table('warehouse_goods')
                ->where('wago_ware_id', $request['rec_ware_id'])
                ->where('wago_class', $wago_class)
                ->where('wago_goo_id', $value['goo_id'])
                ->select(['wago_id', 'wago_class', 'wago_stock_number', 'wago_priority_stock_number', 'wago_unchecked_stock_number', 'wago_goo_id', 'wago_freight_stock_number', 'wago_freight_priority_stock_number'])
                ->first();
            if (empty($warehouse_goods)) { //新增商品
                $wago_add_data['wago_ware_id'] = $request['rec_ware_id'];
                $wago_add_data['wago_class'] = $wago_class;
                $wago_add_data['wago_goo_id'] = $value['goo_id'];
                if ($value['goo_inventory'] == 1) { //良品
                    $wago_add_data['wago_stock_number'] = $value['goo_recycle_amount'];
                    if ($rec_ware_type == 1) {
                        $wago_add_data['wago_freight_stock_number'] = $value['goo_recycle_amount'];
                    }
                    $waon_stock_fine_amount = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $find_recede->rec_ware_id)
                        ->where('waon_class', $value['goo_waon_class'])
                        ->increment('waon_stock_fine_amount', $value['goo_recycle_amount']);
                } elseif ($value['goo_inventory'] == 2) { //优先
                    $wago_add_data['wago_priority_stock_number'] = $value['goo_recycle_amount'];
                    if ($rec_ware_type == 1) {
                        $wago_add_data['wago_freight_priority_stock_number'] = $value['goo_recycle_amount'];
                    }
                    // 固定仓的总库存数量增加
                    // 固定仓库优先商品数量增加
                    $waon_stock_fine_amount = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $find_recede->rec_ware_id)
                        ->where('waon_class', $value['goo_waon_class'])
                        ->increment('waon_stock_priority_amount', $value['goo_recycle_amount']);
                } else {
                    $wago_add_data['wago_unchecked_stock_number'] = $value['goo_recycle_amount'];
                }
                $waon_all_amount = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $find_recede->rec_ware_id)
                    ->where('waon_class', $value['goo_waon_class'])
                    ->increment('waon_all_amount', $value['goo_recycle_amount']);
                $wago_add_res = DB::table('warehouse_goods')->insertGetId($wago_add_data);
                $wago_id = $wago_add_res;
                $wago_stock_number = true;
                $wago_freight_stock_number = true;
            } else {
                $wago_id = $warehouse_goods->wago_id;
                // 库存扣除方式1.良品 2.优先
                if ($value['goo_inventory'] == 1) { //良品
                    // 固定仓库商品良品数量增加
                    // 当前订单已发货,速电锁定撤销,入库时,固定仓库存数量增加
                    // 固定仓的总库存数量增加
                    $waon_all_amount = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $find_recede->rec_ware_id)
                        ->where('waon_class', $value['goo_waon_class'])
                        ->increment('waon_all_amount', $value['goo_recycle_amount']);

                    $waon_stock_fine_amount = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $find_recede->rec_ware_id)
                        ->where('waon_class', $value['goo_waon_class'])
                        ->increment('waon_stock_fine_amount', $value['goo_recycle_amount']);

                    // 固定仓的良品库存数量(仓库+仓位)增加
                    $wago_stock_number = DB::table('warehouse_goods')
                        ->where('wago_id', $wago_id)
                        ->increment('wago_stock_number', $value['goo_recycle_amount']);
                    if ($rec_ware_type == 1) {
                        // 固定仓的良品库存数量(仓库+仓位)增加
                        $wago_freight_stock_number = DB::table('warehouse_goods')
                            ->where('wago_id', $wago_id)
                            ->increment('wago_freight_stock_number', $value['goo_recycle_amount']);
                    } else {
                        $wago_freight_stock_number = true;
                    }
                } else { //优先
                    // 固定仓的总库存数量增加
                    $waon_all_amount = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $find_recede->rec_ware_id)
                        ->where('waon_class', $value['goo_waon_class'])
                        ->increment('waon_all_amount', $value['goo_recycle_amount']);
                    // 固定仓库优先商品数量增加
                    $waon_stock_fine_amount = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $find_recede->rec_ware_id)
                        ->where('waon_class', $value['goo_waon_class'])
                        ->increment('waon_stock_priority_amount', $value['goo_recycle_amount']);
                    if ($rec_ware_type == 1) {
                        //仓库商品表的仓位优先库存数量增加
                        $wago_freight_stock_number = DB::table('warehouse_goods')
                            ->where('wago_id', $wago_id)
                            ->increment('wago_freight_priority_stock_number', $value['goo_recycle_amount']);
                    } else {
                        $wago_freight_stock_number = true;
                    }
                    // 仓库商品表的优先库存数量(仓库+仓位)增加
                    $wago_stock_number = DB::table('warehouse_goods')
                        ->where('wago_id', $wago_id)
                        ->increment('wago_priority_stock_number', $value['goo_recycle_amount']);
                }
                $wago_add_res = true;
            }
            if ($rec_ware_type == 1) { //固定仓
                $find_warehouse_freight_goods = DB::table('warehouse_freight_goods')
                    ->where('wafg_wafr_id', $value['goo_wafr_id'])
                    ->where('wafg_ware_id', $request['rec_ware_id'])
                    ->where('wafg_class', $wago_class)
                    ->where('wafg_goo_id', $value['goo_id'])
                    ->select(['wafg_id', 'wafg_wafr_id', 'wafg_wago_id', 'wafg_class', 'wafg_stock_number', 'wafg_priority_stock_number', 'wafg_unchecked_stock_number', 'wafg_goo_id', 'wafg_ware_id'])
                    ->first();
                if (empty($find_warehouse_freight_goods)) {
                    $wafg_add_data['wafg_wafr_id'] = $value['goo_wafr_id'];
                    $wafg_add_data['wafg_wago_id'] = $wago_id;
                    $wafg_add_data['wafg_goo_id'] = $value['goo_id'];
                    $wafg_add_data['wafg_ware_id'] = $request['rec_ware_id'];
                    $wafg_add_data['wafg_class'] = $wago_class;
                    if ($value['goo_inventory'] == 1) { //良品
                        $wafg_add_data['wafg_stock_number'] = $value['goo_recycle_amount'];
                        // 仓位优先库存数量增加
                        $wafr_lock_res = DB::table('warehouse_freight')
                            ->where('wafr_id', $value['goo_wafr_id'])
                            ->increment('wafr_all_stock', $value['goo_recycle_amount']);
                    } elseif ($value['goo_inventory'] == 2) { //优先
                        $wafg_add_data['wafg_priority_stock_number'] = $value['goo_recycle_amount'];
                        // 仓位优先库存数量增加
                        $wafr_lock_res = DB::table('warehouse_freight')
                            ->where('wafr_id', $value['goo_wafr_id'])
                            ->increment('wafr_priority_all_stock', $value['goo_recycle_amount']);
                    } else {
                        $wafg_add_data['wafg_unchecked_stock_number'] = $value['goo_recycle_amount'];
                        // 仓位优先库存数量增加
                        $wafr_lock_res = DB::table('warehouse_freight')
                            ->where('wafr_id', $value['goo_wafr_id'])
                            ->increment('wafr_unchecked_all_stock', $value['goo_recycle_amount']);
                    }
                    $wafg_add_res = DB::table('warehouse_freight_goods')->insertGetId($wafg_add_data);
                    $find_warehouse_freight_goods = DB::table('warehouse_freight_goods')
                        ->where('wafg_id', $wafg_add_res)
                        ->select('wafg_id', 'wafg_wafr_id', 'wafg_wago_id', 'wafg_class', 'wafg_stock_number', 'wafg_priority_stock_number', 'wafg_unchecked_stock_number', 'wafg_goo_id', 'wafg_ware_id')
                        ->first();
                    $wafg_stock_number = true;
                    $wafr_lock_res = true;
                } else {
                    $wafg_add_res = true;
                    // 库存扣除方式1.良品 2.优先
                    if ($value['goo_inventory'] == 1) { //良品
                        // 仓位商品表良品数量增加
                        $wafg_stock_number = DB::table('warehouse_freight_goods')
                            ->where('wafg_wafr_id', $value['goo_wafr_id'])
                            ->where('wafg_ware_id', $request['rec_ware_id'])
                            ->where('wafg_class', $wago_class)
                            ->where('wafg_goo_id', $value['goo_id'])
                            ->increment('wafg_stock_number', $value['goo_recycle_amount']);
                        // 仓位良品库存数量增加
                        $wafr_lock_res = DB::table('warehouse_freight')
                            ->where('wafr_id', $value['goo_wafr_id'])
                            ->increment('wafr_all_stock', $value['goo_recycle_amount']);
                    } else { //优先
                        // 仓位商品表优先库存增加
                        $wafg_stock_number = DB::table('warehouse_freight_goods')
                            ->where('wafg_wafr_id', $value['goo_wafr_id'])
                            ->where('wafg_ware_id', $request['rec_ware_id'])
                            ->where('wafg_class', $wago_class)
                            ->where('wafg_goo_id', $value['goo_id'])
                            ->increment('wafg_priority_stock_number', $value['goo_recycle_amount']);
                        // 仓位优先库存数量增加
                        $wafr_lock_res = DB::table('warehouse_freight')
                            ->where('wafr_id', $value['goo_wafr_id'])
                            ->increment('wafr_priority_all_stock', $value['goo_recycle_amount']);
                    }
                }
            } else {
                $wafg_add_res = true;
                $wafg_stock_number = true;
                $wafr_lock_res = true;
            }
            $rec_goo_all_amount += $value['goo_recycle_amount'];
            // 回收单商品表重新添加的商品数据
            if (in_array($value['rego_orgo_id'], $new_rego_orgo_id)) {
                $old_num = array_search($value['rego_orgo_id'], $new_rego_orgo_id); //已有商品 数组的key
                $rego_data[$old_num]['rego_recycle_number'] += $value['goo_recycle_amount']; //单个商品回收总数量
                if ($value['goo_inventory'] == 1) {
                    $rego_data[$old_num]['rego_fine_quantity'] += $value['goo_recycle_amount']; //良品回收数量
                } elseif ($value['goo_inventory'] == 2) {
                    $rego_data[$old_num]['rego_priority_quantity'] += $value['goo_recycle_amount']; //良品回收数量
                }
            } else {
                // 回收单商品表重新添加的商品数据
                $rego_data[$num]['rego_rec_id'] = $request['rec_id']; //回收id
                $rego_data[$num]['rego_ware_id'] = $request['rec_ware_id']; //仓库id
                $rego_data[$num]['rego_waon_class'] = $value['goo_waon_class']; //仓库类别
                $rego_data[$num]['rego_wafr_id'] = $value['goo_wafr_id']; //仓位id
                $rego_data[$num]['rego_goo_id'] = $value['goo_id']; //商品id
                $rego_data[$num]['rego_goo_name'] = $value['goo_name']; //商品名称
                $rego_data[$num]['rego_goo_goods_encode'] = $value['goo_goods_encode']; //检索编码
                $rego_data[$num]['rego_sell_number'] = $value['goo_amount']; //销售数量
                $rego_data[$num]['rego_recycle_number'] = $value['new_goo_recycle_amount']; //单个商品回收总数量
                if ($value['goo_inventory'] == 1) {
                    $rego_data[$num]['rego_fine_quantity'] = $value['new_goo_recycle_amount']; //良品回收数量
                } elseif ($value['goo_inventory'] == 2) {
                    $rego_data[$num]['rego_priority_quantity'] = $value['new_goo_recycle_amount']; //良品回收数量
                }
                if ($rec_ware_type == 1) {
                    $rego_data[$num]['rego_wafg_id'] = $find_warehouse_freight_goods->wafg_id; //仓位商品id
                } else {
                    $rego_data[$num]['rego_wafg_id'] = 0;
                }
                $rego_data[$num]['rego_wago_id'] = $wago_id; //仓库商品id
                $rego_data[$num]['rego_goo_inventory'] = $value['goo_inventory'];
                $rego_data[$num]['rego_orgo_id'] = $value['rego_orgo_id']; //订单商品id
                if(isset($value['rego_goo_unit'])){
                    $rego_data[$num]['rego_goo_unit'] =  isset($value['rego_goo_unit'])?$value['rego_goo_unit']:''; //单位
                }else{
                    $rego_data[$num]['rego_goo_unit'] =  $old_recede_goods[$value['goo_id']]->rego_goo_unit;
                }
                if(isset($value['rego_goo_unta_id'])){
                    $rego_data[$num]['rego_goo_unta_id'] =  isset($value['rego_goo_unta_id'])?$value['rego_goo_unta_id']:''; //单位id
                }else{
                    $rego_data[$num]['rego_goo_unta_id'] =  $old_recede_goods[$value['goo_id']]->rego_goo_unta_id;
                }
                $new_rego_orgo_id[$num] = $value['rego_orgo_id'];
                $num++;
            }

            if (!$wafg_add_res || !$wafg_stock_number || !$wago_freight_stock_number || !$wago_stock_number || !$waon_all_amount || !$waon_stock_fine_amount || !$wago_add_res || !$wafr_lock_res) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'退换入库失败!'];
            }
        }

        if (!empty($rego_data)) {
            foreach ($rego_data as $key => $value) {
                $rego_res = DB::table('recede_goods')->insertGetId($value);
                if (!$rego_res) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'退换回收：失败66'];
                }
            }
            $osld_in_key = 0;
            foreach ($wago_class_goods as $goo_inventory => $new_class_goods_data) {
                // 遍历仓库类型数据，处理固定仓库对应仓库类型的出入库记录
                foreach ($new_class_goods_data as $waon_class_key => $class_goods_data) {
                    // 查询仓库类别的进销存计算方式
                    $goo_all_amount = 0;
                    foreach ($class_goods_data as $goo_id_key => $value) {
                        // 出入库记录需要的的商品数组
                        $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_quantity'] = $value['goo_recycle_amount']; //出入库商品数量
                        $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_inventory'] = $value['goo_inventory']; //出入库商品类型，类型1良品2优先
                        $goo_all_amount += $value['goo_recycle_amount'];

                        // 出入库记录需要
                        $oure_goods_id[$goo_id_key] = $value['goo_id']; //出入库商品id
                        $oure_goods_quantity[$goo_id_key] = $value['goo_recycle_amount']; //出入库商品数量
                        $oure_goods_inventory[$goo_id_key] = $value['goo_inventory']; //出入库商品类型，类型1良品2优先
                        $oure_goods_price[$goo_id_key] = 0; //退货入库的商品金额
                    }
                    // 查询入库
                    $find_in_ware = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $find_recede->rec_ware_id)
                        ->where('waon_class', $waon_class_key)
                        ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                        ->first();
                    $oure_goods_data = $oure_goods_dataarray[$waon_class_key];
                    $oure_class_goo_id = array_keys($oure_goods_data);
                    if ($find_recede->rec_source_type == 8) { //工作总台，退货单
                        $oure_type = 13; //退货入库
                    } else {
                        $oure_type = 5; //类型5.退换回收单（技师拒单、技师退回、技师终止）
                    }
                    // 新增一条入库记录
                    $oure_in_data = OutinRecord::addition(
                        $user_info, //用户信息
                        $find_order->wor_order_id, //原始单的关联id
                        $find_order->wor_order_number, //原始单的关联单号
                        6, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                        $find_recede->rec_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                        $find_recede->recl_client_id, //选择的客户id,会员id/单位id
                        $find_recede->rec_number, //原始单号
                        $find_recede->rec_ware_id, //入库仓库id
                        0, //出库仓库id
                        $goo_all_amount, //出库的商品总量
                        $oure_type, //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库 9.发货单
                        3, //操作类型：1锁定库存2出库3入库4调货5发货
                        $find_in_ware->waon_stock_fine_amount, //良品总库存
                        $find_in_ware->waon_lock_fine_amount, //良品锁定数量
                        $find_in_ware->waon_stock_priority_amount, //优先总库存
                        $find_in_ware->waon_lock_priority_amount, //优先锁定数量
                        $find_in_ware->waon_stock_unchecked_amount, //待检测总库存
                        2, //出入库类型：1出库，2入库
                        $waon_class_key, //仓库类别
                        $oure_goods_id, //数组，商品id
                        $oure_goods_quantity, //数组，商品数量
                        $oure_goods_inventory, //数组，出库类型1良品2优先
                        [], //仓位id
                        $oure_class_goo_id, //仓库类别下的商品id
                        $oure_goods_price //退货入库的商品金额
                    );
                    if (!$oure_in_data) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'退换回收：失败6'];
                    }
                }
            }

            foreach ($goo_data as $key => $value) {
                $primary_id = DB::table('recede_goods')
                    ->where('rego_rec_id', $request['rec_id'])
                    ->where('rego_goo_id', $value['goo_id'])
                    ->where('rego_orgo_id', $value['rego_orgo_id'])
                    ->value('rego_id');
                // 仓位入库记录
                $outin_recore_res = Stocktake::junkaddition(
                    $user_info,
                    $request['rec_ware_id'], //仓库id
                    $value['goo_waon_class'], //仓库类型
                    $value['goo_wafr_id'], //仓位id
                    6, //6退货入库
                    $request['rec_id'], //原始单id
                    $find_recede->rec_number, //原始单号
                    $primary_id, //关联商品表主键id
                    $value['goo_id'], //商品表主键id
                    2, //出入库类型：1出库2入库
                    $value['goo_recycle_amount'], //商品数量
                    $value['goo_inventory'] //出库类型1良品2优先3待检测
                );
                // 仓位出库记录
                $out_recore_res = Stocktake::junkaddition(
                    $user_info,
                    $request['rec_ware_id'], //仓库id
                    $value['goo_waon_class'], //仓库类型
                    0, //仓位id
                    6, //6退货入库
                    0, //原始单id
                    0, //原始单号
                    $primary_id, //关联商品表主键id
                    $value['goo_id'], //商品表主键id
                    1, //出入库类型：1出库2入库
                    $value['goo_recycle_amount'], //商品数量
                    $inventory = $value['goo_inventory'] //出库类型1良品2优先3待检测
                );
                // 4.1 查询仓库商品库存数量
                $wago_id = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $request['rec_ware_id'])
                    ->where('wago_class', $value['goo_waon_class'])
                    ->where('wago_goo_id', $value['goo_id'])
                    ->value('wago_id');
                $waon_class_key = $value['goo_waon_class'];
                if ($outin_recore_res['code'] == 500) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'退换回收：失败77'];
                }
            }
        }

        // 3 更改退换回收单表数据
        $update_recycle['rec_amount'] = $rec_goo_all_amount; //回收总数量
        $update_recycle['rec_remark'] = isset($request['rec_remark']) ? $request['rec_remark'] : ''; //备注
        $update_recycle['rec_state'] = 2; //回收状态 1.未回收 2.已回收
        $update_recycle['rec_date'] = $request['rec_date']; //日期
        $update_recycle['rec_ware_id'] = $request['rec_ware_id']; //回收仓库
        $update_recycle['rec_record_adm_id'] = $user_info->adm_id; //记录人
        $update_recycle['rec_update_time'] = date("Y-m-d H:i:s"); //更新时间
        $rec_res = DB::table('recede_recycle')
            ->where('rec_id', $request['rec_id'])
            ->update($update_recycle);

        // 来源类型1. 售后退货 2. 工单退货(换货单) 3 页面新增 4 (工单号)退货单 5技师退回 6技师拒单 7技师终止 8(订单号)退货单
        if ($find_recede->rec_source_type == 4 || $find_recede->rec_source_type == 8) {
            $oure_type = 13;
        } elseif ($find_recede->rec_source_type == 2) {
            $oure_type = 12;
        } else {
            $oure_type = 5;
        }
        
        if ($del_rego  && $rec_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'退换入库成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'退换入库失败'];
        }
    }
}
