<?php

namespace App\Http\Models\Services\WarehouseManage;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

// 商品的出入库记录，记录商品库存、锁定数据
class OutinStockLock extends Model
{
    /**
     * [addition 添加商品的出入库、锁定记录]
     * @param  [type] $user_info                        [用户信息]
     * @param  [type] $oslr_original_correlation_id     [原始单的关联id]
     * @param  [type] $oslr_original_correlation_number [原始单的关联单号]
     * @param  [type] $oslr_original_correlation_type   [原始单的关联类型1订单2调拨单3采购单4销售单5旧货回收6退货入库7售后]
     * @param  [type] $oslr_client_type                 [买家类型：1会员零售2客户单位3速电派单4第三方派单]
     * @param  [type] $oslr_client_id                   [选择的客户id,会员id/单位id]
     * @param  [type] $oslr_original_number             [原始单号]
     * @param  [type] $oslr_ware_id                  [入库仓库id]
     * @param  [type] $oslr_count                       [出库的商品总量]
     * @param  [type] $oslr_type                        [类型：1锁定库存2取消锁定3调拨单4旧货回收单5退换回收单6订单出库7部分入库8部分出库9发货单10移动仓出库11换货出库12换货入库13退货入库14退货出库15盘库单]
     * @param  [type] $oslr_all_stock                   [良品总库存]
     * @param  [type] $oslr_lock_quantity               [良品锁定数量]
     * @param  [type] $oslr_priority_all_stock          [优先总库存]
     * @param  [type] $oslr_priority_lock_quantity      [优先锁定数量]
     * @param  [type] $oslr_unchecked_all_stock         [待检测总库存]
     * @param  [type] $oslr_out_in_type                 [出入库类型：1出库，2入库]
     * @param  [type] $goo_data                         [商品数组，商品数据]
     * @return [type]                                   [description]
     */
    public static function addition(
        $user_info,
        $oslr_original_correlation_id,
        $oslr_original_correlation_number,
        $oslr_original_correlation_type,
        $oslr_client_type,
        $oslr_client_id,
        $oslr_original_number,
        $oslr_ware_id,
        $oslr_count,
        $oslr_type,
        $oslr_all_stock,
        $oslr_lock_quantity,
        $oslr_priority_all_stock,
        $oslr_priority_lock_quantity,
        $oslr_unchecked_all_stock,
        $oslr_out_in_type,
        $goo_data
    ) {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 生成出入库记录
        $number = time().rand(10000, 99999); //共15位
        // 出入库记录表新增数据
        $record['oslr_cid'] = $user_info->adm_cid; //公司id
        $record['oslr_shop_id'] = $user_info->adm_shop_id; //门店id
        $record['oslr_superior_shop_id'] = $shop_id; //门店id
        $record['oslr_adm_id'] = $user_info->adm_id; //操作人
        $record['oslr_number'] = $number; //单号
        $record['oslr_original_correlation_id'] = $oslr_original_correlation_id; //原始单的关联id
        $record['oslr_original_correlation_number'] = $oslr_original_correlation_number; //原始单的关联单号
        $record['oslr_original_correlation_type'] = $oslr_original_correlation_type; //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后8盘库单
        $record['oslr_client_type'] = $oslr_client_type; //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单5.运营中心与门店来往
        $record['oslr_client_id'] = $oslr_client_id; //选择的客户id,会员id/单位id/门店id
        $record['oslr_original_number'] = $oslr_original_number; //原始单号
        $record['oslr_type'] = $oslr_type; //类型：1锁定库存2取消锁定3调拨单4旧货回收单5退换回收单6订单出库7部分入库8部分出库9发货单10移动仓出库11换货出库12换货入库13退货入库14退货出库15盘库单
        $record['oslr_count'] = $oslr_count; //出库的商品总量
        $record['oslr_ware_id'] = $oslr_ware_id; //出库/入库的仓库id
        $record['oslr_new_all_stock'] = $oslr_all_stock; //良品总库存
        $record['oslr_new_lock_quantity'] = $oslr_lock_quantity; //良品锁定数量
        $record['oslr_new_priority_all_stock'] = $oslr_priority_all_stock; //优先总库存
        $record['oslr_new_priority_lock_quantity'] = $oslr_priority_lock_quantity; //优先锁定数量
        $record['oslr_new_unchecked_all_stock'] = $oslr_unchecked_all_stock; //待检测总库存
        $record['oslr_out_in_type'] = $oslr_out_in_type;//出入库类型：1出库2入库3锁定4取消锁定
        $record['oslr_update_time'] = date('Y-m-d H:i:s');
        $record_add = DB::table('outin_stock_lock_record')->insertGetId($record);

        $osld_data = [];
        $n = 0;
        foreach ($goo_data as $key => $value) {
        	$osld_data[$n]['osld_oure_id'] = $record_add;
        	$osld_data[$n]['osld_shop_id'] = $user_info->adm_shop_id;
        	$osld_data[$n]['osld_ware_id'] = $oslr_ware_id;
        	$osld_data[$n]['osld_waon_class'] = $value->goo_waon_class;//仓库类别：1货物仓2非货物仓3旧货仓4临时仓
        	$osld_data[$n]['osld_goo_id'] = $value->goo_id;
        	$osld_data[$n]['osld_goo_number'] = $value->goo_number;//商品数量
        	$osld_data[$n]['osld_out_in_type'] = $value->goo_out_in_type;//出入库类型：1出库2入库3锁定4取消锁定
        	$osld_data[$n]['osld_type'] = $value->goo_inventory;//类型1良品2优先3待检测
        	$osld_data[$n]['osld_old_stock_number'] = $value->old_stock_number;//旧的商品良品库存数量
        	$osld_data[$n]['osld_old_stock_lock_number'] = $value->old_stock_lock_number;//旧的商品良品库存锁定数量
        	$osld_data[$n]['osld_old_priority_number'] = $value->old_priority_number;//旧的商品优先库存数量
        	$osld_data[$n]['osld_old_priority_lock_number'] = $value->old_priority_lock_number;//旧的商品优先库存锁定数量
        	$osld_data[$n]['osld_old_unchecked_number'] = $value->old_unchecked_number;//旧的商品待检测库存数量
        	$osld_data[$n]['osld_new_stock_number'] = $value->new_stock_number;//新的商品良品库存数量
        	$osld_data[$n]['osld_new_stock_lock_number'] = $value->new_stock_lock_number;//新的商品良品库存锁定数量
        	$osld_data[$n]['osld_new_priority_number'] = $value->new_priority_number;//新的商品优先库存数量
        	$osld_data[$n]['osld_new_priority_lock_number'] = $value->new_priority_lock_number;//新的商品优先库存锁定数量
        	$osld_data[$n]['osld_new_unchecked_number'] = $value->new_unchecked_number;//新的商品待检测库存数量
        	$osld_data[$n]['osld_update_time'] = date('Y-m-d H:i:s');
        	$n++;
        }
        // dump($osld_data);
        // exit;
        $osld_res = DB::table('outin_stock_lock_details')->insert($osld_data);
        if ($osld_res && $record_add) {
            return true;
        } else {
            return false;
        }
    }
}
