<?php
namespace App\Http\Models\Services;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Warehouse;
use App\Http\Models\Services\WarehouseManage\OutinStockLock;

// 仓库锁定处理
class WarehouseLock extends Model
{
    /**
     * warehouseLockInventory 仓库商品锁定库存处理
     *
     * @param [array] $user_info  用户信息
     * @param [array] $request    提交信息
     * @param [int] $ware_id    仓库id
     * @param [array] $neaten_goods_data   商品数据数组
     * @param [int] $type   锁定单据类型1订单锁定2调拨单锁定
     * @return void
     */
    public static function warehouseLockInventory(
        $user_info,
        $request,
        $order_data,
        $neaten_goods_data,
        $type = 1
    ) {
        $neaten_wago_id = [];//良品商品
        $priority_neaten_wago_id = [];//优先商品
        $wagl_lock_quantity = [];//仓库锁定表的商品锁定数量
        // 查询仓库类型 ware_type 类型：1固定仓2技师库3移动仓
        $ware_type = DB::table('warehouse')
            ->where('ware_id', $request['ware_id'])
            ->value('ware_type');
        foreach ($neaten_goods_data as $wago_id => $wago_id_value) {
            foreach ($wago_id_value as $goo_inventory => $goo_value) {
                if ($goo_inventory == 1) {
                    // 良品商品锁定库存
                    $ware_id[$wago_id] = $request['ware_id'];
                    $wago_goo_id[$wago_id] = $goo_value['goo_id'];
                    $wago_goo_quantity[$wago_id] = $goo_value['goo_quantity'];
                    $wago_goo_inventory[$wago_id] = $goo_inventory;
                    $wago_goo_class[$wago_id] = $goo_value['goo_waon_class'];
                    $neaten_wago_id[] = $wago_id;
                } else {
                    // 优先商品锁定库存
                    $priority_ware_id[$wago_id] = $request['ware_id'];
                    $priority_wago_goo_id[$wago_id] = $goo_value['goo_id'];
                    $priority_wago_goo_quantity[$wago_id] = $goo_value['goo_quantity'];
                    $priority_wago_goo_inventory[$wago_id] = $goo_inventory;
                    $priority_wago_goo_class[$wago_id] = $goo_value['goo_waon_class'];
                    $priority_neaten_wago_id[] = $wago_id;
                }
                // 仓库锁定表的商品锁定数量：良品+优先 总的锁定数量
                if (isset($wagl_lock_quantity[$wago_id])) {
                    $wagl_lock_quantity[$wago_id] += $goo_value['goo_quantity'];
                } else {
                    $wagl_lock_quantity[$wago_id] = $goo_value['goo_quantity'];
                }
            }
        }
        if ($neaten_wago_id) {
            $wago_id = array_unique($neaten_wago_id);
            // 生成订单时锁定库存,锁定商品的良品库存
            $order_lock_retrun = self::warehouseFreightLockInventory(
                $user_info,
                $ware_type,
                $order_data,
                $ware_id, //数组，仓库商品id=>仓库id
                $wago_goo_id, //数组，仓库商品id=>商品id
                $wago_goo_quantity, //数组，仓库商品id=>商品数量
                $wago_goo_inventory, //数组，仓库商品id=>库存扣除方式 1.良品 2.优先
                $wago_goo_class, //数组，仓库商品id=>仓库类别
                $wago_id, //数组，仓库商品id
                $type//锁定单据类型1订单锁定2调拨单锁定
            );
            if ($order_lock_retrun['code'] == 500) {
                return $order_lock_retrun;
            }
        }
        // 生成订单时锁定库存,锁定商品的优先库存
        if ($priority_neaten_wago_id) {
            $priority_wago_id = array_unique($priority_neaten_wago_id);
            $order_lock_retrun = self::warehouseFreightLockInventory(
                $user_info,
                $ware_type,
                $order_data,
                $priority_ware_id, //数组，仓库商品id=>仓库id
                $priority_wago_goo_id, //数组，仓库商品id=>商品id
                $priority_wago_goo_quantity, //数组，仓库商品id=>商品数量
                $priority_wago_goo_inventory, //数组，仓库商品id=>库存扣除方式 1.良品 2.优先
                $priority_wago_goo_class, //数组，仓库商品id=>仓库类别
                $priority_wago_id, //数组，仓库商品id
                $type//锁定单据类型1订单锁定2调拨单锁定
            );
            if ($order_lock_retrun['code'] == 500) {
                return $order_lock_retrun;
            }
        }
        return ['code'=> 200, 'msg'=>'库存锁定成功', 'data'=>'库存锁定成功'];
    }

    /**
     * [warehouseFreightLockInventory 生成订单锁定库存数量,仓位锁定库存]
     * @param  [array] $user_info          [用户信息]
     * @param  [int] $ware_type          [仓库类型]
     * @param  [array] $order_data         [订单信息]
     * @param  [array] $ware_id            [数组，仓库商品id=>仓库id]
     * @param  [array] $wago_goo_id        [数组，仓库商品id=>商品id]
     * @param  [array] $wago_goo_quantity  [数组，仓库商品id=>商品数量]
     * @param  [array] $wago_goo_inventory [数组，仓库商品id=>库存扣除方式 1.良品 2.优先]
     * @param  [array] $wago_goo_class     [数组，仓库商品id=>仓库类别]
     * @param  [array] $wago_id            [数组，仓库商品id]
     * @param  [int] $type   [锁定单据类型1订单锁定2调拨单锁定]
     * @return [array]                     [description]
     */
    public static function warehouseFreightLockInventory(
        $user_info,
        $ware_type,
        $order_data,
        $ware_id,
        $wago_goo_id,
        $wago_goo_quantity,
        $wago_goo_inventory,
        $wago_goo_class,
        $wago_id,
        $type
    ) {
        // 查询仓库商品表的数据
        $warehouse_goods = DB::table('warehouse_goods')
            ->whereIn('wago_id', $wago_id)
            ->get(['wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_freight_stock_number', 'wago_freight_lock_quantity', 'wago_freight_priority_stock_number', 'wago_freight_priority_lock_quantity', 'wago_stock_amount', 'wago_lock_amount', 'wago_priority_stock_amount', 'wago_priority_lock_amount'])
            ->toArray();
        $warehouse_goods_wago = array_column($warehouse_goods, null, 'wago_id');
        $wago_id_quantity = [];
        $waon_class_fine_quantity = [];//仓库类别对应良品库存总数量
        $waon_class_priority_quantity = [];//仓库类别对应优先库存总数量
        if ($type == 1) {//订单
            $wfgl_correlation_type = 1;
        } elseif ($type == 2) {//调拨单
            $wfgl_correlation_type = 3;
        } elseif ($type == 3) {//销售出库单
            $wfgl_correlation_type = 4;
        }
        foreach ($wago_id as $key => $value) {
            $data['goo_inventory'] = $wago_goo_inventory[$value];//良品、优先
            $data['goo_quantity'] = $wago_goo_quantity[$value];//商品数量
            $data['wago_class'] = $wago_goo_class[$value];//仓库类别
            $data['ware_id'] = $ware_id[$value];//仓库id
            $data['wago_id'] = $value;//仓库商品id
            $wago_id_quantity[] = $data;
            if ($wago_goo_inventory[$value] == 1) {// 商品出库类型，良品出库
                // 良品剩余库存数量  = (仓库+仓位)总的库存数量-下单商品数量
                $surplus_quantity = $warehouse_goods_wago[$value]->wago_stock_number - $wago_goo_quantity[$value];
                if ($surplus_quantity < 0) {
                    return ['code'=>500, 'msg'=>'仓库内商品数量不足', 'data'=>'仓库内商品数量不足1'];
                }
                // 仓库+仓位总的数量处理
                $wago_edit_data['wago_stock_number'] = $surplus_quantity;//良品库存数量减少
                $wago_edit_data['wago_lock_quantity'] = $warehouse_goods_wago[$value]->wago_lock_quantity + $wago_goo_quantity[$value];//良品锁定数量增加

                // 仓位功能是后面增加的，线上正在使用的厦门、北京门店的库存都在仓库里面，没有全部转移到仓位中
                // 仓位功能上线后会存在一部分商品库存在仓位中，一部分商品库存在仓库中
                $goo_diff_amount = $wago_goo_quantity[$value];//下单的商品数量，处理仓库锁定库存
                // 仓位的库存数量处理
                if ($warehouse_goods_wago[$value]->wago_freight_stock_number > 0) {
                    $wago_freight_stock_number = $warehouse_goods_wago[$value]->wago_freight_stock_number - $wago_goo_quantity[$value];
                    // 判断仓位的库存数量是否小于下单数量
                    if ($wago_freight_stock_number < 0) {
                        // 仓位库存数量小于下单数量，仓位库存数量更新为0
                        $wago_edit_data['wago_freight_stock_number'] = 0;
                        // 新的仓位锁定库存数量=原仓位锁定数量+仓位的库存数量
                        $wago_edit_data['wago_freight_lock_quantity'] = $warehouse_goods_wago[$value]->wago_freight_lock_quantity + $warehouse_goods_wago[$value]->wago_freight_stock_number;

                        // 下单数量超过仓位的库存数量，仓库所属的仓位商品表中所有的库存数量都改为锁定数量
                        // 查询仓位商品表中商品有库存的数据
                        $find_freight_goods = DB::table('warehouse_freight_goods')
                            ->where('wafg_ware_id', $ware_id[$value])//仓库id
                            ->where('wafg_wago_id', $value)//仓库商品id
                            ->where('wafg_class', $warehouse_goods_wago[$value]->wago_class)//仓库类别
                            ->where('wafg_goo_id', $warehouse_goods_wago[$value]->wago_goo_id)//商品id
                            ->where('wafg_stock_number', '>', 0)//仓位良品库存数量大于0
                            ->select('wafg_id', 'wafg_wafr_id', 'wafg_stock_number', 'wafg_lock_quantity')
                            ->get()->toArray();
                        $wafr_id_quantity = [];
                        foreach ($find_freight_goods as $wafg_key => $wafg_value) {
                            $wafg_edit_data['wafg_stock_number'] = 0;
                            $wafg_edit_data['wafg_lock_quantity'] = $wafg_value->wafg_lock_quantity + $wafg_value->wafg_stock_number;
                            $wafg_edit_data['wafg_update_time'] = date('Y-m-d H:i:s');
                            $wafg_res = DB::table('warehouse_freight_goods')
                                ->where('wafg_id', $wafg_value->wafg_id)
                                ->update($wafg_edit_data);
                            unset($wafg_edit_data);
                            if (!$wafg_res) {
                                return ['code'=> 500, 'msg'=>'仓位商品库存数量不足！', 'data'=>'仓位商品库存数量不足！'];
                            }
                            // 仓位表总的商品库存数量调整
                            if (isset($wafr_id_quantity[$wafg_value->wafg_wafr_id])) {
                                $wafr_id_quantity[$wafg_value->wafg_wafr_id] += $wafg_value->wafg_stock_number;
                            } else {
                                $wafr_id_quantity[$wafg_value->wafg_wafr_id] = $wafg_value->wafg_stock_number;
                            }

                            // 仓位商品锁定表
                            $wfgl_data['wfgl_shop_id'] = $user_info->adm_shop_id;//门店id
                            $wfgl_data['wfgl_ware_id'] = $ware_id[$value];//仓库id
                            $wfgl_data['wfgl_waon_class'] = $warehouse_goods_wago[$value]->wago_class;//仓库类别
                            $wfgl_data['wfgl_wago_id'] = $value;//仓库商品主键id
                            $wfgl_data['wfgl_wafr_id'] = $wafg_value->wafg_wafr_id;//仓位id
                            $wfgl_data['wfgl_wafg_id'] = $wafg_value->wafg_id;//仓位商品主键id
                            $wfgl_data['wfgl_original_correlation_id'] = $order_data['data']['ord_id'];//关联id：订单id/发货单id/调拨单id
                            $wfgl_data['wfgl_correlation_type'] = $wfgl_correlation_type;//关联类型：1订单2发货单3调拨单4销售出库单
                            $wfgl_data['wfgl_original_id'] = $order_data['data']['ord_id'];//原始id：订单id/调拨单id
                            $wfgl_data['wfgl_original_number'] = $order_data['data']['ord_order_number'];//原始单号：订单号/调拨单号
                            $wfgl_data['wfgl_type'] = $type;//原始单类型：1订单2调拨单3.销售单
                            $wfgl_data['wfgl_state'] = 1;//锁定状态：1下单锁定2出库解锁
                            $wfgl_data['wfgl_lock_quantity'] = $wafg_value->wafg_stock_number;//商品锁定数量
                            $wfgl_data['wfgl_lock_type'] = 1;//商品锁定类型：1良品2优先
                            $wfgl_res = DB::table('warehouse_freight_goods_lock')->insert($wfgl_data);
                            unset($wfgl_data);
                            if (!$wfgl_res) {
                                return ['code'=> 500, 'msg'=>'仓位商品库存数量不足！', 'data'=>'仓位商品库存数量不足！'];
                            }
                        }
                        // 仓位表总的商品库存数量调整
                        foreach ($wafr_id_quantity as $wafr_id => $stock_quantity) {
                            $find_wafr_data = DB::table('warehouse_freight')
                                ->where('wafr_id', $wafr_id)
                                ->select('wafr_all_stock', 'wafr_lock_quantity')
                                ->first();
                            // 良品总库存数量减少
                            $wafr_edit_data['wafr_all_stock'] = $find_wafr_data->wafr_all_stock - $stock_quantity;
                            // 良品总锁定数量增加
                            $wafr_edit_data['wafr_lock_quantity'] = $find_wafr_data->wafr_lock_quantity + $stock_quantity;
                            $wafr_edit_data['wafr_update_time'] = date('Y-m-d H:i:s');
                            $wafr_res = DB::table('warehouse_freight')
                                ->where('wafr_id', $wafr_id)
                                ->update($wafr_edit_data);
                            unset($wafr_edit_data);
                            if (!$wafr_res) {
                                return ['code'=> 500, 'msg'=>'仓位商品库存数量不足！', 'data'=>'仓位商品库存数量不足！'];
                            }
                        }

                        // 仓位库存数量小于下单数量，下单数量减去仓位库存数量，剩下的是仓库应该锁定的数量
                        $goo_diff_amount = $wago_goo_quantity[$value] - $warehouse_goods_wago[$value]->wago_freight_stock_number;
                    } else {
                        // 仓位库存数量不小于下单数量，仓位库存数量减去下单数量是新的仓位库存数量
                        $wago_edit_data['wago_freight_stock_number'] = $wago_freight_stock_number;
                        // 新的仓位锁定库存数量=原仓位锁定数量+下单的数量
                        $wago_edit_data['wago_freight_lock_quantity'] = $warehouse_goods_wago[$value]->wago_freight_lock_quantity + $wago_goo_quantity[$value];

                        // 下单数量超过仓位的库存数量，仓库所属的仓位商品表中所有的库存数量都改为锁定数量
                        // 查询仓位商品表中商品有库存的数据
                        $find_freight_goods = DB::table('warehouse_freight_goods')
                            ->where('wafg_ware_id', $ware_id[$value])//仓库id
                            ->where('wafg_wago_id', $value)//仓库商品id
                            ->where('wafg_class', $warehouse_goods_wago[$value]->wago_class)//仓库类别
                            ->where('wafg_goo_id', $warehouse_goods_wago[$value]->wago_goo_id)//商品id
                            ->where('wafg_stock_number', '>', 0)//仓位良品库存数量大于0
                            ->select('wafg_id', 'wafg_wafr_id', 'wafg_stock_number', 'wafg_lock_quantity')
                            ->orderby('wafg_stock_number', 'desc')
                            ->get()->toArray();
                        // 判断库位的商品库存数量是否有等于下单数量
                        $quantity_equality = false;
                        foreach ($find_freight_goods as $wafg_key => $wafg_value) {
                            // 仓位的商品库存等于下单商品数量
                            if ($wafg_value->wafg_stock_number == $wago_goo_quantity[$value]) {
                                $wafg_edit_data['wafg_stock_number'] = $wafg_value->wafg_stock_number - $wago_goo_quantity[$value];
                                $wafg_edit_data['wafg_lock_quantity'] = $wafg_value->wafg_lock_quantity + $wago_goo_quantity[$value];
                                $wafg_edit_data['wafg_update_time'] = date('Y-m-d H:i:s');
                                $wafg_res = DB::table('warehouse_freight_goods')
                                    ->where('wafg_id', $wafg_value->wafg_id)
                                    ->update($wafg_edit_data);
                                unset($wafg_edit_data);

                                // 仓位表总数量更改
                                $find_wafr_data = DB::table('warehouse_freight')
                                    ->where('wafr_id', $wafg_value->wafg_wafr_id)
                                    ->select('wafr_all_stock', 'wafr_lock_quantity')
                                    ->first();
                                // 良品总库存数量减少
                                $wafr_edit_data['wafr_all_stock'] = $find_wafr_data->wafr_all_stock - $wago_goo_quantity[$value];
                                // 良品总锁定数量增加
                                $wafr_edit_data['wafr_lock_quantity'] = $find_wafr_data->wafr_lock_quantity + $wago_goo_quantity[$value];
                                $wafr_edit_data['wafr_update_time'] = date('Y-m-d H:i:s');
                                $wafr_res = DB::table('warehouse_freight')
                                    ->where('wafr_id', $wafg_value->wafg_wafr_id)
                                    ->update($wafr_edit_data);
                                unset($wafr_edit_data);
                                
                                // 仓位商品锁定表
                                $wfgl_data['wfgl_shop_id'] = $user_info->adm_shop_id;//门店id
                                $wfgl_data['wfgl_ware_id'] = $ware_id[$value];//仓库id
                                $wfgl_data['wfgl_waon_class'] = $warehouse_goods_wago[$value]->wago_class;//仓库类别
                                $wfgl_data['wfgl_wago_id'] = $value;//仓库商品主键id
                                $wfgl_data['wfgl_wafr_id'] = $wafg_value->wafg_wafr_id;//仓位id
                                $wfgl_data['wfgl_wafg_id'] = $wafg_value->wafg_id;//仓位商品主键id
                                $wfgl_data['wfgl_original_correlation_id'] = $order_data['data']['ord_id'];//关联id：订单id/发货单id/调拨单id
                                $wfgl_data['wfgl_correlation_type'] = $wfgl_correlation_type;//关联类型：1订单2发货单3调拨单
                                $wfgl_data['wfgl_original_id'] = $order_data['data']['ord_id'];//原始id：订单id/调拨单id
                                $wfgl_data['wfgl_original_number'] = $order_data['data']['ord_order_number'];//原始单号：订单号/调拨单号
                                $wfgl_data['wfgl_type'] = $type;//原始单类型：1订单2调拨单
                                $wfgl_data['wfgl_state'] = 1;//锁定状态：1下单锁定2出库解锁
                                $wfgl_data['wfgl_lock_quantity'] = $wago_goo_quantity[$value];//商品锁定数量
                                $wfgl_data['wfgl_lock_type'] = 1;//商品锁定类型：1良品2优先
                                $wfgl_res = DB::table('warehouse_freight_goods_lock')->insert($wfgl_data);
                                unset($wfgl_data);
                                if (!$wafr_res || !$wafg_res || !$wfgl_res) {
                                    return ['code'=> 500, 'msg'=>'仓位商品库存数量不足！', 'data'=>'仓位商品库存数量不足！'];
                                }
                                $quantity_equality = true;//数量相等
                                if ($quantity_equality) {
                                    break;
                                }
                            }
                        }
                        // 仓位库存数量与下单商品数量不相等，需要从多个仓位锁定下单商品数量
                        if (!$quantity_equality) {
                            $already_lock_quantity = 0;//仓位已经锁定的库存数量
                            $surplus_lock_quantity = 0;//剩余可以锁定的数量
                            foreach ($find_freight_goods as $wafg_key => $wafg_value) {
                                // 判断仓位已经锁定库存数量是否大于等于下单商品数量，超过下单数量说明下单数量都已经锁定后面不需要在锁定库存可以跳过
                                if ($already_lock_quantity >= $wago_goo_quantity[$value]) {
                                    continue;
                                }
                                // 剩余可以锁定的数量=下单数量-已经锁定的数量
                                $surplus_lock_quantity = $wago_goo_quantity[$value] - $already_lock_quantity;
                                if ($surplus_lock_quantity > $wafg_value->wafg_stock_number) {
                                    // 剩余锁定数量大于仓位库存数量，仓位库存数量全部转为锁定数量
                                    $wafg_edit_data['wafg_stock_number'] = 0;
                                    $wafg_edit_data['wafg_lock_quantity'] = $wafg_value->wafg_lock_quantity + $wafg_value->wafg_stock_number;

                                    // 当前仓位的库存数量就是更改的总库存数量
                                    $wafr_all_stock = $wafg_value->wafg_stock_number;
                                } else {
                                    // 剩余锁定数量小于等于仓位库存数量，仓位库存数量减去剩余锁定库存数量
                                    $wafg_edit_data['wafg_stock_number'] = $wafg_value->wafg_stock_number - $surplus_lock_quantity;
                                    $wafg_edit_data['wafg_lock_quantity'] = $wafg_value->wafg_lock_quantity + $surplus_lock_quantity;
                                    
                                    // 剩余库存数量是更改的总库存数量
                                    $wafr_all_stock = $surplus_lock_quantity;//更改的总库存数量
                                }
                                $wafg_edit_data['wafg_update_time'] = date('Y-m-d H:i:s');
                                $wafg_res = DB::table('warehouse_freight_goods')
                                    ->where('wafg_id', $wafg_value->wafg_id)
                                    ->update($wafg_edit_data);
                                unset($wafg_edit_data);

                                // 仓位表总数量更改
                                $find_wafr_data = DB::table('warehouse_freight')
                                    ->where('wafr_id', $wafg_value->wafg_wafr_id)
                                    ->select('wafr_all_stock', 'wafr_lock_quantity')
                                    ->first();
                                // 良品总库存数量减少
                                $wafr_edit_data['wafr_all_stock'] = $find_wafr_data->wafr_all_stock - $wafr_all_stock;
                                // 良品总锁定数量增加
                                $wafr_edit_data['wafr_lock_quantity'] = $find_wafr_data->wafr_lock_quantity + $wafr_all_stock;
                                $wafr_edit_data['wafr_update_time'] = date('Y-m-d H:i:s');
                                $wafr_res = DB::table('warehouse_freight')
                                    ->where('wafr_id', $wafg_value->wafg_wafr_id)
                                    ->update($wafr_edit_data);
                                unset($wafr_edit_data);
                                
                                // 仓位商品锁定表
                                $wfgl_data['wfgl_shop_id'] = $user_info->adm_shop_id;//门店id
                                $wfgl_data['wfgl_ware_id'] = $ware_id[$value];//仓库id
                                $wfgl_data['wfgl_waon_class'] = $warehouse_goods_wago[$value]->wago_class;//仓库类别
                                $wfgl_data['wfgl_wago_id'] = $value;//仓库商品主键id
                                $wfgl_data['wfgl_wafr_id'] = $wafg_value->wafg_wafr_id;//仓位id
                                $wfgl_data['wfgl_wafg_id'] = $wafg_value->wafg_id;//仓位商品主键id
                                $wfgl_data['wfgl_original_correlation_id'] = $order_data['data']['ord_id'];//关联id：订单id/发货单id/调拨单id
                                $wfgl_data['wfgl_correlation_type'] = $wfgl_correlation_type;//关联类型：1订单2发货单3调拨单
                                $wfgl_data['wfgl_original_id'] = $order_data['data']['ord_id'];//原始id：订单id/调拨单id
                                $wfgl_data['wfgl_original_number'] = $order_data['data']['ord_order_number'];//原始单号：订单号/调拨单号
                                $wfgl_data['wfgl_type'] = $type;//原始单类型：1订单2调拨单
                                $wfgl_data['wfgl_state'] = 1;//锁定状态：1下单锁定2出库解锁
                                $wfgl_data['wfgl_lock_quantity'] = $wafr_all_stock;//商品锁定数量
                                $wfgl_data['wfgl_lock_type'] = 1;//商品锁定类型：1良品2优先
                                $wfgl_res = DB::table('warehouse_freight_goods_lock')->insert($wfgl_data);
                                unset($wfgl_data);
                                if (!$wafg_res || !$wafr_res || !$wfgl_res) {
                                    return ['code'=> 500, 'msg'=>'仓位商品库存数量不足！', 'data'=>'仓位商品库存数量不足！'];
                                }
                                $already_lock_quantity += $wafr_all_stock;
                            }
                        }

                        // 仓位库存数量不小于下单数量，仓库不用锁定库存
                        $goo_diff_amount = 0;
                    }
                }
                // 仓库的数量，固定仓处理仓库库存数量，移动仓没有仓库字段的库存，不需要减仓库库存
                if ($goo_diff_amount && $ware_type == 1) {
                    $wago_stock_amount = $warehouse_goods_wago[$value]->wago_stock_amount - $goo_diff_amount;
                    if ($wago_stock_amount < 0) {
                        return ['code'=> 500, 'msg'=>'仓位商品库存数量不足！', 'data'=>'仓库内商品数量不足2'];
                    }
                    
                    $wago_edit_data['wago_stock_amount'] = $wago_stock_amount;
                    $wago_edit_data['wago_lock_amount'] = $warehouse_goods_wago[$value]->wago_lock_amount + $goo_diff_amount;
                    // 仓位商品锁定表
                    $wfgl_data['wfgl_shop_id'] = $user_info->adm_shop_id;//门店id
                    $wfgl_data['wfgl_ware_id'] = $ware_id[$value];//仓库id
                    $wfgl_data['wfgl_waon_class'] = $warehouse_goods_wago[$value]->wago_class;//仓库类别
                    $wfgl_data['wfgl_wago_id'] = $value;//仓库商品主键id
                    $wfgl_data['wfgl_wafr_id'] = 0;//仓位id
                    $wfgl_data['wfgl_wafg_id'] = 0;//仓位商品主键id
                    $wfgl_data['wfgl_original_correlation_id'] = $order_data['data']['ord_id'];//关联id：订单id/发货单id/调拨单id
                    $wfgl_data['wfgl_correlation_type'] = $wfgl_correlation_type;//关联类型：1订单2发货单3调拨单
                    $wfgl_data['wfgl_original_id'] = $order_data['data']['ord_id'];//原始id：订单id/调拨单id
                    $wfgl_data['wfgl_original_number'] = $order_data['data']['ord_order_number'];//原始单号：订单号/调拨单号
                    $wfgl_data['wfgl_type'] = $type;//原始单类型：1订单2调拨单
                    $wfgl_data['wfgl_state'] = 1;//锁定状态：1下单锁定2出库解锁
                    $wfgl_data['wfgl_lock_quantity'] = $goo_diff_amount;//商品锁定数量
                    $wfgl_data['wfgl_lock_type'] = 1;//商品锁定类型：1良品2优先
                    $wfgl_res = DB::table('warehouse_freight_goods_lock')->insert($wfgl_data);
                    unset($wfgl_data);
                }
            } else {// 商品出库类型，优先出库
                // 优先剩余库存数量
                $surplus_quantity = $warehouse_goods_wago[$value]->wago_priority_stock_number - $wago_goo_quantity[$value];
                if ($surplus_quantity < 0) {
                    return ['code'=> 500, 'msg'=>'仓位商品库存数量不足！', 'data'=>'仓库内商品数量不足3'];
                }
                // 仓库+仓位总的数量处理
                $wago_edit_data['wago_priority_stock_number'] = $surplus_quantity;//优先库存数量减少
                $wago_edit_data['wago_priority_lock_quantity'] = $warehouse_goods_wago[$value]->wago_priority_lock_quantity + $wago_goo_quantity[$value];//优先锁定数量增加

                // 仓位功能是后面增加的，线上正在使用的厦门、北京门店的库存都在仓库里面，没有全部转移到仓位中
                // 仓位功能上线后会存在一部分商品库存在仓位中，一部分商品库存在仓库中
                $goo_diff_amount = $wago_goo_quantity[$value];//下单的商品数量，处理仓库锁定库存

                // 仓位的库存数量处理
                if ($warehouse_goods_wago[$value]->wago_freight_priority_stock_number > 0) {
                    $wago_freight_priority_stock_number = $warehouse_goods_wago[$value]->wago_freight_priority_stock_number - $wago_goo_quantity[$value];

                    // 判断仓位的库存数量是否小于下单数量
                    if ($wago_freight_priority_stock_number < 0) {
                        // 仓位库存数量小于下单数量，仓位库存数量更新为0
                        $wago_edit_data['wago_freight_priority_stock_number'] = 0;
                        // 新的仓位锁定库存数量=原仓位锁定数量+仓位的库存数量
                        $wago_edit_data['wago_freight_priority_lock_quantity'] = $warehouse_goods_wago[$value]->wago_freight_priority_lock_quantity + $warehouse_goods_wago[$value]->wago_freight_priority_stock_number;

                        // 下单数量超过仓位的库存数量，仓库所属的仓位商品表中所有的库存数量都改为锁定数量
                        // 查询仓位商品表中商品有库存的数据
                        $find_freight_goods = DB::table('warehouse_freight_goods')
                            ->where('wafg_ware_id', $ware_id[$value])//仓库id
                            ->where('wafg_wago_id', $value)//仓库商品id
                            ->where('wafg_class', $warehouse_goods_wago[$value]->wago_class)//仓库类别
                            ->where('wafg_goo_id', $warehouse_goods_wago[$value]->wago_goo_id)//商品id
                            ->where('wafg_priority_stock_number', '>', 0)//仓位良品库存数量大于0
                            ->select('wafg_id', 'wafg_wafr_id', 'wafg_priority_stock_number', 'wafg_priority_lock_quantity')
                            ->get()->toArray();
                        $wafr_id_quantity = [];
                        foreach ($find_freight_goods as $wafg_key => $wafg_value) {
                            $wafg_edit_data['wafg_priority_stock_number'] = 0;
                            $wafg_edit_data['wafg_priority_lock_quantity'] = $wafg_value->wafg_priority_stock_number + $wafg_value->wafg_priority_lock_quantity;
                            $wafg_edit_data['wafg_update_time'] = date('Y-m-d H:i:s');
                            $wafg_res = DB::table('warehouse_freight_goods')
                                ->where('wafg_id', $wafg_value->wafg_id)
                                ->update($wafg_edit_data);
                            unset($wafg_edit_data);
                            if (!$wafg_res) {
                                return ['code'=> 500, 'msg'=>'仓位商品库存数量不足！', 'data'=>'仓位商品库存数量不足！'];
                            }
                            // 仓位表总的商品库存数量调整
                            if (isset($wafr_id_quantity[$wafg_value->wafg_wafr_id])) {
                                $wafr_id_quantity[$wafg_value->wafg_wafr_id] += $wafg_value->wafg_priority_stock_number;
                            } else {
                                $wafr_id_quantity[$wafg_value->wafg_wafr_id] = $wafg_value->wafg_priority_stock_number;
                            }
                            
                            // 仓位商品锁定表
                            $wfgl_data['wfgl_shop_id'] = $user_info->adm_shop_id;//门店id
                            $wfgl_data['wfgl_ware_id'] = $ware_id[$value];//仓库id
                            $wfgl_data['wfgl_waon_class'] = $warehouse_goods_wago[$value]->wago_class;//仓库类别
                            $wfgl_data['wfgl_wago_id'] = $value;//仓库商品主键id
                            $wfgl_data['wfgl_wafr_id'] = $wafg_value->wafg_wafr_id;//仓位id
                            $wfgl_data['wfgl_wafg_id'] = $wafg_value->wafg_id;//仓位商品主键id
                            $wfgl_data['wfgl_original_correlation_id'] = $order_data['data']['ord_id'];//关联id：订单id/发货单id/调拨单id
                            $wfgl_data['wfgl_correlation_type'] = $wfgl_correlation_type;//关联类型：1订单2发货单3调拨单
                            $wfgl_data['wfgl_original_id'] = $order_data['data']['ord_id'];//原始id：订单id/调拨单id
                            $wfgl_data['wfgl_original_number'] = $order_data['data']['ord_order_number'];//原始单号：订单号/调拨单号
                            $wfgl_data['wfgl_type'] = $type;//原始单类型：1订单2调拨单
                            $wfgl_data['wfgl_state'] = 1;//锁定状态：1下单锁定2出库解锁
                            $wfgl_data['wfgl_lock_quantity'] = $wafg_value->wafg_priority_stock_number;//商品锁定数量
                            $wfgl_data['wfgl_lock_type'] = 2;//商品锁定类型：1良品2优先
                            $wfgl_res = DB::table('warehouse_freight_goods_lock')->insert($wfgl_data);
                            unset($wfgl_data);
                            if (!$wfgl_res) {
                                return ['code'=> 500, 'msg'=>'仓位商品库存数量不足！', 'data'=>'仓位商品库存数量不足！'];
                            }
                        }
                        // 仓位表总的商品库存数量调整
                        foreach ($wafr_id_quantity as $wafr_id => $stock_quantity) {
                            $find_wafr_data = DB::table('warehouse_freight')
                                ->where('wafr_id', $wafr_id)
                                ->select('wafr_priority_all_stock', 'wafr_priority_lock_quantity')
                                ->first();
                            // 优先总库存数量减少
                            $wafr_edit_data['wafr_priority_all_stock'] = $find_wafr_data->wafr_priority_all_stock - $stock_quantity;
                            // 优先总锁定数量增加
                            $wafr_edit_data['wafr_priority_lock_quantity'] = $find_wafr_data->wafr_priority_lock_quantity + $stock_quantity;
                            $wafr_edit_data['wafr_update_time'] = date('Y-m-d H:i:s');
                            $wafr_res = DB::table('warehouse_freight')
                                ->where('wafr_id', $wafr_id)
                                ->update($wafr_edit_data);
                            unset($wafr_edit_data);
                            if (!$wafr_res) {
                                return ['code'=> 500, 'msg'=>'仓位商品库存数量不足！', 'data'=>'仓位商品库存数量不足！'];
                            }
                        }

                        // 仓位库存数量小于下单数量，下单数量减去仓位库存数量，剩下的是仓库应该锁定的数量
                        $goo_diff_amount = $wago_goo_quantity[$value] - $warehouse_goods_wago[$value]->wago_freight_priority_stock_number;
                    } else {
                        // 仓位库存数量不小于下单数量，仓位库存数量减去下单数量是新的仓位库存数量
                        $wago_edit_data['wago_freight_priority_stock_number'] = $wago_freight_priority_stock_number;
                        // 新的仓位锁定库存数量=原仓位锁定数量+下单的数量
                        $wago_edit_data['wago_freight_priority_lock_quantity'] = $warehouse_goods_wago[$value]->wago_freight_priority_lock_quantity + $wago_goo_quantity[$value];

                        // 下单数量超过仓位的库存数量，仓库所属的仓位商品表中所有的库存数量都改为锁定数量
                        // 查询仓位商品表中商品有库存的数据
                        $find_freight_goods = DB::table('warehouse_freight_goods')
                            ->where('wafg_ware_id', $ware_id[$value])//仓库id
                            ->where('wafg_wago_id', $value)//仓库商品id
                            ->where('wafg_class', $warehouse_goods_wago[$value]->wago_class)//仓库类别
                            ->where('wafg_goo_id', $warehouse_goods_wago[$value]->wago_goo_id)//商品id
                            ->where('wafg_priority_stock_number', '>', 0)//仓位优先库存数量大于0
                            ->select('wafg_id', 'wafg_wafr_id', 'wafg_priority_stock_number', 'wafg_priority_lock_quantity')
                            ->orderby('wafg_priority_stock_number', 'desc')
                            ->get()->toArray();
                        // 判断库位的商品库存数量是否有等于下单数量
                        $quantity_equality = false;
                        foreach ($find_freight_goods as $wafg_key => $wafg_value) {
                            // 仓位的商品库存等于下单商品数量
                            if ($wafg_value->wafg_priority_stock_number == $wago_goo_quantity[$value]) {
                                $wafg_edit_data['wafg_priority_stock_number'] = $wafg_value->wafg_priority_stock_number - $wago_goo_quantity[$value];
                                $wafg_edit_data['wafg_priority_lock_quantity'] = $wafg_value->wafg_priority_lock_quantity + $wago_goo_quantity[$value];
                                $wafg_edit_data['wafg_update_time'] = date('Y-m-d H:i:s');
                                $wafg_res = DB::table('warehouse_freight_goods')
                                    ->where('wafg_id', $wafg_value->wafg_id)
                                    ->update($wafg_edit_data);
                                unset($wafg_edit_data);

                                // 仓位表总数量更改
                                $find_wafr_data = DB::table('warehouse_freight')
                                    ->where('wafr_id', $wafg_value->wafg_wafr_id)
                                    ->select('wafr_priority_all_stock', 'wafr_priority_lock_quantity')
                                    ->first();
                                // 优先总库存数量减少
                                $wafr_edit_data['wafr_priority_all_stock'] = $find_wafr_data->wafr_priority_all_stock - $wago_goo_quantity[$value];
                                // 优先总锁定数量增加
                                $wafr_edit_data['wafr_priority_lock_quantity'] = $find_wafr_data->wafr_priority_lock_quantity + $wago_goo_quantity[$value];
                                $wafr_edit_data['wafr_update_time'] = date('Y-m-d H:i:s');
                                $wafr_res = DB::table('warehouse_freight')
                                    ->where('wafr_id', $wafg_value->wafg_wafr_id)
                                    ->update($wafr_edit_data);
                                unset($wafr_edit_data);
                                
                                // 仓位商品锁定表
                                $wfgl_data['wfgl_shop_id'] = $user_info->adm_shop_id;//门店id
                                $wfgl_data['wfgl_ware_id'] = $ware_id[$value];//仓库id
                                $wfgl_data['wfgl_waon_class'] = $warehouse_goods_wago[$value]->wago_class;//仓库类别
                                $wfgl_data['wfgl_wago_id'] = $value;//仓库商品主键id
                                $wfgl_data['wfgl_wafr_id'] = $wafg_value->wafg_wafr_id;//仓位id
                                $wfgl_data['wfgl_wafg_id'] = $wafg_value->wafg_id;//仓位商品主键id
                                $wfgl_data['wfgl_original_correlation_id'] = $order_data['data']['ord_id'];//关联id：订单id/发货单id/调拨单id
                                $wfgl_data['wfgl_correlation_type'] = $wfgl_correlation_type;//关联类型：1订单2发货单3调拨单
                                $wfgl_data['wfgl_original_id'] = $order_data['data']['ord_id'];//原始id：订单id/调拨单id
                                $wfgl_data['wfgl_original_number'] = $order_data['data']['ord_order_number'];//原始单号：订单号/调拨单号
                                $wfgl_data['wfgl_type'] = $type;//原始单类型：1订单2调拨单
                                $wfgl_data['wfgl_state'] = 1;//锁定状态：1下单锁定2出库解锁
                                $wfgl_data['wfgl_lock_quantity'] = $wago_goo_quantity[$value];//商品锁定数量
                                $wfgl_data['wfgl_lock_type'] = 2;//商品锁定类型：1良品2优先
                                $wfgl_res = DB::table('warehouse_freight_goods_lock')->insert($wfgl_data);
                                unset($wfgl_data);
                                if (!$wafr_res || !$wafg_res || !$wfgl_res) {
                                    return ['code'=> 500, 'msg'=>'仓位商品库存数量不足！', 'data'=>'仓位商品库存数量不足！'];
                                }
                                $quantity_equality = true;//数量相等
                                if ($quantity_equality) {
                                    break;
                                }
                            }
                        }

                        // 仓位库存数量与下单商品数量不相等，需要从多个仓位锁定下单商品数量
                        if (!$quantity_equality) {
                            $already_lock_quantity = 0;//仓位已经锁定的库存数量
                            $surplus_lock_quantity = 0;//剩余可以锁定的数量
                            foreach ($find_freight_goods as $wafg_key => $wafg_value) {
                                // 判断仓位已经锁定库存数量是否大于等于下单商品数量，超过下单数量说明下单数量都已经锁定后面不需要在锁定库存可以跳过
                                if ($already_lock_quantity >= $wago_goo_quantity[$value]) {
                                    continue;
                                }
                                // 剩余可以锁定的数量=下单数量-已经锁定的数量
                                $surplus_lock_quantity = $wago_goo_quantity[$value] - $already_lock_quantity;
                                if ($surplus_lock_quantity > $wafg_value->wafg_priority_stock_number) {
                                    // 剩余锁定数量大于仓位库存数量，仓位库存数量全部转为锁定数量
                                    $wafg_edit_data['wafg_priority_stock_number'] = 0;
                                    $wafg_edit_data['wafg_priority_lock_quantity'] = $wafg_value->wafg_priority_lock_quantity + $wafg_value->wafg_priority_stock_number;

                                    // 当前仓位的库存数量就是更改的总库存数量
                                    $wafr_all_stock = $wafg_value->wafg_priority_stock_number;
                                } else {
                                    // 剩余锁定数量小于等于仓位库存数量，仓位库存数量减去剩余锁定库存数量
                                    $wafg_edit_data['wafg_priority_stock_number'] = $wafg_value->wafg_priority_stock_number - $surplus_lock_quantity;
                                    $wafg_edit_data['wafg_priority_lock_quantity'] = $wafg_value->wafg_priority_lock_quantity + $surplus_lock_quantity;
                                    
                                    // 剩余库存数量是更改的总库存数量
                                    $wafr_all_stock = $surplus_lock_quantity;//更改的总库存数量
                                }
                                $wafg_edit_data['wafg_update_time'] = date('Y-m-d H:i:s');
                                $wafg_res = DB::table('warehouse_freight_goods')
                                    ->where('wafg_id', $wafg_value->wafg_id)
                                    ->update($wafg_edit_data);
                                unset($wafg_edit_data);

                                // 仓位表总数量更改
                                $find_wafr_data = DB::table('warehouse_freight')
                                    ->where('wafr_id', $wafg_value->wafg_wafr_id)
                                    ->select('wafr_priority_all_stock', 'wafr_priority_lock_quantity')
                                    ->first();
                                // 良品总库存数量减少
                                $wafr_edit_data['wafr_priority_all_stock'] = $find_wafr_data->wafr_priority_all_stock - $wafr_all_stock;
                                // 良品总锁定数量增加
                                $wafr_edit_data['wafr_priority_lock_quantity'] = $find_wafr_data->wafr_priority_lock_quantity + $wafr_all_stock;
                                $wafr_edit_data['wafr_update_time'] = date('Y-m-d H:i:s');
                                $wafr_res = DB::table('warehouse_freight')
                                    ->where('wafr_id', $wafg_value->wafg_wafr_id)
                                    ->update($wafr_edit_data);
                                unset($wafr_edit_data);
                                
                                // 仓位商品锁定表
                                $wfgl_data['wfgl_shop_id'] = $user_info->adm_shop_id;//门店id
                                $wfgl_data['wfgl_ware_id'] = $ware_id[$value];//仓库id
                                $wfgl_data['wfgl_waon_class'] = $warehouse_goods_wago[$value]->wago_class;//仓库类别
                                $wfgl_data['wfgl_wago_id'] = $value;//仓库商品主键id
                                $wfgl_data['wfgl_wafr_id'] = $wafg_value->wafg_wafr_id;//仓位id
                                $wfgl_data['wfgl_wafg_id'] = $wafg_value->wafg_id;//仓位商品主键id
                                $wfgl_data['wfgl_original_correlation_id'] = $order_data['data']['ord_id'];//关联id：订单id/发货单id/调拨单id
                                $wfgl_data['wfgl_correlation_type'] = $wfgl_correlation_type;//关联类型：1订单2发货单3调拨单
                                $wfgl_data['wfgl_original_id'] = $order_data['data']['ord_id'];//原始id：订单id/调拨单id
                                $wfgl_data['wfgl_original_number'] = $order_data['data']['ord_order_number'];//原始单号：订单号/调拨单号
                                $wfgl_data['wfgl_type'] = $type;//原始单类型：1订单2调拨单
                                $wfgl_data['wfgl_state'] = 1;//锁定状态：1下单锁定2出库解锁
                                $wfgl_data['wfgl_lock_quantity'] = $wafr_all_stock;//商品锁定数量
                                $wfgl_data['wfgl_lock_type'] = 2;//商品锁定类型：1良品2优先
                                $wfgl_res = DB::table('warehouse_freight_goods_lock')->insert($wfgl_data);
                                unset($wfgl_data);
                                if (!$wafg_res || !$wafr_res || !$wfgl_res) {
                                    return ['code'=> 500, 'msg'=>'仓位商品库存数量不足！', 'data'=>'仓位商品库存数量不足！'];
                                }
                                $already_lock_quantity += $wafr_all_stock;
                            }
                        }
                        // 仓位库存数量不小于下单数量，仓库不用锁定库存
                        $goo_diff_amount = 0;
                    }
                }
                // 仓库的数量
                if ($goo_diff_amount && $ware_type == 1) {
                    $wago_priority_stock_amount = $warehouse_goods_wago[$value]->wago_priority_stock_amount - $goo_diff_amount;
                    if ($wago_priority_stock_amount < 0) {
                        return ['code'=> 500, 'msg'=>'仓库商品库存数量不足！', 'data'=>'仓库内商品数量不足4'];
                    }
                    
                    $wago_edit_data['wago_priority_stock_amount'] = $wago_priority_stock_amount;
                    $wago_edit_data['wago_priority_lock_amount'] = $warehouse_goods_wago[$value]->wago_priority_lock_amount + $goo_diff_amount;
                    // 仓位商品锁定表
                    $wfgl_data['wfgl_shop_id'] = $user_info->adm_shop_id;//门店id
                    $wfgl_data['wfgl_ware_id'] = $ware_id[$value];//仓库id
                    $wfgl_data['wfgl_waon_class'] = $warehouse_goods_wago[$value]->wago_class;//仓库类别
                    $wfgl_data['wfgl_wago_id'] = $value;//仓库商品主键id
                    $wfgl_data['wfgl_wafr_id'] = 0;//仓位id
                    $wfgl_data['wfgl_wafg_id'] = 0;//仓位商品主键id
                    $wfgl_data['wfgl_original_correlation_id'] = $order_data['data']['ord_id'];//关联id：订单id/发货单id/调拨单id
                    $wfgl_data['wfgl_correlation_type'] = $wfgl_correlation_type;//关联类型：1订单2发货单3调拨单
                    $wfgl_data['wfgl_original_id'] = $order_data['data']['ord_id'];//原始id：订单id/调拨单id
                    $wfgl_data['wfgl_original_number'] = $order_data['data']['ord_order_number'];//原始单号：订单号/调拨单号
                    $wfgl_data['wfgl_type'] = $type;//原始单类型：1订单2调拨单
                    $wfgl_data['wfgl_state'] = 1;//锁定状态：1下单锁定2出库解锁
                    $wfgl_data['wfgl_lock_quantity'] = $goo_diff_amount;//商品锁定数量
                    $wfgl_data['wfgl_lock_type'] = 2;//商品锁定类型：1良品2优先
                    $wfgl_res = DB::table('warehouse_freight_goods_lock')->insert($wfgl_data);
                    unset($wfgl_data);
                    if (!$wfgl_res) {
                        return ['code'=> 500, 'msg'=>'仓库商品库存数量不足！', 'data'=>'仓库内商品数量不足5'];
                    }
                }
            }
            $wago_edit_data['wago_update_time'] = date('Y-m-d H:i:s');
            $wag_res = DB::table('warehouse_goods')
                ->where('wago_id', $value)
                ->update($wago_edit_data);
            if (!$wag_res) {
                return ['code'=> 500, 'msg'=>'仓库锁定数量更新失败', 'data'=>'仓库锁定数量更新失败'];
            }
            unset($wago_edit_data);

            // 统计仓库总的库存数量
            if ($data['goo_inventory'] == 1) {
                // 良品总数量
                if (isset($waon_class_fine_quantity[$data['ware_id']][$data['wago_class']])) {
                    $waon_class_fine_quantity[$data['ware_id']][$data['wago_class']] += $data['goo_quantity'];//仓库类别对应良品库存总数量
                } else {
                    $waon_class_fine_quantity[$data['ware_id']][$data['wago_class']] = $data['goo_quantity'];//仓库类别对应良品库存总数量
                }
            } else {
                // 优先总数量
                if (isset($waon_class_priority_quantity[$data['ware_id']][$data['wago_class']])) {
                    $waon_class_priority_quantity[$data['ware_id']][$data['wago_class']] += $data['goo_quantity'];//仓库类别对应优先库存总数量
                } else {
                    $waon_class_priority_quantity[$data['ware_id']][$data['wago_class']] = $data['goo_quantity'];//仓库类别对应优先库存总数量
                }
            }
            unset($data);
        }

        // 更改仓库总库存数量
        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_fine_quantity as $ware_id => $waon_class_value) {
                foreach ($waon_class_value as $waon_class => $value) {
                    $waon_id = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', $waon_class)
                        ->select('waon_id', 'waon_stock_fine_amount', 'waon_lock_fine_amount')
                        ->first();
                    $waon_quantity = $waon_id->waon_stock_fine_amount - $value;
                    if ($waon_quantity < 0) {
                        return ['code'=>500, 'msg'=>'仓库良品库存数量不足了', 'data'=>'仓库良品库存数量不足了'];
                    }
                    $stock_fine_sql = $stock_fine_sql.' WHEN '.$waon_id->waon_id.' THEN `waon_stock_fine_amount` - '.$value;
                    $lock_fine_sql = $lock_fine_sql.' WHEN '.$waon_id->waon_id.' THEN `waon_lock_fine_amount` + '.$value;
                    $time_sql = $time_sql.' WHEN '.$waon_id->waon_id.' THEN "'.date('Y-m-d H:i:s').'"';

                    $ids = $ids . $waon_id->waon_id.',';
                    unset($waon_id->waon_id);
                }
            }
            $sql = $sql .' `waon_stock_fine_amount`=  CASE `waon_id` '.$stock_fine_sql.' END,';
            $sql = $sql .' `waon_lock_fine_amount`=  CASE `waon_id` '.$lock_fine_sql.' END,';
            $sql = $sql .' `waon_update_time`=  CASE `waon_id` '.$time_sql.' END';
            $sql = $sql . ' WHERE `waon_id` IN ('.trim($ids, ',').')';
            $waon_fine_res = DB::update($sql);
        } else {
            $waon_fine_res = true;
        }

        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_priority_quantity as $ware_id => $waon_class_value) {
                foreach ($waon_class_value as $waon_class => $value) {
                    $waon_id = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', $waon_class)
                        ->select('waon_id', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                        ->first();
                    $waon_quantity = $waon_id->waon_stock_priority_amount - $value;
                    if ($waon_quantity < 0) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'仓库优先库存数量不足了'];
                    }
                    $stock_fine_sql = $stock_fine_sql.' WHEN '.$waon_id->waon_id.' THEN `waon_stock_priority_amount` - '.$value;
                    $lock_fine_sql = $lock_fine_sql.' WHEN '.$waon_id->waon_id.' THEN `waon_lock_priority_amount` + '.$value;
                    $time_sql = $time_sql.' WHEN '.$waon_id->waon_id.' THEN "'.date('Y-m-d H:i:s').'"';

                    $ids = $ids . $waon_id->waon_id.',';
                    unset($waon_id->waon_id);
                }
            }
            $sql = $sql .' `waon_stock_priority_amount`=  CASE `waon_id` '.$stock_fine_sql.' END,';
            $sql = $sql .' `waon_lock_priority_amount`=  CASE `waon_id` '.$lock_fine_sql.' END,';
            $sql = $sql .' `waon_update_time`=  CASE `waon_id` '.$time_sql.' END';
            $sql = $sql . ' WHERE `waon_id` IN ('.trim($ids, ',').')';
            $waon_priority_res = DB::update($sql);
        } else {
            $waon_priority_res = true;
        }

        if ($waon_fine_res && $waon_priority_res) {
            return ['code'=> 200, 'msg'=>'success', 'data'=>'库存锁定成功'];
        } else {
            return ['code'=> 500, 'msg'=>'error', 'data'=>'仓库库存锁定失败'];
        }
    }

    /**
     * warehouseLockRecord 仓库商品锁定库存-出入库记录
     *
     * @param [array] $user_info  用户信息
     * @param [array] $request    提交信息
     * @param [array] $order_data 订单信息
     * @param [array] $wago_class_goods 库存锁定-出入库数据
     * @return void
     */
    public static function warehouseLockRecord(
        $user_info,
        $request,
        $order_data,
        $wago_class_goods
    ) {
        $osld_out_key = 0;
        foreach ($wago_class_goods as $goo_inventory => $new_class_goods_data) {
            foreach ($new_class_goods_data as $waon_class_key => $class_goods_data) {
                $goo_all_amount = 0;
                foreach ($class_goods_data as $goo_id_key => $value) {
                    $goo_all_amount += $value['goo_quantity']; //出库总数量
                    // 库存锁定-出库记录表
                    $osld_out_goo_data[$osld_out_key]['goo_waon_class'] = $waon_class_key; //仓库类别：1货物仓2非货物仓3旧货仓4临时仓
                    $osld_out_goo_data[$osld_out_key]['goo_id'] = $value['goo_id']; //商品id
                    $osld_out_goo_data[$osld_out_key]['goo_number'] = $value['goo_quantity']; //商品数量
                    $osld_out_goo_data[$osld_out_key]['goo_out_in_type'] = 3; //出入库类型：1出库2入库3锁定4取消锁定
                    $osld_out_goo_data[$osld_out_key]['goo_inventory'] = $value['goo_inventory']; //类型1良品2优先3待检测
                    // 查询仓库商品库存数量
                    $find_wago_data = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $request['ware_id'])
                        ->where('wago_class', $waon_class_key)
                        ->where('wago_goo_id', $value['goo_id'])
                        ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
                        ->first();
                    if ($goo_inventory == 1) { //良品
                        $osld_out_goo_data[$osld_out_key]['old_stock_number'] = $find_wago_data->wago_stock_number + $value['goo_quantity']; //旧的商品良品库存数量
                        $osld_out_goo_data[$osld_out_key]['old_stock_lock_number'] = $find_wago_data->wago_lock_quantity - $value['goo_quantity']; //旧的商品良品库存锁定数量
                        $osld_out_goo_data[$osld_out_key]['old_priority_number'] = $find_wago_data->wago_priority_stock_number; //旧的商品优先库存数量
                        $osld_out_goo_data[$osld_out_key]['old_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //旧的商品优先库存锁定数量
                        $osld_out_goo_data[$osld_out_key]['new_stock_number'] = $find_wago_data->wago_stock_number; //新的商品良品库存数量
                        $osld_out_goo_data[$osld_out_key]['new_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //新的商品良品库存锁定数量
                        $osld_out_goo_data[$osld_out_key]['new_priority_number'] = $find_wago_data->wago_priority_stock_number; //新的商品优先库存数量
                        $osld_out_goo_data[$osld_out_key]['new_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //新的商品优先库存锁定数量
                    } else { //优先
                        $osld_out_goo_data[$osld_out_key]['old_stock_number'] = $find_wago_data->wago_stock_number; //旧的商品良品库存数量
                        $osld_out_goo_data[$osld_out_key]['old_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //旧的商品良品库存锁定数量
                        $osld_out_goo_data[$osld_out_key]['old_priority_number'] = $find_wago_data->wago_priority_stock_number + $value['goo_quantity']; //旧的商品优先库存数量
                        $osld_out_goo_data[$osld_out_key]['old_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity - $value['goo_quantity']; //旧的商品优先库存锁定数量
                        $osld_out_goo_data[$osld_out_key]['new_stock_number'] = $find_wago_data->wago_stock_number; //新的商品良品库存数量
                        $osld_out_goo_data[$osld_out_key]['new_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //新的商品良品库存锁定数量
                        $osld_out_goo_data[$osld_out_key]['new_priority_number'] = $find_wago_data->wago_priority_stock_number; //新的商品优先库存数量
                        $osld_out_goo_data[$osld_out_key]['new_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //新的商品优先库存锁定数量
                    }
                    $osld_out_goo_data[$osld_out_key]['old_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //旧的商品待检测库存数量
                    $osld_out_goo_data[$osld_out_key]['new_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //新的商品待检测库存数量
                    $osld_out_goo_data[$osld_out_key]['osld_update_time'] = date('Y-m-d H:i:s'); //更新时间
                    $osld_out_goo_data[$osld_out_key] = (object)$osld_out_goo_data[$osld_out_key];
                    $osld_out_key++;
                }
                $find_out_ware = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $request['ware_id'])
                    ->where('waon_class', $waon_class_key)
                    ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                    ->first();
                // 库存锁定-出入库记录
                $oslr_out_res = OutinStockLock::addition(
                    $user_info, //用户信息
                    $order_data['data']['ord_id'], //原始单的关联id
                    $order_data['data']['ord_order_number'], //原始单的关联单号
                    1, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                    $request['ord_type'], //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    $request['ord_client_id'], //选择的客户id,会员id/单位id
                    $order_data['data']['ord_order_number'], //原始单号
                    $request['ware_id'], //出库/入库的仓库id
                    $goo_all_amount, //出库/入库总数量
                    1, //类型：1锁定库存2取消锁定3调拨单4旧货回收单5退换回收单6订单出库7部分入库8部分出库9发货单10移动仓出库11换货出库12换货入库13退货入库14退货出库15盘库单
                    $find_out_ware->waon_stock_fine_amount, //良品总库存
                    $find_out_ware->waon_lock_fine_amount, //良品锁定数量
                    $find_out_ware->waon_stock_priority_amount, //优先总库存
                    $find_out_ware->waon_lock_priority_amount, //优先锁定数量
                    $find_out_ware->waon_stock_unchecked_amount, //待检测总库存
                    1, //出入库类型：1出库，2入库
                    $osld_out_goo_data
                );
                unset($osld_out_goo_data);
                if (!$oslr_out_res) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'生成订单失败L'];
                }
            }
        }
    }
}
