<?php
namespace App\Http\Models\Services;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Pinyin;

class PublicSearch extends Model
{
    /**
     * [searchTechnician 搜索服务技师]
     * @param  [type] $user_info   [用户信息]
     * @param  [type] $search_data [搜索条件]
     * @param  [type] $show_count  [查询条数]
     * @return [type]              [description]
     */
    public function searchTechnician($user_info, $search_data, $show_count = 0)
    {
        // if ($search_data['wor_id']) {
        //     $find_work_th = DB::table('wash_work_technician_part as w')
        //         ->leftjoin('admin as a', 'a.adm_id', '=', 'w.wotp_service_adm_id')
        //         ->where('wotp_wor_id', $search_data['wor_id'])
        //         ->select('wotp_service_adm_id', 'adm_name')
        //         ->get()->toArray();
        //     $adm_id = array_column($find_work_th, 'wotp_service_adm_id');
        // } else {
        //     $adm_id = [];
        //     $find_work_th = [];
        // }
        if (isset($search_data['show_count'])) {
            $show_count = $search_data['show_count'];
        }
        $admin = DB::table('admin as a')
            ->leftJoin('admin_shop_role as asr', 'asr.adm_id', '=', 'a.adm_id')
            ->leftJoin('wash_grade_level as b', 'b.grle_id', '=', 'a.adm_grle_id')
            ->leftJoin('wash_grade_professional as c', 'c.grpr_id', '=', 'b.grle_grpr_id')
            ->where('adm_cid', $user_info->adm_cid)
            ->where('shop_id', $user_info->adm_shop_id)
            ->where('asr.adm_state', 1)
            ->where('asr.create_source', 1)
            ->whereIn('adm_leave', [1, 2, 3, 4, 5])
            ->where('adm_type', '!=', 2)  //不等于虚拟加盟店
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['search_data'])) {
                    $query->where('adm_name', 'like', '%' . $search_data['search_data'] . '%')
                        ->orwhere('adm_phone', 'like', '%' . $search_data['search_data'] . '%');
                }
            })
            ->select('a.adm_id', 'adm_name', 'adm_phone', 'grpr_name', 'grle_name', 'adm_account')
            ->orderBy('a.adm_id', 'desc');
        if (empty($show_count)) {
            $list_data = $admin->get();
            $find_coth_data = DB::table('collection_technician')
                ->where('coth_create_adm_id', $user_info->adm_id)
                ->where('coth_shop_id', $user_info->adm_shop_id)
                ->select('coth_id', 'coth_adm_id')
                ->get()->toArray();
            $coth_adm_id = array_column($find_coth_data, 'coth_adm_id');
            foreach ($list_data as $key => $value) {
                if (in_array($value->adm_id, $coth_adm_id)) {
                    $list_data[$key]->adm_coth_state = 1;
                } else {
                    $list_data[$key]->adm_coth_state = 2;
                }
                $rest = mb_substr($value->adm_name, 0, 1, 'utf-8');
                if ($rest) {
                    $mb = mb_strlen($rest,'utf-8');
                    $st = strlen($rest);
                    if ($st==$mb) {//英文
                        $list_data[$key]->firstLetter = strtoupper($rest);
                    } else {//汉字
                        $list_data[$key]->firstLetter = substr(strtoupper(Pinyin::abbr($value->adm_name)), 0, 1);
                    }
                } else {
                    $list_data[$key]->firstLetter = '';
                }
                $list_data[$key]->adm_name = $value->adm_name??'';
                $list_data[$key]->adm_phone = $value->adm_phone??'';
                $list_data[$key]->adm_account = $value->adm_account??'';
            }
            return ['code'=>200, 'msg'=>'success', 'data_info'=>$list_data];
        }
        $list_data = $admin->paginate($show_count);
        
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();               //返回数据
        // $data_info['data']['work_th_data'] = $find_work_th;               //已选技师
        return ['code'=>200, 'msg'=>'success', 'data_info'=>$data_info];
    }

    /**
     * [searchProject 搜索服务项目]
     * @param  [type] $user_info   [用户信息]
     * @param  [type] $search_data [搜索条件]
     * @return [type]              [description]
     */
    public function searchProject($user_info, $search_data)
    {
        if (!empty($search_data['shop_id'])) {
            $shop_id = $search_data['shop_id'];
        } else {
            $shop_id = $user_info->adm_shop_id;
        }
        $list = DB::table('service_project')
            ->where('sepr_cid', $user_info->adm_cid)
            ->where('sepr_shop_id', $shop_id)
            ->where('sepr_state', 1)
            ->where('sepr_delete', 1)
            ->where(function ($query) use ($search_data, $user_info) {
                if (!empty($search_data['shop_id'])) {
                    $query->where('sepr_assign_state', 2);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['search_data'])) {
                    $query->where('sepr_name', 'like', '%' . $search_data['search_data'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) { //订单类型
                if (!empty($search_data['sepr_order_type'])) {
                    $query->where('sepr_order_type', $search_data['sepr_order_type']);
                }
            })
            ->select('sepr_id', 'sepr_name', 'sepr_order_money', 'sepr_recycle')
            ->get()->toArray();
        return ['code'=>200, 'msg'=>'success', 'data'=>$list];
    }

    // 生成订单的唯一标识
    public function searchUniqueString($user_info)
    {
        // 获取唯一字符串标识
        $ord_unique_string = md5(md5($user_info->adm_id . $user_info->adm_shop_id . date('Y-m-d H:i:s') . rand(1000, 9999)));
        $data = ['ord_unique_string' => $ord_unique_string];
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    /**
     * [searchBrand 查询品牌信息]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $search_data  [搜索信息]
     * @param  [type] $select_field [查询字段，字符串多个字段用,分开]
     * @return [type]               [description]
     */
    public function searchBrand($user_info, $search_data, $select_field)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $shop_state = true;
        if (in_array($shop_id, config('apisystem.NO_SHOPID'))) {
            $shop_state = false;
        }

        $post['string'] = 'bra_';
        $post['user_info'] = $user_info;
        $type = 3;
        $where_data = whereFunction($post,$type);
        $brand_info  =  DB::table('brand')
            ->where(function ($query) use ($user_info, $shop_state) {
                if ($shop_state) {
                    $query->where('bra_cid', 0)
                        ->orwhere('bra_cid', $user_info->adm_cid);
                } else {
                    $query->where('bra_cid', $user_info->adm_cid);
                }
            })
            ->where(function ($query) use ($user_info, $where_data) {
                $query->whereIn($where_data['string'], $where_data['shop_id']);
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['search_data'])) {
                    $query->where('bra_name', 'like', '%' . $search_data['search_data'] . '%');
                }
            })
            ->where('bra_state', 1)
            ->where('bra_delete', 1)
            ->orderBy('bra_sequence', 'asc')
            ->select(DB::raw($select_field))
            ->get()->toArray();
        return ['code'=>200, 'msg'=>'success', 'data_info'=>$brand_info];
    }

    /**
     * [searchBrand 查询品牌信息]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $search_data  [搜索信息]
     * @param  [type] $select_field [查询字段，字符串多个字段用,分开]
     * @return [type]               [description]
     */
    public function searchBrandSerie($user_info, $search_data, $select_field)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $shop_state = true;
        if (in_array($shop_id, config('apisystem.NO_SHOPID'))) {
            $shop_state = false;
        }
        $post['string'] = 'brse_';
        $post['user_info'] = $user_info;
        $type = 3;
        $where_data = whereFunction($post,$type);
        $brand_info  =  DB::table('brand_serie')
            ->where(function ($query) use ($user_info, $shop_state) {
                if ($shop_state) {
                    $query->where('brse_cid', 0)
                        ->orwhere('brse_cid', $user_info->adm_cid);
                } else {
                    $query->where('brse_cid', $user_info->adm_cid);
                }
            })
            ->where(function ($query) use ($user_info, $where_data) {
                $query->whereIn($where_data['string'], $where_data['shop_id']);
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['brse_name'])) { //品牌系列名称
                    $query->where('brse_name', 'like', '%' . $search_data['brse_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['bra_id'])) { //品牌id
                    $query->where('brse_bra_id', $search_data['bra_id']);
                }
            })
            ->where('brse_state', 1)
            ->where('brse_delete', 1)
            ->orderBy('brse_sequence', 'asc')
            ->select(DB::raw($select_field))
            ->get()->toArray();
        return ['code'=>200, 'msg'=>'success', 'data_info'=>$brand_info];
    }

    /**
     * [searchCategory 查询品类信息]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $search_data  [搜索信息]
     * @param  [type] $select_field [查询字段，字符串多个字段用,分开]
     * @return [type]               [description]
     */
    public function searchCategory($user_info, $search_data, $select_field)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $shop_state = true;
        if (in_array($shop_id, config('apisystem.NO_SHOPID'))) {
            $shop_state = false;
        }
        $post['string'] = 'cate_';
        $post['user_info'] = $user_info;
        $type = 3;
        $where_data = whereFunction($post,$type);
        $category_info  =  DB::table('category')
            ->where(function ($query) use ($user_info, $shop_state) {
                if ($shop_state) {
                    $query->where('cate_cid', 0)
                        ->orwhere('cate_cid', $user_info->adm_cid);
                } else {
                    $query->where('cate_cid', $user_info->adm_cid);
                }
            })
            ->where(function ($query) use ($user_info, $where_data) {
                $query->whereIn($where_data['string'], $where_data['shop_id']);
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['search_data'])) {
                    $query->where('cate_name', 'like', '%' . $search_data['search_data'] . '%');
                }
            })
            ->where('cate_delete', 1)
            ->where('cate_state', 1)
            ->select(DB::raw($select_field))
            ->get()->toArray();
        return ['code'=>200, 'msg'=>'success', 'data_info'=>$category_info];
    }

    /**
     * [searchWarehouse 查询仓库信息]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $search_data  [搜索信息]
     * @param  [type] $select_field [查询字段，字符串多个字段用,分开]
     * @return [type]               [description]
     */
    public function searchWarehouse($user_info, $search_data, $select_field)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->adm_shop_id;

        if (in_array($user_info->adm_id, [1])) {
            $list_data = DB::table('warehouse')
                ->where('ware_cid', $user_info->adm_cid)
                ->where('ware_shop_id', $shop_id)
                ->where('ware_state', 1)
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ware_type'])) {
                        $query->where('ware_type', $search_data['ware_type']);
                    }
                }) //仓库类型
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ware_name'])) {
                        $query->where('ware_name', 'like', '%' . $search_data['ware_name'] . '%');
                    }
                }) //仓库名称
                ->select(DB::raw($select_field))
                ->get()->toArray();
        } else {
            $list_data = DB::table('warehouse')
                ->where('ware_cid', $user_info->adm_cid)
                ->where('ware_shop_id', $shop_id)
                ->where('ware_state', 1);
            if (isset($search_data['search_type']) && $search_data['search_type'] == 1) {
                // 销售统计的仓库搜索不加这个限制条件
            } else {
                $list_data = $list_data->where('ware_type', '<>', 2);
            }
            $list_data = $list_data->where(function ($query) use ($search_data) {
                if (!empty($search_data['ware_type'])) {
                    $query->where('ware_type', $search_data['ware_type']);
                }
            }) //仓库类型
                ->where(function ($query) use ($search_data) { //仓库名称
                    if (!empty($search_data['ware_name'])) {
                        $query->where('ware_name', 'like', '%' . $search_data['ware_name'] . '%');
                    }
                })
                ->select(DB::raw($select_field))
                ->get()->toArray();
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$list_data];
    }

    /**
     * [searchSalesman 搜索业务员]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $search_data  [搜索信息]
     * @param  [type] $select_field [查询字段，字符串多个字段用,分开]
     * @return [type]               [description]
     */
    public function searchSalesman($user_info, $search_data, $select_field, $show_count)
    {
        $list_data = DB::table('admin as a')
            ->leftJoin('admin_shop_role as asr', 'asr.adm_id', "=", "a.adm_id")
            ->where('asr.shop_cid', $user_info->adm_cid)
            ->where('asr.shop_id', $user_info->adm_shop_id)
            ->where('asr.adm_state', 1)
            ->whereIn('asr.adm_leave', [4,5])
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['search_data'])) {
                    $query->where('a.adm_name', 'like', '%'. $search_data['search_data'].'%');
                }
            }) //名称
            ->select(DB::raw($select_field))
            ->orderBy('a.adm_id', 'desc')
            ->paginate($show_count);
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据
        return ['code'=>200, 'msg'=>'success', 'data'=>$data_info];
    }

    /**
     * [searchPersonel 搜索人员]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $search_data  [搜索信息]
     * @param  [type] $select_field [查询字段，字符串多个字段用,分开]
     * @return [type]               [description]
     */
    public function searchPersonel($user_info, $search_data, $select_field)
    {
        $list_data = DB::table('admin')
            ->leftJoin('admin_shop_role as asr', 'asr.adm_id', '=', 'admin.adm_id')
            ->where('asr.shop_cid', $user_info->adm_cid)
            ->where('asr.shop_id', $user_info->adm_shop_id)
            ->where('admin.adm_state', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['adm_name'])) {
                    $query->where('adm_name', 'like', '%' . $search_data['adm_name'] . '%');
                }
            })
            ->select('admin.adm_id', 'adm_name')
            ->get()->toArray();
        return ['code'=>200, 'msg'=>'success', 'data'=>$list_data];
    }

    /**
     * [searchChannelUnit 搜索客户单位]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $search_data  [搜索信息]
     * @param  [type] $select_field [查询字段，字符串多个字段用,分开]
     * @return [type]               [description]
     */
    public function searchChannelUnit($user_info, $search_data, $show_count, $select_field)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $find_data =  DB::table('channel_unit')
            ->where('chun_cid', $user_info->adm_cid)
            ->where('chun_superior_shop_id', $shop_id)
            ->where('chun_state', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['search_data'])) {
                    $query->where('chun_unit_name', 'like', '%' . $search_data['search_data'] . '%')
                        ->orwhere('chun_search_letter', 'like', '%' . $search_data['search_data'] . '%');
                }
            })
            ->select(DB::raw($select_field))
            ->paginate($show_count);
        $data_info['current_page'] = $find_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $find_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $find_data->total();               //总数据个数
        $data_info['current_number'] = $show_count;       //一页显示多少个
        $data_info['data'] = $find_data->items();                //返回数据
        return ['code'=>200, 'msg'=>'success', 'data'=>$data_info];
    }

    /**
     * [searchPrecincts 搜索业务划区]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $search_data  [搜索信息]
     * @param  [type] $select_field [查询字段，字符串多个字段用,分开]
     * @return [type]               [description]
     */
    public function searchPrecincts($user_info, $search_data, $select_field)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $list_data  =  DB::table('precincts')
            ->where('prec_cid', $user_info->adm_cid)
            ->where('prec_superior_shop_id', $shop_id)
            ->where('prec_state', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['prec_name'])) {
                    $query->where('prec_name', 'like', '%' . $search_data['prec_name'] . '%');
                }
            })
            ->select(DB::raw($select_field))
            ->limit(10)
            ->get()->toArray();
        return ['code'=>200, 'msg'=>'success', 'data'=>$list_data];
    }

    /**
     * [searchQualityInspectionItem 搜索质检项]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $search_data  [搜索信息]
     * @param  [type] $select_field [查询字段，字符串多个字段用,分开]
     * @return [type]               [description]
     */
    public function searchQualityInspectionItem($user_info, $search_data, $select_field)
    {
        // 判断是否传入查询字段
        if (empty($field_columns)) {
            $field_columns = ['qurp_id', 'qurp_name', 'qurp_type', 'qurp_standard', 'qurp_standard_type', 'qurp_remark', 'qurp_create_time', 'qurp_state'];
        }
        if ($search_data['qurp_type'] == 1) {
            $search_data['qurp_type'] = [1];
        }
        if (isset($search_data['qurp_repu_type'])) {
            if ($search_data['qurp_repu_type'] == 1) {
                $search_data['qurp_type'] = [2];
            } elseif ($search_data['qurp_repu_type'] == 2) {
                $search_data['qurp_type'] = [3];
            }
        }
        // 质检奖惩管理
        $list_data = DB::table('wash_quality_reward_punishment as w')
            ->where('qurp_cid', $user_info->adm_cid)
            ->where('qurp_shop_id', $user_info->adm_shop_id)
            ->where('qurp_delete', 1)
            ->where(function($query) use($search_data) {
                if (!empty($search_data['qurp_name'])) {
                    $query->where('qurp_name', 'like', '%'.$search_data['qurp_name'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['qurp_state'])) {
                    $query->where('qurp_state', $search_data['qurp_state']);
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['qurp_type'])) {
                    $query->whereIn('qurp_type', $search_data['qurp_type']);
                }
            })
            ->select($field_columns)
            ->orderBy('qurp_id', 'desc')
            ->get()->toArray();
        return ['code'=>200, 'msg'=>'success', 'data'=>$list_data];
    }    
}
