<?php

namespace App\Http\Models\Services;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class OrderCache extends Model
{
    protected $table = 'order_cache';//与模型关联的数据表
    protected $primaryKey = 'orca_id';//主键id
    public $timestamps = false;//该模型是否被自动维护时间戳

    /**
     * clearOrderCache 清除订单缓存数据
     * @param [type] $user_info 用户信息
     * @return void
     */
    public function clearOrderCache($user_info)
    {
        $orca_id = DB::table('order_cache')
            ->where('orca_create_id', $user_info->adm_id)
            ->value('orca_id');
        if ($orca_id) {
            $orca_del = DB::table('order_cache')->where('orca_id', $orca_id)->delete();
        } else {
            $orca_del = true;
        }
        // 订单商品缓存表 清除缓存数据
        $orgc_data = DB::table('order_goods_cache')
            ->where('orgc_orca_id', $orca_id)
            ->value('orgc_orca_id');
        if ($orgc_data) {
            $orgc_del = DB::table('order_goods_cache')->where('orgc_orca_id', $orca_id)->delete();
        } else {
            $orgc_del = true;
        }
        // 订单客户缓存表 清除缓存数据
        $orcc_data = DB::table('order_client_cache')
            ->where('orcc_orca_id', $orca_id)
            ->value('orcc_orca_id');
        if ($orcc_data) {
            $orcc_del = DB::table('order_client_cache')->where('orcc_orca_id', $orca_id)->delete();
        } else {
            $orcc_del = true;
        }
        if ($orca_del && $orgc_del && $orcc_del) {
            return ['code' => 200, 'msg' => 'success', 'data' => '缓存数据清除成功'];
        } else {
            return ['code' => 500, 'msg' => 'error', 'data' => '缓存数据清除失败'];
        }
    }
}
