<?php
namespace App\Http\Models\Services;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Services\ImageUpload;
use App\Http\Models\Services\WarehouseManage\OutinStockLock;
use App\Services\Business\WashOrderService;

class Order extends Model
{
    protected $table = 'order'; //与模型关联的数据表
    protected $primaryKey = 'ord_id'; //主键id
    public $timestamps = false; //该模型是否被自动维护时间戳

    /**
     * [createOrder 创建订单]
     * @param  [type]  $user_info [用户信息]
     * @param  [type]  $request   [订单数据]
     * @param  integer $type      [类型1生成订单2生成订单+生成工单]
     * @return [type]             [description]
     */
    public function createOrder(
        $user_info,
        $request,
        $type = 1
    ) {
        $goods_data = json_decode($request['goods_data'], true);
        if (empty($goods_data) && $request['ord_service_type'] != 7) {
            return ['code'=>500, 'msg'=>'success', 'data'=>'请选择商品'];
        }
        if (empty($request['ord_unique_string'])) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'生成订单验证密钥未提交，请刷新页面或重新登录系统！'];
        }
        // 判断唯一标识是否存在
        $find_unique = DB::table('order')
            ->where('ord_unique_string', $request['ord_unique_string'])
            ->value('ord_unique_string');
        if ($find_unique) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'当前订单已提交，请勿重复操作！'];
        }
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $request['orcl_phone'] = isset($request['orcl_phone']) ? $request['orcl_phone'] : '';
        // 添加订单数据
        // 1. 添加订单表数据
        $ord_order_number = Common::orderRule($user_info);
        $ord_data['ord_cid'] = $user_info->adm_cid;
        $ord_data['ord_shop_id'] = $user_info->adm_shop_id;
        $ord_data['ord_superior_shop_id'] = $shop_id;
        $ord_data['ord_create_id'] = $user_info->adm_id;
        // ord_service_type 订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单 7救援单
        if (in_array($request['ord_service_type'], [4, 5, 6])) {
            // ord_wor_state 订单的工单状态1未派工单2服务中3售后中4已完成5无工单
            // 退货单、发货单、结清单 不需要技师，为无工单状态
            $ord_data['ord_wor_state'] = 5;
            $request['service_adm_id'] = 0;
        }
        if (!$request['ord_remark']) {
            $request['ord_remark'] = '';
        }
        $ord_data['ord_service_adm_id'] = $request['service_adm_id']; //服务技师id
        $ord_data['ord_ware_id'] = $request['ware_id']; //仓库id
        $ord_data['ord_client_id'] = isset($request['ord_client_id']) ? $request['ord_client_id'] : 0; //选择客户id
        $ord_data['ord_order_number'] = $ord_order_number; //订单号
        // 订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单
        $ord_data['ord_service_type'] = $request['ord_service_type'];
        $ord_data['ord_payment_way'] = $request['ord_payment_way']; // 结算方式1.账期 2.现结 3微信 4支付宝
        $ord_data['ord_type'] = $request['ord_type']; // 买家类型：1门店零售2渠道单位
        $ord_data['ord_remark'] = $request['ord_remark']; //订单备注
        // type 1生成订单2生成订单+生成工单
        if ($type == 2) {
            $ord_data['ord_wor_quantity'] = 1; //工单数量
            $ord_data['ord_wor_state'] = 2; //订单的工单状态1未派工单2服务中3售后中4已完成
        }
        $ord_data['ord_service_sepr_id'] = $request['service_sepr_id']; //服务项目id
        // 服务门店为0的话 是当前门店id
        if ($request['service_shop_id'] == 0) {
            $ord_data['ord_service_shop_id'] = $user_info->adm_shop_id; //服务门店id
        } else {
            $ord_data['ord_service_shop_id'] = $request['service_shop_id']; //服务门店id
        }
        // orcl_shipment_party 出货方1自营仓库2直营店3加盟店4虚拟加盟店5我的门店(运营中心派单给门店)
        if ($request['orcl_shipment_party'] == 4) {
            $ord_data['ord_form_type'] = 2; //订单分类:1普通订单2虚拟加盟店订单3下级门店订单
        } elseif ($request['orcl_shipment_party'] == 5) {
            $ord_data['ord_form_type'] = 3; //订单分类:1普通订单2虚拟加盟店订单3下级门店订单
        }
        $ord_data['ord_unique_string'] = $request['ord_unique_string']; //生成订单的唯一标识
        $ord_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_id = DB::table('order')->insertGetId($ord_data);

        // 救援单的服务项目金额
        $orcl_rescue_service_price = isset($request['orcl_rescue_service_price']) ? $request['orcl_rescue_service_price'] : 0;
        // 救援单的代收金额
        $orcl_rescue_collection_price = isset($request['orcl_rescue_collection_price']) ? $request['orcl_rescue_collection_price'] : 0;
        if ($request['ord_type'] == '2') {
            $chun_adm_id = DB::table('channel_unit')
                ->where('chun_id', $request['ord_client_id'])
                ->value('chun_adm_id');
            if (empty($chun_adm_id)) {
                $chun_adm_id = 0;
            }
        } else {
            $chun_adm_id = 0;
        }

        // 添加订单客户表数据
        $orcl_data = [
            'orcl_ord_id' => $ord_id,
            'orcl_client_id' => isset($request['ord_client_id']) ? $request['ord_client_id'] : 0, //选择客户id
            'orcl_adm_id' => $chun_adm_id, //业务员id
            'orcl_channel_unit' => isset($request['orcl_channel_unit']) ? $request['orcl_channel_unit'] : '',
            'orcl_name' => $request['orcl_name'],
            'orcl_phone' => $request['orcl_phone'],
            'orcl_car_num' => isset($request['orcl_car_num']) ? $request['orcl_car_num'] : '',
            'orcl_province' => $request['orcl_province'],
            'orcl_city' => $request['orcl_city'],
            'orcl_county' => $request['orcl_county'],
            'orcl_address' => $request['orcl_address'],
            'orcl_chin_type' => $request['orcl_chin_type'], //是否铺货：1是2否
            'orcl_collect_state' => $request['orcl_collect_state'], //技师收钱：1是2否
            // 救援单的服务项目金额
            'orcl_rescue_service_price' => $orcl_rescue_service_price * 100,
            // 救援单的代收金额
            'orcl_rescue_collection_price' => $orcl_rescue_collection_price * 100,
            'orcl_update_time' => date('Y-m-d H:i:s'),
            'orcl_shipment_party' => $request['orcl_shipment_party'], //出货方1自营仓库2直营店3加盟店4虚拟加盟店5我的门店(运营中心派单给门店)
            'orcl_car_vehicle_type' => isset($request['orcl_car_vehicle_type']) ? $request['orcl_car_vehicle_type'] : '', //车型
            'orcl_junk_type' => $request['orcl_junk_type'], //是否回收1是2否
            'orcl_whether_app' => $request['orcl_whether_app'], //APP流程1是2否
            'orcl_precise_lock' => $request['precise_lock'], //精准抵达1是2否
        ];

        if (isset($request['orcl_rescue_assign_price'])) { //救援单虚拟加盟店的派单金额
            $orcl_data['orcl_rescue_assign_price'] = $request['orcl_rescue_assign_price'] * 100;
        } else {
            $orcl_data['orcl_rescue_assign_price'] = 0;
        }
        if (isset($request['orcl_appoint_time'])) {
            $orcl_data['orcl_appoint_time'] = $request['orcl_appoint_time']; //预约时间
        }

        // ord_service_type 订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单 7救援单
        if (in_array($request['ord_service_type'], [1, 7])) {
            // 订单类型为服务单、救援单的有图片上传模板，根据订单类型，获取当前门店的图片上传模板
            $image_manager = new ImageUpload();
            $find_shit_id = $image_manager->getOrderTypeImageTemplate($user_info->adm_shop_id, $request['ord_service_type']);
            $orcl_data['orcl_shit_id'] = $find_shit_id; //图片模板id
        }
        $orcl_id = DB::table('order_client')->insertGetId($orcl_data);

        // 选择的客户id，对应的订单数量增加
        if ($request['ord_client_id']) {
            if ($request['ord_type'] == 1) {
                // 零售，会员表
                $client_res = DB::table('member')
                    ->where('mem_id', $request['ord_client_id'])
                    ->increment('mem_order_all');
            } else {
                $client_res = true;
            }
        } else {
            if ($request['ord_type'] == 2) {
                // 1. 判断客户单位名称是否存在
                $find_chun = DB::table('channel_unit')
                    ->where('chun_cid', $user_info->adm_cid)
                    ->where('chun_shop_id', $user_info->adm_shop_id)
                    ->where('chun_superior_shop_id', $shop_id)
                    ->where('chun_unit_name', $request['orcl_channel_unit'])
                    ->first(['chun_id']);
                if ($find_chun) {
                    return ['code'=>500, 'msg'=>'success', 'data'=>'客户单位已存在，生成订单失败'];
                }

                // 2 新增一个客户单位
                $chun_add_data['chun_cid'] = $user_info->adm_cid;
                $chun_add_data['chun_shop_id'] = $user_info->adm_shop_id;
                $chun_add_data['chun_superior_shop_id'] = $shop_id;
                $chun_add_data['chun_adm_id'] = $user_info->adm_id;
                $chun_add_data['chun_search_letter'] = '';
                $chun_add_data['chun_unit_name'] = $request['orcl_channel_unit'];
                $chun_add_data['chun_name'] = $request['orcl_name'];
                $chun_add_data['chun_phone'] = $request['orcl_phone'];
                $chun_add_data['chun_chty_id'] = 0;
                $chun_add_data['chun_state'] = 1;
                $chun_add_data['chun_payment_way'] = $request['ord_payment_way'];
                $chun_add_data['chun_province'] = $request['orcl_province'];
                $chun_add_data['chun_city'] = $request['orcl_city'];
                $chun_add_data['chun_county'] = $request['orcl_county'];
                $chun_add_data['chun_address'] = $request['orcl_address'];
                $chun_add_data['chun_img'] = '';
                $chun_res =  DB::table('channel_unit')->insertGetId($chun_add_data);

                $request['ord_client_id'] = $chun_res;
                $chin_add_data['chin_chun_id'] = $chun_res;
                $chin_data[0]['key'] = $request['orcl_name'];
                $chin_data[0]['value'] = $request['orcl_phone'];
                $chin_data[0]['default'] = 1;
                $chin_add_data['chin_data'] = json_encode($chin_data);
                $chin_add_data['chin_level'] = 'A';
                $chin_add_data['chin_prec_id'] = 0; //业务划区id
                $chin_add_data['chin_remarks'] = $request['orcl_remarks'];
                $chin_add_data['chin_main_brand'] = '';
                $chin_add_data['chin_second_brand'] = '';
                $chin_add_data['chin_longitude'] =  0; //经度
                $chin_add_data['chin_latitude'] = 0; //维度
                $chin_res =  DB::table('channel_info')->insert($chin_add_data);
                if (!$chin_res || !$chun_res) {
                    return ['code'=>500, 'msg'=>'success', 'data'=>'新增客户单位失败'];
                }
                $client_res = true;
            } else {
                $eme['mem_cid'] = $user_info->adm_cid;
                $eme['mem_superior_shop_id'] = $shop_id;
                $eme['mem_shop_id'] = $user_info->adm_shop_id;
                $eme['mem_name'] = $request['orcl_name'] ?? '';
                $eme['mem_bership'] = 2;
                $eme['mem_sex'] = 3;
                if (!empty($request['orcl_phone'])) {
                    $find_mem = DB::table('member')
                        ->where('mem_cid', $user_info->adm_cid)
                        ->where('mem_shop_id', $user_info->adm_shop_id)
                        ->where('mem_phone', $request['orcl_phone'])
                        ->first(['mem_id']);
                    if ($find_mem) {
                        return ["code"=>500, 'msg'=>'error', 'data'=>'当前手机号已存在'];
                    }
                }
                $eme['mem_phone'] = $request['orcl_phone'] ?? '';
                $eme['mem_car_num'] = $request['orcl_car_num'] ?? '';
                $eme['mem_car_model'] = $request['orcl_car_vehicle_type'] ?? ''; //车型
                $eme['mem_province'] = $request['orcl_province'] ?? ''; //省
                $eme['mem_city'] = $request['orcl_city'] ?? ''; //市
                $eme['mem_county'] = $request['orcl_county'] ?? ''; //县
                $eme['mem_address'] = $request['orcl_address'] ?? ''; //详细地址
                $eme['mem_order_all'] = 1; //订单数
                $mem_id = DB::table('member')->insertGetId($eme);
                WashOrderService::addFestival($mem_id,$user_info);//新增节日提醒
                if (!$mem_id) {
                    return ['code'=>500, 'msg'=>'success', 'data'=>'新增会员失败'];
                }
                $request['ord_client_id'] = $mem_id;
                $client_res = true;
            }
        }

        // 订单类型：7救援单，查询服务项目的订单金额
        if ($request['ord_service_type'] == 7) {
            // 没有添加商品数据
            if (empty($goods_data)) {
                // 4. 更改订单表客户id、订单金额
                $ord_edit_data['ord_orcl_id'] = $orcl_id;
                $ord_edit_data['ord_order_price'] = $orcl_rescue_service_price * 100; // 订单金额（单位：分）
                $ord_edit_data['ord_actual_price'] = $orcl_rescue_service_price * 100; // 结算金额（单位：分）
                $ord_edit_data['ord_goods_quantity'] = 0; // 商品总数量
                $ord_edit_data['ord_collection_price'] = $orcl_rescue_collection_price * 100; //商品代收金额（单位：分）
                $ord_eidt_res = DB::table('order')
                    ->where('ord_id', $ord_id)
                    ->update($ord_edit_data);
                if ($ord_id && $orcl_id && $ord_eidt_res && $client_res) {
                    $return_data['ord_id'] = $ord_id;
                    $return_data['ord_order_number'] = $ord_order_number;
                    $return_data['shop_id'] = $shop_id; //总店id
                    return ['code'=>200, 'msg'=>'success', 'data'=>$return_data];
                } else {
                    return ['code'=>500, 'msg'=>'success', 'data'=>'生成订单失败'];
                }
            }
        }

        $goo_all_price = 0; //商品总金额
        $goo_assign_all_price = 0; //商品派单金额
        $goo_collection_price = 0; //商品代收金额
        $goo_all_quantity = 0; //商品总数量
        if (!empty($goods_data)) {
            if ($request['orcl_shipment_party'] == 4 || $request['orcl_shipment_party'] == 5) {
                $request['ware_id'] = 0;
            }
            foreach ($goods_data as $key => $value) {
                if (!isset($value['goo_assign_price'])) {
                    $value['goo_assign_price'] = 0;
                }
                if (!isset($value['wago_id'])) {
                    $value['wago_id'] = 0;
                }
                if (!is_numeric($value['wago_id']) || !is_numeric($value['goo_id']) || !in_array($value['goo_state'], [1, 3, 4, 5, 6, 7, 8]) || !is_numeric($value['goo_waon_class']) || !in_array($value['goo_inventory'], [1, 2])  || !is_numeric($value['goo_price']) || !is_numeric($value['goo_collection_price']) || !is_numeric($value['goo_assign_price']) || !is_numeric($value['goo_quantity'])) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'商品参数类型错误'];
                }
                // 搜索商品id对应的商品名称、商品编号
                $find_goods_data = DB::table('goods')
                    ->where('goo_id', $value['goo_id'])
                    ->select('goo_name', 'goo_goods_encode', 'goo_type', 'goo_ampere_hour', 'goo_price', 'goo_fid', 'goo_class', 'goo_is_send')
                    ->first();
                if ($find_goods_data->goo_class == 1) { //类型：1自营商品2系统商品
                    // 查询商品附属表
                    $goaf_another_name = DB::table('goods_affiliate')
                        ->where('goaf_goo_id', $value['goo_id'])
                        ->where('goaf_shop_id', $user_info->adm_shop_id)
                        ->value('goaf_another_name');
                    if (!empty($goaf_another_name)) {
                        $find_goods_data->goo_name = $goaf_another_name;
                    }
                } else {
                    // 查询系统商品属性表
                    $gosa_another_name = DB::table('goods_system_affiliate')
                        ->where('gosa_goo_id', $value['goo_id'])
                        ->where('gosa_shop_id', $user_info->adm_shop_id)
                        ->value('gosa_another_name');
                    if (!empty($gosa_another_name)) {
                        $find_goods_data->goo_name = $gosa_another_name;
                    }
                }
                // goo_state 商品状态1.正常 2.删除3.回收的商品4.换货商品5.赠品商品6.备用电池7.临时商品8.旧货商品
                // 换货商品金额处理
                if ($value['goo_state'] == 1 || $value['goo_state'] == 5) {
                    // 订单商品
                    $goo_all_price += $value['goo_price'] * $value['goo_quantity'];
                    $goo_assign_all_price += $value['goo_assign_price'] * $value['goo_quantity'];

                    $goo_all_quantity += $value['goo_quantity']; //商品总数量
                    $goo_collection_price += $value['goo_collection_price'];
                } elseif ($value['goo_state'] == 4) { //换货商品
                    return ['code'=>500, 'msg'=>'success', 'data'=>'换货单生成订单失败'];
                } elseif ($value['goo_state'] == 6) { //备用电池
                    if ($value['goo_inventory'] != '1' && $request['ord_service_type'] != 4) {
                        return ['code'=>500, 'msg'=>'success', 'data'=>'备用电池请选择备用品！'];
                    }
                    $goo_all_quantity += $value['goo_quantity']; //商品总数量
                    $goo_all_price += $value['goo_price'] * $value['goo_quantity'];
                    $goo_collection_price += $value['goo_collection_price'];
                } elseif ($value['goo_state'] == 7) { //临时商品
                    $goo_all_price += $value['goo_price'] * $value['goo_quantity'];
                    $goo_all_quantity += $value['goo_quantity']; //商品总数量
                } elseif ($value['goo_state'] == 8) { //旧货商品
                    $goo_all_price += $value['goo_price'] * $value['goo_quantity'];
                    $goo_assign_all_price += $value['goo_assign_price'] * $value['goo_quantity'];
                    $goo_all_quantity += $value['goo_quantity']; //商品总数量
                    $goo_collection_price += $value['goo_collection_price']; //商品代收总金额
                }

                // 订单商品表
                $orgo_data[$key]['orgo_ord_id'] = $ord_id;
                $orgo_data[$key]['orgo_order_number'] = $ord_order_number;
                $orgo_data[$key]['orgo_ware_id'] = $request['ware_id'];
                $orgo_data[$key]['orgo_wago_id'] = $value['wago_id'];
                $orgo_data[$key]['orgo_waon_class'] = $value['goo_waon_class'];
                $orgo_data[$key]['orgo_actual_goo_id'] = $value['goo_id'];
                $orgo_data[$key]['orgo_goo_id'] = $value['goo_id'];

                $orgo_data[$key]['orgo_goo_price'] = $value['goo_price'] * 100;
                $orgo_data[$key]['orgo_goo_quantity'] = $value['goo_quantity'];
                if ($type == 2) {
                    $orgo_data[$key]['orgo_can_assign_quantity'] = 0;
                } else {
                    $orgo_data[$key]['orgo_can_assign_quantity'] = $value['goo_quantity'];
                }
                $orgo_data[$key]['orgo_collection_price'] = $value['goo_collection_price'] * 100;
                $orgo_data[$key]['orgo_goo_inventory'] = $value['goo_inventory'];
                $orgo_data[$key]['orgo_update_time'] = date('Y-m-d H:i:s');
                if (!empty($value['tem_goo_name'])) {
                    $orgo_data[$key]['orgo_tem_goo_name'] = $value['tem_goo_name'];
                } else {
                    $orgo_data[$key]['orgo_tem_goo_name'] = '';
                }
                $orgo_data[$key]['orgo_goo_name'] = $find_goods_data->goo_name;
                $orgo_data[$key]['orgo_goo_is_send'] = $find_goods_data->goo_name;
                $orgo_data[$key]['orgo_goo_goods_encode'] = $find_goods_data->goo_goods_encode;
                $orgo_data[$key]['orgo_goo_type'] = $find_goods_data->goo_type;
                $orgo_data[$key]['orgo_goo_ampere_hour'] = $find_goods_data->goo_ampere_hour;
                $orgo_data[$key]['orgo_state'] = $value['goo_state'];
                if ($request['orcl_shipment_party'] == 4 || $request['orcl_shipment_party'] == 5) {
                    $orgo_data[$key]['orgo_assign_price'] = $value['goo_assign_price'] * 100;
                }
            }
        }
        $goo_all_price = $goo_all_price + ($orcl_rescue_service_price); //合计金额=商品总金额+服务项目的订单金额
        $goo_order_price = $goo_all_price; //订单总金额
        if ($request['ord_service_type'] == 4) {
            $goo_all_price = '-' . $goo_all_price;
            $goo_order_price = '-' . $goo_order_price;
        }
        if (!empty($goods_data)) {
            // 添加订单商品表数据
            foreach ($orgo_data as $key => $value) {
                $orgo_res = DB::table('order_goods')->insertGetId($orgo_data[$key]);
                $goods_data[$key]['orgo_id'] = $orgo_res;
            }
        } else {
            $orgo_res = true;
        }

        // 4. 更改订单表客户id、订单金额
        $ord_edit_data['ord_orcl_id'] = $orcl_id; //订单客户id
        $ord_edit_data['ord_client_id'] = $request['ord_client_id']; //
        $ord_edit_data['ord_order_price'] = $goo_order_price * 100; // 订单金额（单位：分）
        $ord_edit_data['ord_actual_price'] = $goo_all_price * 100; // 结算金额（单位：分）
        $ord_edit_data['ord_goods_quantity'] = $goo_all_quantity; // 商品总数量
        $ord_edit_data['ord_collection_price'] = ($goo_collection_price + $orcl_rescue_collection_price) * 100; //商品代收金额（单位：分）
        $ord_eidt_res = DB::table('order')
            ->where('ord_id', $ord_id)
            ->update($ord_edit_data);

        if ($request['orcl_shipment_party'] == 4 || $request['orcl_shipment_party'] == 5) {
            $goo_assign_all_price = $goo_assign_all_price * 100;
            $ord_client_res = DB::table('order_client')
                ->where('orcl_id', $orcl_id)
                ->update(['orcl_assign_price' => $goo_assign_all_price, 'orcl_update_time' => date('Y-m-d H:i:s')]);
            if ($ord_client_res || $ord_client_res === 0) {
            } else {
                return ['code'=>500, 'msg'=>'error', 'data'=>'编辑失败'];
            }
        }

        //计算会员消费总金额
        if($ord_data['ord_type'] == 1 && $ord_data['ord_client_id'] > 0){
            WashOrderService::consume_money($ord_data['ord_client_id']);
        }

        // 推送提示信息数据
        $inhi_data['inhi_original_adm_id'] = $user_info->adm_id; //原始单号创建人
        $inhi_data['inhi_original_id'] = $ord_id; //原始单id
        $inhi_data['inhi_original_number'] = $ord_data['ord_order_number']; //原始单号
        $inhi_data['inhi_original_state'] = $ord_data['ord_wor_state'] ?? 0; //原始单状态
        $inhi_data['inhi_original_operation'] = '新订单'; //操作
        $inhi_data['inhi_operation_state'] = 1; //操作状态：1新订单
        $inhi_data['inhi_create_time'] = date('Y-m-d H:i:s'); //操作时间

        // 第三方推送数据
        $inhi_data['modeule_type'] = 1; //模块id；单号类型:1订单2工单3速电网单
        $inhi_data['push_time'] = ''; //推送触发时间,为空则表示立即推送
        $inhi_data['shop_id'] = $user_info->adm_shop_id; //门店系统门店id，有门店id就推送门店下的所有用户，没有门店id就推送用户id
        $inhi_data['target_type'] = 0; //接收端类型0=浏览器;1=移动端
        if (config('apimesssage.WHETHER_OPEN')) {
            // $push = new PushMessageController;
            // $push_return = $push->create($inhi_data);
            // if ($push_return['code'] == 500) {
            //     return ['code'=>500, 'msg'=>'success', 'data'=>'消息推送失败'];
            // }
        }
        // 添加新增订单信息的提示
        addInformationHint($user_info, $inhi_data, 1);

        if ($ord_id && $orgo_res  && $orcl_id && $ord_eidt_res && $client_res) {
            $return_data['ord_id'] = $ord_id; //订单id
            $return_data['ord_order_number'] = $ord_order_number; //订单单号
            $return_data['shop_id'] = $shop_id; //总店id
            $return_data['ord_type'] = $request['ord_type']; //买家类型1.会员零售2.客户单位3.速电派单4.第三方派单
            $return_data['ord_client_id'] = isset($request['ord_client_id']) ? $request['ord_client_id'] : 0; //选择的客户id,会员id/单位id
            $return_data['goods_data'] = $goods_data; //选择的客户id,会员id/单位id
            return ['code'=>200, 'data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'success', 'data'=>'生成订单失败'];
        }
    }

    /**
     * cancelOrderChangeWafgstock 取消商品锁定库存,取消仓库或仓位
     *
     * @param [type] $user_info 用户信息
     * @param [type] $ware_type 仓库类型 类型：1固定仓2技师库3移动仓
     * @param [type] $request   提交信息
     * @param [type] $find_order_goods  查询订单商品数据
     * @param [type] $find_order   查询订单数据
     * @return void
     */
    public static function cancelOrderChangeWafgstock(
        $user_info,
        $ware_type,
        $request,
        $find_order_goods,
        $find_order
    ) {
        // 查询仓位商品锁定表
        $find_wfgl_goods = DB::table('warehouse_freight_goods_lock')
            ->where('wfgl_shop_id', $user_info->adm_shop_id)
            ->where('wfgl_type', 1) //原始单类型：1订单2调拨单
            ->where('wfgl_state', 1)
            ->where('wfgl_original_id', $request['ord_id']) //原始id：订单id/调拨单id
            ->where('wfgl_original_number', $find_order->ord_order_number) //原始单号：订单号/调拨单号
            ->select('wfgl_id', 'wfgl_wafr_id', 'wfgl_wago_id', 'wfgl_wafg_id', 'wfgl_lock_type', 'wfgl_lock_quantity', 'wfgl_ware_id')
            ->get()->toArray();
        $wfgl_id = array_column($find_wfgl_goods, 'wfgl_id');
        $waon_class = collect($find_order_goods)->pluck("orgo_waon_class", "orgo_wago_id")->toarray();
        if (!empty($find_wfgl_goods)) {
            foreach ($find_wfgl_goods as $key => $value) {
                if (empty($value->wfgl_wafr_id)) {
                    continue;
                }
                // 仓位商品id不为空
                $find_wafg_data = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $value->wfgl_wafg_id)
                    ->select('wafg_stock_number', 'wafg_priority_stock_number', 'wafg_lock_quantity', 'wafg_priority_lock_quantity')
                    ->first();
                $find_wago_data = DB::table('warehouse_goods')
                    ->where('wago_id', $value->wfgl_wago_id)
                    ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_freight_stock_number', 'wago_freight_lock_quantity', 'wago_freight_priority_stock_number', 'wago_freight_priority_lock_quantity', 'wago_stock_amount', 'wago_lock_amount', 'wago_priority_stock_amount', 'wago_priority_lock_amount', 'wago_class')
                    ->first();
                $find_waon_data = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $value->wfgl_ware_id)
                    ->where('waon_class', $find_wago_data->wago_class)
                    ->select('waon_all_amount', 'waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                    ->first();
                if (isset($freight_goods_data[$value->wfgl_wago_id][$value->wfgl_lock_type])) {
                    $freight_goods_data[$value->wfgl_wago_id][$value->wfgl_lock_type]['goo_quantity'] += $value->wfgl_lock_quantity;
                } else {
                    $freight_goods_data[$value->wfgl_wago_id][$value->wfgl_lock_type]['goo_quantity'] = $value->wfgl_lock_quantity;
                }

                // 判断良品优先
                if ($value->wfgl_lock_type == 1) {
                    // 总库存数量
                    $waon_edit_data['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + $value->wfgl_lock_quantity;
                    $waon_edit_data['waon_lock_fine_amount'] = $find_waon_data->waon_lock_fine_amount - $value->wfgl_lock_quantity;
                    // 良品库存数量处理,库存数量增加，锁定数量减少
                    $wafg_edit_data['wafg_stock_number'] = $find_wafg_data->wafg_stock_number + $value->wfgl_lock_quantity; //良品库存数量

                    $wafg_edit_data['wafg_lock_quantity'] = $find_wafg_data->wafg_lock_quantity - $value->wfgl_lock_quantity; //良品锁定数量

                    $wago_edit_data['wago_freight_stock_number'] = $find_wago_data->wago_freight_stock_number + $value->wfgl_lock_quantity; //仓位良品库存数量

                    $wago_edit_data['wago_freight_lock_quantity'] = $find_wago_data->wago_freight_lock_quantity - $value->wfgl_lock_quantity; //仓位良品锁定库存数量

                    $wago_edit_data['wago_stock_number'] = $find_wago_data->wago_stock_number + $value->wfgl_lock_quantity; //良品库存数量(仓库+仓位)

                    $wago_edit_data['wago_lock_quantity'] = $find_wago_data->wago_lock_quantity - $value->wfgl_lock_quantity; //良品锁定数量(仓库+仓位)
                    if ($wafg_edit_data['wafg_lock_quantity'] < 0 || $wago_edit_data['wago_freight_lock_quantity'] < 0 || $wago_edit_data['wago_lock_quantity'] < 0) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'锁定数量不足1'];
                    }
                } else {
                    // 总库存数量
                    $waon_edit_data['waon_stock_priority_amount'] = $find_waon_data->waon_stock_priority_amount + $value->wfgl_lock_quantity;
                    $waon_edit_data['waon_lock_priority_amount'] = $find_waon_data->waon_lock_fine_amount - $value->wfgl_lock_quantity;
                    // 优先库存数量处理
                    $wafg_edit_data['wafg_priority_stock_number'] = $find_wafg_data->wafg_priority_stock_number + $value->wfgl_lock_quantity;

                    $wafg_edit_data['wafg_priority_lock_quantity'] = $find_wafg_data->wafg_priority_lock_quantity - $value->wfgl_lock_quantity;

                    $wago_edit_data['wago_freight_priority_stock_number'] = $find_wago_data->wago_freight_priority_stock_number + $value->wfgl_lock_quantity;

                    $wago_edit_data['wago_freight_priority_lock_quantity'] = $find_wago_data->wago_freight_priority_lock_quantity - $value->wfgl_lock_quantity;

                    $wago_edit_data['wago_priority_stock_number'] = $find_wago_data->wago_priority_stock_number + $value->wfgl_lock_quantity; //优先库存数量(仓库+仓位)

                    $wago_edit_data['wago_priority_lock_quantity'] = $find_wago_data->wago_priority_lock_quantity - $value->wfgl_lock_quantity; //优先锁定数量(仓库+仓位)
                }

                $wafg_edit_data['wafg_update_time'] = date('Y-m-d H:i:s');
                // 更新仓位商品表
                $wafg_update_res = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $value->wfgl_wafg_id)
                    ->update($wafg_edit_data);
                // 更新仓位商品表
                $wago_update_res = DB::table('warehouse_goods')
                    ->where('wago_id', $value->wfgl_wago_id)
                    ->update($wago_edit_data);
                // 更新总库存数量
                $waon_update_res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $value->wfgl_ware_id)
                    ->where('waon_class', $find_wago_data->wago_class)
                    ->update($waon_edit_data);
                // 查询仓位总库存数量
                $find_wafr_data = DB::table('warehouse_freight')
                    ->where('wafr_id', $value->wfgl_wafr_id)
                    ->select('wafr_all_stock', 'wafr_priority_all_stock', 'wafr_lock_quantity', 'wafr_priority_lock_quantity')
                    ->first();
                // 判断良品优先1良品2优先
                if ($value->wfgl_lock_type == 1) {
                    // 良品库存数量处理,库存数量增加，锁定数量减少
                    $wafr_edit_data['wafr_all_stock'] = $find_wafr_data->wafr_all_stock + $value->wfgl_lock_quantity;
                    $wafr_edit_data['wafr_lock_quantity'] = $find_wafr_data->wafr_lock_quantity - $value->wfgl_lock_quantity;
                } else {
                    // 优先库存数量处理
                    $wafr_edit_data['wafr_priority_all_stock'] = $find_wafr_data->wafr_priority_all_stock + $value->wfgl_lock_quantity;
                    $wafr_edit_data['wafr_priority_lock_quantity'] = $find_wafr_data->wafr_priority_lock_quantity - $value->wfgl_lock_quantity;
                }
                $wafr_edit_data['wafr_update_time'] = date('Y-m-d H:i:s');
                // 更新仓位库存数量
                $wafr_update_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $value->wfgl_wafr_id)
                    ->update($wafr_edit_data);
                if (!$wafr_update_res || !$wafg_update_res || !$wago_update_res || !$waon_update_res) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'取消订单失败'];
                }
            }
            // warehouse_freight_lock 删除锁定表相关数据
            $wfgl_delete_res = DB::table('warehouse_freight_goods_lock')
                ->whereIn('wfgl_id', $wfgl_id)
                ->delete();
            if (!$wfgl_delete_res) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'取消订单失败'];
            }
        } else {
            $wfgl_delete_res = true;
        }

        // 救援单可能没有商品，没有商品的就不用取消锁定
        if (!empty($find_order_goods)) {
            $find_orgo_wago_id = array_column($find_order_goods, 'orgo_wago_id');
            $neaten_goods_data = []; //整理后的仓库商品库存数据
            foreach ($find_order_goods as $key => $value) {
                // 仓位商品id不为空
                // [仓库商品id][出库类型：良品/优先]，用于判断仓库是否有库存
                if (isset($neaten_goods_data[$value->orgo_wago_id][$value->orgo_goo_inventory])) {
                    $neaten_goods_data[$value->orgo_wago_id][$value->orgo_goo_inventory]['goo_quantity'] += $value->orgo_goo_quantity;
                } else {
                    $neaten_goods_data[$value->orgo_wago_id][$value->orgo_goo_inventory]['goo_quantity'] = $value->orgo_goo_quantity;
                }
                // 仓库类别对应的商品，库存-出入库记录
                if (isset($wago_class_goods[$value->orgo_goo_inventory][$value->orgo_waon_class][$value->orgo_goo_id])) {
                    $wago_class_goods[$value->orgo_goo_inventory][$value->orgo_waon_class][$value->orgo_goo_id]->goo_quantity = $wago_class_goods[$value->orgo_goo_inventory][$value->orgo_waon_class][$value->orgo_goo_id]->orgo_goo_quantity + $value->orgo_goo_quantity;
                } else {
                    $wago_class_goods[$value->orgo_goo_inventory][$value->orgo_waon_class][$value->orgo_goo_id] = $value;
                }
            }

            foreach ($neaten_goods_data as $wago_id => $wago_value) {
                foreach ($wago_value as $goo_inventory => $goo_value) {
                    if (isset($freight_goods_data[$wago_id][$goo_inventory])) {
                        $neaten_goods_data[$wago_id][$goo_inventory]['goo_quantity'] -= $freight_goods_data[$wago_id][$goo_inventory]['goo_quantity'];
                        if (empty($neaten_goods_data[$wago_id][$goo_inventory]['goo_quantity'])) {
                            unset($neaten_goods_data[$wago_id][$goo_inventory]);
                        }
                    }
                }
                if (empty($neaten_goods_data[$wago_id])) {
                    unset($neaten_goods_data[$wago_id]);
                }
            }
            if (!empty($neaten_goods_data)) { //仓库商品库存数量还回
                // 查询仓库库存商品信息
                $find_warehouse_goods = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $find_order->ord_ware_id)
                    ->whereIn('wago_id', $find_orgo_wago_id)
                    ->select('wago_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number', 'wago_lock_quantity', 'wago_priority_lock_quantity', 'wago_lock_amount', 'wago_stock_amount', 'wago_priority_lock_amount', 'wago_priority_stock_amount')
                    ->get()->toArray();
                $warehouse_goods = array_column($find_warehouse_goods, null, 'wago_id');
                foreach ($neaten_goods_data as $wago_id => $wago_value) {
                    foreach ($wago_value as $goo_inventory => $goo_value) {
                        // 良品库存
                        if ($goo_inventory == 1) {
                            // 仓库商品锁定数量减少，正常库存数量增加
                            $surplus_quantity = $warehouse_goods[$wago_id]->wago_lock_quantity - $goo_value['goo_quantity']; //(仓位+仓库)
                            if ($surplus_quantity < 0) {
                                return ['code'=>500, 'msg'=>'error', 'data'=>'商品锁定库存数量不足001'];
                            }
                            // 仓库商品良品锁定数量减少，正常库存数量增加
                            $lock_wago_edit['wago_lock_quantity'] = $surplus_quantity; //良品锁定数量(仓库+仓位)
                            $lock_wago_edit['wago_stock_number'] = $warehouse_goods[$wago_id]->wago_stock_number + $goo_value['goo_quantity']; //良品库存数量(仓库+仓位)

                            // 移动仓库没有仓库库存
                            if ($ware_type == 1) {
                                $surplus_amount = $warehouse_goods[$wago_id]->wago_lock_amount - $goo_value['goo_quantity']; //仓库的
                                if ($surplus_amount < 0) {
                                    return ['code'=>500, 'msg'=>'error', 'data'=>'商品锁定库存数量不足002'];
                                }
                                // 良品总库存数量增加
                                $lock_wago_edit['wago_lock_amount'] = $surplus_amount; //仓库良品锁定库存数量
                                $lock_wago_edit['wago_stock_amount'] = $warehouse_goods[$wago_id]->wago_stock_amount + $goo_value['goo_quantity'];
                            }

                            $stock_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $find_order->ord_ware_id)
                                ->where('waon_class', $warehouse_goods[$wago_id]->wago_class)
                                ->increment('waon_stock_fine_amount', $goo_value['goo_quantity']);
                            // 良品锁定总数量减少
                            $lock_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $find_order->ord_ware_id)
                                ->where('waon_class', $warehouse_goods[$wago_id]->wago_class)
                                ->decrement('waon_lock_fine_amount', $goo_value['goo_quantity']);
                        } else {
                            // 优先库存
                            $surplus_amount = $warehouse_goods[$wago_id]->wago_priority_lock_quantity - $goo_value['goo_quantity']; //(仓库+仓位)
                            if ($surplus_amount < 0) {
                                return ['code'=>500, 'msg'=>'error', 'data'=>'商品锁定库存数量不足2'];
                            }
                            // 固定仓库商品优先锁定数量减少
                            $lock_wago_edit['wago_priority_lock_quantity'] = $surplus_amount; //优先锁定数量(仓库+仓位)
                            $lock_wago_edit['wago_priority_stock_number'] = $warehouse_goods[$wago_id]->wago_priority_stock_number + $goo_value['goo_quantity']; //优先库存数量(仓库+仓位)

                            if ($ware_type == 1) {
                                $surplus_quantity = $warehouse_goods[$wago_id]->wago_priority_lock_amount - $goo_value['goo_quantity']; //仓库优先
                                if ($surplus_quantity < 0) {
                                    return ['code'=>500, 'msg'=>'error', 'data'=>'商品锁定库存数量不足3'];
                                }
                                $lock_wago_edit['wago_priority_lock_amount'] = $surplus_quantity;
                                $lock_wago_edit['wago_priority_stock_amount'] = $warehouse_goods[$wago_id]->wago_priority_stock_amount + $goo_value['goo_quantity'];
                            }

                            // 总库存数量增加
                            $stock_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $find_order->ord_ware_id)
                                ->where('waon_class', $warehouse_goods[$wago_id]->wago_class)
                                ->increment('waon_stock_priority_amount', $goo_value['goo_quantity']);
                            // 锁定总数量减少
                            $lock_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $find_order->ord_ware_id)
                                ->where('waon_class', $warehouse_goods[$wago_id]->wago_class)
                                ->decrement('waon_lock_priority_amount', $goo_value['goo_quantity']);
                        }

                        $lock_wago_edit['wago_update_time'] = date('Y-m-d H:i:s');
                        $lock_edit_res = DB::table('warehouse_goods')
                            ->where('wago_id', $wago_id)
                            ->update($lock_wago_edit);
                        unset($lock_wago_edit);
                        if (!$lock_edit_res || !$stock_res || !$lock_res) {
                            return ['code'=>500, 'msg'=>'error', 'data'=>'编辑订单失败'];
                        }
                    }
                }
            }

            $wagl_res = DB::table('warehouse_goods_lock')
                ->where('wagl_shop_id', $user_info->adm_shop_id)
                ->where('wagl_type', 1)
                ->where('wagl_original_id', $request['ord_id'])
                ->where('wagl_original_number', $find_order->ord_order_number)
                ->delete();
            
            // 遍历仓库类型数据，处理固定仓库对应仓库类型的库存-出入库记录
            if (!empty($wago_class_goods) && $find_order->orcl_shipment_party != 4 && $find_order->orcl_shipment_party != 5) {
                $ware_return_data = self::cancelWarehouseLockRecord(
                    $user_info,
                    $request,
                    $find_order,
                    $wago_class_goods
                );
                if ($ware_return_data['code'] == 500) {
                    DB::rollBack();
                    return response()->json($ware_return_data);
                }
            }
        } else {
            $wagl_res = true;
        }
        if ($wagl_res && $wfgl_delete_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'取消订单成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'取消订单失败'];
        }
    }

    /**
     * info 订单详情
     *
     * @param [type] $user_info 用户信息
     * @param [type] $request   提交信息
     * @return void
     */
    public static function info(
        $user_info,
        $request
    ) {
        $info = DB::table('order as ord')
            ->leftJoin('warehouse as ware', 'ord.ord_ware_id', '=', 'ware.ware_id')
            ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
            ->where('ord_id', $request['ord_id'])
            ->where('ord_shop_id', $user_info->adm_shop_id)
            ->select('ord_id', 'ord_create_id', 'ord_order_number', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_type', 'ord_service_type', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address', 'ord_remark', 'ord_create_time', 'ord_order_price', 'ord_delete', 'ord_collection_price', 'ord_service_shop_id', 'orcl_order_type', 'orcl_consent_state', 'orcl_consent_type', 'orcl_reminder_state', 'ord_order_state', 'orcl_assign_price', 'orcl_shipment_party', 'orcl_rescue_service_price', 'orcl_rescue_collection_price', 'ord_service_sepr_id', 'orcl_client_id', 'orcl_appoint_time', 'orcl_appoint_remark', 'ware_name', 'ware_leader_id', 'ord_other_system_number', 'orcl_shit_id', 'ord_orcl_id', 'orcl_car_vehicle_type', 'ord_client_id', 'orcl_chin_type', 'orcl_rescue_assign_price')
            ->first();
        if (empty($info)) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'当前订单不存在'];
        }
        if ($info->orcl_shipment_party == 4) { //出库方1仓库2直营店3加盟店4虚拟加盟店5下级门店
            // 查询服务门店名称
            $info->ord_service_shop_name = DB::table('virtual_shop')
                ->where('vish_id', $info->ord_service_shop_id)
                ->value('vish_store_name as shop_store_name');
        } else {
            // 查询服务门店名称
            $info->ord_service_shop_name = DB::table('shop')
                ->where('shop_id', $info->ord_service_shop_id)
                ->value('shop_store_name');
        }

        // 账号id
        $adm_id[] = $info->ord_create_id;
        $adm_id[] = $info->ware_leader_id;
        $adm_id = array_filter(array_unique($adm_id));
        // 查询账号id对应姓名
        $adm_name = DB::table('admin')->whereIn('adm_id', $adm_id)->pluck('adm_name', 'adm_id')->toArray();
        if ($info->ord_create_id != '0') {
            $info->create_name = $adm_name[$info->ord_create_id]; //创建人
        }
        $adm_id = explode(',',$info->ware_leader_id);
        $adm_name = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->select('adm_name')
            ->get()->toArray();
        $adm_name = array_column($adm_name, 'adm_name');
        $adm_name =  implode(',', $adm_name);
        $info->ware_leader_name = $adm_name;
        // $info->ware_leader_name = isset($adm_name[$info->ware_leader_id]) ? $adm_name[$info->ware_leader_id] : ''; //仓库负责人

        // ord_type买家类型：1会员零售2客户单位3速电派单4第三方派单5运营中心给门店派单
        // 客户单位名称
        if ($info->ord_type == 2) {
            $info->orcl_channel_unit = DB::table('channel_unit')
                ->where('chun_id', $info->ord_client_id)
                ->value('chun_unit_name');
        } elseif ($info->ord_type == 3) {
            $info->orcl_channel_unit = '速电快保';
        } elseif ($info->ord_type == 5) {
            $info->orcl_channel_unit = DB::table('shop')
                ->where('shop_id', $info->ord_service_shop_id)
                ->value('shop_store_name');
        } else {
            $info->orcl_channel_unit = '';
        }
        unset($info->ord_client_id);

        // 查询服务项目名称
        if ($info->ord_service_sepr_id != '0') {
            $sepr_data = DB::table('service_project')
                ->where('sepr_id', $info->ord_service_sepr_id)
                ->select('sepr_name', 'sepr_order_money')
                ->first();
            $info->ord_service_sepr_name = $sepr_data->sepr_name;
            $info->sepr_order_money = $sepr_data->sepr_order_money;
        }

        // 速电派单,门店没有接单时,客户信息隐藏
        if ($info->ord_wor_state == '7') {
            $info->orcl_name = substituteCharacter($info->orcl_name);
            $info->orcl_phone = substr_replace($info->orcl_phone, '****', 3, 8);
            $info->orcl_city = '***';
            $info->orcl_county = '***';
            $info->orcl_address = '***';
        }

        // 获取该订单下的商品信息
        $goods_data = DB::table('order_goods as orgo')
            ->leftjoin('goods as goo', 'goo.goo_id', '=', 'orgo.orgo_goo_id')
            ->where('orgo_ord_id', $request['ord_id'])
            ->where('orgo_state', '!=', 2)
            ->select('orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_price', 'orgo_is_recycle', 'orgo_can_assign_quantity', 'orgo_collection_price', 'orgo_goo_inventory', 'orgo_state', 'orgo_goo_type', 'orgo_recycle_price', 'orgo_recycle_quantity', 'orgo_tem_goo_name as tem_goo_name', 'orgo_assign_price', 'goo_brse_id', 'goo_bra_name', 'goo_class', 'orgo_wafr_id', 'orgo_id', 'goo_unit', 'orgo_ware_id', 'goo_id')
            ->get()->toArray();
        $goods_datas = array_column($goods_data, null, 'orgo_id');
        // 查询系列数据
        $goo_brse_id = array_column($goods_data, 'goo_brse_id');
        $brse_data = DB::table('brand_serie')
            ->whereIn('brse_id', $goo_brse_id)
            ->pluck('brse_name', 'brse_id')
            ->toArray();
        // 查询仓位数据
        $orgo_wafr_id = array_column($goods_data, 'orgo_wafr_id');
        $wafr_data = DB::table('warehouse_freight')
            ->whereIn('wafr_id', $orgo_wafr_id)
            ->pluck('wafr_name', 'wafr_id')
            ->toArray();
        // 查询订单商品仓位数据
        $orgo_id = array_column($goods_data, 'orgo_id');
        $find_orgf_data = DB::table('order_goods_freight as orgf')
            ->leftjoin('warehouse_freight as wafr', 'wafr.wafr_id', 'orgf.orgf_wafr_id')
            ->where('orgf_shop_id', $user_info->adm_shop_id)
            ->where('orgf_ord_id', $request['ord_id'])
            ->whereIn('orgf_orgo_id', $orgo_id)
            ->where('orgf_order_number', $info->ord_order_number)
            ->where('orgf_delete', 1)
            ->select('orgf_id', 'orgf_ord_id', 'orgf_order_number', 'orgf_orgo_id', 'orgf_wago_id', 'orgf_ware_id', 'orgf_wafr_id', 'orgf_goo_id', 'orgf_goo_quantity', 'orgf_goo_inventory', 'wafr_name')
            ->get()->toArray();
        $new_new_goo_datas = [];
        $wor_id = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->where('wor_delete', 1)
            ->where('wor_state', '!=', 11)
            ->select('wor_id', 'wor_number')
            ->orderBy('wor_id', 'desc')
            ->first();
        $find_rego_data = DB::table('recede_recycle')
            ->where(function ($query) use ($wor_id, $info) {
                if ($wor_id) {
                    $query->where('rec_ord_order_number', $info->ord_order_number)
                        ->orwhere('rec_ord_order_number', $wor_id->wor_number);
                } else {
                    $query->where('rec_ord_order_number', $info->ord_order_number);
                }
            })
            ->where(function ($query) use ($wor_id, $request) {
                if ($wor_id) {
                    $query->where('rec_ord_id', $request['ord_id'])
                        ->orwhere('rec_ord_id', $wor_id->wor_id);
                } else {
                    $query->where('rec_ord_id', $request['ord_id']);
                }
            })
            ->select('rec_id', 'rec_amount', 'rec_source_type')
            ->orderBy('rec_id', 'desc')
            ->first();
        if (!empty($find_rego_data)) {
            $find_rego_data_res = false;
        } else {
            $find_rego_data_res = true;
        }
        if ($find_orgf_data && $find_rego_data_res && $user_info->shop_versions == 2) {
            $new_find_orgf_data = [];
            foreach ($find_orgf_data as $key => $value) {
                $orgf_goods_data = $goods_datas[$value->orgf_orgo_id];
                if (isset($orgf_goods_data)) {
                    // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                    if (!in_array($orgf_goods_data->goo_id, $new_find_orgf_data)) {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                            if (!empty($orgf_goods_data->goo_brse_id)) {
                                if ($orgf_goods_data->goo_class == 2) {
                                    $orgf_goods_data->orgo_goo_name = $brse_data[$orgf_goods_data->goo_brse_id] . ' ' . $orgf_goods_data->orgo_goo_name;
                                } else {
                                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                        $orgf_goods_data->orgo_goo_name = $brse_data[$orgf_goods_data->goo_brse_id] . ' ' . $orgf_goods_data->orgo_goo_name;
                                    }
                                }
                            }
                        }
                        // 显示品牌名称
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                            if ($orgf_goods_data->goo_class == 2) {
                                $orgf_goods_data->orgo_goo_name = $orgf_goods_data->goo_bra_name . ' ' . $orgf_goods_data->orgo_goo_name;
                            } else {
                                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                    $orgf_goods_data->orgo_goo_name = $orgf_goods_data->goo_bra_name . ' ' . $orgf_goods_data->orgo_goo_name;
                                }
                            }
                        }
                        $new_find_orgf_data[] = $orgf_goods_data->goo_id;
                    }
                    $new_goo_data['orgo_goo_name'] = $orgf_goods_data->orgo_goo_name; //商品名称
                    $new_goo_data['orgo_goo_goods_encode'] = $orgf_goods_data->orgo_goo_goods_encode; //检索编码
                    $new_goo_data['orgo_goo_price'] = $orgf_goods_data->orgo_goo_price; //商品售价（单位：分）
                    $new_goo_data['orgo_goo_quantity'] = $value->orgf_goo_quantity; //商品数量
                    $new_goo_data['orgo_collection_price'] = $orgf_goods_data->orgo_collection_price; //代收金额（单位：分）
                    $new_goo_data['orgo_goo_inventory'] = $orgf_goods_data->orgo_goo_inventory; //库存扣除方式1.良品 2.优先
                    $new_goo_data['orgo_wafr_name'] = $value->wafr_name; //仓位
                    $new_goo_data['orgo_is_recycle'] = $orgf_goods_data->orgo_is_recycle; //回收状态：1回收2不回收
                    $new_goo_data['orgo_can_assign_quantity'] = $orgf_goods_data->orgo_can_assign_quantity; //剩余可以派工单的商品数量
                    $new_goo_data['orgo_state'] = $orgf_goods_data->orgo_state; //商品状态1.正常 2.删除3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
                    $new_goo_data['orgo_recycle_price'] = $orgf_goods_data->orgo_recycle_price; //回收金额（单位：分）
                    $new_goo_data['orgo_recycle_quantity'] = $orgf_goods_data->orgo_recycle_quantity; //商品回收数量
                    $new_goo_data['tem_goo_name'] = $orgf_goods_data->tem_goo_name; //临时商品名称
                    $new_goo_data['orgo_assign_price'] = $orgf_goods_data->orgo_assign_price; //派单金额
                    $new_goo_data['goo_unit'] = $orgf_goods_data->goo_unit; //单位
                    $new_goo_data['orgo_freight_space'] = DB::table('warehouse')
                        ->where('ware_id', $orgf_goods_data->orgo_ware_id)
                        ->value('ware_freight_space'); //仓库编码
                    $new_new_goo_datas[] = $new_goo_data;
                    unset($new_goo_data);
                    unset($orgf_goods_data->goo_brse_id);
                }
            }
        } else {
            foreach ($goods_data as $key => $value) {
                // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                    if (!empty($value->goo_brse_id)) {
                        if ($value->goo_class == 2) {
                            $goods_data[$key]->orgo_goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->orgo_goo_name;
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $goods_data[$key]->orgo_goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->orgo_goo_name;
                            }
                        }
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if ($value->goo_class == 2) {
                        $goods_data[$key]->orgo_goo_name = $value->goo_bra_name . ' ' . $value->orgo_goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $goods_data[$key]->orgo_goo_name = $value->goo_bra_name . ' ' . $value->orgo_goo_name;
                        }
                    }
                }
                if (!empty($value->orgo_wafr_id)) {
                    $goods_data[$key]->orgo_wafr_name = $wafr_data[$value->orgo_wafr_id];
                } else {
                    $goods_data[$key]->orgo_wafr_name = '';
                }
                unset($goods_data[$key]->goo_class);
                unset($goods_data[$key]->orgo_wafr_id);
                unset($goods_data[$key]->orgo_wafr_id);
            }
            $new_new_goo_datas = $goods_data;
        }
        $data['order_data'] = $info;
        $data['goods_data'] = $new_new_goo_datas;
        // 如果是虚拟加盟店
        if ($info->orcl_shipment_party == 4) {
            // 获取上传图片
            $find_image_upload = DB::table('image_upload')
                ->where('imup_ord_id', $request['ord_id'])
                ->where('imup_delete', 1)
                ->select('imup_path', 'imup_image_name')
                ->get()->toArray();
            if (empty($find_image_upload)) {
                $shit_template_set = DB::table('shop_image_template')
                    ->where('shit_id', $info->orcl_shit_id)
                    ->select('shit_template_set')
                    ->first();
                $shit_template_set = json_decode($shit_template_set->shit_template_set, true);
                foreach ($shit_template_set as $key => $value) {
                    $find_image_upload[$key]['imup_path'] = '';
                    $find_image_upload[$key]['imup_image_name'] = $value['show_word'];
                }
            }
            $data['image_upload'] = $find_image_upload;
        }
        // 查询备注信息
        $ord_reamrks = DB::table('order_remarks')
            ->where('orre_ord_id', $request['ord_id'])
            ->select('orre_create_adm_name', 'orre_content', 'orre_time', 'orre_module')
            ->orderby('orre_id', 'desc')
            ->get()->toArray();
        $data['ord_reamrks'] = $ord_reamrks;
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    /**
     * cancel 取消订单
     *
     * @param [type] $user_info     用户信息
     * @param [type] $request       提交信息
     * @param [type] $find_order    订单信息
     * @param [type] $type          1、小程序2、PC端
     * @return void
     */
    public static function cancel(
        $user_info,
        $request,
        $find_order,
        $type
    ) {
        $now_time = date('Y-m-d H:i:s');

        // 如果是退货单，删除退货入库单相关数据
        if ($find_order->ord_service_type == 4) {
            $find_recycle = DB::table('recede_recycle')
                ->where('rec_source_type', 8) //来源类型8(订单号)退货单
                ->where('rec_ord_id', $request['ord_id']) //回收状态 1.未回收 2.已回收
                ->select('rec_id', 'rec_state')
                ->first();
            if ($find_recycle->rec_state != 1) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'当前订单的退货入库单已入库！'];
            }
            $del_rec_res = DB::table('recede_recycle')
                ->where('rec_id', $find_recycle->rec_id)
                ->delete();
            $del_recl_res = DB::table('recede_client')
                ->where('recl_rec_id', $find_recycle->rec_id)
                ->delete();
            $del_rego_res = DB::table('recede_goods')
                ->where('rego_rec_id', $find_recycle->rec_id)
                ->delete();
            if (!$del_rec_res || !$del_recl_res || !$del_rego_res) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'取消订单失败01！'];
            }
        }
        // 查询仓库id是否为移动仓库，移动仓库没有锁定库存
        // ware_type 类型：1固定仓2技师库3移动仓
        $ware_type = DB::table('warehouse')
            ->where('ware_id', $find_order->ord_ware_id)
            ->value('ware_type');
        // // 不是虚拟加盟店、退货单的情况，需要取消锁定库存
        // if ($find_order->orcl_shipment_party != 4 && $find_order->ord_service_type != 4 && $ware_type != 2 && $find_order->orcl_shipment_party != 5) {
        //     // 查询订单商品信息
        //     $find_order_goods = DB::table('order_goods')
        //         ->where('orgo_ord_id', $request['ord_id'])
        //         ->whereNotIn('orgo_state', [2, 3, 4])
        //         // ->select('orgo_ware_id', 'orgo_waon_class', 'orgo_wago_id', 'orgo_goo_id', 'orgo_goo_quantity', 'orgo_goo_inventory', 'orgo_wafr_id', 'orgo_wafg_id')
        //         ->select('orgo_ware_id', 'orgo_waon_class', 'orgo_wago_id', 'orgo_goo_id', 'orgo_goo_quantity', 'orgo_goo_inventory', 'orgo_wafr_id', 'orgo_wafg_id')
        //         ->get()->toArray();
        //     // // 取消仓库库存锁定
        //     // $order_cawast_res = Order::cancelOrderChangeWafgstock(
        //     //     $user_info,
        //     //     $ware_type,
        //     //     $request,
        //     //     $find_order_goods,
        //     //     $find_order
        //     // );

        //     // 记录日志
        //     $log_data['user_info'] = $user_info;
        //     $log_data['ware_type'] = $ware_type;
        //     $log_data['request'] = $request;
        //     $log_data['order_goods'] = $find_order_goods;
        //     $log_data['order'] = $find_order;
        //     $log_data['order_cawast_res'] = $order_cawast_res;
        //     if ($type == 1) {
        //         Common::write_record_log($log_data, 'WechatApplet/order_log.txt', 'cancel-cancelOrderChangeWafgstock');
        //     } else {
        //         Common::write_record_log($log_data, 'pc/order_log.txt', 'cancel-cancelOrderChangeWafgstock');
        //     }

        //     if (!$order_cawast_res) {
        //         return ['code'=>500, 'msg'=>'error', 'data'=>'取消订单失败02！'];
        //     } else {
        //         $wagl_res = true;
        //     }
        // } else {
        //     $wagl_res = true;
        // }
        $ord_data['ord_delete'] = 2; //是否删除：1正常订单2取消订单
        $ord_data['ord_wor_state'] = 11; //订单的工单状态1未派工单2服务中3售后中4已完成5无工单6审核活动7待接单8锁定9速电撤销回收10终止11取消订单
        $ord_data['ord_update_time'] = $now_time;
        $ord_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update($ord_data);

        // 更新订单商品表时间
        $edit_orgo_data['orgo_update_time'] = $now_time;
        if (!empty($orgo_id)) {
            $edit_orgo_res = DB::table('order_goods')
                ->where('orgo_ord_id', $request['ord_id'])
                ->update($edit_orgo_data);
        } else {
            $edit_orgo_res = true;
        }

        if ($ord_res && $edit_orgo_res && $wagl_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'取消订单成功！'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'取消订单失败03！'];
        }
    }

    // 作废易损件
    public static function cancelOrder(
        $user_info,
        $request,
        $find_order
    ) {
        $now_time = date('Y-m-d H:i:s');

        // 作废发货单
        $digo_update_res = DB::table('dispatch_bill')
            ->where('dego_original_number', $request['ord_order_number'])
            ->where('dego_wor_id', $request['ord_id'])
            ->where('dego_order_type', 4)
            ->where('dego_shop_id', $user_info->adm_shop_id)
            ->update(['dego_type'=>4, 'dego_update_time'=>date('Y-m-d H:i:s')]);
        // 删除应收及结款明细
        $del_rece_data = DB::table('receivable_credit')
            ->where('recr_shop_id', $user_info->adm_shop_id)
            ->where('recr_original_id', $request['ord_id'])
            ->where('recr_original_number', $request['ord_order_number'])
            ->delete();

        // 查询仓库id是否为移动仓库，移动仓库没有锁定库存
        // ware_type 类型：1固定仓2技师库3移动仓
        $ware_type = DB::table('warehouse')
            ->where('ware_id', $find_order->ord_ware_id)
            ->value('ware_type');

        // 不是虚拟加盟店、退货单的情况，需要取消锁定库存
        if ($ware_type != 2) {
            // 查询订单商品信息
            $find_order_goods = DB::table('order_goods')
                ->where('orgo_ord_id', $request['ord_id'])
                ->whereNotIn('orgo_state', [2, 3, 4])
                ->select('orgo_ware_id', 'orgo_waon_class', 'orgo_wago_id', 'orgo_goo_id', 'orgo_goo_quantity', 'orgo_goo_inventory', 'orgo_wafr_id', 'orgo_wafg_id')
                ->get()->toArray();
            // 取消仓库库存锁定
            $order_cawast_res = Order::cancelOrderChangeWafgstock(
                $user_info,
                $ware_type,
                $request,
                $find_order_goods,
                $find_order
            );

            // 记录日志
            $log_data['user_info'] = $user_info;
            $log_data['ware_type'] = $ware_type;
            $log_data['request'] = $request->all();
            $log_data['order_goods'] = $find_order_goods;
            $log_data['order'] = $find_order;
            $log_data['order_cawast_res'] = $order_cawast_res;

            Common::write_record_log($log_data, 'pc/order_log.txt', 'cancelOrder-cancelOrderChangeWafgstock');

            if (!$order_cawast_res) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'作废订单失败02！'];
            } else {
                $wagl_res = true;
            }
        } else {
            $wagl_res = true;
        }
        
        $ord_data['ord_delete'] = 2; //是否删除：1正常订单2取消订单
        $ord_data['ord_wor_state'] = 19; //订单的工单状态1未派工单2服务中3售后中4已完成5无工单6审核活动7待接单8锁定9速电撤销回收10终止11取消订单
        $ord_data['ord_update_time'] = $now_time;
        $ord_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update($ord_data);

        // 选择的客户id，对应的订单退换次数增加
        if ($find_order->ord_client_id) {
            if ($find_order->ord_type == 1) {
                $client_res = DB::table('member')
                    ->where('mem_id', $find_order->ord_client_id)
                    ->increment('mem_retreat_trade');
                // 会员列表订单总量减少
                $mem_id = DB::table('member')
                    ->where('mem_id', $find_order->ord_client_id)
                    ->decrement('mem_order_all');
            } else {
                $client_res = true;
                $mem_id = true;
            }
        } else {
            $client_res = true;
            $mem_id = true;
        }

        // 更新订单商品表时间
        $edit_orgo_data['orgo_update_time'] = $now_time;
        if (!empty($orgo_id)) {
            $edit_orgo_res = DB::table('order_goods')
                ->where('orgo_ord_id', $request['ord_id'])
                ->update($edit_orgo_data);
        } else {
            $edit_orgo_res = true;
        }

        if ($ord_res && $edit_orgo_res && $client_res && $mem_id && $wagl_res && $digo_update_res && $del_rece_data) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'作废订单成功！'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'作废订单失败03！'];
        }
    }

    /**
     * isExceed 订单审核
     *
     * @param [type] $user_info     用户信息
     * @param [type] $request       提交信息
     * @param [type] $find_order    订单信息
     * @param [type] $type          1、小程序2、PC端
     * @return void
     */
    public static function isExceed(
        $user_info,
        $request,
        $find_ord_data
    ) {
        $ord_edit_data['ord_order_state'] = 1;
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        if ($find_ord_data->ord_service_type == 5) {
            $ord_edit_data['ord_wor_state'] = 5;
        } else {
            $ord_edit_data['ord_wor_state'] = 1;
        }
        $ord_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update($ord_edit_data);

        // 生成操作记录
        orderLog($user_info, $request['ord_id'], 0, '审核通过订单');

        if ($ord_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'审核成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'审核失败！'];
        }
    }

    /**
     * warehouseLockRecord 仓库商品锁定库存-出入库记录
     *
     * @param [array] $user_info  用户信息
     * @param [array] $request    提交信息
     * @param [array] $order_data 订单信息
     * @param [array] $wago_class_goods 库存锁定-出入库数据
     * @return void
     */
    public static function cancelWarehouseLockRecord(
        $user_info,
        $request,
        $find_order,
        $wago_class_goods,
        $type = 1
    ) {
        $osld_out_key = 0;
        $wago_class_goods = json_decode(json_encode($wago_class_goods), true);
        foreach ($wago_class_goods as $goo_inventory => $new_class_goods_data) {
            foreach ($new_class_goods_data as $waon_class_key => $class_goods_data) {
                $goo_all_amount = 0;
                foreach ($class_goods_data as $goo_id_key => $value) {
                    $goo_all_amount += $value['orgo_goo_quantity']; //出库总数量
                    // 库存锁定-出库记录表
                    $osld_out_goo_data[$osld_out_key]['goo_waon_class'] = $waon_class_key; //仓库类别：1货物仓2非货物仓3旧货仓4临时仓
                    $osld_out_goo_data[$osld_out_key]['goo_id'] = $value['orgo_goo_id']; //商品id
                    $osld_out_goo_data[$osld_out_key]['goo_number'] = $value['orgo_goo_quantity']; //商品数量
                    $osld_out_goo_data[$osld_out_key]['goo_out_in_type'] = 4; //出入库类型：1出库2入库3锁定4取消锁定
                    $osld_out_goo_data[$osld_out_key]['goo_inventory'] = $value['orgo_goo_inventory']; //类型1良品2优先3待检测
                    // 查询仓库商品库存数量
                    $find_wago_data = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $find_order->ord_ware_id)
                        ->where('wago_class', $waon_class_key)
                        ->where('wago_goo_id', $value['orgo_goo_id'])
                        ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
                        ->first();
                    if ($value['orgo_goo_inventory'] == 1) { //良品
                        $osld_out_goo_data[$osld_out_key]['old_stock_number'] = $find_wago_data->wago_stock_number - $value['orgo_goo_quantity']; //旧的商品良品库存数量
                        $osld_out_goo_data[$osld_out_key]['old_stock_lock_number'] = $find_wago_data->wago_lock_quantity + $value['orgo_goo_quantity']; //旧的商品良品库存锁定数量
                        $osld_out_goo_data[$osld_out_key]['old_priority_number'] = $find_wago_data->wago_priority_stock_number; //旧的商品优先库存数量
                        $osld_out_goo_data[$osld_out_key]['old_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //旧的商品优先库存锁定数量
                        $osld_out_goo_data[$osld_out_key]['new_stock_number'] = $find_wago_data->wago_stock_number; //新的商品良品库存数量
                        $osld_out_goo_data[$osld_out_key]['new_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //新的商品良品库存锁定数量
                        $osld_out_goo_data[$osld_out_key]['new_priority_number'] = $find_wago_data->wago_priority_stock_number; //新的商品优先库存数量
                        $osld_out_goo_data[$osld_out_key]['new_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //新的商品优先库存锁定数量
                    } else { //优先
                        $osld_out_goo_data[$osld_out_key]['old_stock_number'] = $find_wago_data->wago_stock_number; //旧的商品良品库存数量
                        $osld_out_goo_data[$osld_out_key]['old_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //旧的商品良品库存锁定数量
                        $osld_out_goo_data[$osld_out_key]['old_priority_number'] = $find_wago_data->wago_priority_stock_number - $value['orgo_goo_quantity']; //旧的商品优先库存数量
                        $osld_out_goo_data[$osld_out_key]['old_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity + $value['orgo_goo_quantity']; //旧的商品优先库存锁定数量
                        $osld_out_goo_data[$osld_out_key]['new_stock_number'] = $find_wago_data->wago_stock_number; //新的商品良品库存数量
                        $osld_out_goo_data[$osld_out_key]['new_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //新的商品良品库存锁定数量
                        $osld_out_goo_data[$osld_out_key]['new_priority_number'] = $find_wago_data->wago_priority_stock_number; //新的商品优先库存数量
                        $osld_out_goo_data[$osld_out_key]['new_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //新的商品优先库存锁定数量
                    }
                    $osld_out_goo_data[$osld_out_key]['old_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //旧的商品待检测库存数量
                    $osld_out_goo_data[$osld_out_key]['new_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //新的商品待检测库存数量
                    $osld_out_goo_data[$osld_out_key]['osld_update_time'] = date('Y-m-d H:i:s'); //更新时间
                    $osld_out_goo_data[$osld_out_key] = (object)$osld_out_goo_data[$osld_out_key];
                    $osld_out_key++;
                }
                $find_out_ware = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $find_order->ord_ware_id)
                    ->where('waon_class', $waon_class_key)
                    ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                    ->first();
                if ($type == 1) {
                    $type_state = 1;
                } else {
                    $type_state = 2;
                }
                // 库存锁定-出入库记录
                $oslr_out_res = OutinStockLock::addition(
                    $user_info, //用户信息
                    $request['ord_id'], //原始单的关联id
                    $find_order->ord_order_number, //原始单的关联单号
                    $type_state, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                    $find_order->ord_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    $find_order->ord_client_id, //选择的客户id,会员id/单位id
                    $find_order->ord_order_number, //原始单号
                    $find_order->ord_ware_id, //出库/入库的仓库id
                    $goo_all_amount, //出库/入库总数量
                    2, //类型：1锁定库存2取消锁定3调拨单4旧货回收单5退换回收单6订单出库7部分入库8部分出库9发货单10移动仓出库11换货出库12换货入库13退货入库14退货出库15盘库单
                    $find_out_ware->waon_stock_fine_amount, //良品总库存
                    $find_out_ware->waon_lock_fine_amount, //良品锁定数量
                    $find_out_ware->waon_stock_priority_amount, //优先总库存
                    $find_out_ware->waon_lock_priority_amount, //优先锁定数量
                    $find_out_ware->waon_stock_unchecked_amount, //待检测总库存
                    1, //出入库类型：1出库，2入库
                    $osld_out_goo_data
                );
                unset($osld_out_goo_data);
                if (!$oslr_out_res) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'取消失败L'];
                }
            }
        }
    }
}
