<?php
namespace App\Http\Models\Services\DataStatistical;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

// 财务系统 -- 销售统计
class DataStatistical extends Model
{
    /**
     * [searchIndex 查询销售统计公共方法]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $search_data  [搜索信息]
     * @return [type]               [description]
     */
    public function searchIndex($user_info, $search_data)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info['shop_superior_id'] ? $user_info['shop_superior_id'] : $user_info['adm_shop_id'];

        $find_dast_data = DB::table('data_statistical as dast')
            ->leftjoin('goods as goo', 'goo.goo_id', '=', 'dast.dast_goo_id')
            ->leftjoin('warehouse as ware', 'ware.ware_id', '=', 'dast.dast_ware_id')
            ->where('dast_cid', $user_info['adm_cid'])
            ->where('dast_superior_shop_id', $shop_id)
            ->where('dast_order_type', '!=', 3)
            ->where('dast_ord_delete', 1)
            ->where(function ($query) use ($search_data) { //客户单位
                if (!empty($search_data['dast_type'])) {
                    $query->where('dast_type', $search_data['dast_type']);
                } else {
                    if (!empty($search_data['dast_client_id'])) {
                        $query->where('dast_type', 2);
                    }
                }
                if (!empty($search_data['dast_client_id'])) {
                    $query->where('dast_client_id', $search_data['dast_client_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //商品品牌id
                if (!empty($search_data['goo_bra_id'])) {
                    $query->where('goo_bra_id', $search_data['goo_bra_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //商品品类id
                if (!empty($search_data['goo_cate_id'])) {
                    $query->where('goo_cate_id', $search_data['goo_cate_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //检索编码
                if (!empty($search_data['goo_goods_encode'])) {
                    $query->where('goo_goods_encode', $search_data['goo_goods_encode']);
                }
            })
            ->where(function ($query) use ($search_data) { //仓库类型：1固定仓2技师库3移动仓
                if (!empty($search_data['ware_type'])) {
                    $query->where('ware_type', $search_data['ware_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //仓库id
                if (!empty($search_data['dast_ware_id'])) {
                    $query->where('dast_ware_id', $search_data['dast_ware_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //买家类型
                if (!empty($search_data['dast_type'])) {
                    $query->where('dast_type', $search_data['dast_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //客户类型id
                if (!empty($search_data['chun_chty_id'])) {
                    $query->where('dast_chty_id', $search_data['chun_chty_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单 7救援单
                if (!empty($search_data['dast_service_type'])) {
                    $query->where('dast_service_type', $search_data['dast_service_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //业务员id
                if (!empty($search_data['dast_adm_id'])) {
                    $query->where('dast_adm_id', $search_data['dast_adm_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //开单员id
                if (!empty($search_data['dast_create_id'])) {
                    $query->where('dast_create_id', $search_data['dast_create_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //出库方1仓库2直营店3加盟店4虚拟加盟店
                if (!empty($search_data['dast_orcl_shipment_party'])) {
                    $query->where('dast_orcl_shipment_party', $search_data['dast_orcl_shipment_party']);
                }
            })
            ->where(function ($query) use ($search_data) { //订单单号
                if (!empty($search_data['dast_order_number'])) {
                    $query->where('dast_order_number', $search_data['dast_order_number']);
                }
            })
            ->where(function ($query) use ($search_data) { //铺货类型1是铺货2不是铺货
                if (!empty($search_data['dast_orcl_chin_type'])) {
                    $query->where('dast_orcl_chin_type', $search_data['dast_orcl_chin_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //日期范围
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['creatData'])) {
                    $search_data['creatData'][1] = date("Y-m-d", strtotime($search_data['creatData'][1] . " +1 day"));
                    $query->whereBetween('dast_create_time', $search_data['creatData']);
                }
            })
            ->where(function ($query) use ($search_data) { //服务项目
                if (!empty($search_data['dast_service_sepr_id'])) {
                    $query->where('dast_service_sepr_id', $search_data['dast_service_sepr_id']);
                }
            });
        return $find_dast_data;
    }

    /**
     * [searchRealIndex 查询实时数据公共方法]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $search_data  [搜索信息]
     * @return [type]               [description]
     */
    public function searchRealIndex($user_info, $search_data)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info['shop_superior_id'] ? $user_info['shop_superior_id'] : $user_info['adm_shop_id'];

        $find_ord_data = DB::table("order as ord")
            ->leftJoin('order_goods as orgo', 'orgo.orgo_ord_id', '=', 'ord.ord_id')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'orgo.orgo_goo_id')
            ->leftJoin('channel_unit as chun', 'chun.chun_id', '=', 'ord.ord_client_id')
            ->leftJoin('warehouse as ware', 'ware.ware_id', '=', 'orgo.orgo_ware_id')
            ->where("ord_cid", $user_info['adm_cid'])
            ->where('ord_shop_id', $shop_id)
            ->where("ord_collection_bill", '1')
            ->where("orgo_state", "!=", '3')
            ->where("orgo_state", "!=", '2')
            ->where("ord_delete", '1')
            ->where(function ($query) use ($search_data) { //客户单位
                if (!empty($search_data['dast_type'])) {
                    $query->where('ord_type', $search_data['dast_type']);
                } else {
                    if (!empty($search_data['dast_client_id'])) {
                        $query->where('ord_type', 2);
                    }
                }
                if (!empty($search_data['dast_client_id'])) {
                    $query->where('ord_client_id', $search_data['dast_client_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //商品品牌id
                if (!empty($search_data['goo_bra_id'])) {
                    $query->where('goo_bra_id', $search_data['goo_bra_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //商品品类id
                if (!empty($search_data['goo_cate_id'])) {
                    $query->where('goo_cate_id', $search_data['goo_cate_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //检索编码
                if (!empty($search_data['goo_goods_encode'])) {
                    $query->where('goo_goods_encode', $search_data['goo_goods_encode']);
                }
            })
            ->where(function ($query) use ($search_data) { //仓库类型：1固定仓2技师库3移动仓
                if (!empty($search_data['ware_type'])) {
                    $query->where('ware_type', $search_data['ware_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //仓库id
                if (!empty($search_data['dast_ware_id'])) {
                    $query->where('ord_ware_id', $search_data['dast_ware_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //买家类型
                if (!empty($search_data['dast_type'])) {
                    $query->where('ord_type', $search_data['dast_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单 7救援单
                if (!empty($search_data['dast_service_type'])) {
                    $query->where('ord_service_type', $search_data['dast_service_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //业务员id
                if (!empty($search_data['dast_adm_id'])) {
                    $query->where('chun_adm_id', $search_data['dast_adm_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //开单员id
                if (!empty($search_data['dast_create_id'])) {
                    $query->where('ord_create_id', $search_data['dast_create_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //出库方1仓库2直营店3加盟店4虚拟加盟店
                if (!empty($search_data['dast_orcl_shipment_party'])) {
                    $query->where('orcl_shipment_party', $search_data['dast_orcl_shipment_party']);
                }
            })
            ->where(function ($query) use ($search_data) { //订单单号
                if (!empty($search_data['dast_order_number'])) {
                    $query->where('ord_order_number', $search_data['dast_order_number']);
                }
            })
            ->where(function ($query) use ($search_data) { //日期范围
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['creatData'])) {
                    $search_data['creatData'][1] = date("Y-m-d", strtotime($search_data['creatData'][1] . " +1 day"));
                    $query->whereBetween('ord_create_time', $search_data['creatData']);
                }
            });
        return $find_ord_data;
    }

    /**
     * [searchRealIndexs 查询实时数据头部合计公共方法]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $search_data  [搜索信息]
     * @return [type]               [description]
     */
    public function searchRealIndexs($user_info, $search_data)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info['shop_superior_id'] ? $user_info['shop_superior_id'] : $user_info['adm_shop_id'];

        $find_ord_datas = DB::table("order as ord")
            ->leftJoin('order_goods as orgo', 'orgo.orgo_ord_id', '=', 'ord.ord_id')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'orgo.orgo_goo_id')
            ->leftJoin('channel_unit as chun', 'chun.chun_id', '=', 'ord.ord_client_id')
            ->leftJoin('warehouse as ware', 'ware.ware_id', '=', 'orgo.orgo_ware_id')
            ->where("ord_cid", $user_info['adm_cid'])
            ->where('ord_shop_id', $shop_id)
            ->where("ord_collection_bill", '1')
            ->where("orgo_state", "!=", '3')
            ->where("orgo_state", "!=", '2')
            ->where("ord_delete", '1')
            ->where(function ($query) use ($search_data) { //客户单位
                if (!empty($search_data['dast_type'])) {
                    $query->where('ord_type', $search_data['dast_type']);
                } else {
                    if (!empty($search_data['dast_client_id'])) {
                        $query->where('ord_type', 2);
                    }
                }
                if (!empty($search_data['dast_client_id'])) {
                    $query->where('ord_client_id', $search_data['dast_client_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //商品品牌id
                if (!empty($search_data['goo_bra_id'])) {
                    $query->where('goo_bra_id', $search_data['goo_bra_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //商品品类id
                if (!empty($search_data['goo_cate_id'])) {
                    $query->where('goo_cate_id', $search_data['goo_cate_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //检索编码
                if (!empty($search_data['goo_goods_encode'])) {
                    $query->where('goo_goods_encode', $search_data['goo_goods_encode']);
                }
            })
            ->where(function ($query) use ($search_data) { //仓库类型：1固定仓2技师库3移动仓
                if (!empty($search_data['ware_type'])) {
                    $query->where('ware_type', $search_data['ware_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //仓库id
                if (!empty($search_data['dast_ware_id'])) {
                    $query->where('ord_ware_id', $search_data['dast_ware_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //买家类型
                if (!empty($search_data['dast_type'])) {
                    $query->where('ord_type', $search_data['dast_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单 7救援单
                if (!empty($search_data['dast_service_type'])) {
                    $query->where('ord_service_type', $search_data['dast_service_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //业务员id
                if (!empty($search_data['dast_adm_id'])) {
                    $query->where('chun_adm_id', $search_data['dast_adm_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //开单员id
                if (!empty($search_data['dast_create_id'])) {
                    $query->where('ord_create_id', $search_data['dast_create_id']);
                }
            })
            ->where(function ($query) use ($search_data) { //出库方1仓库2直营店3加盟店4虚拟加盟店
                if (!empty($search_data['dast_orcl_shipment_party'])) {
                    $query->where('orcl_shipment_party', $search_data['dast_orcl_shipment_party']);
                }
            })
            ->where(function ($query) use ($search_data) { //订单单号
                if (!empty($search_data['dast_order_number'])) {
                    $query->where('ord_order_number', $search_data['dast_order_number']);
                }
            })
            ->where(function ($query) use ($search_data) { //日期范围
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['creatData'])) {
                    $search_data['creatData'][1] = date("Y-m-d", strtotime($search_data['creatData'][1] . " +1 day"));
                    $query->whereBetween('ord_create_time', $search_data['creatData']);
                }
            });
        return $find_ord_datas;
    }

    /**
     * [goodsIndex 查询销售统计信息]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $search_data  [搜索信息]
     * @param  [type] $show_count   [每页条数]
     * @param  [type] $select_field [查询字段，字符串多个字段用,分开]
     * @return [type]               [description]
     */
    public function goodsIndex($user_info, $search_data, $show_count, $select_field, $count_select_field = '', $type = 1)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info['shop_superior_id'] ? $user_info['shop_superior_id'] : $user_info['adm_shop_id'];

        $find_dast_data = $this->searchIndex($user_info, $search_data);
        if ($search_data['searchtype'] == '1') { //查询品牌
            $list = $find_dast_data->where('dast_goo_id', '>', 0)
                ->where('dast_service_project_type', 1)
                ->select(DB::raw($select_field))
                ->groupBy('goo_bra_id', 'dast_order_type')
                ->get()->toArray();
            $list = $this->objectToArray($list);
            return $list;
        } elseif ($search_data['searchtype'] == '2') { //销售明细
            $find_dast_data = $find_dast_data->leftJoin('channel_unit as chun', 'chun.chun_id', '=', 'dast.dast_client_id')
                ->where('dast_service_project_type', 1)
                ->select(DB::raw($select_field))
                ->orderBy('dast_create_time', 'desc');
            if ($type == 1) {
                $find_dast_data = $find_dast_data->paginate($show_count);
                $list_items = $find_dast_data->items();
            } else {
                $list_items = $find_dast_data->get()->toArray();
            }
            if ($list_items) {
                $ord_id = array_column($list_items, 'dast_ord_id'); //订单id
                // 查询备注信息
                $order_reamrks = DB::table('order_remarks')
                    ->whereIn('orre_ord_id', $ord_id)
                    ->select('orre_create_adm_name', 'orre_content', 'orre_time', 'orre_ord_id', 'orre_module')
                    ->orderby('orre_id', 'desc')
                    ->get()->toArray();
                if ($order_reamrks) {
                    $order_reamrks = $this->objectToArray($order_reamrks);
                    $order_reamrk = [];
                    foreach ($order_reamrks as $k => $v) {
                        $order_reamrk[$v['orre_ord_id']][] = $v;
                    }
                }
                $chun_chty_id = [];
                $system_goo_id = []; //系统商品id
                foreach ($list_items as $key => $value) {
                    if ($value->chun_chty_id > 0) {
                        $chun_chty_id[] = $value->chun_chty_id;
                    }
                    if ($value->goo_class == 2) {
                        $system_goo_id[] = $value->goo_id;
                    }
                }

                $channel_type = [];
                if ($chun_chty_id) {
                    $channel_type = DB::table('channel_type')
                        ->whereIn("chty_id", $chun_chty_id)
                        ->pluck('chty_name', 'chty_id');
                }
                $system_goo_price = []; //系统商品金额
                if ($system_goo_id) {
                    $system_goo_price = DB::table('goods_system_affiliate')
                        ->where('gosa_shop_id', $user_info['adm_shop_id'])
                        ->whereIn('gosa_goo_id', $system_goo_id)
                        ->pluck('gosa_direct_accounting_price', 'gosa_goo_id')
                        ->toArray();
                }
                $list_items = $this->objectToArray($list_items);
                // 查询系列数据
                $goo_brse_id = array_column($list_items, 'goo_brse_id');
                $brse_data = DB::table('brand_serie')
                    ->whereIn('brse_id', $goo_brse_id)
                    ->pluck('brse_name', 'brse_id')
                    ->toArray();
                foreach ($list_items as $key => $value) {
                    $list_items[$key]['order_reamrks'] = $order_reamrk[$value['dast_ord_id']] ?? [];
                    if ($channel_type) {
                        $list_items[$key]['type_name'] = $channel_type[$value['chun_chty_id']] ?? '未定义' . $value['chun_chty_id'];
                    }
                    switch ($value['dast_service_type']) {
                        case 1:
                            $list_items[$key]['service_name'] = '服务单';
                            break;
                        case 2:
                            $list_items[$key]['service_name'] = '销售单';
                            break;
                        case 3:
                            $list_items[$key]['service_name'] = '换货单';
                            break;
                        case 4:
                            $list_items[$key]['service_name'] = '退货单';
                            break;
                        case 5:
                            $list_items[$key]['service_name'] = '发货单';
                            break;
                        case 6:
                            $list_items[$key]['service_name'] = '结清单';
                            break;
                        case 7:
                            $list_items[$key]['service_name'] = '救援单';
                            break;
                        default:
                            $list_items[$key]['service_name'] = '未知';
                            break;
                    }
                    if ($value['unit_name'] == '' || $value['dast_type'] != 2) {
                        $list_items[$key]['unit_name'] = '无';
                    }
                    $list_items[$key]['total_cost'] = $value['cost'] * $value['dast_goo_quantity'];
                    $list_items[$key]['profit'] = $value['allprice'] - $value['cost'] * $value['dast_goo_quantity'];
                    $list_items[$key]['attribute'] = $value['goo_unit'];
                    // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                    if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                        if (!empty($value['goo_brse_id'])) {
                            if ($value['goo_class'] == 2) {
                                $list_items[$key]['goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['goo_name'];
                            } else {
                                if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                    $list_items[$key]['goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['goo_name'];
                                }
                            }
                        }
                    }
                    // 显示品牌名称
                    if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_BRAND_SHOP'))) {
                        if ($value['goo_class'] == 2) {
                            $list_items[$key]['goo_name'] = $value['goo_bra_name'] . ' ' . $list_items[$key]['goo_name'];
                        } else {
                            if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $list_items[$key]['goo_name'] = $value['goo_bra_name'] . ' ' . $list_items[$key]['goo_name'];
                            }
                        }
                    }
                    if ($value['goo_class'] == 2) {
                        $list_items[$key]['goo_direct_accounting_price'] = isset($system_goo_price[$value['goo_id']]) ? $system_goo_price[$value['goo_id']] : 0; //系统商品的直营核算价
                    }
                    unset($list_items[$key]['goo_brse_id']);
                    unset($list_items[$key]['goo_bra_name']);
                }
                if ($type == 1) {
                    $data_info['current_page'] = $find_dast_data->currentPage();  //当前页面页码
                    $data_info['last_page'] = $find_dast_data->lastPage();        //表示最后一页的页码
                    $data_info['total'] = $find_dast_data->total();               //总数据个数
                    $data_info['current_number'] = $show_count;        //一页显示多少个
                }
                $data_info['data'] = $list_items;
            } else {
                if ($type == 1) {
                    $data_info['current_page'] = $find_dast_data->currentPage();  //当前页面页码
                    $data_info['last_page'] = $find_dast_data->lastPage();        //表示最后一页的页码
                    $data_info['total'] = $find_dast_data->total();               //总数据个数
                    $data_info['current_number'] = $show_count;        //一页显示多少个
                }
                $data_info['data'] = [];
            }
            return $data_info;
        } elseif ($search_data['searchtype'] == '3') { //销量排行
            $list = $find_dast_data->where('dast_goo_id', '>', 0)
                ->where('dast_service_project_type', 1)
                ->select(DB::raw($select_field))
                ->groupBy('goo_goods_encode')
                ->orderBy('quantity', 'desc')
                ->get()->toArray();
            if (count($list) > 0) {
                $allnums = 0; //数量合计
                $allprice = 0; //销售合计
                // 查询系列数据
                $goo_brse_id = array_column($list, 'goo_brse_id');
                $brse_data = DB::table('brand_serie')
                    ->whereIn('brse_id', $goo_brse_id)
                    ->pluck('brse_name', 'brse_id')
                    ->toArray();
                foreach ($list as $key => $value) {
                    $allnums = $allnums + $value->quantity;
                    $allprice = $allprice + $value->price;
                    $list[$key]->attribute = $value->goo_unit;
                    // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                    if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                        if (!empty($value->goo_brse_id)) {
                            if ($value->goo_class == 2) {
                                $list[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                            } else {
                                if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                    $list[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                                }
                            }
                        }
                    }
                    // 显示品牌名称
                    if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_BRAND_SHOP'))) {
                        if ($value->goo_class == 2) {
                            $list[$key]->goo_name = $value->goo_bra_name . ' ' . $list[$key]->goo_name;
                        } else {
                            if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $list[$key]->goo_name = $value->goo_bra_name . ' ' . $list[$key]->goo_name;
                            }
                        }
                    }
                    unset($list[$key]->goo_brse_id);
                    unset($list[$key]->goo_class);
                    unset($list[$key]->goo_bra_name);
                }
                return $list;
            }
        } elseif ($search_data['searchtype'] == '4') { //开单员销量
            $list = $find_dast_data->leftJoin('channel_unit as chun', 'chun.chun_id', '=', 'dast.dast_client_id')
                ->where('dast_create_id', '>', 0)
                ->where('dast_service_project_type', 1)
                ->select(DB::raw($select_field))
                ->groupBy('dast_create_id', 'dast_order_type')
                ->orderBy('quantity', 'desc')
                ->get()->toArray();
            $list = $this->objectToArray($list);
            return $list;
        } elseif ($search_data['searchtype'] == '5') { //业务员销量
            $find_dast_data = $find_dast_data->where('dast_adm_id', '>', 0);
            $list = $find_dast_data->select(DB::raw($select_field))
                ->where('dast_service_project_type', 1)
                ->groupBy('dast_adm_id', 'dast_order_type')
                ->orderBy('quantity', 'desc')
                ->get()->toArray();
            $list = $this->objectToArray($list);
            return $list;
        } elseif ($search_data['searchtype'] == '6') { //客户汇总--查看明细
            $find_dast_data = $find_dast_data->leftJoin('channel_unit as chun', 'chun.chun_id', '=', 'dast.dast_client_id')
                ->where('dast_service_project_type', 1)
                ->select(DB::raw($select_field))
                ->orderBy('dast_create_time', 'desc');
            if ($type == 1) {
                $find_dast_data = $find_dast_data->paginate($show_count);
                $list_items = $find_dast_data->items();
            } else {
                $list_items = $find_dast_data->get()->toArray();
            }
            if ($list_items) {
                $ord_id = array_column($list_items, 'dast_ord_id'); //订单id
                // 查询备注信息
                $order_reamrks = DB::table('order_remarks')
                    ->whereIn('orre_ord_id', $ord_id)
                    ->select('orre_create_adm_name', 'orre_content', 'orre_time', 'orre_ord_id', 'orre_module')
                    ->orderby('orre_id', 'desc')
                    ->get()->toArray();
                if ($order_reamrks) {
                    $order_reamrks = $this->objectToArray($order_reamrks);
                    $order_reamrk = [];
                    foreach ($order_reamrks as $k => $v) {
                        $order_reamrk[$v['orre_ord_id']][] = $v;
                    }
                }
                $chun_chty_id = [];
                $system_goo_id = []; //系统商品id
                foreach ($list_items as $key => $value) {
                    if ($value->chun_chty_id > 0) {
                        $chun_chty_id[] = $value->chun_chty_id;
                    }
                    if ($value->goo_class == 2) {
                        $system_goo_id[] = $value->goo_id;
                    }
                }

                $channel_type = [];
                if ($chun_chty_id) {
                    $channel_type = DB::table('channel_type')
                        ->whereIn("chty_id", $chun_chty_id)
                        ->pluck('chty_name', 'chty_id');
                }
                $system_goo_price = []; //系统商品金额
                if ($system_goo_id) {
                    $system_goo_price = DB::table('goods_system_affiliate')
                        ->where('gosa_shop_id', $user_info['adm_shop_id'])
                        ->whereIn('gosa_goo_id', $system_goo_id)
                        ->pluck('gosa_direct_accounting_price', 'gosa_goo_id')
                        ->toArray();
                }
                $list_items = $this->objectToArray($list_items);
                // 查询系列数据
                $goo_brse_id = array_column($list_items, 'goo_brse_id');
                $brse_data = DB::table('brand_serie')
                    ->whereIn('brse_id', $goo_brse_id)
                    ->pluck('brse_name', 'brse_id')
                    ->toArray();
                foreach ($list_items as $key => $value) {
                    $list_items[$key]['order_reamrks'] = $order_reamrk[$value['dast_ord_id']] ?? [];
                    if ($channel_type) {
                        $list_items[$key]['type_name'] = $channel_type[$value['chun_chty_id']] ?? '未定义' . $value['chun_chty_id'];
                    }
                    switch ($value['dast_service_type']) {
                        case 1:
                            $list_items[$key]['service_name'] = '服务单';
                            break;
                        case 2:
                            $list_items[$key]['service_name'] = '销售单';
                            break;
                        case 3:
                            $list_items[$key]['service_name'] = '换货单';
                            break;
                        case 4:
                            $list_items[$key]['service_name'] = '退货单';
                            break;
                        case 5:
                            $list_items[$key]['service_name'] = '发货单';
                            break;
                        case 6:
                            $list_items[$key]['service_name'] = '结清单';
                            break;
                        case 7:
                            $list_items[$key]['service_name'] = '救援单';
                            break;
                        default:
                            $list_items[$key]['service_name'] = '未知';
                            break;
                    }
                    if ($value['unit_name'] == '' || $value['dast_type'] != 2) {
                        $list_items[$key]['unit_name'] = '无';
                    }
                    $list_items[$key]['total_cost'] = $value['cost'] * $value['dast_goo_quantity'];
                    $list_items[$key]['profit'] = $value['allprice'] - $value['cost'] * $value['dast_goo_quantity'];
                    $list_items[$key]['attribute'] = $value['goo_unit'];
                    // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                    if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                        if (!empty($value['goo_brse_id'])) {
                            if ($value['goo_class'] == 2) {
                                $list_items[$key]['goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['goo_name'];
                            } else {
                                if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                    $list_items[$key]['goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['goo_name'];
                                }
                            }
                        }
                    }
                    // 显示品牌名称
                    if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_BRAND_SHOP'))) {
                        if ($value['goo_class'] == 2) {
                            $list_items[$key]['goo_name'] = $value['goo_bra_name'] . ' ' . $list_items[$key]['goo_name'];
                        } else {
                            if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $list_items[$key]['goo_name'] = $value['goo_bra_name'] . ' ' . $list_items[$key]['goo_name'];
                            }
                        }
                    }
                    if ($value['goo_class'] == 2) {
                        $list_items[$key]['goo_direct_accounting_price'] = isset($system_goo_price[$value['goo_id']]) ? $system_goo_price[$value['goo_id']] : 0; //系统商品的直营核算价
                    }
                    unset($list_items[$key]['goo_brse_id']);
                }
                if ($type == 1) {
                    $data_info['current_page'] = $find_dast_data->currentPage();  //当前页面页码
                    $data_info['last_page'] = $find_dast_data->lastPage();        //表示最后一页的页码
                    $data_info['total'] = $find_dast_data->total();               //总数据个数
                    $data_info['current_number'] = $show_count;        //一页显示多少个
                }
                $data_info['data'] = $list_items;
            } else {
                if ($type == 1) {
                    $data_info['current_page'] = $find_dast_data->currentPage();  //当前页面页码
                    $data_info['last_page'] = $find_dast_data->lastPage();        //表示最后一页的页码
                    $data_info['total'] = $find_dast_data->total();               //总数据个数
                    $data_info['current_number'] = $show_count;        //一页显示多少个
                }
                $data_info['data'] = [];
            }
            return $data_info;
        } elseif ($search_data['searchtype'] == '7') { //客户汇总
            $list = $find_dast_data->leftJoin('channel_unit as chun', 'chun.chun_id', '=', 'dast.dast_client_id')
                ->where('dast_service_project_type', 1)
                ->select(DB::raw($select_field))
                ->groupBy('dast_client_ids', 'dast_type')
                ->orderBy('quantity', 'desc')
                ->get()->toArray();
            $list = $this->objectToArray($list);
            return $list;
        } elseif ($search_data['searchtype'] == '8') { //实时数据
            $find_ord_data = $this->searchRealIndex($user_info, $search_data);

            $find_ord_data = $find_ord_data->select(DB::raw($select_field))
                ->orderBy('ord_create_time', 'desc');
            if ($type == 1) {
                $find_ord_data = $find_ord_data->paginate($show_count);
                $list_items = $find_ord_data->items();
            } else {
                $list_items = $find_ord_data->get()->toArray();
            }
            if ($list_items) {
                $ord_id = array_column($list_items, 'ord_id'); //订单id
                // 查询备注信息
                $order_reamrks = DB::table('order_remarks')
                    ->whereIn('orre_ord_id', $ord_id)
                    ->select('orre_create_adm_name', 'orre_content', 'orre_time', 'orre_ord_id', 'orre_module')
                    ->orderby('orre_id', 'desc')
                    ->get()->toArray();
                if ($order_reamrks) {
                    $order_reamrks = $this->objectToArray($order_reamrks);
                    $order_reamrk = [];
                    foreach ($order_reamrks as $key => $value) {
                        $order_reamrk[$value['orre_ord_id']][] = $value;
                    }
                }
                $chun_chty_id = [];
                foreach ($list_items as $key => $value) {
                    if ($value->chun_chty_id > 0) {
                        $chun_chty_id[] = $value->chun_chty_id;
                    }
                    $list_items[$key]->attribute = $value->goo_unit;
                }
                $channel_type = [];
                if ($chun_chty_id) {
                    $channel_type = DB::table('channel_type')
                        ->whereIn("chty_id", $chun_chty_id)
                        ->pluck('chty_name', 'chty_id')
                        ->toArray();
                }
                $list_items = $this->objectToArray($list_items);
                // 查询系列数据
                $goo_brse_id = array_column($list_items, 'goo_brse_id');
                $brse_data = DB::table('brand_serie')
                    ->whereIn('brse_id', $goo_brse_id)
                    ->pluck('brse_name', 'brse_id')
                    ->toArray();
                foreach ($list_items as $key => $value) {
                    if ($value['ord_service_type'] == '4' || $value['orgo_state'] == '4') {
                        $list_items[$key]['orgo_goo_price'] = 0 - $value['orgo_goo_price'];
                        $list_items[$key]['orgo_goo_quantity'] = 0 - $value['orgo_goo_quantity'];
                    }
                    $list_items[$key]['allprice'] = $list_items[$key]['orgo_goo_price'] * $value['orgo_goo_quantity'];
                    $list_items[$key]['order_reamrks'] = $order_reamrk[$value['ord_id']] ?? [];
                    if ($channel_type) {
                        $list_items[$key]['type_name'] = $channel_type[$value['chun_chty_id']] ?? '未定义' . $value['chun_chty_id'];
                    }
                    if ($value['unit_name'] == '' || $value['ord_type'] != 2) {
                        $list_items[$key]['unit_name'] = '无';
                    }
                    // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                    if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                        if (!empty($value['goo_brse_id'])) {
                            if ($value['goo_class'] == 2) {
                                $list_items[$key]['goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['goo_name'];
                            } else {
                                if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                    $list_items[$key]['goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['goo_name'];
                                }
                            }
                        }
                    }
                    // 显示品牌名称
                    if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_BRAND_SHOP'))) {
                        if ($value['goo_class'] == 2) {
                            $list_items[$key]['goo_name'] = $value['goo_bra_name'] . ' ' . $list_items[$key]['goo_name'];
                        } else {
                            if (!in_array($user_info['adm_shop_id'], config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $list_items[$key]['goo_name'] = $value['goo_bra_name'] . ' ' . $list_items[$key]['goo_name'];
                            }
                        }
                    }
                    $list_items[$key]['ord_service_type'] = ordType($value['ord_service_type']);//订单类型
                    unset($list_items[$key]['goo_brse_id']);
                    unset($list_items[$key]['goo_class']);
                }
                if ($type == 1) {
                    $data_info['current_page'] = $find_ord_data->currentPage();  //当前页面页码
                    $data_info['last_page'] = $find_ord_data->lastPage();        //表示最后一页的页码
                    $data_info['total'] = $find_ord_data->total();               //总数据个数
                    $data_info['current_number'] = $show_count;        //一页显示多少个
                }
                $data_info['data'] = $list_items;
            } else {
                if ($type == 1) {
                    $data_info['current_page'] = $find_ord_data->currentPage();  //当前页面页码
                    $data_info['last_page'] = $find_ord_data->lastPage();        //表示最后一页的页码
                    $data_info['total'] = $find_ord_data->total();               //总数据个数
                    $data_info['current_number'] = $show_count;        //一页显示多少个
                }
                $data_info['data'] = [];
            }
            return $data_info;
        } elseif ($search_data['searchtype'] == '9') { //服务数据
            $find_dast_data = $find_dast_data->leftJoin('channel_unit as chun', 'chun.chun_id', '=', 'dast.dast_client_id')
                ->where('dast_service_project_type', 2)
                ->select(DB::raw($select_field))
                ->orderBy('dast_create_time', 'desc');
            if ($type == 1) {
                $find_dast_data = $find_dast_data->paginate($show_count);
                $list_items = $find_dast_data->items();
            } else {
                $list_items = $find_dast_data->get()->toArray();
            }
            if ($list_items) {
                $dast_service_sepr_id = array_column($list_items, 'dast_service_sepr_id'); //服务项目id
                $chun_chty_id = array_column($list_items, 'chun_chty_id'); //客户类型id
                $ord_id = array_column($list_items, 'dast_ord_id'); //订单id
                // 查询服务项目数据
                $find_sepr_data = DB::table('service_project')
                    ->whereIn('sepr_id', $dast_service_sepr_id)
                    ->where('sepr_shop_id', $user_info['adm_shop_id'])
                    ->pluck('sepr_name', 'sepr_id')
                    ->toArray();
                // 查询客户类型数据
                $find_chty_data = DB::table('channel_type')
                    ->whereIn('chty_id', $chun_chty_id)
                    ->where('chty_shop_id', $user_info['adm_shop_id'])
                    ->where('chty_delete', 1)
                    ->pluck('chty_name', 'chty_id')
                    ->toArray();
                // 查询备注信息
                $order_reamrks = DB::table('order_remarks')
                    ->whereIn('orre_ord_id', $ord_id)
                    ->select('orre_create_adm_name', 'orre_content', 'orre_time', 'orre_ord_id', 'orre_module')
                    ->orderby('orre_id', 'desc')
                    ->get()->toArray();
                if ($order_reamrks) {
                    $order_reamrks = $this->objectToArray($order_reamrks);
                    $order_reamrk = [];
                    foreach ($order_reamrks as $k => $v) {
                        $order_reamrk[$v['orre_ord_id']][] = $v;
                    }
                }
                $list_items = $this->objectToArray($list_items);
                foreach ($list_items as $key => $value) {
                    $data[$key]['dast_order_number'] = $value['dast_order_number']; //订单号
                    if (isset($find_sepr_data[$value['dast_service_sepr_id']])) { //服务项目
                        $data[$key]['dast_sepr_name'] = $find_sepr_data[$value['dast_service_sepr_id']];
                    } else {
                        $data[$key]['dast_sepr_name'] = '无';
                    }
                    $data[$key]['dast_goo_price'] = $value['dast_goo_price']; //服务金额
                    $data[$key]['dast_unit_name'] = $value['chun_unit_name']; //客户单位
                    if (isset($find_chty_data[$value['chun_chty_id']])) { //客户类型
                        $data[$key]['chty_name'] = $find_chty_data[$value['chun_chty_id']];
                    } else {
                        $data[$key]['chty_name'] = '无';
                    }
                    $data[$key]['dast_create_time'] = $value['dast_create_time']; //创建日期
                    switch ($value['dast_service_type']) { //订单类型
                        case 1:
                            $data[$key]['service_name'] = '服务单';
                            break;
                        case 2:
                            $data[$key]['service_name'] = '销售单';
                            break;
                        case 3:
                            $data[$key]['service_name'] = '换货单';
                            break;
                        case 4:
                            $data[$key]['service_name'] = '退货单';
                            break;
                        case 5:
                            $data[$key]['service_name'] = '发货单';
                            break;
                        case 6:
                            $data[$key]['service_name'] = '结清单';
                            break;
                        case 7:
                            $data[$key]['service_name'] = '救援单';
                            break;
                        default:
                            $data[$key]['service_name'] = '未知';
                            break;
                    }
                    $data[$key]['dast_creacor'] = $value['dast_creacor']; //开单员
                    $data[$key]['order_reamrks'] = $order_reamrk[$value['dast_ord_id']] ?? []; //备注
                }
                if ($type == 1) {
                    $data_info['current_page'] = $find_dast_data->currentPage();  //当前页面页码
                    $data_info['last_page'] = $find_dast_data->lastPage();        //表示最后一页的页码
                    $data_info['total'] = $find_dast_data->total();               //总数据个数
                    $data_info['current_number'] = $show_count;        //一页显示多少个
                }
                $data_info['data'] = $data;
            } else {
                if ($type == 1) {
                    $data_info['current_page'] = $find_dast_data->currentPage();  //当前页面页码
                    $data_info['last_page'] = $find_dast_data->lastPage();        //表示最后一页的页码
                    $data_info['total'] = $find_dast_data->total();               //总数据个数
                    $data_info['current_number'] = $show_count;        //一页显示多少个
                }
                $data_info['data'] = [];
            }
            return $data_info;
        }
    }

    /**
     * [brandDirectAccountingPrice 品牌直营核算价]
     * @param  [type] $user_info [用户信息]
     * @param  [type] $input     [前端传值]
     * @return [type]            [description]
     */
    private function brandDirectAccountingPrice($user_info, $input)
    {
        /*
            同一品牌的直营核算价
            a1 同一个商品的销售的直营核算价=实售商品数量*商品的直营核算价
            b1 同一个商品的退货直营核算价=退货商品数量*商品的直营核算价
            c1 同一个品牌的销售的直营核算价=这个品牌下所有商品的销售直营核算价的和 a1+a2+...
            c2 同一个品牌的退货的直营核算价=这个品牌下所有商品的退货直营核算价的和 b1+b2+...
            直营核算价 =  c1 - c2;这个价格是页面显示的价格
         */
        $Db = DB::table("data_statistical as a")
            ->leftJoin('goods as b', 'b.goo_id', '=', 'a.dast_goo_id')
            ->leftJoin('warehouse as c', 'c.ware_id', '=', 'a.dast_ware_id')
            ->where('dast_cid', $user_info['adm_cid'])
            ->where('dast_shop_id', $user_info['adm_shop_id'])
            ->where('dast_order_type', '!=', '3')
            ->where('dast_goo_id', '>', 0)
            ->where('dast_ord_delete', '1');
        if (isset($input['creatData']) && !empty($input['creatData'])) { //时间
            $input['creatData'][1] = date("Y-m-d", strtotime($input['creatData'][1] . " +1 day"));
            $Db = $Db->whereBetween('a.dast_create_time', $input['creatData']);
        }
        if (isset($input['dast_type']) && !empty($input['dast_type'])) { //买家类型：1门店零售2渠道单位3速电派单4第三方派单
            $Db = $Db->where('dast_type', $input['dast_type']);
        }
        if (isset($input['dast_client_id']) && !empty($input['dast_client_id'])) { //往来单位
            // 有客户单位id，默认搜索买家类型为客户单位的
            $Db = $Db->where('dast_type', 2); //买家类型
            $Db = $Db->where('dast_client_id', $input['dast_client_id']);
        }
        if (isset($input['goo_bra_id']) && !empty($input['goo_bra_id'])) { //品牌id
            $Db = $Db->where('goo_bra_id', $input['goo_bra_id']);
        }
        if (isset($input['goo_cate_id']) && !empty($input['goo_cate_id'])) { //商品类型
            $Db = $Db->where('goo_cate_id', $input['goo_cate_id']);
        }
        if (isset($input['dast_orcl_chin_type']) && !empty($input['dast_orcl_chin_type'])) { //铺货类型1是铺货2不是铺货
            $Db = $Db->where('dast_orcl_chin_type', $input['dast_orcl_chin_type']);
        }
        if (isset($input['ware_type']) && !empty($input['ware_type'])) { //仓库类型
            $Db = $Db->where('ware_type', $input['ware_type']);
        }
        if (isset($input['dast_ware_id']) && !empty($input['dast_ware_id'])) { //仓库id
            $Db = $Db->where('dast_ware_id', $input['dast_ware_id']);
        }
        if (isset($input['dast_create_id']) && !empty($input['dast_create_id'])) { //开单员id
            $Db = $Db->where('dast_create_id', $input['dast_create_id']);
        }
        if (isset($input['dast_adm_id']) && !empty($input['dast_adm_id'])) { //业务员id
            $Db = $Db->where('dast_adm_id', $input['dast_adm_id']);
        }
        if (isset($input['chun_chty_id']) && !empty($input['chun_chty_id'])) { //客户类型
            $Db = $Db->where('dast_chty_id', $input['chun_chty_id']);
        }
        if (isset($input['dast_orcl_shipment_party']) && !empty($input['dast_orcl_shipment_party'])) { //出库方1仓库2直营店3加盟店4虚拟加盟店
            $Db = $Db->where('dast_orcl_shipment_party', $input['dast_orcl_shipment_party']);
        }
        $list = $Db->selectRaw('goo_bra_id, dast_goo_id, goo_class,  goo_direct_accounting_price, sum(`dast_goo_quantity`) as quantity, dast_order_type')
            ->groupBy('goo_id', 'dast_order_type')->get()->toArray();
        $brand_goo_price = [];
        foreach ($list as $key => $value) {
            if ($value->goo_bra_id) {
                // goo_class 类型：1自营商品2系统商品
                $goo_direct_accounting_price = $value->goo_direct_accounting_price;
                if ($value->goo_class == 2) {
                    // 查询系统商品的直营核算价
                    $goo_direct_accounting_price = DB::table('goods_system_affiliate')
                        ->where('gosa_shop_id', $user_info['adm_shop_id'])
                        ->where('gosa_goo_id', $value->dast_goo_id)
                        ->value('gosa_direct_accounting_price');
                }
                if (isset($brand_goo_price[$value->goo_bra_id])) {
                    // dast_order_type 订单类型1销售单2退款单
                    if ($value->dast_order_type == 1) {
                        $brand_goo_price[$value->goo_bra_id]['sell_price'] += $value->quantity * $goo_direct_accounting_price; //销售金额
                    } else {
                        $brand_goo_price[$value->goo_bra_id]['back_price'] += $value->quantity * $goo_direct_accounting_price; //退回金额
                    }
                } else {
                    // dast_order_type 订单类型1销售单2退款单
                    if ($value->dast_order_type == 1) {
                        $brand_goo_price[$value->goo_bra_id]['sell_price'] = $value->quantity * $goo_direct_accounting_price; //销售金额
                        $brand_goo_price[$value->goo_bra_id]['back_price'] = 0; //退回金额
                    } else {
                        $brand_goo_price[$value->goo_bra_id]['sell_price'] = 0; //销售金额
                        $brand_goo_price[$value->goo_bra_id]['back_price'] = $value->quantity * $goo_direct_accounting_price; //退回金额
                    }
                }
            }
        }
        return $brand_goo_price;
    }


    /**|---------------------------------------------------------------------------------
     * @name  对象转数组
     * @param $object 对象数据
     * @return \Illuminate\Http\JsonResponse
     * @author dou <2020/9/30 16:35>
     * |---------------------------------------------------------------------------------
     */
    public function objectToArray($object)
    {
        // 先编码成json字符串，再解码成数组
        return json_decode(json_encode($object), true);
    }
}
