<?php

namespace App\Http\Models\Services\DataSearch;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

// 商品库存查询
class GoodsInventory extends Model
{
	/**
	 * [goodsIndex 查询商品信息]
	 * @param  [type] $user_info    [用户信息]
	 * @param  [type] $search_data  [搜索信息]
	 * @param  [type] $show_count   [每页条数]
	 * @param  [type] $select_field [查询字段，字符串多个字段用,分开]
	 * @return [type]               [description]
	 */
    public function goodsIndex($user_info, $search_data, $show_count, $select_field)
    {
        $list_data = DB::table('goods')
            ->where('goo_delete', 1) //是否删除：1正常2已删除
            ->where('goo_state', 1) //状态1启用2停用
            ->where('goo_type', 1) //商品类型 1正常商品2赠品商品3活动商品4旧货商品
            ->where(function ($query) use ($user_info) {//门店id
                $query->where('goo_shop_id', 0)
                    ->orwhere('goo_shop_id', $user_info->adm_shop_id);
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_name'])) {//商品信息
                    $query->where('goo_name', 'like', '%'.$search_data['goo_name'].'%')
                    ->orwhere('goo_goods_encode', 'like', '%'.$search_data['goo_name'].'%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_bra_id'])) {//品牌
                    $query->where('goo_bra_id', $search_data['goo_bra_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_cate_id'])) { //品类
                    $query->where('goo_cate_id', $search_data['goo_cate_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_brse_id'])) {//品牌系列id
                    $query->where('goo_brse_id', $search_data['goo_brse_id']);
                }
            })
            ->where(function ($query) use ($search_data) {//类型1自营商品2系统商品
                if (!empty($search_data['goo_class'])) {
                    $query->where('goo_class', $search_data['goo_class']);
                }
            })
            // ->select('goo_id', 'goo_name', 'goo_goods_encode', 'goo_cate_name', 'goo_bra_name', 'goo_brse_id', 'goo_state', 'goo_attribute', 'goo_price', 'goo_wholesale_price', 'goo_purchase_price', 'goo_direct_accounting_price', 'goo_unit', 'goo_class', 'goo_type')
            ->select(DB::raw($select_field))
            ->orderBy('goo_id', 'desc')
            ->paginate($show_count);
        
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据
        if ($data_info['data']) {
            // 查询品牌系列数据
            $goo_brse_id = array_filter(array_unique(array_column($data_info['data'], 'goo_brse_id')));
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $goo_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            foreach ($data_info['data'] as $key => $value) {
                // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                    if (!empty($value->goo_brse_id)) {
                        // 显示系列名称
                        if ($value->goo_class == 2) {
                            $data_info['data'][$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $data_info['data'][$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                            }
                        }
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if ($value->goo_class == 2) {
                        $data_info['data'][$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $data_info['data'][$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                        }
                    }
                }

                if ($value->goo_class == 2) {
                	// 查询系统商品属性数据
	                $goods_data = DB::table('goods_system_affiliate')
	                    ->where('gosa_shop_id', $user_info->adm_shop_id)
	                    ->where('gosa_goo_id', $value->goo_id)
	                    ->select('gosa_goo_id', 'gosa_price', 'gosa_wholesale_price', 'gosa_purchase_price', 'gosa_direct_accounting_price')
	                    ->first();
	                if ($goods_data) {
	                    $data_info['data'][$key]->goo_price = $goods_data->gosa_price;//售价金额(单位：分）
	                    $data_info['data'][$key]->goo_wholesale_price = $goods_data->gosa_wholesale_price;//批发价（单位：分）
	                    $data_info['data'][$key]->goo_purchase_price = $goods_data->gosa_purchase_price;//采购价（单位：分）
	                    $data_info['data'][$key]->goo_direct_accounting_price = $goods_data->gosa_direct_accounting_price;//直营核算价（单位：分）
	                }
	                unset($goods_data);
                }
                unset( $data_info['data'][$key]->goo_brse_id);
                unset( $data_info['data'][$key]->goo_bra_name);
            }
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$data_info];
    }

    /**
     * [stockIndex 商品库存查询]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $search_data  [搜索信息]
     * @param  [type] $show_count   [每页条数]
     * @param  [type] $select_field [查询字段，字符串多个字段用,分开]
     * @return [type]               [description]
     */
    public function stockIndex($user_info, $search_data, $show_count, $select_field)
    {
        // 获取到该账号下勾选的仓库id
        $find_ware_id = DB::table('admin_set')
            ->where('adms_adm_id', $user_info->adm_id)
            ->where('adms_shop_id', $user_info->adm_shop_id)
            ->select('adms_ware_ids')
            ->first();
        if (empty($find_ware_id->adms_ware_ids)) {
            $ware_id = [];
        } else {
            $ware_id = $find_ware_id->adms_ware_ids;
            $ware_id = array_unique(explode(',', $ware_id));
        }
        if (empty($ware_id)) {
        	return ['code'=>500, 'msg'=>'success', 'data'=>'当前账号暂无仓库查询权限！'];
        }
        
        $list_data = DB::table('warehouse as ware')
            ->leftJoin('warehouse_goods as wago', 'wago.wago_ware_id', '=', 'ware.ware_id')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'wago.wago_goo_id')
            ->whereIn('ware_id', $ware_id)
            ->where('ware_shop_id', $user_info->adm_shop_id)
            ->where('goo_id', $search_data['goo_id'])
            ->where(function ($query) use ($user_info) {
                $query->where('wago_stock_number', '>', 0)
                    ->orWhere('wago_priority_stock_number', '>', 0);
            })
            ->where('ware_type', '<>', 2)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_name'])) {
                    $query->where('goo_name', 'like', '%'.$search_data['goo_name'].'%')
                    ->orwhere('goo_goods_encode', 'like', '%'.$search_data['goo_name'].'%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_bra_id'])) { //品牌
                    $query->where('goo_bra_id', $search_data['goo_bra_id']);
                }
            }) //品牌
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_cate_id'])) { //品类
                    $query->where('goo_cate_id', $search_data['goo_cate_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ware_id'])) { //仓库id
                    $query->where('ware_id', $search_data['ware_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['wago_class'])) { //仓库类别
                    $query->where('wago_class', $search_data['wago_class']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_brse_id'])) {//品牌系列id
                    $query->where('goo_brse_id', $search_data['goo_brse_id']);
                }
            })
            // ->select('ware_id', 'ware_name', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number', 'wago_class', 'goo_name', 'goo_goods_encode', 'goo_cate_name', 'goo_bra_name', 'goo_price', 'goo_wholesale_price', 'goo_brse_id', 'goo_class', 'goo_id', 'wago_freight_stock_number', 'wago_freight_priority_stock_number', 'wago_id', 'goo_purchase_price', 'goo_direct_accounting_price')
            ->select(DB::raw($select_field))
            ->orderBy('wago_stock_number', 'desc')
            ->paginate($show_count);
        
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $show_count;       //一页显示多少个
        $data_info['wago_data'] = $list_data->items();                //返回数据
        if ($data_info['wago_data']) {
            // 查询品牌系列数据
            $goo_brse_id = array_filter(array_unique(array_column($data_info['wago_data'], 'goo_brse_id')));
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $goo_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            foreach ($data_info['wago_data'] as $key => $value) {
                // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                    if (!empty($value->goo_brse_id)) {
                        // 显示系列名称
                        if ($value->goo_class == 2) {
                            $data_info['wago_data'][$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $data_info['wago_data'][$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                            }
                        }
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if ($value->goo_class == 2) {
                        $data_info['wago_data'][$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $data_info['wago_data'][$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                        }
                    }
                }

                if ($value->goo_class == 2) {
	                $goods_data = DB::table('goods_system_affiliate')
	                    ->where('gosa_shop_id', $user_info->adm_shop_id)
	                    ->where('gosa_goo_id', $value->goo_id)
	                    ->select('gosa_goo_id', 'gosa_price', 'gosa_wholesale_price', 'gosa_purchase_price', 'gosa_direct_accounting_price')
	                    ->first();
	                if ($goods_data) {
	                    $data_info['wago_data'][$key]->goo_price = $goods_data->gosa_price;
	                    $data_info['wago_data'][$key]->goo_wholesale_price = $goods_data->gosa_wholesale_price;
	                    $data_info['wago_data'][$key]->goo_purchase_price = $goods_data->gosa_purchase_price;
	                    $data_info['wago_data'][$key]->goo_direct_accounting_price = $goods_data->gosa_direct_accounting_price;
	                }
                }
                // 仓位良品库存数量或仓位优先库存数量 > 0, 查询对应的仓位表数据
                $data_info['wago_data'][$key]->wafg_data = DB::table('warehouse_freight_goods as wafg')
                    ->leftjoin('warehouse_freight as wafr', 'wafg.wafg_wafr_id', '=', 'wafr.wafr_id')
                    ->where('wafg_ware_id', $value->ware_id)
                    ->where('wafg_wago_id', $value->wago_id)
                    ->where('wafg_class', $value->wago_class)
                    ->where('wafg_goo_id', $value->wago_goo_id)
                    ->where(function ($query) use ($user_info) {
                        $query->where('wafg_stock_number', '>', 0)
                            ->orWhere('wafg_priority_stock_number', '>', 0);
                    })
                    ->select('wafr_id', 'wafr_name', 'wafr_rank', 'wafg_stock_number', 'wafg_priority_stock_number')
                    ->get()->toArray();
                unset($data_info['wago_data'][$key]->goo_brse_id);
                unset($data_info['wago_data'][$key]->goo_bra_name);
            }
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$data_info];
    }
}
