<?php
namespace App\Http\Models\Services\AccountControl;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

// 财务系统 -- 账单列表
class AppletOrderBill extends Model
{
    /**
     * [billNumber 单量详情]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $request      [提交信息]
     * @param  [type] $search_data  [搜索信息]
     * @param  [type] $show_count   [每页条数]
     * @param  [type] $select_field [查询字段，字符串多个字段用,分开]
     * @return [type]               [description]
     */
    public function billNumber($user_info, $request, $search_data, $show_count, $select_field)
    {
        // 账单信息
        $bill = DB::table('order_bill')
            // ->leftJoin('order', 'ord_id', '=', 'orbi_ord')
            ->where('orbi_id', $request['orbi_id'])
            ->select(DB::raw($select_field))
            ->first();
        if ($request['type'] == 1) { //获取账单信息
            if ($bill) {
                if ($bill->orbi_type == 2) { //客户单位
                    $bill->orbi_client_name = DB::table('channel_unit')
                        ->where('chun_id', $bill->orbi_client_id)
                        ->value('chun_unit_name');
                } elseif ($bill->orbi_type == 1) { //客户名称
                    $bill->orbi_client_name = DB::table('admin')
                        ->where('adm_id', $bill->orbi_client_id)
                        ->value('adm_name');
                } elseif ($bill->orbi_type == 4) { //虚拟加盟店
                    $bill->orbi_client_name = DB::table('virtual_shop')
                        ->where('vish_id', $bill->orbi_client_id)
                        ->value('vish_store_name');
                } elseif ($bill->orbi_type == 5) { //加盟店
                    $bill->orbi_client_name = DB::table('shop')
                        ->where('shop_id', $bill->orbi_client_id)
                        ->value('shop_store_name');
                }
                $bill->orbi_actual_price = sprintf("%.2f",$bill->orbi_actual_price / 100);
                $bill->orbi_bill_price = sprintf("%.2f",$bill->orbi_bill_price / 100);
                return ['code'=>200, 'msg'=>'success', 'data'=>$bill];
            } else {
                return ['code'=>500, 'msg'=>'error', 'data'=>'暂无数据'];
            }
        } else {
            if ($bill->orbi_create_type == 3) { //工单账单
                // 订单信息
                $list_data = DB::table('work_order as wor')
                    ->leftJoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                    ->leftJoin('admin as adm', 'adm.adm_id', '=', 'wor.wor_create_id')
                    ->where('wor_cid', $user_info->adm_cid)
                    ->where('wor_shop_id', $user_info->adm_shop_id)
                    ->where('wor_delete', 1)
                    ->where('wor_wobi_id', $request['orbi_id'])
                    ->where(function ($query) use ($search_data) {
                        if (!empty($search_data['ord_order_number'])) {
                            $query->where('wor_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                        }
                    }) //单号
                    ->select('wor_id', 'adm_name', 'wor_number as ord_order_number', 'wor_goo_amount as ord_goods_quantity', 'wor_actual_price as ord_actual_price', 'wocl_channel_unit as orcl_channel_unit', 'wocl_name as orcl_name', 'wocl_phone as orcl_phone', 'wocl_address as orcl_address', 'wor_remark as ord_remark', 'wor_create_time as ord_create_time', 'wor_collection_bill as ord_collection_bill')
                    ->paginate($show_count);
                $list_items = $list_data->items();

                // 查找订单商品
                if (empty($list_items)) {
                    $ord_id = [];
                    $recycle_price = 0;
                } else {
                    foreach ($list_items as $key => $value) {
                        $ord_id[] = $value->wor_id;
                    }
                }
                $recycle_price = 0;

                $order_goods = DB::table('work_good')
                    ->whereIn('wogo_wor_id', $ord_id)
                    ->select('wogo_goo_name as orgo_goo_name', 'wogo_goo_goods_encode as orgo_goo_goods_encode', 'wogo_goo_price as orgo_goo_price', 'wogo_goo_amount as orgo_goo_quantity', 'wogo_tem_goo_name as tem_goo_name')
                    ->get()->toArray();

                // 查询备注信息
                $order_reamrks = DB::table('order_remarks')
                    ->whereIn('orre_wor_id', $ord_id)
                    ->select('orre_create_adm_name', 'orre_content', 'orre_time', 'orre_wor_id', 'orre_ord_id', 'orre_module')
                    ->orderby('orre_id', 'desc')
                    ->get()->toArray();
            } elseif ($bill->orbi_create_type == 5) { //采购账单信息
                $list_data = DB::table('purchase_order as puor')
                    ->leftJoin('channel_unit as chun', 'chun.chun_id', '=', 'puor.cg_supplyunit')
                    ->where('company_id', $user_info->adm_cid)
                    ->where('cg_shop_id', $user_info->adm_shop_id)
                    ->where('is_del', 1)
                    ->where('cg_zdnumber', $bill->orbi_number)
                    ->where(function ($query) use ($search_data) {
                        if (!empty($search_data['ord_order_number'])) {
                            $query->where('cg_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                        }
                    })
                    ->select('cg_id', 'cg_creator as adm_name', 'cg_number as ord_order_number', 'cg_amount as ord_actual_price', 'create_time as ord_create_time', 'cg_supplyunit', 'chun_unit_name as orcl_channel_unit')
                    ->paginate($show_count);
                $list_items = $list_data->items();

                // 查找采购单商品
                if (empty($list_items)) {
                    $cg_number = [];
                    $recycle_price = 0;
                } else {
                    foreach ($list_items as $key => $value) {
                        $goods = DB::table('storage_goods')
                            ->where('relation_number', $value->ord_order_number)
                            ->select('id', 'goods_num')
                            ->get()->toArray();
                        $list_items[$key]->ord_goods_quantity = '0';
                        if (substr($value->ord_order_number, 0, 2) == 'TH') {
                            $list_items[$key]->ord_plus_minus = '1';
                        } else {
                            $list_items[$key]->ord_plus_minus = '2';
                        }

                        $list_items[$key]->ord_actual_price = $list_items[$key]->ord_actual_price * 100;
                        foreach ($goods as $k => $v) {
                            $list_items[$key]->ord_goods_quantity = $list_items[$key]->ord_goods_quantity + $v->goods_num;
                        }
                        $cg_number[] = $value->ord_order_number;
                    }
                }
                $recycle_price = 0;

                $order_goods = DB::table('storage_goods')
                    ->whereIn('relation_number', $cg_number)
                    ->select('goods_name as orgo_goo_name', 'goods_number as orgo_goo_goods_encode', 'univalence as orgo_goo_price', 'goods_num as orgo_goo_quantity')
                    ->get()->toArray();

                // 查询备注信息
                $order_reamrks = array(); //备注
            } elseif ($bill->orbi_create_type == 1) { //订单账单
                // 订单信息
                $list_data = DB::table('order as ord')
                    ->leftJoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                    ->leftJoin('admin as adm', 'adm.adm_id', '=', 'ord.ord_create_id')
                    ->where('ord_cid', $user_info->adm_cid)
                    ->where('ord_shop_id', $user_info->adm_shop_id)
                    ->where('ord_delete', 1)
                    ->where('ord_orbi_id', $request['orbi_id'])
                    ->where(function ($query) use ($search_data) {
                        if (!empty($search_data['ord_order_number'])) {
                            $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                        }
                    }) //单号
                    ->select('ord_id', 'adm_name', 'ord_order_number', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_type', 'ord_service_type', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_address', 'ord_remark', 'ord_create_time', 'ord_order_price', 'ord_collection_price', 'ord_delete', 'ord_collection_bill','orcl_business_name')
                    ->paginate($show_count);
                $list_items = $list_data->items();

                // 查找订单商品
                if (empty($list_items)) {
                    $ord_id = [];
                    $recycle_price = 0;
                } else {
                    foreach ($list_items as $key => $value) {
                        $ord_id[] = $value->ord_id;
                        $list_items[$key]->ord_order_price = $value->ord_order_price / 100;
                    }
                    if($value->orcl_business_name != '' && $value->ord_type == 2){
                        $list_items[$key]->orcl_name = $value->orcl_business_name;
                    }
                    // 查找所有订单回收金额
                    $recycle_price = DB::table('junk_recycle')
                        ->whereIn('jur_ord_id', $ord_id)
                        ->where('jur_price', '!=', 0)
                        ->select('jur_ord_id', 'jur_price')
                        ->get()->toArray();
                }

                $order_goods = DB::table('order_goods')
                    ->whereIn('orgo_ord_id', $ord_id)
                    ->select('orgo_ord_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_price', 'orgo_goo_quantity', 'orgo_is_recycle', 'orgo_state', 'orgo_goo_exchange', 'orgo_tem_goo_name as tem_goo_name')
                    ->get()->toArray();
                // 查询备注信息
                $order_reamrks = DB::table('order_remarks')
                    //->whereIn('orre_wor_id', $ord_id)
                    ->whereIn('orre_ord_id', $ord_id)
                    ->select('orre_create_adm_name', 'orre_content', 'orre_time', 'orre_wor_id', 'orre_ord_id', 'orre_module')
                    ->orderby('orre_id', 'desc')
                    ->get()->toArray();
            } else { //速电同步生成
                $sdob_id = DB::table('sd_order_bill')
                    ->where('sdob_orbi_id', $request['orbi_id'])
                    ->value('sdob_id');
                // 订单信息
                $list_data = DB::table('sd_order_bill_details')
                    ->where('sobd_sdob_id', $sdob_id)
                    ->where(function ($query) use ($search_data) {
                        if (!empty($search_data['ord_order_number'])) {
                            $query->where('sobd_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                        }
                    }) //单号
                    ->select('sobd_ord_order_number as ord_order_number', 'sobd_order_number as sd_number', 'sobd_ord_id', 'sobd_actual_price as ord_actual_price', 'sobd_create_time as ord_create_time')
                    ->paginate($show_count);
                $list_items = $list_data->items();
                $ord_id = [];
                foreach ($list_items as $key => $value) {
                    if (!empty($value->sobd_ord_id)) {
                        $order_data = DB::table('order as ord')
                            ->leftjoin('admin as adm', 'adm.adm_id', '=', 'ord.ord_create_id')
                            ->where('ord_id', $value->sobd_ord_id)
                            ->select('ord_create_time', 'adm_name', 'ord_goods_quantity')
                            ->first();
                        $list_items[$key]->ord_create_time = $order_data->ord_create_time;
                        $list_items[$key]->adm_name = $order_data->adm_name;
                        $list_items[$key]->ord_goods_quantity = $order_data->ord_goods_quantity;
                        $list_items[$key]->order_type = 1; //系统订单
                        $ord_id[] = $value->sobd_ord_id;
                    } else {
                        $list_items[$key]->ord_goods_quantity = 0;
                        $list_items[$key]->order_type = 2; //非系统订单
                    }
                    $list_items[$key]->orcl_channel_unit = config('apisystem.sd_chan_info')['name'];
                    $list_items[$key]->ord_plus_minus = 1;
                }

                if (!empty($ord_id)) {
                    $order_goods = DB::table('order_goods')
                        ->whereIn('orgo_ord_id', $ord_id)
                        ->select('orgo_ord_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_price', 'orgo_goo_quantity', 'orgo_is_recycle', 'orgo_state', 'orgo_goo_exchange', 'orgo_tem_goo_name as tem_goo_name')
                        ->get()->toArray();
                    // 查询备注信息
                    $order_reamrks = DB::table('order_remarks')
                        ->whereIn('orre_ord_id', $ord_id)
                        ->select('orre_create_adm_name', 'orre_content', 'orre_time', 'orre_wor_id', 'orre_ord_id', 'orre_module')
                        ->orderby('orre_id', 'desc')
                        ->get()->toArray();
                } else {
                    $order_goods = [];
                    $order_reamrks = [];
                }
                $recycle_price = [];
            }
            $order['current_page'] = $list_data->currentPage();  //当前页面页码
            $order['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $order['total'] = $list_data->total();               //总数据个数
            $order['current_number'] = $show_count;        //一页显示多少个
            $order['data'] = $list_items;                        //返回数据
            $order['order_goods'] = $order_goods;                //订单商品数据
            $order['recycle_price'] = $recycle_price;            //订单回收金额
            $order['order_reamrks'] = $order_reamrks;            //操作记录
            $order['orbi_create_type'] = $bill->orbi_create_type;   //操作记录

            if ($order) {
                return ['code'=>200, 'msg'=>'success', 'data'=>$order];
            } else {
                return ['code'=>500, 'msg'=>'error', 'data'=>'暂无数据'];
            }
        }
    }

    /**
     * [lookInfo 查询商品信息]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $request      [提交信息]
     * @param  [type] $select_field [查询字段，字符串多个字段用,分开]
     * @return [type]               [description]
     */
    public function lookInfo($user_info, $request, $select_field)
    {
        // 验证当前账单是否存在
        $orbi_data = DB::table('order_bill')
            ->where('orbi_id', $request['orbi_id'])
            ->where('orbi_shop_id', $user_info->adm_shop_id)
            ->select(DB::raw($select_field))
            ->first();
        if (empty($orbi_data)) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'当前账单不存在'];
        }

        // 获取到创建人姓名
        $orbi_data->orbi_create_adm_name = DB::table('admin')
            ->where('adm_id', $orbi_data->orbi_create_adm_id)
            ->value('adm_name');
        // 获取到审核人名称
        $orbi_data->orbi_audit_adm_name = DB::table('admin')
            ->where('adm_id', $orbi_data->orbi_audit_adm_id)
            ->value('adm_name');
        if (empty($orbi_data->orbi_audit_adm_name)) {
            $orbi_data->orbi_audit_adm_name = '';
        }
        // 获取到结款人名称
        $orbi_data->orbi_payee_name = DB::table('admin')
            ->where('adm_id', $orbi_data->orbi_payee_id)
            ->value('adm_name');
        if (empty($orbi_data->orbi_payee_name)) {
            $orbi_data->orbi_payee_name = '';
        }

        // 获取客户单位信息
        if ($orbi_data->orbi_type == 1) { //会员零售
            $member = DB::table('member')
                ->where('mem_id', $orbi_data->orbi_client_id)
                ->select('mem_name', 'mem_phone', 'mem_province', 'mem_city', 'mem_county', 'mem_address')
                ->first();
            $orbi_data->unit_name = '';
            $orbi_data->adm_name = $member->mem_name;
            $orbi_data->adm_phone = $member->mem_phone;
            $orbi_data->adm_province = $member->mem_province;
            $orbi_data->adm_city = $member->mem_city;
            $orbi_data->adm_county = $member->mem_county;
            $orbi_data->adm_address = $member->mem_address;
        } elseif ($orbi_data->orbi_type == 2) { //客户单位
            /*$channel = DB::table('channel_unit')
                ->where('chun_id', $orbi_data->orbi_client_id)
                ->select('chun_unit_name', 'chun_name', 'chun_phone', 'chun_province', 'chun_city', 'chun_county', 'chun_address')
                ->first();*/
            $channel = DB::table('business_client')
                ->where('bucl_id', $orbi_data->orbi_client_id)
                ->first(['bucl_name', 'bucl_user_phone', 'bucl_user_name', 'bucl_province', 'bucl_city', 'bucl_county', 'bucl_address']);
            $orbi_data->unit_name = $channel->bucl_name;
            $orbi_data->adm_name = $channel->bucl_user_name;
            $orbi_data->adm_phone = $channel->bucl_user_phone;
            $orbi_data->adm_province = $channel->bucl_province;
            $orbi_data->adm_city = $channel->bucl_city;
            $orbi_data->adm_county = $channel->bucl_county;
            $orbi_data->adm_address = $channel->bucl_address;
        } elseif ($orbi_data->orbi_type == 3) { //速电网单
            $find_sd_chan = config('apisystem.sd_chan_info');
            $orbi_data->adm_name = $find_sd_chan['name'];
            $orbi_data->adm_phone = $find_sd_chan['phone'];
            $orbi_data->adm_address = $find_sd_chan['address'];
        } elseif ($orbi_data->orbi_type == 4) { //虚拟加盟店
            $vish_data = DB::table('virtual_shop')
                ->where('vish_id', $orbi_data->orbi_client_id)
                ->select('vish_store_name', 'vish_name', 'vish_phone', 'vish_province', 'vish_city', 'vish_county', 'vish_address')
                ->first();
            $orbi_data->unit_name = $vish_data->vish_store_name;
            $orbi_data->adm_name = $vish_data->vish_name;
            $orbi_data->adm_phone = $vish_data->vish_phone;
            $orbi_data->adm_province = $vish_data->vish_province;
            $orbi_data->adm_city = $vish_data->vish_city;
            $orbi_data->adm_county = $vish_data->vish_county;
            $orbi_data->adm_address = $vish_data->vish_address;
        } elseif ($orbi_data->orbi_type == 5) { //加盟店
            $shop_data = DB::table('shop')
                ->where('shop_id', $orbi_data->orbi_client_id)
                ->select('shop_store_name', 'shop_name', 'shop_phone', 'shop_province', 'shop_city', 'shop_county', 'shop_address')
                ->first();
            $orbi_data->unit_name = $shop_data->shop_store_name;
            $orbi_data->adm_name = $shop_data->shop_name;
            $orbi_data->adm_phone = $shop_data->shop_phone;
            $orbi_data->adm_province = $shop_data->shop_province;
            $orbi_data->adm_city = $shop_data->shop_city;
            $orbi_data->adm_county = $shop_data->shop_county;
            $orbi_data->adm_address = $shop_data->shop_address;
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$orbi_data];
    }
}
