<?php
namespace App\Http\Models\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use App\Http\Controllers\Api\YongYou\YongYouController;

class YongYous extends Model
{
    /**
     * [apiAccountVerify 结款明细同步上传凭证]
     * @param  [type]  $user_info       [用户信息]
     * @param  [type]  $search_data [查询的结款明细数据]
     * @param  [type]  $request_voucher [凭证需要的数据]
     * @return [type]                   [description]
     */
    public static function apiAccountVerify($user_info, $search_data, $request_voucher, $now_date)
    {
        // 调用u8系统接口，将凭证数据传到用友系统上，需要传的凭证
        /*
            acset_type 单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款9订单代收10采购入库单预付款11订单退款12工单代收13订单完成后结算14非实物开单15.订单冲单16.加盟店订单收款17.加盟店订单代收18.工单结算19.旧货回收20售后单结算21销售出库单22采购单23采购退货单24采购款到发货(预付款)

            收款确认时  借：银行存款   贷：对应的科目
            付款确认时  借：对应科目   贷：银行存款
                货物入库时：
                    借：库存商品
                    贷：应付账款-货款
                付款时：
                    借：应付账款-货款
                    贷：银行存款
         */
        // 金额为0的用友系统无法上传凭证
        // if (empty(abs($request_voucher['voucher_price']))) {
        //     return ['code'=>200, 'msg'=>'success', 'data'=>'U8财务系统凭证上传成功！'];
        // }

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $yongyou = new YongYouController;
        // 获取门店对应用友系统的配置数据
        $unitcode = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['unitcode'];//用友-公司编码
        $subjschemecode  = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['subjschemecode'];//用友-科目方案编码

        $vou_voucher_id = $search_data['acset_id'];//凭证所对应的id：结款明细id
        $vou_voucher_number = $search_data['acset_number'];//凭证对应的单号：流水号

        // dump($vou_voucher_id);
        // dump($vou_voucher_number);
        // dump($search_data);
        // dump($request_voucher);
        // die;
        // 查找凭证号
        $find_voucher = self::findVoucher($user_info, $now_date);

        $vou_num = 0;

        $find_acsl_data = DB::table('accounting_settlement_loan')
            ->where('acsl_shop_id', $user_info->adm_shop_id)
            ->where('acsl_acset_id', $search_data['acset_id'])
            ->get()->toArray();
        $find_acsl_data = json_decode(json_encode($find_acsl_data), true);
        // dump($find_acsl_data);
        // exit;
        $date = $now_date;

        switch ($search_data['acset_type']) {
            case '1'://1订单结算：收到钱核销单据时, 借：库存现金或银行存款 贷：应收账款
                $find_data = DB::table('order')
                    ->where('ord_shop_id', $user_info->adm_shop_id)
                    ->where('ord_id', $search_data['acset_original_id'])
                    ->where('ord_order_number', $search_data['acset_original_number'])
                    ->select('ord_client_id', 'ord_type')
                    ->first();
                // ord_type 买家类型：1门店零售2渠道单位3速电派单4第三方派单
                if ($find_data->ord_type == 1) {
                    if ($find_data->ord_client_id) {
                        // 会员零售
                        $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                    } else {
                        // 临时会员
                        $checkvaluecode = config('apiu8cloud.custcode.temporary').$user_info->adm_shop_id.config('apiu8cloud.project.item').'0';
                    }
                } elseif ($find_data->ord_type == 2) {
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->ord_client_id;
                } elseif ($find_data->ord_type == 3) {
                    // 速电派单
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                }

                $vou_hint = '【订单结算】流水号：'.$search_data['acset_number'].'订单单号：'.$search_data['acset_original_number'];

                if ($search_data['acset_inex_type'] == '1') {//收入
                    // 借：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码

                    // 贷：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                    if ($find_acsl_data[1]['acsl_borrow_price'] != '0') {
                        // 借
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                    if ($find_acsl_data[1]['acsl_loan_price'] != '0') {
                        // 贷
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    }
                } else {//支出
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                    // 贷：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                    if ($find_acsl_data[1]['acsl_borrow_price'] != '0') {
                        // 借
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                    if ($find_acsl_data[1]['acsl_loan_price'] != '0') {
                        // 贷
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    }
                }
                
                // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $vou_hint;//凭证摘要
                $vou_num++;

                break;
            case '2'://2.订单账单：收到钱核销单据时, 借：库存现金或银行存款 贷：应收账款
                $find_data = DB::table('order_bill')
                    ->where('orbi_shop_id', $user_info->adm_shop_id)
                    ->where('orbi_id', $search_data['acset_original_id'])
                    ->where('orbi_number', $search_data['acset_original_number'])
                    ->whereIn('orbi_create_type', [1, 2])
                    ->select('orbi_client_id', 'orbi_type')
                    ->first();
                // orbi_type 类型：1门店零售2渠道单位3速电网单4虚拟加盟店5加盟店
                if ($find_data->orbi_type == 1) {
                    if ($find_data->orbi_client_id) {
                        // 会员零售
                        $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                    } else {
                        // 临时会员
                        $checkvaluecode = config('apiu8cloud.custcode.temporary').$user_info->adm_shop_id.config('apiu8cloud.project.item').'0';
                    }
                } elseif ($find_data->orbi_type == 2) {
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->orbi_client_id;
                } elseif ($find_data->orbi_type == 3) {
                    // 速电派单
                    // $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->orbi_client_id;
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                } elseif ($find_data->orbi_type == 4) {
                    $vish_chun_id = DB::table('virtual_shop')
                        ->where('vish_cid', $user_info->adm_cid)
                        ->where('vish_superior_shop_id', $shop_id)
                        ->where('vish_id', $find_data->orbi_client_id)
                        ->value('vish_chun_id');
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$vish_chun_id;
                } else {
                    $checkvaluecode = config('apiu8cloud.custcode.assignment').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->orbi_client_id;
                }

                $vou_hint = '【订单账单】流水号：'.$search_data['acset_number'].'订单账单单号：'.$search_data['acset_original_number'];

                if ($search_data['acset_inex_type'] == '1') {//收入
                    // 借：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                    if ($find_acsl_data[0]['acsl_borrow_subject'] == '600101' || $find_acsl_data[0]['acsl_borrow_subject'] == '1122') {
                        $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                        $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    }

                    // 贷：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                    if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                        // 借
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                    if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                        // 贷
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    }
                } else {//支出
                    // 借：应收账款
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                    // 贷：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                    if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                        // 借
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                    if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                        // 贷
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    }
                }
                // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $vou_hint;//凭证摘要
                $vou_num++;
                break;
            case '3'://3.工单账单：收到钱核销单据时, 借：库存现金或银行存款 贷：应收账款
                $find_data = DB::table('order_bill')
                    ->where('orbi_shop_id', $user_info->adm_shop_id)
                    ->where('orbi_id', $search_data['acset_original_id'])
                    ->where('orbi_number', $search_data['acset_original_number'])
                    ->where('orbi_create_type', 3)
                    ->select('orbi_client_id', 'orbi_type')
                    ->first();
                // orbi_type 类型：1门店零售2渠道单位3速电网单4虚拟加盟店5加盟店
                if ($find_data->orbi_type == 1) {
                    if ($find_data->orbi_client_id) {
                        // 会员零售
                        $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                    } else {
                        // 临时会员
                        $checkvaluecode = config('apiu8cloud.custcode.temporary').$user_info->adm_shop_id.config('apiu8cloud.project.item').'0';
                    }
                } elseif ($find_data->orbi_type == 2) {
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.$find_data->orbi_client_id;
                } elseif ($find_data->orbi_type == 3) {
                    // 速电派单
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.'1';
                } elseif ($find_data->orbi_type == 4) {
                    $vish_chun_id = DB::table('virtual_shop')
                        ->where('vish_cid', $user_info->adm_cid)
                        ->where('vish_superior_shop_id', $shop_id)
                        ->where('vish_id', $find_data->orbi_client_id)
                        ->value('vish_chun_id');
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$vish_chun_id;
                } else {
                    $checkvaluecode = config('apiu8cloud.custcode.assignment').$user_info->adm_shop_id.$find_data->orbi_client_id;
                }

                $vou_hint = '【工单账单】流水号：'.$search_data['acset_number'].'工单账单单号：'.$search_data['acset_original_number'];

                if ($search_data['acset_inex_type'] == '1') {//收入
                    // 借：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码

                    // 贷：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                    if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                        // 借
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                    if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                        // 贷
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    }
                } else {//支出
                    // 借：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                    // 贷：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                    if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                        // 借
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                    if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                        // 贷
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    }
                }
                // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $vou_hint;//凭证摘要
                $vou_num++;
                break;
            case '4'://4.采购账单：收到钱核销单据时, 借：应付账款 贷：库存现金或银行存款
                $find_data = DB::table('order_bill')
                    ->where('orbi_shop_id', $user_info->adm_shop_id)
                    ->where('orbi_id', $search_data['acset_original_id'])
                    ->where('orbi_number', $search_data['acset_original_number'])
                    ->where('orbi_create_type', 5)
                    ->select('orbi_client_id', 'orbi_type')
                    ->first();
                // orbi_type 类型：1门店零售2渠道单位3速电网单4虚拟加盟店5加盟店
                if ($find_data->orbi_type == 1) {
                    if ($find_data->orbi_client_id) {
                        // 会员零售
                        $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                    } else {
                        // 临时会员
                        $checkvaluecode = config('apiu8cloud.custcode.temporary').$user_info->adm_shop_id.config('apiu8cloud.project.item').'0';
                    }
                } elseif ($find_data->orbi_type == 2) {
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->orbi_client_id;
                } elseif ($find_data->orbi_type == 3) {
                    // 速电派单
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                } elseif ($find_data->orbi_type == 4) {
                    $vish_chun_id = DB::table('virtual_shop')
                        ->where('vish_cid', $user_info->adm_cid)
                        ->where('vish_superior_shop_id', $shop_id)
                        ->where('vish_id', $find_data->orbi_client_id)
                        ->value('vish_chun_id');
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$vish_chun_id;
                }

                $vou_hint = '【采购账单】流水号：'.$search_data['acset_number'].'采购账单单号：'.$search_data['acset_original_number'];

                if ($search_data['acset_inex_type'] == '1') {//收入
                    // 借：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码

                    // 贷：应付账款
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：应付账款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                    if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                        // 借
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：主营业务成本
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                    if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                        // 贷
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                } else {//支出
                    // 借：应付账款
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：应付账款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                    // 贷：银行存款
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                    if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                        // 借
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：主营业务成本
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                    if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                        // 贷
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                }
                // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $vou_hint;//凭证摘要
                $vou_num++;
                break;
            case '6'://6.预收款,收款；借：银行存款    贷：应收账款
                $find_data = DB::table('receivable_credit')
                    ->where('recr_shop_id', $user_info->adm_shop_id)
                    ->where('recr_original_id', $search_data['acset_original_id'])
                    ->where('recr_original_number', $search_data['acset_original_number'])
                    ->select('recr_client_type', 'recr_client_id')
                    ->first();
                // recr_client_type 客户类型：1.会员零售 2.来往单位 3.外派门店（加盟店或总店） 4会员零售(工单代收）5接单门店（总店或加盟店）6速电派单
                if ($find_data->recr_client_type == 1 || $find_data->recr_client_type == 4) {
                    $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                } elseif ($find_data->recr_client_type == 2) {
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->recr_client_id;
                } elseif ($find_data->recr_client_type == 6) {
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                } elseif ($find_data->recr_client_type == 7) {
                    $vish_chun_id = DB::table('virtual_shop')
                        ->where('vish_cid', $user_info->adm_cid)
                        ->where('vish_superior_shop_id', $shop_id)
                        ->where('vish_id', $find_data->orbi_client_id)
                        ->value('vish_chun_id');
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$vish_chun_id;
                }
                $vou_hint = '【预收款】流水号：'.$search_data['acset_number'].'预收款单号：'.$search_data['acset_original_number'];
                $explanation = $vou_hint;
                // 借: 银行存款
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：银行存款
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码

                // 贷：应收账款
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：应收账款
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                    // 借
                    $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                    $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                    $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                }
                if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                    // 贷
                    $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                    $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                }

                // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                $vou_num++;
                break;
            case '9'://9.订单代收,借：库存现金或银行存款 贷：应收账款
                $find_data = DB::table('order')
                    ->where('ord_shop_id', $user_info->adm_shop_id)
                    ->where('ord_id', $search_data['acset_original_id'])
                    ->where('ord_order_number', $search_data['acset_original_number'])
                    ->select('ord_client_id', 'ord_type', 'ord_service_shop_id')
                    ->first();
                // ord_type 客户类型：1.会员零售 2.来往单位 3.外派门店（加盟店或总店） 4会员零售(工单代收）5接单门店（总店或加盟店）6速电派单
                if ($find_data->ord_type == 1 || $find_data->ord_type == 4) {
                    $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                } elseif ($find_data->ord_type == 2) {
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->ord_client_id;
                } elseif ($find_data->ord_type == 3 || $find_data->ord_type == 5) {
                    $checkvaluecode = config('apiu8cloud.custcode.assignment').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->ord_service_shop_id;
                } elseif ($find_data->ord_type == 6) {
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                }

                $vou_hint = '【订单代收】流水号：'.$search_data['acset_number'].'订单单号：'.$search_data['acset_original_number'];
                $explanation = $vou_hint;
                // 借:银行存款
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：银行存款
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                // 贷：应收账款
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：应收账款
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                    // 借
                    $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                    $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                    $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                }
                if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                    // 贷
                    $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                    $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                }

                // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                $vou_num++;
                break;
            case '11'://11.订单退款：退客户钱, 借：应收账款 贷：库存现金或银行存款
                $find_data = DB::table('order')
                    ->where('ord_shop_id', $user_info->adm_shop_id)
                    ->where('ord_id', $search_data['acset_original_id'])
                    ->where('ord_order_number', $search_data['acset_original_number'])
                    ->select('ord_client_id', 'ord_type')
                    ->first();
                // ord_type 买家类型：1门店零售2渠道单位3速电派单4第三方派单
                if ($find_data->ord_type == 1) {
                    if ($find_data->ord_client_id) {
                        // 会员零售
                        $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                    } else {
                        // 临时会员
                        $checkvaluecode = config('apiu8cloud.custcode.temporary').$user_info->adm_shop_id.config('apiu8cloud.project.item').'0';
                    }
                } elseif ($find_data->ord_type == 2) {
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->ord_client_id;
                } elseif ($find_data->ord_type == 3) {
                    // 速电派单
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                }

                $vou_hint = '【订单退款】流水号：'.$search_data['acset_number'].'订单单号：'.$search_data['acset_original_number'];
                // 借：应收账款
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：应收账款
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                // 贷：库存现金或银行存款
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] =  $find_acsl_data[0]['acsl_loan_subject'];//科目：库存现金或银行存款
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                    // 借
                    $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                    $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                    $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                }
                if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                    // 贷
                    $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                    $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                }

                // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $vou_hint;//凭证摘要
                $vou_num++;
                break;
            case '12'://12工单代收,收款；借：银行存款  贷：其他应付款-代收款项
                $find_data = DB::table('work_order as wo')
                    ->leftjoin('work_client as wc', 'wc.wocl_wor_id', '=', 'wo.wor_id')
                    ->where('wor_shop_id', $user_info->adm_shop_id)
                    ->where('wor_id', $search_data['acset_original_id'])
                    ->where('wor_number', $search_data['acset_original_number'])
                    ->select('wocl_client_id', 'wor_type', 'wor_service_shop_id', 'wocl_wor_type')
                    ->first();
                // wor_type 客户类型：1.会员零售 2.来往单位 3.外派门店（加盟店或总店） 4会员零售(工单代收）5接单门店（总店或加盟店）6速电派单
                if ($find_data->wor_type == 1 || $find_data->wor_type == 4) {
                    $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                } elseif ($find_data->wor_type == 2) {
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->wocl_client_id;
                } elseif ($find_data->wor_type == 3 || $find_data->wor_type == 5) {
                    $checkvaluecode = config('apiu8cloud.custcode.assignment').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->wor_service_shop_id;
                } elseif ($find_data->wor_type == 6) {
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                } elseif ($find_data->wor_type == 4) {
                    $vish_chun_id = DB::table('virtual_shop')
                        ->where('vish_cid', $user_info->adm_cid)
                        ->where('vish_superior_shop_id', $shop_id)
                        ->where('vish_id', $find_data->wor_service_shop_id)
                        ->value('vish_chun_id');
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$vish_chun_id;
                }

                $vou_hint = '【工单代收】流水号：'.$search_data['acset_number'].'工单单号：'.$search_data['acset_original_number'];
                $explanation = $vou_hint;

                // 借：应收账款
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：应收账款
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码

                // 贷：库存现金或银行存款
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] =  $find_acsl_data[0]['acsl_loan_subject'];//科目：库存现金或银行存款
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                    // 借
                    $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                    $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                    $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                }
                if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                    // 贷
                    $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                    $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                }

                // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                $vou_num++;
                break;
            case '13'://13订单完成后结算,收款；借：银行存款 贷：应收账款
                $find_data = DB::table('order')
                    ->where('ord_shop_id', $user_info->adm_shop_id)
                    ->where('ord_id', $search_data['acset_original_id'])
                    ->where('ord_order_number', $search_data['acset_original_number'])
                    ->select('ord_client_id', 'ord_type')
                    ->first();
                // ord_type 买家类型：1门店零售2渠道单位3速电派单4第三方派单
                if ($find_data->ord_type == 1) {
                    if ($find_data->ord_client_id) {
                        // 会员零售
                        $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                    } else {
                        // 临时会员
                        $checkvaluecode = config('apiu8cloud.custcode.temporary').$user_info->adm_shop_id.config('apiu8cloud.project.item').'0';
                    }
                } elseif ($find_data->ord_type == 2) {
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->ord_client_id;
                } elseif ($find_data->ord_type == 3) {
                    // 速电派单
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                }

                $vou_hint = '【订单完成后结算】流水号：'.$search_data['acset_number'].'订单单号：'.$search_data['acset_original_number'];

                if ($search_data['acset_inex_type'] == '1') {//收入
                    // 借：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码

                    // 贷：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                    if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                        // 借
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                    if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                        // 贷
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    }
                } else {//支出
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                    // 贷：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                    if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                        // 借
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                    if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                        // 贷
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    }
                }

                // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $vou_hint;//凭证摘要
                $vou_num++;
                break;
            case '18'://18工单结算-工单费用, 付款；借：应收账款 贷：银行存款
                $find_data = DB::table('work_order')
                    ->where('wor_shop_id', $user_info->adm_shop_id)
                    ->where('wor_id', $search_data['acset_original_id'])
                    ->where('wor_number', $search_data['acset_original_number'])
                    ->select('wor_service_shop_id')
                    ->first();
                // 客商，加盟店
                $checkvaluecode = config('apiu8cloud.custcode.assignment').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->wor_service_shop_id;

                $vou_hint = '【工单费用结算】流水号：'.$search_data['acset_number'].'工单单号：'.$search_data['acset_original_number'];

                // 借：应收账款
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：应收账款
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                // 贷：银行存款
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：银行存款
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $vou_hint;//凭证摘要
                $vou_num++;
                break;
            case '19'://19.旧货回收：收到钱核销单据时, 借：应收账款 贷：库存现金或银行存款
                $find_data = DB::table('junk_recycle as jur')
                    ->leftjoin('junk_client as jucl', 'jucl.jucl_jur_id', 'jur.jur_id')
                    ->where('jur_shop_id', $user_info->adm_shop_id)
                    ->where('jur_id', $search_data['acset_original_id'])
                    ->where('jur_number', $search_data['acset_original_number'])
                    ->select('jur_type', 'jucl_client_id')
                    ->first();
                // jur_type 买家类型 1.门店零售 2.来往单位 3加盟店
                if ($find_data->jur_type == 1) {
                    if ($find_data->jucl_client_id) {
                        // 会员零售
                        $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                    } else {
                        // 临时会员
                        $checkvaluecode = config('apiu8cloud.custcode.temporary').$user_info->adm_shop_id.config('apiu8cloud.project.item').'0';
                    }
                } elseif ($find_data->jur_type == 2) {
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->jucl_client_id;
                } elseif ($find_data->jur_type == 3) {
                    // 速电派单
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                }

                $vou_hint = '【旧货回收】流水号：'.$search_data['acset_number'].'旧货回收单号：'.$search_data['acset_original_number'];
                // 借：应收账款
                $voucher['voucher'][0]['details'][0]['detailindex'] = '2';//分录号
                $voucher['voucher'][0]['details'][0]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][0]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                $voucher['voucher'][0]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：应收账款
                $voucher['voucher'][0]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][0]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][0]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                // 贷：银行存款
                $voucher['voucher'][0]['details'][1]['detailindex'] = '1';//分录号
                $voucher['voucher'][0]['details'][1]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][0]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                $voucher['voucher'][0]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：银行存款
                $voucher['voucher'][0]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                $voucher['voucher'][0]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][0]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][0]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][0]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][0]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][0]['explanation'] = $vou_hint;//凭证摘要
                break;
            case '20'://20.售后单结算：收到钱核销单据时, 借：应收账款 贷：库存现金或银行存款
                $find_data = DB::table('order_after')
                    ->where('oraf_shop_id', $user_info->adm_shop_id)
                    ->where('oraf_id', $search_data['acset_original_id'])
                    ->where('oraf_number', $search_data['acset_original_number'])
                    ->select('oraf_type', 'oraf_client_id')
                    ->first();
                // oraf_type 买家类型：1门店零售2渠道单位3速电派单4第三方派单
                if ($find_data->oraf_type == 1) {
                    if ($find_data->oraf_client_id) {
                        // 会员零售
                        $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                    } else {
                        // 临时会员
                        $checkvaluecode = config('apiu8cloud.custcode.temporary').$user_info->adm_shop_id.config('apiu8cloud.project.item').'0';
                    }
                } elseif ($find_data->oraf_type == 2) {
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->oraf_client_id;
                } elseif ($find_data->oraf_type == 3) {
                    // 速电派单
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                }

                $vou_hint = '【售后单结算】流水号：'.$search_data['acset_number'].'售后单单号：'.$search_data['acset_original_number'];

                if ($search_data['acset_inex_type'] == '1') {//收入
                    // 借：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码

                    // 贷：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：应收账款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                    if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                        // 借
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                    if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                        // 贷
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    }
                } else {//支出
                    // 借：应收账款
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：应收账款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码

                    // 贷：银行存款
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额

                    if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                        // 借
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                    if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                        // 贷
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                        $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    }
                }
                // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $vou_hint;//凭证摘要
                $vou_num++;
                break;
            case '21'://21销售出库单
                /*
                    借：应收账款--客户
                    贷：主营业务收入
                    应交税费-应交增值税-销项税
                    借：主营业务成本
                    贷：库存商品
                 */

                $find_data = DB::table('sell')
                    ->where('sell_shop_id', $user_info->adm_shop_id)
                    ->where('sell_id', $search_data['acset_original_id'])
                    ->where('sell_number', $search_data['acset_original_number'])
                    ->select('sell_chun_id')
                    ->first();
                $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->sell_chun_id;

                $vou_hint = '【销售出库单】流水号：'.$search_data['acset_number'].'单号：'.$search_data['acset_original_number'];
                // 借：应收账款
                $voucher['voucher'][0]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][0]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                $voucher['voucher'][0]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][0]['details'][0]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][0]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                $voucher['voucher'][0]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：应收账款
                $voucher['voucher'][0]['details'][0]['pk_currtype'] = 'CNY';//币种编码

                // 贷：主营业务收入
                $voucher['voucher'][0]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][0]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                $voucher['voucher'][0]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][0]['details'][1]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][0]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                $voucher['voucher'][0]['details'][1]['pk_accsubj'] = '6001';//科目：主营业务收入
                $voucher['voucher'][0]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                $voucher['voucher'][0]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][0]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][0]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][0]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][0]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][0]['explanation'] = $vou_hint;//凭证摘要
                break;
            case '22'://22.采购单,借：应付账款-货款    贷：银行存款
                // 查询采购单数据，采购入库单确认
                $find_data = DB::table('purchase_order as po')
                    ->leftjoin('ware_inorder as wi', 'wi.cg_number', '=', 'po.cg_number')
                    ->where('rk_id', $search_data['acset_original_id'])
                    ->where('rk_number', $search_data['acset_original_number'])
                    ->first(['cg_supplyunit']);
                $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->cg_supplyunit;

                $vou_hint = '【采购入库付款】流水号：'.$search_data['acset_number'].'采购单单号：'.$search_data['acset_original_number'];
                $explanation = $vou_hint;
                // 借：应付账款
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币贷方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：应付账款
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                // 贷：银行存款
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币借方金额
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：银行存款
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                $vou_num++;
                break;
            case '23'://23.采购退货单,借：应付账款-货款    贷：银行存款
                // 查询采购单数据，采购入库单确认
                $find_data = DB::table('purchase_order as po')
                    ->leftjoin('ware_inorder as wi', 'wi.cg_number', '=', 'po.cg_number')
                    ->where('rk_id', $search_data['acset_original_id'])
                    ->where('rk_number', $search_data['acset_original_number'])
                    ->first(['cg_supplyunit']);
                $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->cg_supplyunit;

                // 借：应付账款-货款
                $vou_hint = '【采购退货单】流水号：'.$search_data['acset_number'].'采购退货单单号：'.$search_data['acset_original_number'];
                $explanation = $vou_hint;

                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币贷方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：应付账款-货款
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                // 贷：银行存款
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币借方金额
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：银行存款
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                $vou_num++;
                break;
            case '24'://24.采购款到发货,借：应付账款-货款    贷：银行存款
                // 查询采购单数据，采购入库单确认
                $find_data = DB::table('purchase_order')
                    ->where('cg_id', $search_data['acset_original_id'])
                    ->where('cg_number', $search_data['acset_original_number'])
                    ->first(['cg_supplyunit']);
                $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->cg_supplyunit;

                // 借：应付账款-货款
                $vou_hint = '【采购款到发货】流水号：'.$search_data['acset_number'].'采购款到发货单号：'.$search_data['acset_original_number'];
                $explanation = $vou_hint;

                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币贷方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];;//科目：应付账款-货款
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                // 贷：银行存款
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币借方金额
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：银行存款
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                if ($search_data['acset_zero_price'] != '0') {
                    if ($find_acsl_data[1]['acsl_borrow_price'] == '0' && $find_acsl_data[1]['acsl_borrow_subject_name'] == '' && $find_acsl_data[1]['acsl_loan_price'] == '0' && $find_acsl_data[1]['acsl_loan_subject_name'] == '') {
                        if ($find_acsl_data[2]['acsl_borrow_price'] != '0') {
                            // 借
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[2]['acsl_borrow_price'];//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[2]['acsl_borrow_subject'];//科目：应付账款-货款
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        }
                        if ($find_acsl_data[2]['acsl_loan_price'] != '0') {
                            // 贷
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[2]['acsl_loan_price'];//本币借方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[2]['acsl_loan_subject'];//科目：银行存款
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        }
                    } else {
                        if ($find_acsl_data[1]['acsl_borrow_price'] != '0') {
                            // 借
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        }
                        if ($find_acsl_data[1]['acsl_loan_price'] != '0') {
                            // 贷
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        }
                    }
                }

                // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                $vou_num++;
                break;
            case '25'://25.批量结算,借：应付账款-货款    贷：银行存款
                // 查询批量结算数据
                $find_data = DB::table('accounting_settlement')
                    ->where('acset_shop_id', $user_info->adm_shop_id)
                    ->where('acset_id', $search_data['acset_id'])
                    ->where('acset_number', $search_data['acset_number'])
                    ->where('acset_type', 25)
                    ->select('acset_client_type', 'acset_client_id')
                    ->first();
                if ($find_data->acset_client_type == 1 || $find_data->acset_client_type == 4) {
                    if ($find_data->acset_client_id) {
                        // 会员零售
                        $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                    } else {
                        // 临时会员
                        $checkvaluecode = config('apiu8cloud.custcode.temporary').$user_info->adm_shop_id.config('apiu8cloud.project.item').'0';
                    }
                } elseif ($find_data->acset_client_type == 2) {
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->acset_client_id;
                } elseif ($find_data->acset_client_type == 6 || $find_data->acset_client_type == 3) {
                    // 速电派单
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                } elseif ($find_data->acset_client_type == 7) {
                    // 客户单位
                    $vish_chun_id = DB::table('virtual_shop')
                        ->where('vish_cid', $user_info->adm_cid)
                        ->where('vish_superior_shop_id', $shop_id)
                        ->where('vish_id', $find_data->acset_client_id)
                        ->value('vish_chun_id');
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$vish_chun_id;
                } else {
                    $checkvaluecode = config('apiu8cloud.custcode.assignment').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->acset_client_id;
                }
                // 借：应付账款-货款
                $vou_hint = '【批量结算】流水号：'.$search_data['acset_number'].'批量结算单号：'.$search_data['acset_original_number'];
                $explanation = $vou_hint;

                if ($search_data['acset_id'] == '8508') {
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];
                    ;//科目：应付账款-货款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
    
                    // 贷：银行存款
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                    if ($find_acsl_data[1]['acsl_borrow_price'] != '0') {
                        // 借
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                    if ($find_acsl_data[1]['acsl_loan_price'] != '0') {
                        // 贷
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                    // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                    $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                    $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                    $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                    $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                    $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                    $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                    $vou_num++;
                } else {
                    if ($find_acsl_data[0]['acsl_borrow_subject'] == '220201') {
                        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];
                        ;//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                        $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
        
                        // 贷：银行存款
                        $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                        $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                        $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                        if ($find_acsl_data[0]['acsl_loan_subject'] == '1122') {
                            $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                            $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                        }
    
                        if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                            // 借
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        }
                        if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                            // 贷
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        }
                        // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                        $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                        $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                        $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                        $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                        $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                        $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                        $vou_num++;
                    } elseif ($find_acsl_data[0]['acsl_borrow_subject'] == '1122') {//借:应收账款
                        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];
                        ;//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                        if ($find_acsl_data[0]['acsl_borrow_subject'] == '1122' || $find_acsl_data[0]['acsl_borrow_subject'] == '600101') {
                            $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                            $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                        }
        
                        // 贷：银行存款
                        $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                        $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                        $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                        if ($find_acsl_data[0]['acsl_loan_subject'] == '1122' || $find_acsl_data[0]['acsl_loan_subject'] == '600101') {
                            $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                            $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                        }
    
                        if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                            // 借
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                            if ($find_acsl_data[1]['acsl_borrow_subject'] == '1122' || $find_acsl_data[1]['acsl_borrow_subject'] == '600101') {
                                $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                                $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                            }
                        }
                        if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                            // 贷
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                            if ($find_acsl_data[1]['acsl_loan_subject'] == '1122' || $find_acsl_data[1]['acsl_loan_subject'] == '600101') {
                                $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                                $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                            }
                        }
                        // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                        $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                        $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                        $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                        $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                        $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                        $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                        $vou_num++;
                    } else {
                        // 借：银行存款
                        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '2';//分录号
                        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                        if ($find_acsl_data[0]['acsl_borrow_subject'] == '600101') {
                            $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                            $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                        }
    
                        // 贷：应收账款
                        $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '1';//分录号
                        $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：应收账款
                        $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                        $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
    
                        if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                            // 借
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        }
                        if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                            // 贷
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                            $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                            $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                        }
                        // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                        $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                        $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                        $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                        $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                        $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                        $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                        $vou_num++;
                    }
                }
                break;
            case '26'://26.期初账单,借：应付账款-货款    贷：银行存款
                // 查询采期初账单数据
                $find_data = DB::table('order_bill')
                    ->where('orbi_shop_id', $user_info->adm_shop_id)
                    ->where('orbi_id', $search_data['acset_original_id'])
                    ->where('orbi_number', $search_data['acset_original_number'])
                    ->where('orbi_create_type', 4)
                    ->first(['orbi_type', 'orbi_client_id']);
                // 买家类型：1门店零售2渠道单位3速电网单4虚拟加盟店5加盟店
                if ($find_data->orbi_type == 1) {
                    if ($find_data->orbi_client_id) {
                        // 会员零售
                        $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                    } else {
                        // 临时会员
                        $checkvaluecode = config('apiu8cloud.custcode.temporary').$user_info->adm_shop_id.config('apiu8cloud.project.item').'0';
                    }
                } elseif ($find_data->orbi_type == 2) {
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->orbi_client_id;
                } elseif ($find_data->orbi_type == 3) {
                    // 速电派单
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                } elseif ($find_data->orbi_type == 4) {
                    $vish_chun_id = DB::table('virtual_shop')
                        ->where('vish_cid', $user_info->adm_cid)
                        ->where('vish_superior_shop_id', $shop_id)
                        ->where('vish_id', $find_data->orbi_client_id)
                        ->value('vish_chun_id');
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$vish_chun_id;
                } else {
                    $checkvaluecode = config('apiu8cloud.custcode.assignment').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->orbi_client_id;
                }
                
                // 借：应付账款-货款
                $vou_hint = '【期初账单】流水号：'.$search_data['acset_number'].'期初账单单号：'.$search_data['acset_original_number'];
                $explanation = $vou_hint;

                if ($find_acsl_data[0]['acsl_borrow_subject'] == '220201') {
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];
                    ;//科目：应付账款-货款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
    
                    // 贷：银行存款
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：银行存款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                    if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                        // 借
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                    if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                        // 贷
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                    }
                } else {
                    if ($find_acsl_data[0]['acsl_borrow_subject'] == '1122') {
                        // 借: 应收账款
                        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                        $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
    
                        // 贷：银行存款
                        $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                        $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                        $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                        if ($find_acsl_data[0]['acsl_loan_subject'] == '600101') {
                            $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                            $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                        }
                    } else {
                        // 借: 应收账款
                        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_acsl_data[0]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_acsl_data[0]['acsl_borrow_subject'];//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                        if ($find_acsl_data[0]['acsl_borrow_subject'] == '600101') {
                            $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                            $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                        }
    
                        // 贷：银行存款
                        $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                        $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                        $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_acsl_data[0]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_acsl_data[0]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                        $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    }
                    if (!empty($find_acsl_data[1]['acsl_borrow_price']) != '0') {
                        // 借
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $explanation;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $find_acsl_data[1]['acsl_borrow_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_borrow_subject'];//科目：应付账款-货款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        if ($find_acsl_data[1]['acsl_borrow_subject'] == '600101') {
                            $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                            $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                        }
                    }
                    if (!empty($find_acsl_data[1]['acsl_loan_price']) != '0') {
                        // 贷
                        $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                        $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $explanation;//摘要
                        $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_acsl_data[1]['acsl_loan_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_acsl_data[1]['acsl_loan_subject'];//科目：银行存款
                        $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        if ($find_acsl_data[1]['acsl_loan_subject'] == '600101') {
                            $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                            $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                        }
                    }
                }

                // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                $vou_num++;
                break;
            default:
                return ['code'=> 500, 'msg'=>'error', 'vou_data'=>'', 'data'=>'U8财务系统上传失败！'];
                break;
        }
        if ($user_info->adm_id == '1') {
            dump($voucher);
            // exit;
        }
        // 调用u8系统接口
        $curl_return = $yongyou->u8cloudApi('凭证新增', $voucher);
        if ($user_info->adm_id == '1') {
            // dump($voucher);
            // exit;
            dump($curl_return);
            exit;
        }
        // 判断用友接口返回的数据
        if ($curl_return['status'] != 'success') {
            self::logRecord(5041, $user_info, $voucher, $curl_return);//保存操作日志
            // 如果凭证添加失败，凭证号自动加1
            $vou_data['vou_voucher_id'] = 0;//凭证所对应的id：工单id
            $vou_data['vou_voucher_type'] = 0;//类型：1采购入库2工单审核
            $vou_data['vou_no'] = $find_voucher->vou_no + 1;//凭证号
            // self::insertVoucher($user_info, $vou_data, $now_date, 1);
            return ['code'=> 500, 'msg'=>'error', 'vou_data'=>$vou_data, 'data'=>'U8财务系统凭证上传失败1！'];
        }

        // 添加用友上传凭证的记录
        $vou_info['vou_voucher_id'] = $vou_voucher_id;//凭证所对应的id：采购单id/工单id/结款明细id
        $vou_info['vou_voucher_number'] = $vou_voucher_number;//凭证对应的单号：流水号
        $vou_info['vou_voucher_record_number'] = $search_data['acset_original_number'];//原始单号
        $vou_info['vou_voucher_type'] = 3;//凭证所对应的id：采购单id/工单id/结款明细id
        $vou_info['vou_no'] = $find_voucher->vou_no + 1;//凭证号
        self::insertVoucher($user_info, $vou_info, $now_date, 1);
        return ['code'=>200, 'msg'=>'success', 'data'=>'U8财务系统凭证上传成功！'];
    }

    /**
     * [apiWorkOrder 凭证列表上传凭证]
     * @param  [array] $user_info       [用户信息]
     * @param  [array] $find_wor        [工单信息]
     * @param  [array] $request_voucher [凭证需要的信息]
     * @return [type]                  [description]
     */
    public static function apiWorkOrder($user_info, $vore_data, $find_volo_data, $now_date)
    {
        // 调用u8系统接口，将凭证数据传到用友系统上，需要传的凭证
        /*
            销售商品的税率是13%  所以税金的计算=含税收入/（1+13%）*13%
            假如订单销售金额300，成本200
                凭证一：不含增值税
                    借：应收账款--客户   300
                    贷：主营业务收入     300
                凭证一：含增值税
                    借：应收账款--客户   300
                    贷：主营业务收入  300/1.13  265.4867
                        应交税费-应交增值税-销项税   300/1.13*0.13    34.5132
                凭证二：
                    借：主营业务成本  200
                    贷：库存商品    200
            退货时 做相反的销售出库分录。
            换货视同先退原商品再发新商品。

            工单费用：总店把订单派给加盟店，加盟店完成订单之后跟加盟店的结算的钱
            总店付款时：借：应付账款
                        贷：银行存款
         */
        $yongyou = new YongYouController;
        // 获取门店对应用友系统的配置数据
        $unitcode = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['unitcode'];//用友-公司编码
        $subjschemecode  = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['subjschemecode'];//用友-科目方案编码
        $sell_tax  = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['SHOP_TAX']['sell'];//销售出库是否含税：1不含税2含税
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 各门店的主营业务收入
        $main_business_income = [
            // 门店id=>用友科目编码
            1=>'600101',//主营业务收入销售收入
            2=>'6001',
            26=>'6001',
        ];
        // 各门店的成本：库存商品
        $inventory_cost = [
            // 门店id=>用友科目编码
            1=>'140501',//主营业务收入销售收入
            2=>'1405',//库存商品
            26=>'1405',
        ];

        // 各门店的主营业务成本：主营业务成本
        $main_business_cost = [
            // 门店id=>用友科目编码
            1=>'640102',//主营业务成本手工凭证录入
            2=>'6401',//主营业务成本
            26=>'6401',
        ];

        // 查找凭证号
        $find_voucher = self::findVoucher($user_info, $now_date);
        // 获取制单日期
        $date = $now_date;
        switch ($vore_data['vore_order_type']) {
            case '1'://订单
                // 判断客户类型，用友客商的对象
                $find_data = DB::table('order as ord')
                    ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                    ->where('ord_id', $vore_data['vore_ord_id'])
                    ->where('ord_order_number', $vore_data['vore_ord_number'])
                    ->select('ord_service_shop_id', 'ord_type', 'ord_client_id', 'orcl_shipment_party', 'ord_form_type')
                    ->first();
                if ($find_data->ord_type == 1) {
                    if ($find_data->ord_client_id) {
                        // 会员零售
                        $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                    } else {
                        // 临时会员
                        $checkvaluecode = config('apiu8cloud.custcode.temporary').$user_info->adm_shop_id.config('apiu8cloud.project.item').'0';
                    }
                } elseif ($find_data->ord_type == 2) {
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->ord_client_id;
                } elseif ($find_data->ord_type == 3) {
                    // 速电派单
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                }

                $receivable_hint = '【订单销售】订单单号：';
                $cost_hint = '【销售成本】订单单号：';

                $number = $vore_data['vore_ord_number'];//订单单号

                $vou_num = 0;//凭证个数
                $vou_nums = 0;

                if ($find_volo_data[0]['volo_borrow_subject'] == '1122') {
                    // 判断成本金额是否为0，不为0的生成凭证，为0，不生成凭证
                    if (!empty(abs($find_volo_data[0]['volo_borrow_price']))) {
                        // 借：应收账款--客户
                        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $receivable_hint.$number;//摘要
                        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_volo_data[0]['volo_borrow_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_volo_data[0]['volo_borrow_subject'];//借：科目 应收账款
                        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                        $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                        if (!empty($find_volo_data[1]['volo_borrow_price']) != '0') {
                            // 借：库存商品
                            $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                            $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][1]['localdebitamount'] = $find_volo_data[1]['volo_borrow_price'];//本币借方金额
                            $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[1]['volo_borrow_subject'];//借：科目 库存商品
                            $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                            // 贷：主营业务收入
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_volo_data[0]['volo_loan_price'];//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_volo_data[0]['volo_loan_subject'];//贷：科目 主营业务收入
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                            if ($find_volo_data[0]['volo_loan_subject'] == '600101') {
                                $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                                $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                            }
                        } else {
                            // 贷：主营业务收入
                            $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                            $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_volo_data[0]['volo_loan_price'];//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[0]['volo_loan_subject'];//贷：科目 主营业务收入
                            $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                            if ($find_volo_data[0]['volo_loan_subject'] == '600101') {
                                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                            }
                        }
    
                        $loan_money = $find_volo_data[0]['volo_loan_price'];//主营业务收入
                        // 销售出库是否含税：1不含税2含税
                        if ($sell_tax == 2) {
                            // 销售商品的税率是13%  所以税金的计算=含税收入/（1+13%）*13%
                            $loan_main_money = round($loan_money / 1.13, 2);
                            $loan_tax_money = $loan_money - $loan_main_money;//应交税费
    
                            $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $loan_main_money;//本币贷方金额，
    
                            // 贷：应交税费
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $loan_tax_money;//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = '2221';//科目，贷：应交税费
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        } else {
                            $loan_main_money = $loan_money;
                        }


                        // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                        $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                        $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                        $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                        $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                        $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                        $voucher['voucher'][$vou_num]['explanation'] = $receivable_hint.$number;//凭证摘要
                        $vou_num++;
                        $vou_nums++;
                    }
    
                    // 判断成本金额是否为0，不为0的生成凭证，外派订单的成本为0，不生成凭证
                    if (!empty(abs($find_volo_data[0]['volo_borrow_costing']))) {
                        // 借：主营业务成本
                        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $cost_hint.$number;//摘要
                        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_volo_data[0]['volo_borrow_costing'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_volo_data[0]['volo_borrow_costing_subject'];//科目，借：主营业务成本
                        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                        // 贷：库存商品
                        $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                        $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $cost_hint.$number;//摘要
                        $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_volo_data[0]['volo_loan_costing'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[0]['volo_loan_costing_subject'];//科目，贷：库存商品
                        $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
    
                        // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                        $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                        $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                        $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                        $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                        $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                        $voucher['voucher'][$vou_num]['explanation'] =$cost_hint.$number;//凭证摘要
                        $vou_num++;
                    }
                } else {
                    // 判断成本金额是否为0，不为0的生成凭证，为0，不生成凭证
                    if (!empty(abs($find_volo_data[0]['volo_borrow_price']))) {
                        // 借：主营业务收入
                        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $receivable_hint.$number;//摘要
                        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_volo_data[0]['volo_borrow_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_volo_data[0]['volo_borrow_subject'];//借：科目 主营业务收入
                        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                        if ($find_volo_data[0]['volo_borrow_subject'] == '600101' && !empty(abs($find_volo_data[0]['volo_borrow_price']))) {
                            $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                            $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                        }

                        if (!empty($find_volo_data[1]['volo_borrow_price']) != '0') {
                            // 借：库存商品
                            $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                            $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][1]['localdebitamount'] = $find_volo_data[1]['volo_borrow_price'];//本币借方金额
                            $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[1]['volo_borrow_subject'];//借：科目 库存商品
                            $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                            // 贷：应收账款
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_volo_data[0]['volo_loan_price'];//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_volo_data[0]['volo_loan_subject'];//贷：科目 应收账款
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                            $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                            $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                        } else {
                            // 贷：应收账款
                            $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                            $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_volo_data[0]['volo_loan_price'];//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[0]['volo_loan_subject'];//贷：科目 应收账款
                            $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                            $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                            $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                            if (!empty($find_volo_data[1]['volo_loan_price'])) {
                                // 贷：
                                $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                                $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $receivable_hint.$number;//摘要
                                $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_volo_data[1]['volo_loan_price'];//本币贷方金额
                                $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_volo_data[1]['volo_loan_subject'];//贷：科目 应收账款
                                $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                                if ($find_volo_data[1]['volo_loan_subject'] == '600101' || $find_volo_data[1]['volo_loan_subject'] == '1122') {
                                    $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                                    $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                                }
                            }
                        }

                        $loan_money = $find_volo_data[0]['volo_borrow_price'];//主营业务收入
                        // 销售出库是否含税：1不含税2含税
                        if ($sell_tax == 2) {
                            // 销售商品的税率是13%  所以税金的计算=含税收入/（1+13%）*13%
                            $loan_main_money = round($loan_money / 1.13, 2);
                            $loan_tax_money = $loan_money - $loan_main_money;//应交税费
    
                            $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $loan_main_money;//本币贷方金额，
    
                            // 贷：应交税费
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $loan_tax_money;//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = '2221';//科目，贷：应交税费
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        } else {
                            $loan_main_money = $loan_money;
                        }
    
                        // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                        $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                        $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                        $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                        $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                        $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                        $voucher['voucher'][$vou_num]['explanation'] = $receivable_hint.$number;//凭证摘要
                        $vou_num++;
                        $vou_nums++;
                    }

                    // 判断成本金额是否为0，不为0的生成凭证，外派订单的成本为0，不生成凭证
                    if (!empty(abs($find_volo_data[0]['volo_borrow_costing']))) {
                        // 借：主营业务成本
                        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $cost_hint.$number;//摘要
                        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_volo_data[0]['volo_borrow_costing'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_volo_data[0]['volo_borrow_costing_subject'];//科目，借：主营业务成本
                        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                        // 贷：库存商品
                        $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                        $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $cost_hint.$number;//摘要
                        $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_volo_data[0]['volo_loan_costing'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[0]['volo_loan_costing_subject'];//科目，贷：库存商品
                        $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
    
                        // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                        $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                        $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                        $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                        $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                        $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                        $voucher['voucher'][$vou_num]['explanation'] =$cost_hint.$number;//凭证摘要
                        $vou_num++;
                        $vou_nums++;
                    }
                }
                break;
            case '2'://工单
                // 判断客户类型，用友客商的对象
                // 根据单号查询单位类型
                $find_data = DB::table('work_order as wor')
                    ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                    ->where('wor_id', $vore_data['vore_wor_id'])
                    ->where('wor_number', $vore_data['vore_wor_number'])
                    ->select('wor_service_shop_id', 'wor_type', 'wocl_client_id', 'wocl_wor_type')
                    ->first();
                if ($find_data->wocl_wor_type == '1') {//系统工单
                    if ($find_data->wor_type == 1) {
                        if ($find_data->wocl_client_id) {
                            // 会员零售
                            $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                        } else {
                            // 临时会员
                            $checkvaluecode = config('apiu8cloud.custcode.temporary').$user_info->adm_shop_id.config('apiu8cloud.project.item').'0';
                        }
                    } elseif ($find_data->wor_type == 2) {
                        // 客户单位
                        $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->wocl_client_id;
                    }
                } elseif ($find_data->wocl_wor_type == '3') {//速电派单
                    // 速电派单
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.config('apiu8cloud.project.item').'1';
                } elseif ($find_data->wocl_wor_type == '4') {
                    // 虚拟加盟店
                    $vish_chun_id = DB::table('virtual_shop')
                        ->where('vish_cid', $user_info->adm_cid)
                        ->where('vish_superior_shop_id', $shop_id)
                        ->where('vish_id', $find_data->wor_service_shop_id)
                        ->value('vish_chun_id');
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$vish_chun_id;
                }
                $receivable_hint = '【工单销售】工单单号：';
                $cost_hint = '【销售成本】工单单号：';

                $number = $vore_data['vore_wor_number'];//工单单号

                $vou_num = 0;//凭证个数
                $vou_nums = 0;

                if ($find_volo_data[0]['volo_borrow_subject'] == '1122') {
                    // 判断业务凭证金额是否为0，不为0的生成凭证，为0，不生成凭证
                    if (!empty(abs($find_volo_data[0]['volo_borrow_price']))) {
                        // 借：应收账款--客户
                        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $receivable_hint.$number;//摘要
                        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_volo_data[0]['volo_borrow_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_volo_data[0]['volo_borrow_subject'];//借：科目 应收账款
                        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                        $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                        $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                        if (!empty($find_volo_data[1]['volo_borrow_price']) != '0') {
                            // 借：库存商品
                            $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                            $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][1]['localdebitamount'] = $find_volo_data[1]['volo_borrow_price'];//本币借方金额
                            $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[1]['volo_borrow_subject'];//借：科目 库存商品
                            $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                            // 贷：主营业务收入
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_volo_data[0]['volo_loan_price'];//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_volo_data[0]['volo_loan_subject'];//贷：科目 主营业务收入
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                            if ($find_volo_data[0]['volo_loan_subject'] == '600101') {
                                $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                                $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                            }
                        } else {
                            // 贷：主营业务收入
                            $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                            $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_volo_data[0]['volo_loan_price'];//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[0]['volo_loan_subject'];//贷：科目 主营业务收入
                            $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                            if ($find_volo_data[0]['volo_loan_subject'] == '600101') {
                                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                            }
                        }
    
                        $loan_money = $find_volo_data[0]['volo_loan_price'];//主营业务收入
                        // 销售出库是否含税：1不含税2含税
                        if ($sell_tax == 2) {
                            // 销售商品的税率是13%  所以税金的计算=含税收入/（1+13%）*13%
                            $loan_main_money = round($loan_money / 1.13, 2);
                            $loan_tax_money = $loan_money - $loan_main_money;//应交税费
    
                            $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $loan_main_money;//本币贷方金额，
    
                            // 贷：应交税费
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $loan_tax_money;//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = '2221';//科目，贷：应交税费
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        } else {
                            $loan_main_money = $loan_money;
                        }
                        
                        // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                        $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                        $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                        $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                        $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                        $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                        $voucher['voucher'][$vou_num]['explanation'] = $receivable_hint.$number;//凭证摘要
                        $vou_num++;
                        $vou_nums++;
                    }
                    // 借：应收账款 0，借：库存商品 金额>0，贷：主营业务收入
                    if (empty(abs($find_volo_data[0]['volo_borrow_price'])) && !empty($find_volo_data[1]['volo_borrow_price']) != '0') {
                        // 借：库存商品
                        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $receivable_hint.$number;//摘要
                        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_volo_data[1]['volo_borrow_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_volo_data[1]['volo_borrow_subject'];//借：科目 库存商品
                        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                        // 贷：主营业务收入
                        $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                        $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $receivable_hint.$number;//摘要
                        $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_volo_data[0]['volo_loan_price'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[0]['volo_loan_subject'];//贷：科目 主营业务收入
                        $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                        if ($find_volo_data[0]['volo_loan_subject'] == '600101') {
                            $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                            $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                        }
    
                        $loan_money = $find_volo_data[0]['volo_loan_price'];//主营业务收入
                        // 销售出库是否含税：1不含税2含税
                        if ($sell_tax == 2) {
                            // 销售商品的税率是13%  所以税金的计算=含税收入/（1+13%）*13%
                            $loan_main_money = round($loan_money / 1.13, 2);
                            $loan_tax_money = $loan_money - $loan_main_money;//应交税费
    
                            $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $loan_main_money;//本币贷方金额，
    
                            // 贷：应交税费
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $loan_tax_money;//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = '2221';//科目，贷：应交税费
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        } else {
                            $loan_main_money = $loan_money;
                        }
                        
                        // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                        $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                        $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                        $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                        $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                        $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                        $voucher['voucher'][$vou_num]['explanation'] = $receivable_hint.$number;//凭证摘要
                        $vou_num++;
                        $vou_nums++;
                    }
                    // 判断结转成本金额是否为0，不为0的生成凭证，外派订单的成本为0，不生成凭证
                    if (!empty(abs($find_volo_data[0]['volo_borrow_costing']))) {
                        // 借：主营业务成本
                        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $cost_hint.$number;//摘要
                        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_volo_data[0]['volo_borrow_costing'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_volo_data[0]['volo_borrow_costing_subject'];//科目，借：主营业务成本
                        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                        // 贷：库存商品
                        $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                        $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $cost_hint.$number;//摘要
                        $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_volo_data[0]['volo_loan_costing'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[0]['volo_loan_costing_subject'];//科目，贷：库存商品
                        $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
    
                        // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                        $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                        $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                        $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                        $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                        $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                        $voucher['voucher'][$vou_num]['explanation'] =$cost_hint.$number;//凭证摘要
                        $vou_num++;
                        $vou_nums++;
                    }
                } else {
                    // 判断成本金额是否为0，不为0的生成凭证，为0，不生成凭证
                    if (!empty(abs($find_volo_data[0]['volo_borrow_price']))) {
                        // 借：主营业务收入
                        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $receivable_hint.$number;//摘要
                        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_volo_data[0]['volo_borrow_price'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_volo_data[0]['volo_borrow_subject'];//借：科目 主营业务收入
                        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                        if ($find_volo_data[0]['volo_borrow_subject'] == '600101') {
                            $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                            $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                        }
                        if (!empty($find_volo_data[1]['volo_borrow_price']) != '0') {
                            // 借：库存商品
                            $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                            $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][1]['localdebitamount'] = $find_volo_data[1]['volo_borrow_price'];//本币借方金额
                            $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[1]['volo_borrow_subject'];//借：科目 库存商品
                            $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                            // 贷：应收账款
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_volo_data[0]['volo_loan_price'];//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_volo_data[0]['volo_loan_subject'];//贷：科目 应收账款
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                            $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                            $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                        } else {
                            // 贷：应收账款
                            $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                            $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_volo_data[0]['volo_loan_price'];//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[0]['volo_loan_subject'];//贷：科目 应收账款
                            $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                            $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                            $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                            if (!empty($find_volo_data[1]['volo_loan_price'])) {
                                // 贷：
                                $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                                $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $receivable_hint.$number;//摘要
                                $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $find_volo_data[1]['volo_loan_price'];//本币贷方金额
                                $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = $find_volo_data[1]['volo_loan_subject'];//贷：科目 应收账款
                                $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                                if ($find_volo_data[1]['volo_loan_subject'] == '600101' || $find_volo_data[1]['volo_loan_subject'] == '1122') {
                                    $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                                    $voucher['voucher'][$vou_num]['details'][2]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                                }
                            }
                        }
    
                        $loan_money = $find_volo_data[0]['volo_borrow_price'];//主营业务收入
                        // 销售出库是否含税：1不含税2含税
                        if ($sell_tax == 2) {
                            // 销售商品的税率是13%  所以税金的计算=含税收入/（1+13%）*13%
                            $loan_main_money = round($loan_money / 1.13, 2);
                            $loan_tax_money = $loan_money - $loan_main_money;//应交税费
    
                            $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $loan_main_money;//本币贷方金额，
    
                            // 贷：应交税费
                            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $receivable_hint.$number;//摘要
                            $voucher['voucher'][$vou_num]['details'][2]['localdebitamount'] = $loan_tax_money;//本币贷方金额
                            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = '2221';//科目，贷：应交税费
                            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                        } else {
                            $loan_main_money = $loan_money;
                        }
                        
                        // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                        $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                        $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                        $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                        $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                        $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                        $voucher['voucher'][$vou_num]['explanation'] = $receivable_hint.$number;//凭证摘要
                        $vou_num++;
                    }
                    // 判断成本金额是否为0，不为0的生成凭证，外派订单的成本为0，不生成凭证
                    if (!empty(abs($find_volo_data[0]['volo_borrow_costing']))) {
                        // 借：主营业务成本
                        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $cost_hint.$number;//摘要
                        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_volo_data[0]['volo_borrow_costing'];//本币借方金额
                        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_volo_data[0]['volo_borrow_costing_subject'];//科目，借：主营业务成本
                        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                        // 贷：库存商品
                        $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                        $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $cost_hint.$number;//摘要
                        $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_volo_data[0]['volo_loan_costing'];//本币贷方金额
                        $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[0]['volo_loan_costing_subject'];//科目，贷：库存商品
                        $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
    
                        // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                        $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                        $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                        $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                        $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                        $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                        $voucher['voucher'][$vou_num]['explanation'] =$cost_hint.$number;//凭证摘要
                        $vou_num++;
                        $vou_nums++;
                    }
                }
                break;
            case '3'://采购单
                // 根据采购单id,查询对应的入库单号
                $find_rk_number = DB::table('ware_inorder')
                    ->where('company_id', $user_info->adm_cid)
                    ->where('rk_superior_shop_id', $user_info->adm_shop_id)
                    ->where('rk_shop_id', $user_info->adm_shop_id)
                    ->where('cg_number', $vore_data['vore_ord_number'])
                    ->select('rk_number')
                    ->first();
                $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$vore_data['vore_client_id'];

                $vou_hint = '【采购入库】采购单号：';//提示文字
                $vou_hint2 = '入库单号:';//提示文字
                $explanation = $vou_hint.$vore_data['vore_ord_number'];//摘要
                $vou_voucher_id = isset($vore_data['vore_ord_id']) ? $vore_data['vore_ord_id'] : 0;//凭证所对应的id：采购单id/工单id
                $vou_voucher_number = $vore_data['vore_ord_number'];//凭证对应的单号：采购单号

                $details_explanation = $explanation.$vou_hint2.$find_rk_number->rk_number;//分录摘要

                $vou_num = 0;//凭证个数

                // 查找凭证号
                $find_voucher = self::findVoucher($user_info, $now_date);
                // 判断成本金额是否为0，不为0的生成凭证，为0，不生成凭证
                if (!empty(abs($find_volo_data[0]['volo_borrow_price']))) {
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $details_explanation;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_volo_data[0]['volo_borrow_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_volo_data[0]['volo_borrow_subject'];//科目：库存商品
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
    
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $details_explanation;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_volo_data[0]['volo_loan_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[0]['volo_loan_subject'];//科目：应付账款-货款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
    
                    // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                    $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                    $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                    $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                    $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                    $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                    $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                    $vou_num++;
                }
                break;
            case '5'://采购退货单
                // 根据采购单id,查询对应的入库单号
                $find_rk_number = DB::table('ware_inorder')
                    ->where('company_id', $user_info->adm_cid)
                    ->where('rk_superior_shop_id', $user_info->adm_shop_id)
                    ->where('rk_shop_id', $user_info->adm_shop_id)
                    ->where('cg_number', $vore_data['vore_ord_number'])
                    ->select('rk_number')
                    ->first();
                // 判断客户类型，用友客商的对象
                $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$vore_data['vore_client_id'];

                $vou_hint = '【退货】采购单号：';
                $vou_hint2 = '退货单号：';//提示文字
                $explanation = $vou_hint.$vore_data['vore_ord_number'];//摘要
                $vou_voucher_number = $vore_data['vore_ord_number'];//凭证对应的单号：采购单号
                $vou_voucher_id = $vore_data['vore_ord_id'];//凭证所对应的id：采购单id/工单id

                $details_explanation = $explanation.$vou_hint2.$find_rk_number->rk_number;//分录摘要

                $vou_num = 0;//凭证个数

                // 查找凭证号
                $find_voucher = self::findVoucher($user_info, $now_date);
                if (!empty(abs($find_volo_data[0]['volo_borrow_price']))) {
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $details_explanation;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_volo_data[0]['volo_borrow_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_volo_data[0]['volo_borrow_subject'];//科目：库存商品
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
    
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $details_explanation;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_volo_data[0]['volo_loan_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[0]['volo_loan_subject'];//科目：应付账款-货款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
    
                    // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                    $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                    $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                    $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                    $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                    $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                    $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                    $vou_num++;
                }
                break;
            case '6'://盘库单
                $vou_hint = '【盘库单】盘库单号：';//提示文字
                $explanation = $vou_hint.$vore_data['vore_ord_number'];//摘要

                $vou_num = 0;//凭证个数

                // 查找凭证号
                $find_voucher = self::findVoucher($user_info, $now_date);
                if (!empty(abs($find_volo_data[0]['volo_borrow_price']))) {
                    $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                    $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                    $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $find_volo_data[0]['volo_borrow_price'];//本币借方金额
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $find_volo_data[0]['volo_borrow_subject'];//科目：库存商品
                    $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
    
                    $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                    $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $find_volo_data[0]['volo_loan_price'];//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $find_volo_data[0]['volo_loan_subject'];//科目：应付账款-货款
                    $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
    
                    // $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                    $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                    $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                    $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                    $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                    $voucher['voucher'][$vou_num]['prepareddate'] = $date;//制单日期
                    $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                    $vou_num++;
                }
                break;
            default:
                return ['code'=> 500, 'msg'=>'error', 'vou_data'=>'', 'data'=>'U8财务系统上传失败！'];
                break;
        }
         
        if (empty($voucher)) {
            return ['code'=>200, 'msg'=>'success', 'data'=>''];
        }
        if ($user_info->adm_id == '1') {
            dump($voucher);
            // exit;
        }
        // 调用u8系统接口
        $curl_return = $yongyou->u8cloudApi('凭证新增', $voucher);
        if ($user_info->adm_id == '1') {
            dump($curl_return);
            exit;
        }
        // 判断用友接口返回的数据
        if ($curl_return['status'] != 'success') {
            self::logRecord(5031, $user_info, $voucher, $curl_return);//保存操作日志
            // 如果凭证添加失败，凭证号自动加1
            $vou_data['vou_voucher_id'] = 0;//凭证所对应的id：工单id
            $vou_data['vou_voucher_type'] = 0;//类型：1采购入库2工单审核
            $vou_data['vou_no'] = $find_voucher->vou_no + 1;//凭证号
            // self::insertVoucher($user_info, $vou_data, $now_date, 1);
            return ['code'=> 500, 'msg'=>'error', 'vou_data'=>$vou_data, 'data'=>'U8财务系统凭证上传失败！'];
        }

        // 添加用友上传凭证的记录
        for ($i=0; $i < $vou_num; $i++) {
            // 添加用友上传凭证的记录
            $vou_data[$i]['vou_cid'] = $user_info->adm_cid;
            $vou_data[$i]['vou_shop_id'] = $user_info->adm_shop_id;
            if ($vore_data['vore_order_type'] == '1') {
                $vou_data[$i]['vou_voucher_id'] = $vore_data['vore_ord_id'];//凭证所对应的id：订单id
                $vou_data[$i]['vou_voucher_number'] = $vore_data['vore_ord_number'];//凭证对应的单号：订单单号
                $vou_data[$i]['vou_voucher_type'] = 1;//类型：1订单
            } elseif ($vore_data['vore_order_type'] == '2') {
                $vou_data[$i]['vou_voucher_id'] = $vore_data['vore_wor_id'];//凭证所对应的id：工单id
                $vou_data[$i]['vou_voucher_number'] = $vore_data['vore_wor_number'];//凭证对应的单号：工单单号
                $vou_data[$i]['vou_voucher_type'] = 2;//类型：2工单
            } elseif ($vore_data['vore_order_type'] == '3') {
                $vou_data[$i]['vou_voucher_id'] = $vore_data['vore_ord_id'];//凭证所对应的id：工单id
                $vou_data[$i]['vou_voucher_number'] = $vore_data['vore_ord_number'];//凭证对应的单号：工单单号
                $vou_data[$i]['vou_voucher_type'] = 3;//类型：3采购单
            } elseif ($vore_data['vore_order_type'] == '5') {
                $vou_data[$i]['vou_voucher_id'] = $vore_data['vore_ord_id'];//凭证所对应的id：工单id
                $vou_data[$i]['vou_voucher_number'] = $vore_data['vore_ord_number'];//凭证对应的单号：工单单号
                $vou_data[$i]['vou_voucher_type'] = 5;//类型：5采购退货单
            } elseif ($vore_data['vore_order_type'] == '6') {
                $vou_data[$i]['vou_voucher_id'] = $vore_data['vore_ord_id'];//凭证所对应的id：工单id
                $vou_data[$i]['vou_voucher_number'] = $vore_data['vore_ord_number'];//凭证对应的单号：工单单号
                $vou_data[$i]['vou_voucher_type'] = 6;//类型：6盘库单
            }
            $vou_data[$i]['vou_no'] = $find_voucher->vou_no + $i + 1;//凭证号
        }
        self::insertVoucher($user_info, $vou_data, $now_date, 2);
        return ['code'=>200, 'msg'=>'success', 'data'=>'U8财务系统凭证上传成功！'];
    }

    /**
     * [logRecord 日志]
     * @param  [type] $code      [返回码-错误码]
     * @param  [type] $user_info       [用户信息]
     * @param  [type] $search_data     [单据信息/上传凭证数据]
     * @param  [type] $request_voucher [凭证相关信息/接口返回数据]
     * @return [type]                  [description]
     */
    protected static function logRecord($code, $user_info, $search_data, $request_voucher)
    {
        // 返回码对应的信息
        $code_message = [
            '2001'=>'金额为0，U8财务系统无法上传凭证！',
            '2002'=>'其他类型，无法上传凭证！',
            '5001'=>'采购单款到发货，上传凭证失败',
            '5011'=>'采购入库，上传凭证失败',
            '5021'=>'U8财务系统凭证作废失败！',
            '5031'=>'工单审核，上传凭证失败！',
            '5032'=>'工单审核，速电网单上传凭证失败！',
            '5033'=>'速电对账，上传凭证失败！',
            '5041'=>'结款明细，上传凭证失败！',
            '0'=>'临时测试',
        ];

        $log_data['time'] = date('Y-m-d H:i:s');
        $log_data['code'] = $code;
        $log_data['code_message'] = $code_message[$code];
        $log_data['user_info'] = $user_info;
        $log_data['search_data'] = $search_data;
        $log_data['request_voucher'] = $request_voucher;
        logRecord($log_data, 'u8cloudApi_log', 2);
    }

    /**
     * [findVoucher 查找当前凭证号]
     * @param  [type] $user_info [用户信息]
     * @return [type]            [description]
     */
    protected static function findVoucher($user_info, $now_date)
    {
        // 查找凭证号
        // $now_year_month = date('Ym');//当前年月
        $now_year_month = intval(date('Ym', strtotime($now_date)));
        $find_voucher = DB::table('voucher')
            ->where('vou_cid', $user_info->adm_cid)
            ->where('vou_shop_id', $user_info->adm_shop_id)
            ->where('vou_year_month', $now_year_month)
            ->select('vou_id', 'vou_no')
            ->orderBy('vou_id', 'desc')
            ->first();
        if (empty($find_voucher)) {
            $find_voucher['vou_no'] = config('apiu8cloud.vou_no');//凭证号初始值
            $find_voucher = (object)$find_voucher;
        }
        return $find_voucher;
    }

    /**
     * [insertVoucher 添加凭证数据]
     * @param  [type]  $user_info [用户信息]
     * @param  [type]  $vou_info  [凭证数据]
     * @param  integer $type      [类型1添加一条2添加多条]
     * @return [type]             [description]
     */
    protected static function insertVoucher($user_info, $vou_info, $now_date, $type = 1)
    {
        // 查找凭证号
        // $now_year_month = date('Ym');//当前年月
        $now_year_month = intval(date('Ym', strtotime($now_date)));
        if ($type == 1) {
            // 添加用友上传凭证的记录
            $vou_data['vou_cid'] = $user_info->adm_cid;
            $vou_data['vou_shop_id'] = $user_info->adm_shop_id;
            $vou_data['vou_voucher_id'] = $vou_info['vou_voucher_id'];//凭证所对应的id：采购单id/工单id
            $vou_data['vou_voucher_number'] = isset($vou_info['vou_voucher_number']) ? $vou_info['vou_voucher_number'] : '';//凭证对应的单号：采购单号
            $vou_data['vou_voucher_record_number'] = isset($vou_info['vou_voucher_record_number']) ? $vou_info['vou_voucher_record_number'] : '';//采购入库记录单号
            $vou_data['vou_year_month'] = $now_year_month;
            $vou_data['vou_voucher_type'] = $vou_info['vou_voucher_type'];//类型：1采购入库2工单审核
            // $vou_data['vou_no'] = $vou_info['vou_no'];//凭证号
        } else {
            // 添加用友上传凭证的记录
            foreach ($vou_info as $key => $value) {
                $vou_data[$key]['vou_cid'] = $user_info->adm_cid;
                $vou_data[$key]['vou_shop_id'] = $user_info->adm_shop_id;
                $vou_data[$key]['vou_voucher_id'] = $value['vou_voucher_id'];//凭证所对应的id：采购单id/工单id
                $vou_data[$key]['vou_voucher_number'] = isset($value['vou_voucher_number']) ? $value['vou_voucher_number'] : '';//凭证对应的单号：采购单号
                $vou_data[$key]['vou_voucher_record_number'] = isset($value['vou_voucher_record_number']) ? $value['vou_voucher_record_number'] : '';//采购入库记录单号
                $vou_data[$key]['vou_year_month'] = $now_year_month;
                $vou_data[$key]['vou_voucher_type'] = $value['vou_voucher_type'];//凭证所对应的id：采购单id/工单id
                // $vou_data[$key]['vou_no'] = $value['vou_no'];//凭证号
            }
        }
        $vou_res = DB::table('voucher')->insert($vou_data);
        return $vou_res;
    }
}
