<?php

namespace App\Http\Models\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use App\Http\Controllers\Api\YongYou\YongYouController;

class YongYou extends Model
{
    /**
     * [apiWorkOrder 工单审核上传凭证]
     * @param  [array] $user_info       [用户信息]
     * @param  [array] $find_wor        [工单信息]
     * @param  [array] $request_voucher [凭证需要的信息]
     * @return [type]                  [description]
     */
    public static function apiWorkOrder($user_info, $find_wor, $request_voucher)
    {
        // 调用u8系统接口，将凭证数据传到用友系统上，需要传的凭证
        /*
            销售商品的税率是13%  所以税金的计算=含税收入/（1+13%）*13%
            假如订单销售金额300，成本200
                凭证一：不含增值税
                    借：应收账款--客户   300
                    贷：主营业务收入     300
                凭证一：含增值税
                    借：应收账款--客户   300
                    贷：主营业务收入  300/1.13  265.4867
                        应交税费-应交增值税-销项税   300/1.13*0.13    34.5132
                凭证二：
                    借：主营业务成本  200
                    贷：库存商品    200
            退货时 做相反的销售出库分录。
            换货视同先退原商品再发新商品。

            工单费用：总店把订单派给加盟店，加盟店完成订单之后跟加盟店的结算的钱
            总店付款时：借：应付账款
                        贷：银行存款
         */
        $yongyou = new YongYouController;
        // 获取门店对应用友系统的配置数据
        $unitcode = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['unitcode'];//用友-公司编码
        $subjschemecode  = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['subjschemecode'];//用友-科目方案编码
        $sell_tax  = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['SHOP_TAX']['sell'];//销售出库是否含税：1不含税2含税

        // 各门店的主营业务收入
        $main_business_income = [
            // 门店id=>用友科目编码
            1=>'600101',//主营业务收入销售收入
            2=>'6001',
            26=>'6001',
        ];
        // 各门店的成本：库存商品
        $inventory_cost = [
            // 门店id=>用友科目编码
            1=>'140504',//主营业务收入销售收入
            2=>'1405',//库存商品
            26=>'1405',
        ];

        // 各门店的主营业务成本：主营业务成本
        $main_business_cost = [
            // 门店id=>用友科目编码
            1=>'640102',//主营业务成本手工凭证录入
            2=>'6401',//主营业务成本
            26=>'6401',
        ];

        // 查找凭证号
        $find_voucher = self::findVoucher($user_info);

        // wor_plus_minus 金额正负：1正值2负值
        if ($request_voucher['wor_plus_minus'] == 2) {
            $wor_actual_price = '-'.$request_voucher['wor_actual_price'];
        }else{
            $wor_actual_price = $request_voucher['wor_actual_price'];
        }
        // 判断客户类型，用友客商的对象
        // wor_type 订单类型：1门店零售2渠道单位3速电派单
        if ($find_wor->wor_type == 1) {
            if ($find_wor->wocl_client_id) {
                // 会员零售
                $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.'1';
            }else{
                // 临时会员
                $checkvaluecode = config('apiu8cloud.custcode.temporary').$user_info->adm_shop_id.'0';
            }
        }else if($find_wor->wor_type == 2){
            // 客户单位
            $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$request_voucher['ord_client_id'];
        }

        if ($find_wor->wor_service_type == 4) {
            $voucher_cost = '-'.$request_voucher['voucher_cost'];//订单退货成本金额
            $receivable_hint = '【订单退货】工单单号:';
            $cost_hint = '【退货成本】工单单号:';
        } else {
            $voucher_cost = $request_voucher['voucher_cost'];//销售成本金额
            $receivable_hint = '【订单销售】工单单号:';
            $cost_hint = '【销售成本】工单单号:';
        }

        $number = $find_wor->wor_number;//工单单号或订单单号
        // 判断是否为外派工单  总店审核
        if ($find_wor->wocl_wor_type == 2 && $find_wor->wocl_join_wor_id == 0){
            // ord_plus_minus 金额正负：1正值2负值
            if ($request_voucher['ord_info']->ord_plus_minus == 2) {
                $wor_actual_price = '-'.$request_voucher['ord_info']->ord_actual_price/100;
            }else{
                $wor_actual_price = $request_voucher['ord_info']->ord_actual_price/100;
            }
            $wor_actual_price = $request_voucher['ord_info']->ord_actual_price/100;
            $number = $find_wor->wor_order_number;//外派工单，订单销售凭证传的是订单单号
            $receivable_hint = '【外派-订单销售】订单单号:';
            $cost_hint = '【外派-销售成本】订单单号:';
        }

        $vou_num = 0;//凭证个数
        // 订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单 7救援单
        if ($find_wor->wor_service_type == 3) {
            // 判断金额是否为0，不为0的生成凭证，为0，不生成凭证
            if (!empty(abs($request_voucher['voucher_sell_total_price']))) {
                $vou_hint = '【换货单换新】';
                // 借：应收账款--客户
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint.'工单单号:'.$find_wor->wor_number;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $request_voucher['voucher_sell_total_price'];//本币借方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = '1122';//借：科目 应收账款
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                // 贷：主营业务收入
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] =  $vou_hint.'工单单号:'.$find_wor->wor_number;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $request_voucher['voucher_sell_total_price'];//本币贷方金额
                // $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = '6001';//贷：科目 主营业务收入
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $main_business_income[$user_info->adm_shop_id];//贷：科目 主营业务收入
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                $loan_money = $request_voucher['voucher_sell_total_price'];//主营业务收入
                // 销售出库是否含税：1不含税2含税
                if ($sell_tax == 2) {
                    // 销售商品的税率是13%  所以税金的计算=含税收入/（1+13%）*13%
                    $loan_main_money = round($loan_money / 1.13, 2);
                    $loan_tax_money = $loan_money - $loan_main_money;//应交税费

                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $loan_main_money;//本币贷方金额，

                    // 贷：应交税费
                    $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                    $voucher['voucher'][$vou_num]['details'][2]['explanation'] =  $vou_hint.'工单单号:'.$find_wor->wor_number;//摘要
                    $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $loan_tax_money;//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = '2221';//科目，贷：应交税费
                    $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                }else{
                    $loan_main_money = $loan_money;
                }
                $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = date('Y-m-d');//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $vou_hint.'工单单号:'.$find_wor->wor_number;//凭证摘要
                $vou_num++;
            }

            // 判断金额是否为0，不为0的生成凭证，为0，不生成凭证
            if (!empty(abs($request_voucher['voucher_refund_total_price']))) {
                $vou_hint = '【换货单退货】';
                //换货单退货 借：应收账款--客户
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint.'工单单号:'.$find_wor->wor_number;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = '-'.$request_voucher['voucher_refund_total_price'];//本币借方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = '1122';//借：科目 应收账款
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                // 贷：主营业务收入
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint.'工单单号:'.$find_wor->wor_number;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = '-'.$request_voucher['voucher_refund_total_price'];//本币贷方金额
                // $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = '6001';//贷：科目 主营业务收入
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $main_business_income[$user_info->adm_shop_id];//贷：科目 主营业务收入
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                $loan_money = $request_voucher['voucher_refund_total_price'];//主营业务收入
                // 销售出库是否含税：1不含税2含税
                if ($sell_tax == 2) {
                    // 销售商品的税率是13%  所以税金的计算=含税收入/（1+13%）*13%
                    $loan_main_money = round($loan_money / 1.13, 2);
                    $loan_tax_money = $loan_money - $loan_main_money;//应交税费

                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = '-'.$loan_main_money;//本币贷方金额，

                    // 贷：应交税费
                    $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                    $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $vou_hint.'工单单号:'.$find_wor->wor_number;//摘要
                    $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = '-'.$loan_tax_money;//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = '2221';//科目，贷：应交税费
                    $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                }else{
                    $loan_main_money = $loan_money;
                }
                $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = date('Y-m-d');//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $vou_hint.'工单单号:'.$find_wor->wor_number;//凭证摘要
                $vou_num++;
            }
            if ($request_voucher['voucher_cost'] && !empty(abs($request_voucher['voucher_cost']))) {
                $vou_hint = '【换货单换新成本】';
                // 借：主营业务成本
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint.'工单单号:'.$find_wor->wor_number;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $request_voucher['voucher_cost'];//本币借方金额
                // $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = '6401';//科目，借：主营业务成本
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $main_business_cost[$user_info->adm_shop_id];//科目，借：主营业务成本
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                // 贷：库存商品
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint.'工单单号:'.$find_wor->wor_number;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $request_voucher['voucher_cost'];//本币贷方金额
                // $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = '1405';//科目，贷：库存商品
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $inventory_cost[$user_info->adm_shop_id];//科目，贷：库存商品
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = date('Y-m-d');//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $vou_hint.'工单单号:'.$find_wor->wor_number;//凭证摘要
                $vou_num++;
            }

            if ($request_voucher['refund_voucher_cost'] && !empty(abs($request_voucher['refund_voucher_cost']))) {
                $vou_hint = '【换货单换新成本】';
                // 借：主营业务成本
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $vou_hint.'工单单号:'.$find_wor->wor_number;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = '-'.$request_voucher['refund_voucher_cost'];//本币借方金额
                // $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = '6401';//科目，借：主营业务成本
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $main_business_cost[$user_info->adm_shop_id];//科目，借：主营业务成本
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                // 贷：库存商品
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $vou_hint.'工单单号:'.$find_wor->wor_number;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = '-'.$request_voucher['refund_voucher_cost'];//本币贷方金额
                // $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = '1405';//科目，贷：库存商品
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $inventory_cost[$user_info->adm_shop_id];//科目，贷：库存商品
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = date('Y-m-d');//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $vou_hint.'工单单号:'.$find_wor->wor_number;//凭证摘要
                $vou_num++;
            }
        }else{
            // 判断成本金额是否为0，不为0的生成凭证，为0，不生成凭证
            if (!empty(abs($wor_actual_price))) {
                // 借：应收账款--客户
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $receivable_hint.$number;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $wor_actual_price;//本币借方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = '1122';//借：科目 应收账款
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                // 贷：主营业务收入
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $receivable_hint.$number;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $wor_actual_price;//本币贷方金额
                // $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = '6001';//贷：科目 主营业务收入
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $main_business_income[$user_info->adm_shop_id];//贷：科目 主营业务收入
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                $loan_money = $wor_actual_price;//主营业务收入
                // 销售出库是否含税：1不含税2含税
                if ($sell_tax == 2) {
                    // 销售商品的税率是13%  所以税金的计算=含税收入/（1+13%）*13%
                    $loan_main_money = round($loan_money / 1.13, 2);
                    $loan_tax_money = $loan_money - $loan_main_money;//应交税费

                    $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $loan_main_money;//本币贷方金额，

                    // 贷：应交税费
                    $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
                    $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $receivable_hint.$number;//摘要
                    $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $loan_tax_money;//本币贷方金额
                    $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = '2221';//科目，贷：应交税费
                    $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
                }else{
                    $loan_main_money = $loan_money;
                }
                $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = date('Y-m-d');//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $receivable_hint.$number;//凭证摘要
                $vou_num++;
            }

            // 判断成本金额是否为0，不为0的生成凭证，外派订单的成本为0，不生成凭证
            if (!empty(abs($voucher_cost))) {
                // 借：主营业务成本
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $cost_hint.$number;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $voucher_cost;//本币借方金额
                // $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = '6401';//科目，借：主营业务成本
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $main_business_cost[$user_info->adm_shop_id];//科目，借：主营业务成本
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                // 贷：库存商品
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $cost_hint.$number;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $voucher_cost;//本币贷方金额
                // $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = '1405';//科目，贷：库存商品
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $inventory_cost[$user_info->adm_shop_id];//科目，贷：库存商品
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = date('Y-m-d');//制单日期
                $voucher['voucher'][$vou_num]['explanation'] =$cost_hint.$number;//凭证摘要
                $vou_num++;
            }

            // 判断是否为外派工单  总店审核
            if ($find_wor->wocl_wor_type == 2 && $find_wor->wocl_join_wor_id == 0 && !empty(abs($wor_actual_price))){
                // 外派工单，总店审核通过时生成工单费用的凭证
                $receivable_hint = '【外派-工单费用】工单单号:';
                // 客商--加盟店
                $checkvaluecode = config('apiu8cloud.custcode.assignment').$user_info->adm_shop_id.$find_wor->wor_service_shop_id;
                // wor_plus_minus 金额正负：1正值2负值
                if ($request_voucher['wor_plus_minus'] == 2) {
                    $wor_actual_price = '-'.$request_voucher['wor_actual_price'];
                }else{
                    $wor_actual_price = $request_voucher['wor_actual_price'];
                }
                // 借：应付账款--加盟店
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $receivable_hint.$number;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $wor_actual_price;//本币借方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = '220202';//借：科目 应付账款-服务费
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                if (empty($request_voucher['subjcode']) && $user_info->adm_shop_id == 1) {
                    $request_voucher['subjcode'] = '100201';//银行存款农行东区支行，厦门科目编码
                }
                // 贷：银行存款
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $receivable_hint.$number;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $wor_actual_price;//本币贷方金额
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $request_voucher['subjcode'];//贷：科目 银行存款
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                // $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                // $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = date('Y-m-d');//制单日期
                $voucher['voucher'][$vou_num]['explanation'] = $receivable_hint.$number;//凭证摘要
                $vou_num++;
            }
        }

        // 代收金额，代收凭证
        if ($request_voucher['find_wocl']) {
            // 如果选择技师代收，生成工单代收凭证，生成订单代收凭证
            /**
             * 收到款时 借：现金  1000
             *          贷：其他应付款-代收代付款 1000
             */
            if ($find_wor->wocl_collect_state == 1 && $request_voucher['wor_coll_price'] > 0) {
                if (empty($request_voucher['subjcode']) && $user_info->adm_shop_id == 1) {
                    $request_voucher['subjcode'] = '100201';//银行存款农行东区支行，厦门科目编码
                }
                // 订单代收 
                // 借：现金或银行存款
                $cost_hint = '【订单代收】订单单号:';
                $wor_coll_price = $request_voucher['wor_coll_price'] / 100;
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $cost_hint.$find_wor->wor_order_number;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $wor_coll_price;//本币借方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $request_voucher['subjcode'];//科目，借：现金或银行存款
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                // 贷：其他应付款-代收代付款
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $cost_hint.$find_wor->wor_order_number;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $wor_coll_price;//本币贷方金额
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = '224103';//科目，贷：其他应付款-代收代付款
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = date('Y-m-d');//制单日期
                $voucher['voucher'][$vou_num]['explanation'] =$cost_hint.$find_wor->wor_order_number;//凭证摘要
                $vou_num++;

                /**
                 * 工单代收，技师向车主收钱
                 * 收到款时：
                 *     借：现金（或银行存款）
                 *     贷：其他应付款-代收款项
                 *     应收账款的客商辅助核算指的是客户，也就是接受服务的对像，工单代收的对象是车主，这个客商指的就是车主
                 */
                $cost_hint = '【工单代收】工单单号:';
                $checkvaluecode = config('apiu8cloud.custcode.owner').$user_info->adm_shop_id.'0';//用友车主的客商编码
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $cost_hint.$find_wor->wor_number;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $wor_coll_price;//本币借方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $request_voucher['subjcode'];//科目，借：现金或银行存款
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                // 贷：其他应付款-代收代付款
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $cost_hint.$find_wor->wor_number;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $wor_coll_price;//本币贷方金额
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = '224103';//科目，贷：其他应付款-代收款项
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//客商辅助核算
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['prepareddate'] = date('Y-m-d');//制单日期
                $voucher['voucher'][$vou_num]['explanation'] =$cost_hint.$find_wor->wor_number;//凭证摘要
                $vou_num++;
            }
        }
        
        if (empty($voucher)) {
            return ['code'=>200, 'msg'=>'success', 'data'=>''];
        }

        // 调用u8系统接口
        $curl_return = $yongyou->u8cloudApi('凭证新增', $voucher);
        // 判断用友接口返回的数据
        if ($curl_return['status'] != 'success') {
            self::logRecord(5031, $user_info, $voucher, $curl_return);//保存操作日志
            // 如果凭证添加失败，凭证号自动加1
            $vou_data['vou_voucher_id'] = 0;//凭证所对应的id：工单id
            $vou_data['vou_voucher_type'] = 0;//类型：1采购入库2工单审核
            $vou_data['vou_no'] = $find_voucher->vou_no + 1;//凭证号
            // self::insertVoucher($user_info, $vou_data, 1);
            return ['code'=> 500, 'msg'=>'error', 'vou_data'=>$vou_data, 'data'=>'U8财务系统凭证上传失败！'];
        }

        // 添加用友上传凭证的记录
        for ($i=0; $i < $vou_num; $i++) {
            // 添加用友上传凭证的记录
            $vou_data[$i]['vou_cid'] = $user_info->adm_cid;
            $vou_data[$i]['vou_shop_id'] = $user_info->adm_shop_id;
            $vou_data[$i]['vou_voucher_id'] = $request_voucher['wor_id'];//凭证所对应的id：工单id
            $vou_data[$i]['vou_voucher_number'] = $find_wor->wor_number;//凭证对应的单号：工单单号
            $vou_data[$i]['vou_voucher_type'] = 2;//类型：1采购入库2工单审核
            $vou_data[$i]['vou_no'] = $find_voucher->vou_no + $i + 1;//凭证号
        }
        self::insertVoucher($user_info, $vou_data, 2);
        return ['code'=>200, 'msg'=>'success', 'data'=>'U8财务系统凭证上传成功！'];
    }

    /**
     * [apiSdOrder 速电派单上传凭证]
     * @param  [type] $user_info       [用户信息]
     * @param  [type] $find_wor        [工单信息]
     * @param  [type] $request_voucher [凭证需要的信息]
     * @return [type]                  [description]
     */
    public static function apiSdOrder($user_info, $find_wor, $request_voucher)
    {
        // 调用u8系统接口，将凭证数据传到用友系统上，需要传的凭证
        /*
            速电给门店派订单，门店服务完成订单后，速电审核完成时生成，应该生成的凭证
                借：应收账款
                贷：主营业务收入
            门店服务，商品出库时：
                借：库存商品
                贷：应付账款--供应商
            速电付款，门店收款时：
            借：银行存款    贷：应收账款
         */
        $yongyou = new YongYouController;
        // 获取门店对应用友系统的配置数据
        $unitcode = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['unitcode'];//用友-公司编码
        $subjschemecode  = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['subjschemecode'];//用友-科目方案编码
        $sell_tax  = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['SHOP_TAX']['sell'];//销售出库是否含税：1不含税2含税

        // 查找凭证号
        $find_voucher = self::findVoucher($user_info);

        $wor_actual_price = $find_wor->wor_actual_price;
        // 速电派单，用友客商的对象
        $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.'1';

        $voucher_hint = '【速电网单】工单单号:'.$find_wor->wor_number;
        $voucher_cost = $request_voucher['voucher_cost'];//速电网单-销售成本金额

        $vou_num = 0;//凭证个数
        // 借：应收账款--客户
        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $receivable_hint.$number;//摘要
        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $wor_actual_price;//本币借方金额
        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = '1122';//借：科目 应收账款
        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
        $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//客商辅助核算
        $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

        // 贷：主营业务收入
        $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
        $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $receivable_hint.$number;//摘要
        $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $wor_actual_price;//本币贷方金额
        // $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = '6001';//贷：科目 主营业务收入
        $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $main_business_income[$user_info->adm_shop_id];//贷：科目 主营业务收入
        $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
        $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//客商辅助核算
        $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

        $loan_money = $wor_actual_price;//主营业务收入
        // 销售出库是否含税：1不含税2含税
        if ($sell_tax == 2) {
            // 销售商品的税率是13%  所以税金的计算=含税收入/（1+13%）*13%
            $loan_main_money = round($loan_money / 1.13, 2);
            $loan_tax_money = $loan_money - $loan_main_money;//应交税费

            $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $loan_main_money;//本币贷方金额，

            // 贷：应交税费
            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $receivable_hint.$number;//摘要
            $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $loan_tax_money;//本币贷方金额
            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = '2221';//科目，贷：应交税费
            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
        }else{
            $loan_main_money = $loan_money;
        }
        $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
        $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
        $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
        $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
        $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
        $voucher['voucher'][$vou_num]['explanation'] = $receivable_hint.$number;//凭证摘要
        $vou_num++;

        // 判断成本金额是否为0，不为0的生成凭证，外派订单的成本为0，不生成凭证
        if (!empty(abs($voucher_cost))) {
            // 借：主营业务成本
            $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
            $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $cost_hint.$number;//摘要
            $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $voucher_cost;//本币借方金额
            $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = '6401';//科目，借：主营业务成本
            $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
            // 贷：库存商品
            $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
            $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $cost_hint.$number;//摘要
            $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $voucher_cost;//本币贷方金额
            $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = '1405';//科目，贷：库存商品
            $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

            $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
            $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
            $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
            $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
            $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
            $voucher['voucher'][$vou_num]['explanation'] =$cost_hint.$number;//凭证摘要
            $vou_num++;
        }

        // 调用u8系统接口
        $curl_return = $yongyou->u8cloudApi('凭证新增', $voucher);
        // 判断用友接口返回的数据
        if ($curl_return['status'] != 'success') {
            self::logRecord(5032, $user_info, $voucher, $curl_return);//保存操作日志
            // 如果凭证添加失败，凭证号自动加1
            $vou_data['vou_voucher_id'] = 0;//凭证所对应的id：工单id
            $vou_data['vou_voucher_type'] = 0;//类型：1采购入库2工单审核
            $vou_data['vou_no'] = $find_voucher->vou_no + 1;//凭证号
            // self::insertVoucher($user_info, $vou_data, 1);
            return ['code'=> 500, 'msg'=>'error', 'vou_data'=>$vou_data, 'data'=>'U8财务系统凭证上传失败！'];
        }

        // 添加用友上传凭证的记录
        for ($i=0; $i < $vou_num; $i++) {
            // 添加用友上传凭证的记录
            $vou_data[$i]['vou_cid'] = $user_info->adm_cid;
            $vou_data[$i]['vou_shop_id'] = $user_info->adm_shop_id;
            $vou_data[$i]['vou_voucher_id'] = $request_voucher['wor_id'];//凭证所对应的id：工单id
            $vou_data[$i]['vou_voucher_number'] = $find_wor->wor_number;//凭证对应的单号：工单单号
            $vou_data[$i]['vou_voucher_type'] = 2;//类型：1采购入库2工单审核
            $vou_data[$i]['vou_no'] = $find_voucher->vou_no + $i + 1;//凭证号
        }
        self::insertVoucher($user_info, $vou_data, 2);
        return ['code'=>200, 'msg'=>'success', 'data'=>'U8财务系统凭证上传成功！'];
    }

    /**
     * [apiSdBill 速电账单确认上传凭证]
     * @param  [type] $user_info       [用户信息]
     * @param  [type] $find_data        [description]
     * @param  [type] $request_voucher [description]
     * @return [type]                  [description]
     */
    public static function apiSdBill($user_info, $find_data, $request_voucher)
    {
        // 调用u8系统接口，将凭证数据传到用友系统上，需要传的凭证
        /*
            速电付款，门店收款时：
            借：银行存款    贷：应收账款
         */
        $yongyou = new YongYouController;
        // 获取门店对应用友系统的配置数据
        $unitcode = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['unitcode'];//用友-公司编码
        $subjschemecode  = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['subjschemecode'];//用友-科目方案编码
        $sell_tax  = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['SHOP_TAX']['sell'];//销售出库是否含税：1不含税2含税

        // 查找凭证号
        $find_voucher = self::findVoucher($user_info);

        $voucher_price = $find_data->sdob_sd_bill_price/100;
        $voucher_hint = '【速电对账】速电账单:'.$find_data->sdob_sd_bill_bumber;
        // 速电派单，用友客商的对象
        $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.'1';

        $vou_num = 0;//凭证个数
        // 借：银行存款
        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $voucher_hint;//摘要
        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $voucher_price;//本币借方金额
        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $voucher['subjcode'];//借：科目 银行存款
        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码

        // 贷：应收账款--客户
        $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
        $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $voucher_hint;//摘要
        $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $voucher_price;//本币贷方金额
        $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = '1122';//贷：科目 应收账款--客户
        $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
        $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//客商辅助核算
        $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

        $loan_money = $wor_actual_price;//主营业务收入
        // 销售出库是否含税：1不含税2含税
        if ($sell_tax == 2) {
            // 销售商品的税率是13%  所以税金的计算=含税收入/（1+13%）*13%
            $loan_main_money = round($loan_money / 1.13, 2);
            $loan_tax_money = $loan_money - $loan_main_money;//应交税费

            $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $loan_main_money;//本币贷方金额，

            // 贷：应交税费
            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $voucher_hint;//摘要
            $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $loan_tax_money;//本币贷方金额
            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = '2221';//科目，贷：应交税费
            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
        }else{
            $loan_main_money = $loan_money;
        }
        $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
        $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
        $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
        $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
        $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
        $voucher['voucher'][$vou_num]['explanation'] = $voucher_hint;//凭证摘要
        $vou_num++;

        // 调用u8系统接口
        $curl_return = $yongyou->u8cloudApi('凭证新增', $voucher);
        // 判断用友接口返回的数据
        if ($curl_return['status'] != 'success') {
            self::logRecord(5033, $user_info, $voucher, $curl_return);//保存操作日志
            // 如果凭证添加失败，凭证号自动加1
            $vou_data['vou_voucher_id'] = 0;//凭证所对应的id：工单id
            $vou_data['vou_voucher_type'] = 0;//类型：1采购入库2工单审核
            $vou_data['vou_no'] = $find_voucher->vou_no + 1;//凭证号
            // self::insertVoucher($user_info, $vou_data, 1);
            return ['code'=>500, 'msg'=>'error', 'vou_data'=>$vou_data, 'data'=>'U8财务系统凭证上传失败！'];
        }

        // 添加用友上传凭证的记录
        for ($i=0; $i < $vou_num; $i++) {
            // 添加用友上传凭证的记录
            $vou_data[$i]['vou_cid'] = $user_info->adm_cid;
            $vou_data[$i]['vou_shop_id'] = $user_info->adm_shop_id;
            $vou_data[$i]['vou_voucher_id'] = $request_voucher['wor_id'];//凭证所对应的id：工单id
            $vou_data[$i]['vou_voucher_number'] = $find_data->sdob_sd_bill_bumber;//凭证对应的单号：工单单号
            $vou_data[$i]['vou_voucher_type'] = 2;//类型：1采购入库2工单审核
            $vou_data[$i]['vou_no'] = $find_voucher->vou_no + $i + 1;//凭证号
        }
        self::insertVoucher($user_info, $vou_data, 2);
        return ['code'=>200, 'msg'=>'success', 'data'=>'U8财务系统凭证上传成功！'];
    }

    /**
     * [apiAfterOrder 售后确认上传凭证]
     * @param  [type] $user_info       [用户信息]
     * @param  [type] $find_data       [售后信息]
     * @param  [type] $request_voucher [凭证信息]
     * @return [type]                  [description]
     */
    public static function apiAfterOrder($user_info, $find_data, $request_voucher)
    {
        // 调用u8系统接口，将凭证数据传到用友系统上，需要传的凭证
        /*
            速电付款，门店收款时：
            借：银行存款    贷：应收账款
         */
        $yongyou = new YongYouController;
        // 获取门店对应用友系统的配置数据
        $unitcode = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['unitcode'];//用友-公司编码
        $subjschemecode  = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['subjschemecode'];//用友-科目方案编码
        $sell_tax  = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['SHOP_TAX']['sell'];//销售出库是否含税：1不含税2含税

        // 查找凭证号
        $find_voucher = self::findVoucher($user_info);

        $voucher_price = $find_data->sdob_sd_bill_price/100;
        $voucher_hint = '【售后】售后单号:'.$find_data->sdob_sd_bill_bumber;
        // 速电派单，用友客商的对象
        $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.'1';

        $vou_num = 0;//凭证个数
        // 借：银行存款
        $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
        $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $voucher_hint;//摘要
        $voucher['voucher'][$vou_num]['details'][0]['localdebitamount'] = $voucher_price;//本币借方金额
        $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $voucher['subjcode'];//借：科目 银行存款
        $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码

        // 贷：应收账款--客户
        $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
        $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $voucher_hint;//摘要
        $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $voucher_price;//本币贷方金额
        $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = '1122';//贷：科目 应收账款--客户
        $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
        $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//客商辅助核算
        $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

        $loan_money = $wor_actual_price;//主营业务收入
        // 销售出库是否含税：1不含税2含税
        if ($sell_tax == 2) {
            // 销售商品的税率是13%  所以税金的计算=含税收入/（1+13%）*13%
            $loan_main_money = round($loan_money / 1.13, 2);
            $loan_tax_money = $loan_money - $loan_main_money;//应交税费

            $voucher['voucher'][$vou_num]['details'][1]['localcreditamount'] = $loan_main_money;//本币贷方金额，

            // 贷：应交税费
            $voucher['voucher'][$vou_num]['details'][2]['detailindex'] = '3';//分录号
            $voucher['voucher'][$vou_num]['details'][2]['explanation'] = $voucher_hint;//摘要
            $voucher['voucher'][$vou_num]['details'][2]['localcreditamount'] = $loan_tax_money;//本币贷方金额
            $voucher['voucher'][$vou_num]['details'][2]['pk_accsubj'] = '2221';//科目，贷：应交税费
            $voucher['voucher'][$vou_num]['details'][2]['pk_currtype'] = 'CNY';//币种编码
        }else{
            $loan_main_money = $loan_money;
        }
        $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1 + $vou_num;//凭证号
        $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
        $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
        $voucher['voucher'][$vou_num]['pk_prepared'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
        $voucher['voucher'][$vou_num]['pk_vouchertype'] ='记账';//凭证类别简称
        $voucher['voucher'][$vou_num]['explanation'] = $voucher_hint;//凭证摘要
        $vou_num++;

        // 调用u8系统接口
        $curl_return = $yongyou->u8cloudApi('凭证新增', $voucher);
        // 判断用友接口返回的数据
        if ($curl_return['status'] != 'success') {
            self::logRecord(5033, $user_info, $voucher, $curl_return);//保存操作日志
            // 如果凭证添加失败，凭证号自动加1
            $vou_data['vou_voucher_id'] = 0;//凭证所对应的id：工单id
            $vou_data['vou_voucher_type'] = 0;//类型：1采购入库2工单审核
            $vou_data['vou_no'] = $find_voucher->vou_no + 1;//凭证号
            // self::insertVoucher($user_info, $vou_data, 1);
            return ['code'=>500, 'msg'=>'error', 'vou_data'=>$vou_data, 'data'=>'U8财务系统凭证上传失败！'];
        }

        // 添加用友上传凭证的记录
        for ($i=0; $i < $vou_num; $i++) {
            // 添加用友上传凭证的记录
            $vou_data[$i]['vou_cid'] = $user_info->adm_cid;
            $vou_data[$i]['vou_shop_id'] = $user_info->adm_shop_id;
            $vou_data[$i]['vou_voucher_id'] = $request_voucher['wor_id'];//凭证所对应的id：工单id
            $vou_data[$i]['vou_voucher_number'] = $find_data->sdob_sd_bill_bumber;//凭证对应的单号：工单单号
            $vou_data[$i]['vou_voucher_type'] = 2;//类型：1采购入库2工单审核
            $vou_data[$i]['vou_no'] = $find_voucher->vou_no + $i + 1;//凭证号
        }
        self::insertVoucher($user_info, $vou_data, 2);
        return ['code'=>200, 'msg'=>'success', 'data'=>'U8财务系统凭证上传成功！'];
    }

    /**
     * [apiVoucherCancel 凭证作废]
     * @param  [type] $user_info       [用户信息]
     * @param  [type] $request_voucher [凭证信息]
     * @return [type]                  [description]
     */
    public static function apiVoucherCancel($user_info, $request_voucher)
    {
        $yongyou = new YongYouController;
        // 获取门店对应用友系统的配置数据
        $unitcode = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['unitcode'];//用友-公司编码
        $subjschemecode  = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['subjschemecode'];//用友-科目方案编码
        $abandoner_code = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码-用友系统

        foreach ($request_voucher['vou_no'] as $key => $value) {
            $voucher['bills'][$key]['abandoner_code'] = $abandoner_code;
            $voucher['bills'][$key]['glorgbook_code'] = $unitcode.'-'.$subjschemecode;
            $voucher['bills'][$key]['no'] = $value->vou_no;
            $voucher['bills'][$key]['period'] = substr($value->vou_year_month, -2);//月
            $voucher['bills'][$key]['year'] = substr($value->vou_year_month, 0, 4);//年
            $voucher['bills'][$key]['vouchertype_code'] = '记账';
        }
        // 调用u8系统接口
        $curl_return = $yongyou->u8cloudApi('凭证作废', $voucher);
        // 判断用友接口返回的数据
        if ($curl_return['status'] != 'success') {
            self::logRecord(5021, $user_info, $voucher, $curl_return);//保存操作日志
            return ['code'=> 500, 'msg'=>'error', 'data'=>'U8财务系统凭证作废失败！'];
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>'U8财务系统凭证作废成功！'];
    }

    /**
     * [apiWareIn 采购入库上传凭证]
     * @param  [array] $user_info [用户信息]
     * @param  [array] $cg_data   [采购单信息]
     * @param  [array] $request_voucher [凭证需要的数据]
     * @param  [int] $type [类型：1采购入库2改价3退货]
     * @return [type]            [description]
     */
    public static function apiWareIn($user_info, $cg_data, $request_voucher, $type = 1)
    {
        // 调用u8系统接口，将凭证数据传到用友系统上，需要传的凭证
        // 采购入库：
        //     借：库存商品
        //     借：应交税费-应交增值税-进项税   --不含税时传这个凭证，含税时不传这个凭证
        //     贷：应付账款--供应商
        $yongyou = new YongYouController;
        // 获取门店对应用友系统的配置数据
        $unitcode = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['unitcode'];//用友-公司编码
        $subjschemecode  = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['subjschemecode'];//用友-科目方案编码
        $vou_hint = '【采购入库】采购单号:';//提示文字
        $vou_hint2 = '入库单号:';//提示文字
        $amount = $request_voucher['cw_amount'];//采购价
        $explanation = $vou_hint.$cg_data['cg_number'];//摘要
        $vou_voucher_id = isset($cg_data['cg_id']) ? $cg_data['cg_id'] : 0;//凭证所对应的id：采购单id/工单id
        $vou_voucher_number = $cg_data['cg_number'];//凭证对应的单号：采购单号

        // 金额为0的用友系统无法上传凭证
        if (empty($amount)) {
            return ['code'=>200, 'msg'=>'success', 'data'=>''];
        }
        
        if ($type == 2) {
            $vou_hint = '【改价】采购单号:';
            $explanation = $vou_hint.$cg_data['cg_number'];//摘要
        }elseif ($type == 3) {
            // 采购退货
            $amount = '-'.$request_voucher['cw_amount'];//采购价
            $vou_hint = '【退货】采购单号:';
            $vou_hint2 = '退货单号:';//提示文字
            $explanation = $vou_hint.$cg_data['cg_original_number'];//摘要
            $vou_voucher_number = $cg_data['cg_original_number'];//凭证对应的单号：采购单号
            $vou_voucher_id = $request_voucher['cg_id'];//凭证所对应的id：采购单id/工单id
        }
        $details_explanation = $explanation.$vou_hint2.$request_voucher['rk_number'];//分录摘要

        // 各门店的主营业务收入
        $main_business_income = [
            // 门店id=>用友科目编码
            1=>'600101',//主营业务收入销售收入
            2=>'6001',
            26=>'6001',
        ];
        // 各门店的成本：库存商品
        $inventory_cost = [
            // 门店id=>用友科目编码
            1=>'140504',//主营业务收入销售收入
            2=>'1405',//库存商品
            26=>'1405',
        ];
        // 各门店的主营业务成本：主营业务成本
        $main_business_cost = [
            // 门店id=>用友科目编码
            1=>'640102',//主营业务成本手工凭证录入
            2=>'6401',//主营业务成本
            26=>'6401',
        ];

        // 查找凭证号
        $find_voucher = self::findVoucher($user_info);
        $voucher['voucher'][0]['details'][0]['detailindex'] = '1';//分录号
        $voucher['voucher'][0]['details'][0]['explanation'] = $details_explanation;//摘要
        $voucher['voucher'][0]['details'][0]['localdebitamount'] = $amount;//本币借方金额
        // $voucher['voucher'][0]['details'][0]['pk_accsubj'] = '1405';//科目：库存商品
        $voucher['voucher'][0]['details'][0]['pk_accsubj'] = $inventory_cost[$user_info->adm_shop_id];//科目：库存商品
        $voucher['voucher'][0]['details'][0]['pk_currtype'] = 'CNY';//币种编码

        $voucher['voucher'][0]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
        $voucher['voucher'][0]['details'][1]['ass'][0]['checkvaluecode'] = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$cg_data['cg_supplyunit'];//辅助核算的值编码-用友客商的编码
        $voucher['voucher'][0]['details'][1]['detailindex'] = '2';//分录号
        $voucher['voucher'][0]['details'][1]['explanation'] = $details_explanation;//摘要
        $voucher['voucher'][0]['details'][1]['localcreditamount'] = $amount;//本币贷方金额
        $voucher['voucher'][0]['details'][1]['pk_accsubj'] = '220201';//科目：应付账款-货款
        $voucher['voucher'][0]['details'][1]['pk_currtype'] = 'CNY';//币种编码

        $voucher['voucher'][0]['no'] = $find_voucher->vou_no + 1;//凭证号
        $voucher['voucher'][0]['pk_corp'] = $unitcode;//公司 9999
        $voucher['voucher'][0]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
        $voucher['voucher'][0]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
        $voucher['voucher'][0]['pk_vouchertype'] = '记账';//凭证类别简称
        $voucher['voucher'][0]['explanation'] = $explanation;//凭证摘要
        // 调用u8系统接口
        $curl_return = $yongyou->u8cloudApi('凭证新增', $voucher);
        // 判断用友接口返回的数据
        if ($curl_return['status'] != 'success') {
            self::logRecord(5011, $user_info, $voucher, $curl_return);//保存操作日志
            // 如果凭证添加失败，凭证号自动加1
            $vou_data['vou_voucher_id'] = 0;//凭证所对应的id：工单id
            $vou_data['vou_voucher_type'] = 0;//类型：1采购入库2工单审核
            $vou_data['vou_no'] = $find_voucher->vou_no + 1;//凭证号
            // self::insertVoucher($user_info, $vou_data, 1);
            return ['code'=> 500, 'msg'=>'error', 'vou_data'=>$vou_data, 'data'=>'U8财务系统凭证上传失败！'];
        }

        // 添加用友上传凭证的记录
        $vou_info['vou_voucher_id'] = $vou_voucher_id;//凭证所对应的id：采购单id/工单id
        $vou_info['vou_voucher_number'] = $vou_voucher_number;//凭证对应的单号：采购单号
        $vou_info['vou_voucher_record_number'] = $request_voucher['rk_number'];//采购入库记录单号
        $vou_info['vou_voucher_type'] = 1;//凭证所对应的id：采购单id/工单id
        $vou_info['vou_no'] = $find_voucher->vou_no + 1;//凭证号
        self::insertVoucher($user_info, $vou_info, 1);
        return ['code'=>200, 'msg'=>'success', 'data'=>'U8财务系统凭证上传成功！'];
    }

    /**
     * [apiAccountVerify 结款明细确认上传凭证]
     * @param  [type]  $user_info       [用户信息]
     * @param  [type]  $search_data [查询的结款明细数据]
     * @param  [type]  $request_voucher [凭证需要的数据]
     * @return [type]                   [description]
     */
    public static function apiAccountVerify($user_info, $search_data, $request_voucher)
    {
        // 调用u8系统接口，将凭证数据传到用友系统上，需要传的凭证
        /*
            acset_type 单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款9订单代收10采购入库单预付款11订单退款12工单代收13订单完成后结算14非实物开单15.订单冲单16.加盟店订单收款17.加盟店订单代收18.工单结算19.旧货回收20售后单结算21销售出库单22采购单23采购退货单24采购款到发货(预付款)

            收款确认时  借：银行存款   贷：对应的科目
            付款确认时  借：对应科目   贷：银行存款  
                货物入库时：
                    借：库存商品
                    贷：应付账款-货款
                付款时：
                    借：应付账款-货款
                    贷：银行存款
         */
        // 金额为0的用友系统无法上传凭证
        if (empty(abs($request_voucher['voucher_price']))) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'U8财务系统凭证上传成功！'];
        }

        $yongyou = new YongYouController;
        // 获取门店对应用友系统的配置数据
        $unitcode = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['unitcode'];//用友-公司编码
        $subjschemecode  = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['subjschemecode'];//用友-科目方案编码

        $voucher_price = $request_voucher['voucher_price'];//凭证金额
        $vou_voucher_id = $search_data['acset_id'];//凭证所对应的id：结款明细id
        $vou_voucher_number = $search_data['acset_number'];//凭证对应的单号：流水号

        // acset_inex_type 类型1收入2支出
        if ($search_data['acset_inex_type'] == 2) {
            $voucher_price = '-'.$request_voucher['voucher_price'];
        }
        // dump($search_data);
        // dump($request_voucher);
        // dump($voucher_price);
        // die;
        // 查找凭证号
        $find_voucher = self::findVoucher($user_info);
        $vou_num = 0;
        // dump($search_data['acset_type']);
        if (empty($request_voucher['subjcode']) && $user_info->adm_shop_id == 1) {
            $request_voucher['subjcode'] = '100201';
        }
        switch ($search_data['acset_type']) {
            case '1'://1订单结算,收款；借：银行存款 贷：应收账款
                $find_data = DB::table('order')
                    ->where('ord_shop_id', $user_info->adm_shop_id)
                    ->where('ord_id', $search_data['acset_original_id'])
                    ->where('ord_order_number', $search_data['acset_original_number'])
                    ->select('ord_client_id', 'ord_type')
                    ->first();
                // ord_type 买家类型：1门店零售2渠道单位3速电派单4第三方派单
                if ($find_data->ord_type == 1) {
                    if ($find_data->ord_client_id) {
                        // 会员零售
                        $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.'1';
                    }else{
                        // 临时会员
                        $checkvaluecode = config('apiu8cloud.custcode.temporary').$user_info->adm_shop_id.'0';
                    }
                }else if($find_data->ord_type == 2){
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->ord_client_id;
                }elseif ($find_data->ord_type == 3) {
                    // 速电派单
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.'1';
                }

                $vou_hint = '【订单结算】流水号：'.$search_data['acset_number'].'单号：'.$search_data['acset_original_number'];
                // 借：银行存款
                $voucher['voucher'][0]['details'][0]['detailindex'] = '2';//分录号
                $voucher['voucher'][0]['details'][0]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][0]['details'][0]['localdebitamount'] = $voucher_price;//本币借方金额
                $voucher['voucher'][0]['details'][0]['pk_accsubj'] = $request_voucher['subjcode'];//科目：银行存款
                $voucher['voucher'][0]['details'][0]['pk_currtype'] = 'CNY';//币种编码

                // 贷：应收账款
                $voucher['voucher'][0]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][0]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                $voucher['voucher'][0]['details'][1]['detailindex'] = '1';//分录号
                $voucher['voucher'][0]['details'][1]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][0]['details'][1]['localcreditamount'] = $voucher_price;//本币贷方金额
                $voucher['voucher'][0]['details'][1]['pk_accsubj'] = '1122';//科目：应收账款
                $voucher['voucher'][0]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                $voucher['voucher'][0]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][0]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][0]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][0]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][0]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][0]['explanation'] = $vou_hint;//凭证摘要
                break;
            case '6'://6预收款,收款；借：银行存款    贷：应收账款
                $find_data = DB::table('receivable_credit')
                    ->where('recr_shop_id', $user_info->adm_shop_id)
                    ->where('recr_original_id', $search_data['acset_original_id'])
                    ->where('recr_original_number', $search_data['acset_original_number'])
                    ->select('recr_client_type', 'recr_client_id')
                    ->first();
                // recr_client_type 客户类型：1.会员零售 2.来往单位 3.外派门店（加盟店或总店） 4会员零售(工单代收）5接单门店（总店或加盟店）6速电派单
                if ($find_data->recr_client_type == 1 || $find_data->recr_client_type == 4) {
                    $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.'1';
                }elseif ($find_data->recr_client_type == 2) {
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->recr_client_id;
                }else if ($find_data->recr_client_type == 3) {
                    $checkvaluecode = config('apiu8cloud.custcode.assignment').$user_info->adm_shop_id.$find_data->recr_client_id;
                }elseif ($find_data->recr_client_type == 6) {
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.'1';
                }
                // 借：银行存款
                $vou_hint = '【预收款】流水号：'.$search_data['acset_number'].'单号：'.$search_data['acset_original_number'];
                $explanation = $vou_hint;
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localcreditamount'] = $request_voucher['voucher_price'];//本币贷方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $request_voucher['subjcode'];//科目：银行存款
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码

                // 贷：应收账款
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localdebitamount'] = $request_voucher['voucher_price'];//本币借方金额
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = '1122';//科目：应收账款
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                break;
            case '9'://9订单代收,收款或还款；收款，借：银行存款    贷：其他应付款-代收代付款；还款，借：其他应付款-代收代付款  贷：银行存款
                $find_data = DB::table('order')
                    ->where('ord_shop_id', $user_info->adm_shop_id)
                    ->where('ord_id', $search_data['acset_original_id'])
                    ->where('ord_order_number', $search_data['acset_original_number'])
                    ->select('ord_client_id', 'ord_type')
                    ->first();
                // ord_type 客户类型：1.会员零售 2.来往单位 3.外派门店（加盟店或总店） 4会员零售(工单代收）5接单门店（总店或加盟店）6速电派单
                if ($find_data->ord_type == 1 || $find_data->ord_type == 4) {
                    $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.'1';
                }elseif ($find_data->ord_type == 2) {
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->ord_client_id;
                }else if ($find_data->ord_type == 3) {
                    $checkvaluecode = config('apiu8cloud.custcode.assignment').$user_info->adm_shop_id.$find_data->ord_client_id;
                }elseif ($find_data->ord_type == 6) {
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.'1';
                }

                $vou_hint = '【预收款】流水号：'.$search_data['acset_number'].'单号：'.$search_data['acset_original_number'];
                $explanation = $vou_hint;
                // acset_inex_type 类型1收入2支出
                if ($search_data['acset_inex_type'] == 2) {
                    // 支出就是还款
                    // 借：其他应付款-代收款项  贷：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = '224103';//科目：其他应付款-代收款项
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                    
                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $request_voucher['subjcode'];//贷：科目：银行存款
                }else{
                    // 收入就是收款
                    // 收款，借：银行存款    贷：其他应付款-代收代付款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $request_voucher['subjcode'];//借：科目：银行存款

                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = '224103';//贷：科目：其他应付款-代收款项
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                }

                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localcreditamount'] = $request_voucher['voucher_price'];//本币贷方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码

                // 贷：应收账款
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localdebitamount'] = $request_voucher['voucher_price'];//本币借方金额
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                break;
            case '12'://12工单代收,收款；借：银行存款  贷：其他应付款-代收款项
                $find_data = DB::table('work_order as wo')
                    ->leftjoin('work_client as wc', 'wc.wocl_wor_id', '=', 'wo.wor_id')
                    ->where('wor_shop_id', $user_info->adm_shop_id)
                    ->where('wor_id', $search_data['acset_original_id'])
                    ->where('wor_number', $search_data['acset_original_number'])
                    ->select('wocl_client_id', 'wor_type')
                    ->first();
                // wor_type 客户类型：1.会员零售 2.来往单位 3.外派门店（加盟店或总店） 4会员零售(工单代收）5接单门店（总店或加盟店）6速电派单
                if ($find_data->wor_type == 1 || $find_data->wor_type == 4) {
                    $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.'1';
                }elseif ($find_data->wor_type == 2) {
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->wocl_client_id;
                }else if ($find_data->wor_type == 3) {
                    $checkvaluecode = config('apiu8cloud.custcode.assignment').$user_info->adm_shop_id.$find_data->wocl_client_id;
                }elseif ($find_data->wor_type == 6) {
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.'1';
                }

                $vou_hint = '【预收款】流水号：'.$search_data['acset_number'].'单号：'.$search_data['acset_original_number'];
                $explanation = $vou_hint;
                // acset_inex_type 类型1收入2支出
                if ($search_data['acset_inex_type'] == 2) {
                    // 支出就是还款
                    // 借：其他应付款-代收款项  贷：银行存款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = '224103';//科目：其他应付款-代收款项
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $request_voucher['subjcode'];//贷：科目：银行存款
                }else{
                    // 收入就是收款
                    // 收款，借：银行存款    贷：其他应付款-代收代付款
                    $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = $request_voucher['subjcode'];//借：科目：银行存款

                    $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = '224103';//贷：科目：其他应付款-代收款项
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                    $voucher['voucher'][$vou_num]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                }

                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localcreditamount'] = $request_voucher['voucher_price'];//本币贷方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码

                // 贷：应收账款
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localdebitamount'] = $request_voucher['voucher_price'];//本币借方金额
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                break;
            case '13'://13订单完成后结算,收款；借：银行存款 贷：应收账款
                $find_data = DB::table('order')
                    ->where('ord_shop_id', $user_info->adm_shop_id)
                    ->where('ord_id', $search_data['acset_original_id'])
                    ->where('ord_order_number', $search_data['acset_original_number'])
                    ->select('ord_client_id', 'ord_type')
                    ->first();
                // ord_type 买家类型：1门店零售2渠道单位3速电派单4第三方派单
                if ($find_data->ord_type == 1) {
                    if ($find_data->ord_client_id) {
                        // 会员零售
                        $checkvaluecode = config('apiu8cloud.custcode.member').$user_info->adm_shop_id.'1';
                    }else{
                        // 临时会员
                        $checkvaluecode = config('apiu8cloud.custcode.temporary').$user_info->adm_shop_id.'0';
                    }
                }else if($find_data->ord_type == 2){
                    // 客户单位
                    $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->ord_client_id;
                }elseif ($find_data->ord_type == 3) {
                    // 速电派单
                    $checkvaluecode = config('apiu8cloud.custcode.platform').$user_info->adm_shop_id.'1';
                }

                $vou_hint = '【订单完成后结算】流水号：'.$search_data['acset_number'].'单号：'.$search_data['acset_original_number'];
                // 借：银行存款
                $voucher['voucher'][0]['details'][0]['detailindex'] = '2';//分录号
                $voucher['voucher'][0]['details'][0]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][0]['details'][0]['localdebitamount'] = $voucher_price;//本币借方金额
                $voucher['voucher'][0]['details'][0]['pk_accsubj'] = $request_voucher['subjcode'];//科目：银行存款
                $voucher['voucher'][0]['details'][0]['pk_currtype'] = 'CNY';//币种编码

                // 贷：应收账款
                $voucher['voucher'][0]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][0]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                $voucher['voucher'][0]['details'][1]['detailindex'] = '1';//分录号
                $voucher['voucher'][0]['details'][1]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][0]['details'][1]['localcreditamount'] = $voucher_price;//本币贷方金额
                $voucher['voucher'][0]['details'][1]['pk_accsubj'] = '1122';//科目：应收账款
                $voucher['voucher'][0]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                $voucher['voucher'][0]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][0]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][0]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][0]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][0]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][0]['explanation'] = $vou_hint;//凭证摘要
                break;
            case '18'://18工单结算-工单费用, 付款；借：应收账款 贷：银行存款
                $find_data = DB::table('work_order')
                    ->where('wor_shop_id', $user_info->adm_shop_id)
                    ->where('wor_id', $search_data['acset_original_id'])
                    ->where('wor_number', $search_data['acset_original_number'])
                    ->select('wor_service_shop_id')
                    ->first();
                // 客商，加盟店
                $checkvaluecode = config('apiu8cloud.custcode.assignment').$user_info->adm_shop_id.$find_data->wor_service_shop_id;

                $vou_hint = '【工单费用结算】流水号：'.$search_data['acset_number'].'单号：'.$search_data['acset_original_number'];
                // 借：应收账款
                $voucher['voucher'][0]['details'][0]['detailindex'] = '2';//分录号
                $voucher['voucher'][0]['details'][0]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][0]['details'][0]['localdebitamount'] = $voucher_price;//本币借方金额
                $voucher['voucher'][0]['details'][0]['pk_accsubj'] = '1122';//科目：应收账款
                $voucher['voucher'][0]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][0]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][0]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                // 贷：银行存款
                $voucher['voucher'][0]['details'][1]['detailindex'] = '1';//分录号
                $voucher['voucher'][0]['details'][1]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][0]['details'][1]['localcreditamount'] = $voucher_price;//本币贷方金额
                $voucher['voucher'][0]['details'][1]['pk_accsubj'] = $request_voucher['subjcode'];//科目：银行存款
                $voucher['voucher'][0]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                $voucher['voucher'][0]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][0]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][0]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][0]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][0]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][0]['explanation'] = $vou_hint;//凭证摘要
                break;
            case '21'://21销售出库单
                /*
                    借：应收账款--客户
                    贷：主营业务收入
                    应交税费-应交增值税-销项税
                    借：主营业务成本
                    贷：库存商品
                 */

                $find_data = DB::table('sell')
                    ->where('sell_shop_id', $user_info->adm_shop_id)
                    ->where('sell_id', $search_data['acset_original_id'])
                    ->where('sell_number', $search_data['acset_original_number'])
                    ->select('sell_chun_id')
                    ->first();
                $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->sell_chun_id;

                $vou_hint = '【销售出库单】流水号：'.$search_data['acset_number'].'单号：'.$search_data['acset_original_number'];
                // 借：应收账款
                $voucher['voucher'][0]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][0]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                $voucher['voucher'][0]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][0]['details'][0]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][0]['details'][0]['localdebitamount'] = $voucher_price;//本币借方金额
                $voucher['voucher'][0]['details'][0]['pk_accsubj'] = '1122';//科目：应收账款
                $voucher['voucher'][0]['details'][0]['pk_currtype'] = 'CNY';//币种编码

                // 贷：主营业务收入
                $voucher['voucher'][0]['details'][1]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][0]['details'][1]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码
                $voucher['voucher'][0]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][0]['details'][1]['explanation'] = $vou_hint;//摘要
                $voucher['voucher'][0]['details'][1]['localcreditamount'] = $voucher_price;//本币贷方金额
                $voucher['voucher'][0]['details'][1]['pk_accsubj'] = '6001';//科目：主营业务收入
                $voucher['voucher'][0]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                $voucher['voucher'][0]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][0]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][0]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][0]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][0]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][0]['explanation'] = $vou_hint;//凭证摘要
                break;
            case '22'://22采购单,付款；借：应付账款-货款    贷：银行存款
                // 查询采购单数据，采购入库单确认
                $find_data = DB::table('purchase_order as po')
                    ->leftjoin('ware_inorder as wi', 'wi.cg_number', '=', 'po.cg_number')
                    ->where('rk_id', $search_data['acset_original_id'])
                    ->where('rk_number', $search_data['acset_original_number'])
                    ->first(['cg_supplyunit']);
                $checkvaluecode = config('apiu8cloud.custcode.unit').$user_info->adm_shop_id.config('apiu8cloud.project.item').$find_data->cg_supplyunit;

                // 借：应付账款-货款
                $vou_hint = '【采购入库付款】流水号：'.$search_data['acset_number'].'单号：'.$search_data['acset_original_number'];
                $explanation = $vou_hint;
                $voucher['voucher'][$vou_num]['details'][0]['detailindex'] = '1';//分录号
                $voucher['voucher'][$vou_num]['details'][0]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][0]['localcreditamount'] = $voucher_price;//本币贷方金额
                $voucher['voucher'][$vou_num]['details'][0]['pk_accsubj'] = '220201';//科目：应付账款-货款
                $voucher['voucher'][$vou_num]['details'][0]['pk_currtype'] = 'CNY';//币种编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checktypecode'] = '73';//辅助核算类型编码
                $voucher['voucher'][$vou_num]['details'][0]['ass'][0]['checkvaluecode'] = $checkvaluecode;//辅助核算的值编码-用友客商的编码

                // 贷：银行存款
                $voucher['voucher'][$vou_num]['details'][1]['detailindex'] = '2';//分录号
                $voucher['voucher'][$vou_num]['details'][1]['explanation'] = $explanation;//摘要
                $voucher['voucher'][$vou_num]['details'][1]['localdebitamount'] = $voucher_price;//本币借方金额
                $voucher['voucher'][$vou_num]['details'][1]['pk_accsubj'] = $request_voucher['subjcode'];//科目：银行存款
                $voucher['voucher'][$vou_num]['details'][1]['pk_currtype'] = 'CNY';//币种编码

                $voucher['voucher'][$vou_num]['no'] = $find_voucher->vou_no + 1;//凭证号
                $voucher['voucher'][$vou_num]['pk_corp'] = $unitcode;//公司 9999
                $voucher['voucher'][$vou_num]['pk_glorgbook'] = $unitcode.'-'.$subjschemecode;//账簿 9999-0003
                $voucher['voucher'][$vou_num]['pk_prepared'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info->adm_shop_id]['pk_prepared'];//制单人编码
                $voucher['voucher'][$vou_num]['pk_vouchertype'] = '记账';//凭证类别简称
                $voucher['voucher'][$vou_num]['explanation'] = $explanation;//凭证摘要
                break;
            default:
                return ['code'=> 500, 'msg'=>'error', 'vou_data'=>'', 'data'=>'U8财务系统上传失败！'];
                break;
        }
        // 调用u8系统接口
        $curl_return = $yongyou->u8cloudApi('凭证新增', $voucher);
        // 判断用友接口返回的数据
        if ($curl_return['status'] != 'success') {
            self::logRecord(5041, $user_info, $voucher, $curl_return);//保存操作日志
            // 如果凭证添加失败，凭证号自动加1
            $vou_data['vou_voucher_id'] = 0;//凭证所对应的id：工单id
            $vou_data['vou_voucher_type'] = 0;//类型：1采购入库2工单审核
            $vou_data['vou_no'] = $find_voucher->vou_no + 1;//凭证号
            // self::insertVoucher($user_info, $vou_data, 1);
            return ['code'=> 500, 'msg'=>'error', 'vou_data'=>$vou_data, 'data'=>'U8财务系统凭证上传失败！'];
        }

        // 添加用友上传凭证的记录
        $vou_info['vou_voucher_id'] = $vou_voucher_id;//凭证所对应的id：采购单id/工单id/结款明细id
        $vou_info['vou_voucher_number'] = $vou_voucher_number;//凭证对应的单号：流水号
        $vou_info['vou_voucher_record_number'] = $search_data['acset_original_number'];//原始单号
        $vou_info['vou_voucher_type'] = 3;//凭证所对应的id：采购单id/工单id/结款明细id
        $vou_info['vou_no'] = $find_voucher->vou_no + 1;//凭证号
        self::insertVoucher($user_info, $vou_info, 1);
        return ['code'=>200, 'msg'=>'success', 'data'=>'U8财务系统凭证上传成功！'];
    }

    /**
     * [logRecord 日志]
     * @param  [type] $code      [返回码-错误码]
     * @param  [type] $user_info       [用户信息]
     * @param  [type] $search_data     [单据信息/上传凭证数据]
     * @param  [type] $request_voucher [凭证相关信息/接口返回数据]
     * @return [type]                  [description]
     */
    protected static function logRecord($code, $user_info, $search_data, $request_voucher)
    {
        // 返回码对应的信息
        $code_message = [
            '2001'=>'金额为0，U8财务系统无法上传凭证！',
            '2002'=>'其他类型，无法上传凭证！',
            '5001'=>'采购单款到发货，上传凭证失败',
            '5011'=>'采购入库，上传凭证失败',
            '5021'=>'U8财务系统凭证作废失败！',
            '5031'=>'工单审核，上传凭证失败！',
            '5032'=>'工单审核，速电网单上传凭证失败！',
            '5033'=>'速电对账，上传凭证失败！',
            '5041'=>'结款明细，上传凭证失败！',
            '0'=>'临时测试',
        ];

        $log_data['time'] = date('Y-m-d H:i:s');
        $log_data['code'] = $code;
        $log_data['code_message'] = $code_message[$code];
        $log_data['user_info'] = $user_info;
        $log_data['search_data'] = $search_data;
        $log_data['request_voucher'] = $request_voucher;
        logRecord($log_data, 'u8cloudApi_log', 2);
    }

    /**
     * [findVoucher 查找当前凭证号]
     * @param  [type] $user_info [用户信息]
     * @return [type]            [description]
     */
    protected static function findVoucher($user_info)
    {
        // 查找凭证号
        $now_year_month = date('Ym');//当前年月
        $find_voucher = DB::table('voucher')
            ->where('vou_cid', $user_info->adm_cid)
            ->where('vou_shop_id', $user_info->adm_shop_id)
            ->where('vou_year_month', $now_year_month)
            ->select('vou_id', 'vou_no')
            ->orderBy('vou_id', 'desc')
            ->first();
        if (empty($find_voucher)) {
            $find_voucher['vou_no'] = config('apiu8cloud.vou_no');//凭证号初始值
            $find_voucher = (object)$find_voucher;
        }
        return $find_voucher;
    }

    /**
     * [insertVoucher 添加凭证数据]
     * @param  [type]  $user_info [用户信息]
     * @param  [type]  $vou_info  [凭证数据]
     * @param  integer $type      [类型1添加一条2添加多条]
     * @return [type]             [description]
     */
    protected static function insertVoucher($user_info, $vou_info, $type = 1)
    {
        // 查找凭证号
        $now_year_month = date('Ym');//当前年月
        if ($type == 1) {
            // 添加用友上传凭证的记录
            $vou_data['vou_cid'] = $user_info->adm_cid;
            $vou_data['vou_shop_id'] = $user_info->adm_shop_id;
            $vou_data['vou_voucher_id'] = $vou_info['vou_voucher_id'];//凭证所对应的id：采购单id/工单id
            $vou_data['vou_voucher_number'] = isset($vou_info['vou_voucher_number']) ? $vou_info['vou_voucher_number'] : '';//凭证对应的单号：采购单号
            $vou_data['vou_voucher_record_number'] = isset($vou_info['vou_voucher_record_number']) ? $vou_info['vou_voucher_record_number'] : '';//采购入库记录单号
            $vou_data['vou_year_month'] = $now_year_month;
            $vou_data['vou_voucher_type'] = $vou_info['vou_voucher_type'];//类型：1采购入库2工单审核
            $vou_data['vou_no'] = $vou_info['vou_no'];//凭证号
        } else {
            // 添加用友上传凭证的记录
            foreach ($vou_info as $key => $value) {
                $vou_data[$key]['vou_cid'] = $user_info->adm_cid;
                $vou_data[$key]['vou_shop_id'] = $user_info->adm_shop_id;
                $vou_data[$key]['vou_voucher_id'] = $value['vou_voucher_id'];//凭证所对应的id：采购单id/工单id
                $vou_data[$key]['vou_voucher_number'] = isset($value['vou_voucher_number']) ? $value['vou_voucher_number'] : '';//凭证对应的单号：采购单号
                $vou_data[$key]['vou_voucher_record_number'] = isset($value['vou_voucher_record_number']) ? $value['vou_voucher_record_number'] : '';//采购入库记录单号
                $vou_data[$key]['vou_year_month'] = $now_year_month;
                $vou_data[$key]['vou_voucher_type'] = $value['vou_voucher_type'];//凭证所对应的id：采购单id/工单id
                $vou_data[$key]['vou_no'] = $value['vou_no'];//凭证号
            }
        }
        $vou_res = DB::table('voucher')->insert($vou_data);
        return $vou_res;
    }
}
