<?php

namespace App\Http\Models\Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class SellDetail extends Model
{
    /**
     * [add 生成销售明细数据]
     * @param [type] $user_info            [用户信息]
     * @param [type] $sede_order_number    [订单号]
     * @param [type] $sede_order_type      [订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单]
     * @param [type] $sede_orla_id         [订单标签id]
     * @param [type] $sede_ware_id         [仓库id]
     * @param [type] $sede_client_type     [客户类型：1.门店零售 2.来往单位]
     * @param [type] $sede_client_id       [会员id/来往单位id]
     * @param [type] $sede_service_shop_id [服务门店id]
     * @param [type] $sede_goo_id          [商品id]
     * @param [type] $sede_goo_price       [商品售价,没有*100的价格]
     * @param [type] $sede_goo_quantity    [订单商品数量]
     * @param [type] $sede_goo_cost_price  [商品成本价]
     * @param [type] $sede_goo_inventory   [库存扣除方式1.良品 2.优先]
     * @param [type] $sede_goo_state       [商品状态1.正常 2.删除3回收的商品4换货商品]
     * @param [type] $sede_remarks       [订单备注]
     */
    public static  function add(
        $user_info,
        $sede_order_number,
        $sede_order_type,
        $sede_orla_id,
        $sede_ware_id,
        $sede_client_type,
        $sede_client_id,
        $sede_service_shop_id,
        $sede_goo_id,
        $sede_goo_price,
        $sede_goo_quantity,
        $sede_goo_cost_price,
        $sede_goo_inventory,
        $sede_goo_state,
        $sede_remarks = ''
    ) {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        if ($sede_order_type == 4 || $sede_goo_state == 4) {
			$sede_plus_minus = 2;
        }else{
			$sede_plus_minus = 1;
        }
        $sede_data['sede_create_id'] = $user_info->adm_id; //创建人id
        $sede_data['sede_cid'] = $user_info->adm_cid;
        $sede_data['sede_shop_id'] = $user_info->adm_shop_id;
        $sede_data['sede_superior_shop_id'] = $shop_id;
        $sede_data['sede_order_number'] = $sede_order_number; //订单号
        $sede_data['sede_order_type'] = $sede_order_type; //订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单
        $sede_data['sede_orla_id'] = $sede_orla_id; //订单标签id
        $sede_data['sede_ware_id'] = $sede_ware_id; //仓库id
        $sede_data['sede_client_type'] = $sede_client_type; //客户类型：1.门店零售 2.来往单位
        $sede_data['sede_client_id'] = $sede_client_id; //会员id/来往单位id
        $sede_data['sede_service_shop_id'] = $sede_service_shop_id; //服务门店id
        $sede_data['sede_goo_id'] = $sede_goo_id; //商品id
        $sede_data['sede_goo_price'] = $sede_goo_price * 100; //销售单价/退货单价
        $sede_data['sede_goo_quantity'] = $sede_goo_quantity; //销售数量/退货数量
        $sede_data['sede_goo_cost_price'] = $sede_goo_cost_price * 100; //成本单价
        $sede_data['sede_goo_inventory'] = $sede_goo_inventory; //库存扣除方式1.良品 2.优先
        $sede_data['sede_goo_state'] = $sede_goo_state; //商品状态1.正常 2.删除3回收的商品4换货商品
        $sede_data['sede_update_time'] = date('Y-m-d H:i:s');
        $sede_data['sede_amount_price'] = $sede_goo_price * $sede_goo_quantity * 100; //订单商品销售总金额
        $sede_data['sede_cost_amount_price'] = $sede_goo_cost_price * $sede_goo_quantity * 100; //订单商品成本总金额
        $sede_data['sede_plus_minus'] = $sede_plus_minus; //金额正负：1正值2负值
        $sede_data['sede_remarks'] = $sede_remarks; //订单备注
        $sede_id = DB::table('sell_detail')->insert($sede_data);
        return $sede_id;
    }

    /**
     * [findGoodsCostPrice 查询订单商品的成本金额]
     * @param  [type] $sede_order_number [订单号]
     * @param  [type] $sede_goo_id       [商品id]
     * @return [type]                    [description]
     */
    public static function findGoodsCostPrice($sede_order_number,$sede_goo_id)
    {

        $sede_goo_cost_price = DB::table('sell_detail')
            ->where('sede_order_number', $sede_order_number)
            ->where('sede_goo_id', $sede_goo_id)
            ->value('sede_goo_cost_price');
        return $sede_goo_cost_price;
    }
}

