<?php

namespace App\Http\Models\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
class Replenish extends Model
{
    /**
     * 补货方法
     * @param  $user_info    array      用户数据
     * @param  $goods_id     array      商品id
     * @param  $quantity     array      补货数量
     * @param  $goo_name     array      商品名称
     * @param  $goo_encode   array      检索编号
     * @param  $cate_name    array      分类名称
     * @param  $bra_name     array      商品品牌

     * @return boolean
     */
    public static function inventory(
        $user_info,
        $goods_id,
        $quantity,
        $goo_name,
        $goo_encode,
        $cate_name,
        $bra_name
    ){
        if (count($goods_id) != count($quantity)) {
            return false;
        }
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        //获取待补商品数据
        $regw_data = collect(DB::table('replenishment_goods_wd')
            ->whereIn('regw_goo_id',$goods_id)
            ->where('regw_shop_id',$user_info->adm_shop_id)
            ->get(['regw_stock_type','regw_stock_quantity','regw_goo_id']))
            ->keyBy('regw_goo_id')
            ->toArray();

        $goods_id_str = implode(',',$goods_id);
        $sql = 'UPDATE `faster_replenishment_goods_wd` SET ';
        $stock_quantity = '';//库存数量
        $enroute_amount = '';//在途数量
        $delivery_amount = '';//累计数量
        $update_time = '';//修改时间
        $stock_type = '';//库存正负
        $ids = '';
        $insert_key = 0;
        $insert_goo_data = [];

        foreach ($goods_id as $key => $value) {
            //如果待补商品里有此数据
            if(isset($regw_data[$value])){
                $num = $quantity[$key];
                // 判断库存是为负数
                if($regw_data[$value]->regw_stock_type == 3){
                    if($regw_data[$value]->regw_stock_quantity > $num){
                        //库存数量
                        $stock_quantity .= ' WHEN '.$value.' THEN `regw_stock_quantity` - '.$num;
                        $stock_type .= ' WHEN '.$value.' THEN 3';
                    }
                    if($regw_data[$value]->regw_stock_quantity == $num){
                        //库存数量
                        $stock_quantity .= ' WHEN '.$value.' THEN `regw_stock_quantity` - '.$num;
                        $stock_type .= ' WHEN '.$value.' THEN 1';
                    }
                    if($regw_data[$value]->regw_stock_quantity < $num){
                        $num = $num - $regw_data[$value]->regw_stock_quantity - $regw_data[$value]->regw_stock_quantity;
                        //库存数量
                        $stock_quantity .= ' WHEN '.$value.' THEN `regw_stock_quantity` + '.$num;
                        $stock_type .= ' WHEN '.$value.' THEN 2';
                    }
                //库存数量为平
                }else if($regw_data[$value]->regw_stock_type == 1){
                    //库存数量
                    $stock_quantity .= ' WHEN '.$value.' THEN `regw_stock_quantity` + '.$num;
                    $stock_type .= ' WHEN '.$value.' THEN 2';
                //库存数量为正
                }else if($regw_data[$value]->regw_stock_type == 2){
                    $stock_quantity .= ' WHEN '.$value.' THEN `regw_stock_quantity` + '.$num;
                    $stock_type .= ' WHEN '.$value.' THEN 2';
                }
                //在途数量
                $enroute_amount .= ' WHEN '.$value.' THEN `regw_enroute_amount` - '.$quantity[$key];
                //累计数量
                // $delivery_amount .= ' WHEN '.$value.' THEN `regw_delivery_amount` + '.$quantity[$key];
                // 更改时间
                $update_time .= ' WHEN '.$value.' THEN "'.date('Y-m-d H:i:s').'"';
            }else{
                $insert_goo_data[$insert_key]['regw_goo_id'] = $value;
                $insert_goo_data[$insert_key]['regw_goo_name'] = $goo_name[$key];
                $insert_goo_data[$insert_key]['regw_goo_encode'] = $goo_encode[$key];
                $insert_goo_data[$insert_key]['regw_cate_name'] = $cate_name[$key];
                $insert_goo_data[$insert_key]['regw_bra_name'] = $bra_name[$key];
                $insert_goo_data[$insert_key]['regw_stock_quantity'] = $quantity[$key];
                $insert_goo_data[$insert_key]['regw_stock_type'] = 2;
                $insert_goo_data[$insert_key]['regw_delivery_amount'] = $quantity[$key];
                $insert_goo_data[$insert_key]['regw_shop_superior_id'] = $shop_id;
                $insert_goo_data[$insert_key]['regw_shop_id'] = $user_info->adm_shop_id;
                $insert_goo_data[$insert_key]['regw_cid'] = $user_info->adm_cid;
                $insert_key++;
            }
        }
        if(!empty($stock_quantity)){
            $sql .= ' `regw_stock_quantity`=  CASE `regw_goo_id` '.$stock_quantity.' END,';
            if(!empty($stock_type)){
                $sql .= ' `regw_stock_type`=  CASE `regw_goo_id` '.$stock_type.' END,';
            }
            $sql .= ' `regw_enroute_amount`=  CASE `regw_goo_id` '.$enroute_amount.' END,';
            // $sql .= ' `regw_delivery_amount`=  CASE `regw_goo_id` '.$delivery_amount.' END,';
            $sql .= ' `regw_update_time`=  CASE `regw_goo_id` '.$update_time.' END';
            $sql .= ' WHERE  `regw_goo_id` IN ('.trim($goods_id_str,',').') AND  `regw_shop_id` = '.$user_info->adm_shop_id;
            $regw_update = DB::update($sql);
            if(empty($regw_update)){
                return false;
            }
        }
        //待补商品里没有此商品新增
        if(!empty($insert_goo_name)){
            $insert_res = DB::table('replenishment_goods_wd')->insert($insert_goo_name);
            if(empty($insert_res)){
                return false;
            }
        }
        return true;
    }
}
