<?php
namespace App\Http\Models\Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class ReceivablePay extends Model
{

    /**
     * 生成订单应收应付
     * 20230721
     * @param [type] $user_info                 [用户信息]
     * @param [type] $recpay_type               [类型：1.订单]
     * @param [type] $recpay_original_id        [与类型所对应的id]
     * @param [type] $recpay_original_number    [与类型所对应的单号]
     * @param [type] $recpay_client_type        [客户类型：0散户1门店零售2企业客户]
     * @param [type] $recpay_client_id          [会员id/来往单位id/加盟店id/虚拟加盟店]
     * @param [type] $recpay_client_name        [会员姓名/来往单位名称/加盟店名称/虚拟加盟店
     * @param [type] $recpay_receivable_price   [应收金额]
     * @param [type] $recpay_arrears_price      [欠收金额]
     * @param [type] $recpay_actual_price       [实收金额]
     * @param [type] $recpay_cost_price         [成本价]
     * @param [type] $recpay_receivable_pay     [应付金额]
     * @param [type] $recpay_actual_pay         [实付金额]
     * @param [type] $recpay_state              [状态：1未确认2已确认3已收款4已付款]
     * @param [type] $recpay_settle_time        [结款时间]
     * @param [type] $recpay_settle_id          [结款人]
     * @param [type] $recpay_remark             [备注]
     */
    public static function add($user_info,$input) {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        if($user_info) {
            $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
            $receivable['recpay_cid'] = $user_info->adm_cid;
            $receivable['recpay_shop_id'] = $user_info->adm_shop_id;
            $receivable['recpay_shop_superior_id'] = $shop_id;
        }else{
            $receivable['recpay_cid'] = $input['recpay_cid'];
            $receivable['recpay_shop_id'] = $input['recpay_shop_id'];
            $receivable['recpay_shop_superior_id'] = $input['recpay_shop_superior_id'];
        }
        //判断订单金额征服值
        /*$ord_plus_minus = DB::table('order')
                ->where('ord_id', $recr_original_id)
                ->value('ord_plus_minus');
        if ($ord_plus_minus == 2) {
            $receivable['recr_plus_minus'] = 2;
        }*/
        $receivable['recpay_type'] = $input['recpay_type']??'1'; //类型：1.销售订单
        //$receivable['recr_number_id'] = $recr_number_id; //应收账单id
        $receivable['recpay_original_id'] = $input['recpay_original_id']??'0'; //与类型所对应的id
        $receivable['recpay_original_number'] = $input['recpay_original_number']??''; //与类型所对应的单号
        $receivable['recpay_client_type'] = $input['recpay_client_type']??'0'; //客户类型：1.会员零售 2.来往单位 3.加盟店 4会员零售(工单代收）
        $receivable['recpay_client_id'] = $input['recpay_client_id']??'0'; //会员id/来往单位id
        $receivable['recpay_client_name'] = $input['recpay_client_name']??''; //来往单位名称
        $receivable['recpay_receivable_price'] = $input['recpay_receivable_price']??'0'; //应收金额
        $receivable['recpay_arrears_price'] = $input['recpay_arrears_price']??'0'; //欠收金额
        $receivable['recpay_actual_price'] = $input['recpay_actual_price']??'0'; //实收金额
        $receivable['recpay_cost_price'] = $input['recpay_cost_price']??'0'; //成本价
        $receivable['recpay_receivable_pay'] = $input['recpay_receivable_pay']??'0'; //应付金额
        $receivable['recpay_actual_pay'] = $input['recpay_actual_pay']??'0'; //实付金额
        $receivable['recpay_state'] = $input['recpay_state']??'1'; //状态：1未确认2已确认
        $receivable['recpay_order_state'] = $input['recpay_order_state']??'1'; //订单状态：1正常2退款3取消
        $receivable['recpay_remark'] = $input['recpay_remark']??''; //备注
        $receivable['recpay_plus_minus'] = $input['recpay_plus_minus']??'1'; //盈利正负：1正值2负值
        $receivable['recpay_profit'] = $input['recpay_profit']??'0'; //盈利金额
        $receivable['recpay_orcl_id'] = $input['recpay_orcl_id']??'0'; //订单客户id
        $receivable['recpay_source'] = $input['recpay_source']??'1'; //下单来源：1pc端2车主端(车主小程序)3技师端4合作商5智配贴装
        $receivable['recpay_create_time'] = date('Y-m-d H:i:s');; //开单时间(单子的创建时间)
        $recr_id = DB::table('receivable_pay')->insertGetId($receivable);
        if ($recr_id) {
            return ['code'=>200, 'msg'=>'添加成功', 'data'=>$recr_id];
        } else {
            return ['code'=>500, 'msg'=>'添加失败', 'data'=>''];
        }
    }

    /**
     * 修改订单应收应付
     * 20230721
     * @param [type] $recpay_id                 [应收应付id]
     * @param [type] $user_info                 [用户信息]
     * @param [type] $recpay_type               [类型：1.订单]
     * @param [type] $recpay_original_id        [与类型所对应的id]
     * @param [type] $recpay_original_number    [与类型所对应的单号]
     * @param [type] $recpay_client_type        [客户类型：1会员零售2来往单位3外派门店（加盟店或总店）4会员零售(工单代收）5接单门店（总店或加盟店）6速电派单7虚拟加盟店]
     * @param [type] $recpay_client_id          [会员id/来往单位id/加盟店id/虚拟加盟店]
     * @param [type] $recpay_client_name        [会员姓名/来往单位名称/加盟店名称/虚拟加盟店
     * @param [type] $recpay_receivable_price   [应收金额]
     * @param [type] $recpay_arrears_price      [欠收金额]
     * @param [type] $recpay_actual_price       [实收金额]
     * @param [type] $recpay_cost_price         [成本价]
     * @param [type] $recpay_receivable_pay     [应付金额]
     * @param [type] $recpay_actual_pay         [实付金额]
     * @param [type] $recpay_state              [状态：1未确认2已确认3已收款4已付款]
     * @param [type] $recpay_settle_time        [结款时间]
     * @param [type] $recpay_settle_id          [结款人]
     * @param [type] $recpay_remark             [备注]
     */
    public static function edit($input) {
        //判断订单金额 正负值
        /*$ord_plus_minus = DB::table('order')
                ->where('ord_id', $recr_original_id)
                ->value('ord_plus_minus');
        if ($ord_plus_minus == 2) {
            $receivable['recr_plus_minus'] = 2;
        }*/
        if(isset($input['recpay_receivable_price'])){//应收金额
            $receivable['recpay_receivable_price'] = floatval($input['recpay_receivable_price']) * 100;
        }
        if(isset($input['recpay_arrears_price'])){//欠收金额
            $receivable['recpay_arrears_price'] = floatval($input['recpay_arrears_price']) * 100;
        }
        if(isset($input['recpay_actual_price'])){//实收金额
            $receivable['recpay_actual_price'] = floatval($input['recpay_actual_price']) * 100;
        }
        if(isset($input['recpay_cost_price'])){//成本价
            $receivable['recpay_cost_price'] = floatval($input['recpay_cost_price']) * 100;
        }
        if(isset($input['recpay_receivable_pay'])){//应付金额
            $receivable['recpay_receivable_pay'] = floatval($input['recpay_receivable_pay']) * 100;
        }
        if(isset($input['recpay_actual_pay'])){//实付金额
            $receivable['recpay_actual_pay'] = floatval($input['recpay_actual_pay']) * 100;
        }
        if(isset($input['recpay_state'])){//状态：1未确认2已确认
            $receivable['recpay_state'] = $input['recpay_state'];
        }
        if(isset($input['recpay_order_state'])){//订单状态：1正常2退款3取消
            $receivable['recpay_order_state'] = $input['recpay_order_state'];
        }
        if(isset($input['recpay_remark'])){//备注
            $receivable['recpay_remark'] = $input['recpay_remark'];
        }
        if(isset($input['recpay_plus_minus'])){//盈利正负：1正值2负值
            $receivable['recpay_plus_minus'] = $input['recpay_plus_minus'];
        }
        if(isset($input['recpay_profit'])){//盈利金额
            if($input['recpay_profit'] < 0){
                $receivable['recpay_plus_minus'] = 2;
            }
            $receivable['recpay_profit'] = abs(floatval($input['recpay_profit'])) * 100;
        }
        if(isset($input['recpay_statue_pay'])){//绩效是否结算
            $receivable['recpay_statue_pay'] = $input['recpay_statue_pay'];
        }
        $receivable['recpay_update_time'] = date('Y-m-d H:i:s'); //修改时间
        if(isset($input['recpay_id'])){
            $where['recpay_id'] = $input['recpay_id'];
        }
        if(isset($input['recpay_original_id'])){
            $where['recpay_original_id'] = $input['recpay_original_id'];
        }
        $edit_res = DB::table('receivable_pay')
            ->where(function ($query) use ($input) {
                if (isset($input['recpay_id']) && !empty($input['recpay_id'])) {
                    $query->where('recpay_id', $input['recpay_id']);
                }
            })
            ->where(function ($query) use ($input) {
                if (isset($input['recpay_original_id']) && !empty($input['recpay_original_id'])) {
                    $query->where('recpay_original_id', $input['recpay_original_id']);
                }
            })
            ->where(function ($query) use ($input) {
                if (isset($input['recpay_original_number']) && !empty($input['recpay_original_number'])) {
                    $query->where('recpay_original_number', $input['recpay_original_number']);
                }
            })
            ->update($receivable);
        if ($edit_res) {
            return ['code'=>200, 'msg'=>'修改成功', 'data'=>$edit_res];
        } else {
            return ['code'=>500, 'msg'=>'修改失败', 'data'=>''];
        }
    }

    /*
     * @name 详情
     * @param
     * @retrun array
     * @author Ma 2023/7/25 17:39
     *
    */
    public static function info($input){
        $list_data = DB::table('receivable_pay')
            ->where('recpay_id', $input['recpay_id'])
            ->first();
        if($list_data){
            $list_data->recpay_receivable_price = sprintf("%.2f",$list_data->recpay_receivable_price / 100);//应收金额
            $list_data->recpay_arrears_price = sprintf("%.2f",$list_data->recpay_arrears_price / 100);//欠收金额
            $list_data->recpay_actual_price = sprintf("%.2f",$list_data->recpay_actual_price / 100);//实收金额
            $list_data->recpay_cost_price = sprintf("%.2f",$list_data->recpay_cost_price / 100);//成本价
            $list_data->recpay_receivable_pay = sprintf("%.2f",$list_data->recpay_receivable_pay / 100);//应付金额
            $list_data->recpay_actual_pay = sprintf("%.2f",$list_data->recpay_actual_pay / 100);//实付金额
            $list_data->recpay_profit = sprintf("%.2f",$list_data->recpay_profit / 100);//盈利金额
            if ($list_data->recpay_plus_minus == 2) {
                $list_data->recpay_profit = - abs($list_data->recpay_profit);
            }
            return ['code'=>200, 'msg'=>'获取成功', 'data'=>$list_data];
        }else{
            return ['code'=>500, 'msg'=>'获取失败', 'data'=>'获取失败'];
        }

    }
}
