<?php
namespace App\Http\Models\Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class ReceivableBill extends Model
{
    /**
     * 生成应收账单
     * @param [type] $user_info                 [用户信息]
     * @param [type] $recr_type                 [类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 6.销售账单 7.销售出库单 8非实物开单]
     * @param [type] $recr_number_id            [应收账款id]
     * @param [type] $recr_original_id          [原始id]
     * @param [type] $recr_number               [应收账款单号/原始号]
     * @param [type] $recr_client_type          [客户类型：1.会员零售 2.来往单位 3.加盟店 4会员零售(工单代收）]
     * @param [type] $recr_client_id            [会员id/来往单位id]
     * @param [type] $recr_client_name          [来往单位名称]
     * @param [type] $recr_settle_price         [结算金额]
     * @param [type] $recr_settle_time          [结款时间]
     * @param [type] $recr_acti_id              [会计科目id]
     * @param [type] $recr_actual_price         [实际金额]
     * @param [type] $recr_zero_price           [抹零金额]
     * @param [type] $recr_state                [状态：1.未核销 2.已核销]
     * @param [type] $is_myself                 [应收账单id是否是自己 1.不是 2.是]
     * @param [type] $recr_remark               [结款备注]
     * @param [type] $recr_yet_receipt          [已收金额]
     * @param [type] $recr_abort_time           [截止时间]
     * @param [type] $recr_order_time           [开单时间,单子的创建时间]
     */
    public static function add(
        $user_info,
        $recr_type,
        $recr_number_id,
        $recr_original_id,
        $recr_number,
        $recr_client_type,
        $recr_client_id,
        $recr_client_name,
        $recr_settle_price,
        $recr_settle_time,
        $recr_acti_id,
        $recr_actual_price,
        $recr_zero_price,
        $recr_state,
        $is_myself,
        $recr_remark,
        $recr_yet_receipt,
        $recr_abort_time,
        $recr_order_time
    ) {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        //判断订单金额征服值
        $ord_plus_minus = DB::table('order')
                ->where('ord_id', $recr_original_id)
                ->value('ord_plus_minus');
        if ($ord_plus_minus == 2) {
            $receivable['recr_plus_minus'] = 2;
        }
        $receivable['recr_cid'] = $user_info->adm_cid;
        $receivable['recr_shop_id'] = $user_info->adm_shop_id;
        $receivable['recr_shop_superior_id'] = $shop_id;
        $receivable['recr_type'] = $recr_type; //类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 5.采购账单 6.销售账单
        $receivable['recr_number_id'] = $recr_number_id; //应收账单id
        $receivable['recr_original_id'] = $recr_original_id; //与类型所对应的id
        $receivable['recr_original_number'] = $recr_number; //与类型所对应的单号
        $receivable['recr_client_type'] = $recr_client_type; //客户类型：1.会员零售 2.来往单位 3.加盟店 4会员零售(工单代收）
        $receivable['recr_client_id'] = $recr_client_id; //会员id/来往单位id
        $receivable['recr_client_name'] = $recr_client_name; //来往单位名称
        $receivable['recr_settle_price'] = $recr_settle_price; //结算金额
        $receivable['recr_settle_time'] = $recr_settle_time; //结款时间
        $receivable['recr_settle_id'] = $user_info->adm_id; //结款人
        $receivable['recr_acti_id'] = $recr_acti_id; //会计科目id
        $receivable['recr_actual_price'] = $recr_actual_price; //实际金额
        $receivable['recr_zero_price'] = $recr_zero_price; //抹零金额
        $receivable['recr_state'] = $recr_state; //状态：1.未核销 2.已核销
        $receivable['recr_remark'] = $recr_remark ? $recr_remark : ''; //备注
        $receivable['recr_yet_receipt'] = $recr_yet_receipt; //已收金额
        $receivable['recr_abort_time'] = $recr_abort_time; //截止时间
        $receivable['recr_order_time'] = $recr_order_time; //开单时间(单子的创建时间)
        $recr_id = DB::table('receivable_credit')->insertGetId($receivable);
        if ($is_myself == 2) {
            $update_data['recr_number_id'] = $recr_id; //应收款id
            $update_data['recr_update_time'] = date('Y-m-d H:i:s');
            $update_id = DB::table('receivable_credit')
                    ->where('recr_id', $recr_id)
                    ->update($update_data);
            if ($recr_id && $update_id) {
                return $recr_id;
            } else {
                return false;
            }
        } else {
            return $recr_id;
        }
    }

    /**
     * 生成应收账单
     * @param [type] $user_info                 [用户信息]
     * @param [type] $recr_type                 [类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 5.采购账单 6.销售账单]
     * @param [type] $recr_number_id            [应收账款id]
     * @param [type] $recr_original_id          [原始id]
     * @param [type] $recr_number               [应收账款单号/原始号]
     * @param [type] $recr_client_type          [客户类型：1.门店零售 2.来往单位]
     * @param [type] $recr_client_id            [会员id/来往单位id]
     * @param [type] $recr_client_name          [来往单位名称]
     * @param [type] $recr_settle_price         [结算金额]
     * @param [type] $recr_settle_time          [结款时间]
     * @param [type] $recr_acti_id              [会计科目id]
     * @param [type] $recr_actual_price         [实际金额]
     * @param [type] $recr_zero_price           [抹零金额]
     * @param [type] $recr_state                [状态：1.未核销 2.已核销]
     * @param [type] $is_myself                 [应收账单id是否是自己 1.不是 2.是]
     * @param [type] $recr_remark               [结款备注]
     * @param [type] $recr_yet_receipt          [已收金额]
     * @param [type] $recr_abort_time           [截止时间]
     * @param [type] $plus_minus                [金额正负]
     * @param [type] $recr_account_type         [显示类型：1订单收款 2受托代收（订单代收）3委托代收（工单代收）4工单费用（工单收款）5订单账单 6工单账单 7销售账单 8预收款 9销售出库单  10订单退款]
     * @param [type] $orbi_merge_state          [是否合并代收：1是2否]
     * @param [type] $collect_state             [技师是否收钱：0未选择1是2否]
     * @param [type] $recr_order_time           [开单时间(单子的创建时间)]
     */
    public static function create(
        $user_info,
        $recr_type,
        $recr_number_id,
        $recr_original_id,
        $recr_number,
        $recr_client_type,
        $recr_client_id,
        $recr_client_name,
        $recr_settle_price,
        $recr_settle_time,
        $recr_acti_id,
        $recr_actual_price,
        $recr_zero_price,
        $recr_state,
        $is_myself,
        $recr_remark,
        $recr_yet_receipt,
        $recr_abort_time,
        $plus_minus,
        $recr_account_type=1,
        $orbi_merge_state=1,
        $recr_order_time,
        $collect_state=0
    ) {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $receivable['recr_cid'] = $user_info->adm_cid;
        $receivable['recr_shop_id'] = $user_info->adm_shop_id;
        $receivable['recr_shop_superior_id'] = $shop_id;
        $receivable['recr_type'] = $recr_type; //类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 5.采购账单 6.销售账单
        $receivable['recr_account_type'] = $recr_account_type;
        $receivable['recr_number_id'] = $recr_number_id; //应收账单id
        $receivable['recr_original_id'] = $recr_original_id; //与类型所对应的id
        $receivable['recr_original_number'] = $recr_number; //与类型所对应的单号
        $receivable['recr_client_type'] = $recr_client_type; //客户类型：1.门店零售 2.来往单位
        $receivable['recr_client_id'] = $recr_client_id; //会员id/来往单位id
        $receivable['recr_client_name'] = $recr_client_name; //来往单位名称
        $receivable['recr_settle_price'] = $recr_settle_price; //结算金额
        $receivable['recr_settle_time'] = $recr_settle_time; //结款时间
        $receivable['recr_settle_id'] = $user_info->adm_id; //结款人
        $receivable['recr_acti_id'] = $recr_acti_id; //会计科目id
        $receivable['recr_actual_price'] = $recr_actual_price; //实际金额
        $receivable['recr_zero_price'] = $recr_zero_price; //抹零金额
        $receivable['recr_state'] = $recr_state; //状态：1.未核销 2.已核销
        $receivable['recr_remark'] = $recr_remark ? $recr_remark : ''; //备注
        $receivable['recr_yet_receipt'] = $recr_yet_receipt; //已收金额
        $receivable['recr_abort_time'] = $recr_abort_time; //截止时间
        $receivable['recr_plus_minus'] = $plus_minus; //金额正负值
        // 订单收款状态判断
        switch ($recr_account_type) {
            // recr_leisurely_type 订单收款状态：0待收款 1收款待核对 2收款已核对/待还款 3还款待核对 4还款已核对
            case 1://订单收款
                if ($plus_minus == 2 && $orbi_merge_state == 2) {
                    // 订单收款类型，金额为负数的，说明是换货单类型的
                    $receivable['recr_leisurely_type'] = 2;
                }
                break;
            case 2://受托代收（订单代收）
                // 代收状态为 待还款状态
                $receivable['recr_leisurely_type'] = 2;
                break;
            case 3://委托代收（工单代收）
                if ($collect_state == 1) {
                    // collect_state 状态为1的，说明让技师收款了，生成了结款明细
                    // 代收状态改为 收款待核对
                    $receivable['recr_leisurely_type'] = 1;
                } else {
                    // 其他状态的，说明还没有生成结款明细
                    // 代收状态为 代收款状态
                    $receivable['recr_leisurely_type'] = 0;
                }
                break;
            case 10://10订单退款
                $receivable['recr_leisurely_type'] = 0;
                break;
            default:
                $receivable['recr_leisurely_type'] = 0;
                break;
        }

        // 11加盟店订单收款
        if ($recr_type == 11) {
            $receivable['recr_leisurely_type'] = 1;
        // 12加盟店订单代收
        } elseif ($recr_type == 12) {
            $receivable['recr_leisurely_type'] = 3;
        }
        $receivable['recr_order_time'] = $recr_order_time; //金额正负值
        $recr_id = DB::table('receivable_credit')->insertGetId($receivable);


        //3.订单账单    6.销售账单
        if ($recr_type == 3 || $recr_type == 6 || $recr_type == 4) {
            //订单账单
            if ($recr_type == 3) {
                $data = DB::table('order')
                    ->where('ord_orbi_id', $recr_original_id)
                    ->pluck('ord_order_number', 'ord_id');
            }
            //工单账单
            if ($recr_type == 4) {
                $data = DB::table('work_order')
                    ->where('wor_wobi_id', $recr_original_id)
                    ->pluck('wor_number', 'wor_id');
            }
            // 销售账单
            if ($recr_type  == 6) {
                $data = DB::table('sell')
                    ->where('sell_sebi_id', $recr_original_id)
                    ->pluck('sell_number', 'sell_id');
            }

            $data = json_decode(json_encode($data), true);

            // 编辑部分代码日后有时间需要在优化
            if (!empty($data)) {
                $recr_edit_data['recr_belongs_id'] = $recr_original_id;//与类型所对应的id
                $recr_edit_data['recr_number_id'] = $recr_id;//账单的应收账款id
                $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                // 是否合并代收：1是2否
                if ($recr_type == 4) {
                    if ($orbi_merge_state == 2) {
                        $recr_account_type = [4];
                    } else {
                        $recr_account_type = [3,4];//4工单费用（工单收款）3委托代收（工单代收）
                    }
                } else {
                    if ($orbi_merge_state == 2) {
                        // 不合并代收，就不更改代收的应收账款
                        $recr_account_type = [1,10];
                    } else {
                        $recr_account_type = [1,2,10];//1订单收款 2受托代收（订单代收） 10订单退款(退货单)
                    }
                }
                $rece_update = DB::table('receivable_credit')
                        ->where('recr_cid', $user_info->adm_cid)
                        ->where('recr_shop_superior_id', $shop_id)
                        ->where('recr_type', $recr_type)
                        ->whereIn('recr_account_type', $recr_account_type)
                        ->whereIn('recr_original_number', $data)
                        ->whereNotIn('recr_id', [$recr_id])
                        ->update($recr_edit_data);
                if (empty($rece_update)) {
                    return false;
                }
            }
        }
        if ($is_myself == 2) {
            $update_data['recr_number_id'] = $recr_id; //应收款id
            $update_data['recr_belongs_id'] = 0; //应收款id
            $update_data['recr_update_time'] = date('Y-m-d H:i:s');
            $update_id = DB::table('receivable_credit')
                    ->where('recr_id', $recr_id)
                    ->update($update_data);
            if ($recr_id && $update_id) {
                return $recr_id;
            } else {
                return false;
            }
        } else {
            return $recr_id;
        }
    }

    /**
     * 生成应付账单
     * @param [type] $user_info                 [用户信息]
     * @param [type] $acpa_type                 [类型：1.预收款 2.采购账单]
     * @param [type] $acpa_number_id            [应收账款id]
     * @param [type] $acpa_original_id          [原始id]
     * @param [type] $acpa_number               [应收账款单号/原始号]
     * @param [type] $acpa_client_type          [客户类型：1.门店零售 2.来往单位]
     * @param [type] $acpa_client_id            [会员id/来往单位id]
     * @param [type] $acpa_client_name          [来往单位名称]
     * @param [type] $acpa_settle_price         [结算金额]
     * @param [type] $acpa_settle_time          [结款时间]
     * @param [type] $acpa_acti_id              [会计科目id]
     * @param [type] $acpa_actual_price         [实际金额]
     * @param [type] $acpa_zero_price           [抹零金额]
     * @param [type] $acpa_state                [状态：1.未核销 2.已核销]
     * @param [type] $is_myself                 [应收账单id是否是自己 1.不是 2.是]
     * @param [type] $acpa_remark               [备注]
     * @param [type] $acpa_yet_receipt          [已收金额]
     */
    public static function addAccounts(
        $user_info,
        $acpa_type,
        $acpa_number_id,
        $acpa_original_id,
        $acpa_number,
        $acpa_client_type,
        $acpa_client_id,
        $acpa_client_name,
        $acpa_settle_price,
        $acpa_settle_time,
        $acpa_acti_id,
        $acpa_actual_price,
        $acpa_zero_price,
        $acpa_state,
        $is_myself,
        $acpa_remark,
        $acpa_yet_receipt
    ) {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $receivable['acpa_cid'] = $user_info->adm_cid;
        $receivable['acpa_shop_id'] = $user_info->adm_shop_id;
        $receivable['acpa_shop_superior_id'] = $shop_id;
        $receivable['acpa_type'] = $acpa_type; //类型：1.预付款 2.采购账单 3.现结 4.采购入库单
        $receivable['acpa_number_id'] = $acpa_number_id; //应收账单id
        $receivable['acpa_original_id'] = $acpa_original_id; //与类型所对应的id
        $receivable['acpa_original_number'] = $acpa_number; //与类型所对应的单号
        $receivable['acpa_client_type'] = $acpa_client_type; //客户类型：1.门店零售 2.来往单位
        $receivable['acpa_client_id'] = $acpa_client_id; //会员id/来往单位id
        $receivable['acpa_client_name'] = $acpa_client_name; //来往单位名称
        $receivable['acpa_settle_price'] = $acpa_settle_price; //结算金额
        $receivable['acpa_settle_time'] = $acpa_settle_time; //结款时间
        $receivable['acpa_settle_id'] = $user_info->adm_id; //结款人
        $receivable['acpa_acti_id'] = $acpa_acti_id; //会计科目id
        $receivable['acpa_actual_price'] = $acpa_actual_price; //实际金额
        $receivable['acpa_zero_price'] = $acpa_zero_price; //抹零金额
        $receivable['acpa_state'] = $acpa_state; //状态：1.未核销 2.已核销
        $receivable['acpa_plus_minus'] = $acpa_type == 1 ? 2 : 1; //金额正负：1正值2负值
        $receivable['acpa_remark'] = $acpa_remark ? $acpa_remark : ''; //备注
        $receivable['acpa_yet_receipt'] = $acpa_yet_receipt; //已收金额
        $acpa_id = DB::table('accounts_payable')->insertGetId($receivable);

        //采购账单
        if ($acpa_type == 2) {
            //采购入库表
            $data = DB::table('procurement')
                ->where('proc_prbi_id', $acpa_original_id)
                ->pluck('proc_id', 'proc_number');

            $data = json_decode($data, true);
            if (!empty($data)) {
                $rece_update = DB::table('accounts_payable')
                ->where('acpa_cid', $user_info->adm_cid)
                ->where('acpa_shop_superior_id', $shop_id)
                ->where('acpa_type', 4)
                ->whereIn('acpa_original_id', $data)
                ->update(['acpa_belongs_id'=>$acpa_original_id,'acpa_update_time'=>date('Y-m-d H:i:s')]);
                if (empty($rece_update)) {
                    return false;
                }
            }
        }

        if ($is_myself == 2) {
            $update_data['acpa_number_id'] = $acpa_id; //应收款id
            $update_data['acpa_update_time'] = date('Y-m-d H:i:s');
            $update_id = DB::table('accounts_payable')
                    ->where('acpa_id', $acpa_id)
                    ->update($update_data);
            if ($acpa_id && $update_id) {
                return $acpa_id;
            } else {
                return false;
            }
        } else {
            return $acpa_id;
        }
    }
}
