<?php
namespace App\Http\Models\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;

class RecedeRecycle extends Model
{
    /**
     * 退换回收单
     * @param  $user_info    array   用户数据
     * @param  $genre        int     买家类型 1.门店零售 2.来往单位
     * @param  $ord_client   int     来往单位id/客户id
     * @param  $number       int     单号
     * @param  $type         int     来源类型1. 售后退货 2. 工单退货 3 页面新增 4 退货单'
     * @param  $goods_id     array   商品id [0=>商品id]
     * @param  $price        array   商品金额没有乘以100 ['商品id'=>商品金额] 
     * @param  $ware_id      int     仓库id
     * @param  $num          array   退货数量 ['商品id'=>商品退货数量]
     * @param  $channel_unit int     客户单位
     * @param  $name         int     客户姓名
     * @param  $phone        int     客户电话
     * @param  $remark       int     备注
     * @param  $rec_mobile_ware_id       int     移动仓库id
     * @return boolean
     */
    public static function add(
        $user_info,
        $genre,
        $ord_client,
        $number,
        $number_id,
        $type,
        $goods_id,
        $price,
        $ware_id,
        $num,
        $channel_unit,
        $name,
        $phone,
        $remark,
        $rec_mobile_ware_id=0,
        $rego_ware_id = [],
        $rego_waon_class = [],
        $rego_wago_id = []
    ) {
        if (count($price) != count($num) || count($price) != count($goods_id) ) {
            return false;
        }
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        //金额乘以一百
        foreach ($price as $key => $value) {
            $all_price[$key] = $value * 100 * $num[$key];
        }
        // 1.退换回收单表添加数据
        $rec_number = 'TH' . rand(100, 999) . date('mdHis'). rand(100000, 999999); // 回收单号
        $add_recycle['rec_cid'] = $user_info->adm_cid; //公司id
        $add_recycle['rec_shop_id'] = $user_info->adm_shop_id; //门店id
        $add_recycle['rec_superior_shop_id'] = $shop_id; //总店id
        $add_recycle['rec_number'] = $rec_number; //回收单号
        $add_recycle['rec_ord_order_number'] = $number; //单号
        $add_recycle['rec_ord_id'] = $number_id; //单号id
        $add_recycle['rec_source_type'] = $type; //来源类型
        $add_recycle['rec_create_adm_id'] = $user_info->adm_id; //创建人id
        $add_recycle['rec_date'] = date('Y-m-d'); //日期
        $add_recycle['rec_price'] = array_sum($all_price); //回收总金额（单位：分）
        $add_recycle['rec_amount'] = array_sum($num); //回收总数量
        $add_recycle['rec_state'] = 1; //回收状态 1.未回收 2.已回收
        $add_recycle['rec_type'] = $genre; //买家类型 1.门店零售 2.来往单位
        $add_recycle['rec_ware_id'] = $ware_id; //仓库id
        $add_recycle['rec_remark'] = $remark; //备注
        $add_recycle['rec_mobile_ware_id'] = $rec_mobile_ware_id; //移动仓库id

        $recycle_id = DB::table('recede_recycle')->insertGetId($add_recycle);
        if(empty($recycle_id)){
            return false;
        }
        $goods = collect(DB::table('goods')
            ->whereIn('goo_id',$goods_id)
            ->get(['goo_name','goo_goods_encode','goo_id']))
            ->keyBy('goo_id')
            ->toArray();
        // 2.退换回收单商品表添加数据
        foreach ($goods_id as $key => $value) {
            $rego_data[$key]['rego_rec_id'] = $recycle_id;
            $rego_data[$key]['rego_ware_id'] = $rego_ware_id[$goods_id[$key]];
            $rego_data[$key]['rego_waon_class'] = $rego_waon_class[$goods_id[$key]];
            $rego_data[$key]['rego_wago_id'] = $rego_wago_id[$goods_id[$key]];
            $rego_data[$key]['rego_goo_id'] = $goods_id[$key];
            $rego_data[$key]['rego_goo_name'] = $goods[$goods_id[$key]]->goo_name;
            $rego_data[$key]['rego_goo_goods_encode'] = $goods[$goods_id[$key]]->goo_goods_encode;
            $rego_data[$key]['rego_goo_price'] = $price[$goods_id[$key]] * 100;
            $rego_data[$key]['rego_sell_number'] = $num[$goods_id[$key]];//销售数量
            $rego_data[$key]['rego_recycle_number'] = $num[$goods_id[$key]];//回收数量
        }
        $add_goods =  DB::table('recede_goods')->insert($rego_data);
        if(empty($add_goods)){
            return false;
        }
        // 3.回收单客户表添加数据
        $recl_data['recl_rec_id'] = $recycle_id; //回收单id
        $recl_data['recl_client_id'] = $ord_client; //来往单位id/客户id
        $recl_data['recl_name'] = $name; //客户姓名
        $recl_data['recl_phone'] =$phone; //联系电话
        if($genre == 2){
            $recl_data['recl_channel_unit'] = $channel_unit; //渠道单位
            $mem_res = true;
        }else{
            if ($recl_data['recl_client_id']) {
                // 零售类型，会员对应的退货数量加1
                $mem_res =  DB::table('member')
                    ->where('mem_id', $recl_data['recl_client_id'])
                    ->increment('mem_retreat_trade');
            }else{
                $mem_res = true;
            }
        }
        $add_client =  DB::table('recede_client')->insert($recl_data);
        if(empty($add_client) || empty($mem_res)){
            return false;
        }
        return true;
    }

    /**
     * 退换回收单
     * @param  $user_info    array   用户数据
     * @param  $genre        int     买家类型 1.门店零售 2.来往单位
     * @param  $ord_client   int     来往单位id/客户id
     * @param  $number       int     单号
     * @param  $type         int     来源类型1. 售后退货 2. 工单退货 3 页面新增 4 退货单'
     * @param  $goods_id     array   商品id [0=>商品id]
     * @param  $price        array   商品金额没有乘以100 ['商品id'=>商品金额] 
     * @param  $ware_id      int     仓库id
     * @param  $num          array   退货数量 ['商品id'=>商品退货数量]
     * @param  $channel_unit int     客户单位
     * @param  $name         int     客户姓名
     * @param  $phone        int     客户电话
     * @param  $remark       int     备注
     * @param  $rec_mobile_ware_id       int     移动仓库id
     * @param  $rego_ware_id    array     ['商品id'=>仓库id]
     * @param  $rego_waon_class array     ['商品id'=>仓库类别]
     * @param  $rego_wago_id    array     ['商品id'=>仓库商品id]
     * @return boolean
     */
    public static function addition(
        $user_info,
        $genre,
        $ord_client,
        $number,
        $number_id,
        $type,
        $goods_id,
        $price,
        $ware_id,
        $num,
        $channel_unit,
        $name,
        $phone,
        $remark,
        $rec_mobile_ware_id=0,
        $rego_ware_id = [],
        $rego_waon_class = [],
        $rego_wago_id = []
    ) {
        if (count($price) != count($num) || count($price) != count($goods_id) ) {
            return false;
        }
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        //金额乘以一百
        foreach ($price as $key => $value) {
            $all_price[$key] = $value * 100 * $num[$key];
        }
        // 1.退换回收单表添加数据
        $rec_number = 'TH' . rand(100, 999) . date('mdHis'). rand(100000, 999999); // 回收单号
        $add_recycle['rec_cid'] = $user_info->adm_cid; //公司id
        $add_recycle['rec_shop_id'] = $user_info->adm_shop_id; //门店id
        $add_recycle['rec_superior_shop_id'] = $shop_id; //总店id
        $add_recycle['rec_number'] = $rec_number; //回收单号
        $add_recycle['rec_ord_order_number'] = $number; //单号
        $add_recycle['rec_ord_id'] = $number_id; //单号id
        $add_recycle['rec_source_type'] = $type; //来源类型
        $add_recycle['rec_create_adm_id'] = $user_info->adm_id; //创建人id
        $add_recycle['rec_date'] = date('Y-m-d'); //日期
        $add_recycle['rec_price'] = array_sum($all_price); //回收总金额（单位：分）
        $add_recycle['rec_amount'] = array_sum($num); //回收总数量
        $add_recycle['rec_state'] = 1; //回收状态 1.未回收 2.已回收
        $add_recycle['rec_type'] = $genre; //买家类型 1.门店零售 2.来往单位
        $add_recycle['rec_ware_id'] = $ware_id; //仓库id
        $add_recycle['rec_remark'] = $remark; //备注
        $add_recycle['rec_mobile_ware_id'] = $rec_mobile_ware_id; //移动仓库id

        $recycle_id = DB::table('recede_recycle')->insertGetId($add_recycle);
        if(empty($recycle_id)){
            return false;
        }
        $goods = collect(DB::table('goods')
            ->whereIn('goo_id',$goods_id)
            ->get(['goo_name','goo_goods_encode','goo_id']))
            ->keyBy('goo_id')
            ->toArray();
        // 2.退换回收单商品表添加数据
        foreach ($goods_id as $key => $value) {
            $rego_data[$key]['rego_rec_id'] = $recycle_id;
            $rego_data[$key]['rego_ware_id'] = $rego_ware_id[$goods_id[$key]];
            $rego_data[$key]['rego_waon_class'] = $rego_waon_class[$goods_id[$key]];
            $rego_data[$key]['rego_wago_id'] = $rego_wago_id[$goods_id[$key]];
            $rego_data[$key]['rego_goo_id'] = $goods_id[$key];
            $rego_data[$key]['rego_goo_name'] = $goods[$goods_id[$key]]->goo_name;
            $rego_data[$key]['rego_goo_goods_encode'] = $goods[$goods_id[$key]]->goo_goods_encode;
            $rego_data[$key]['rego_goo_price'] = $price[$goods_id[$key]] * 100;
            $rego_data[$key]['rego_sell_number'] = $num[$goods_id[$key]];//销售数量
            $rego_data[$key]['rego_recycle_number'] = $num[$goods_id[$key]];//回收数量
        }
        $add_goods =  DB::table('recede_goods')->insert($rego_data);
        if(empty($add_goods)){
            return false;
        }
        // 3.回收单客户表添加数据
        $recl_data['recl_rec_id'] = $recycle_id; //回收单id
        $recl_data['recl_client_id'] = $ord_client; //来往单位id/客户id
        $recl_data['recl_name'] = $name; //客户姓名
        $recl_data['recl_phone'] =$phone; //联系电话
        if($genre == 2){
            $recl_data['recl_channel_unit'] = $channel_unit; //渠道单位
            $mem_res = true;
        }else{
            if ($recl_data['recl_client_id']) {
                // 零售类型，会员对应的退货数量加1
                $mem_res =  DB::table('member')
                    ->where('mem_id', $recl_data['recl_client_id'])
                    ->increment('mem_retreat_trade');
            }else{
                $mem_res = true;
            }
        }
        $add_client =  DB::table('recede_client')->insert($recl_data);
        if(empty($add_client) || empty($mem_res)){
            return false;
        }
        return true;
    }
}
