<?php

namespace App\Http\Models\Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class OutinRecord extends Model
{
    /**
     * [addition 添加出入库记录]
     * @param  [type] $user_info                        [用户信息]
     * @param  [type] $oure_original_correlation_id     [原始单的关联id]
     * @param  [type] $oure_original_correlation_number [原始单的关联单号]
     * @param  [type] $oure_original_correlation_type   [原始单的关联类型1订单2调拨单3采购单4销售单5旧货回收6退货入库7售后]
     * @param  [type] $oure_client_type                 [买家类型：1会员零售2客户单位3速电派单4第三方派单]
     * @param  [type] $oure_client_id                   [选择的客户id,会员id/单位id]
     * @param  [type] $oure_original_number             [原始单号]
     * @param  [type] $oure_in_ware_id                  [入库仓库id]
     * @param  [type] $oure_out_ware_id                 [出库仓库id]
     * @param  [type] $oure_count                       [出库的商品总量]
     * @param  [type] $oure_type                        [类型1入库单2出库单3调货单4旧货回收单5退换回收单6订单出库7部分入库8部分出库9发货单]
     * @param  [type] $oure_operation_type              [操作类型：1锁定库存2出库3入库4调货5发货]
     * @param  [type] $oure_all_stock                   [良品总库存]
     * @param  [type] $oure_lock_quantity               [良品锁定数量]
     * @param  [type] $oure_priority_all_stock          [优先总库存]
     * @param  [type] $oure_priority_lock_quantity      [优先锁定数量]
     * @param  [type] $oure_unchecked_all_stock         [待检测总库存]
     * @param  [type] $oure_out_in_type                 [出入库类型：1出库，2入库]
     * @param  [type] $oure_waon_class                  [仓库类别：1货物仓2非货物仓3旧货仓4临时仓]
     * @param  [type] $goo_id                           [商品id]
     * @param  [type] $goo_quantity                     [商品数量]
     * @param  [type] $goo_inventory                    [商品出入库类型]
     * @param  [type] $oure_wafr_id                     [仓位id]
     * @param  [type] $oure_class_goo_id                [仓库类别商品id]
     * @param  [type] $request_goo_price                        [退货入库金额或者是导入金额]
     * @return [type]                                   [description]
     */
    public static function addition(
        $user_info,
        $oure_original_correlation_id,
        $oure_original_correlation_number,
        $oure_original_correlation_type,
        $oure_client_type,
        $oure_client_id,
        $oure_original_number,
        $oure_in_ware_id,
        $oure_out_ware_id,
        $oure_count,
        $oure_type,
        $oure_operation_type,
        $oure_all_stock,
        $oure_lock_quantity,
        $oure_priority_all_stock,
        $oure_priority_lock_quantity,
        $oure_unchecked_all_stock,
        $oure_out_in_type,
        $oure_waon_class,
        $goo_id,
        $goo_quantity,
        $goo_inventory,
        $oure_wafr_id = [],
        $oure_class_goo_id = [],
        $request_goo_price = []
    ) {
        // 生成出入库记录
        $number = time() . rand(10000, 99999); //共15位
        // 出入库记录表新增数据
        $record['oure_cid'] = $user_info->adm_cid; //公司id
        $record['oure_shop_id'] = $user_info->adm_shop_id; //门店id
        $record['oure_superior_shop_id'] = $user_info->shop_superior_id; //门店id
        $record['oure_adm_id'] = $user_info->adm_id; //操作人
        $record['oure_number'] = $number; //单号
        $record['oure_original_correlation_id'] = $oure_original_correlation_id; //原始单的关联id
        $record['oure_original_correlation_number'] = $oure_original_correlation_number; //原始单的关联单号
        $record['oure_original_correlation_type'] = $oure_original_correlation_type; //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后8盘库
        $record['oure_client_type'] = $oure_client_type; //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
        $record['oure_client_id'] = $oure_client_id; //选择的客户id,会员id/单位id
        $record['oure_original_number'] = $oure_original_number; //原始单号
        $record['oure_in_ware_id'] = $oure_in_ware_id; //入库仓库id
        $record['oure_out_ware_id'] = $oure_out_ware_id; //出库仓库id
        $record['oure_count'] = $oure_count; //出库的商品总量
        $record['oure_type'] = $oure_type; //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库
        $record['oure_operation_type'] = $oure_operation_type; //操作类型：1锁定库存2出库3入库4调货5发货
        $record['oure_all_stock'] = $oure_all_stock; //良品总库存
        $record['oure_priority_all_stock'] = $oure_priority_all_stock; //优先总库存
        $record['oure_unchecked_all_stock'] = $oure_unchecked_all_stock; //待检测总库存
        $record['oure_update_time'] = date('Y-m-d H:i:s');
        $record['oure_out_in_type'] = $oure_out_in_type; //出入库类型：1出库，2入库
        $record['oure_waon_class'] = $oure_waon_class; //仓库类别
        // dump($record);
        // exit;
        $record_add = DB::table('outin_record')->insertGetId($record);
        // $record_add = true;
        // dump($oure_type);
        // exit;

        $n = 0;
        if ($oure_waon_class == '2') {
            $oure_waon_class = '1';
        }
        foreach ($goo_id as $key => $value) {
            if (!empty($oure_class_goo_id) && !in_array($value, $oure_class_goo_id)) {
                continue;
            }
            // 出入库类型：1出库，2入库
            if ($oure_out_in_type == '2') {
                $oure_ware_id = $oure_in_ware_id; //入库仓库id
                // 出库
            } else {
                $oure_ware_id = $oure_out_ware_id; //出库仓库id
            }
            // 当前成本价
            $newprice = DB::table('enters_sells_saves')
                ->where('ense_goo_id', $value)
                ->where('ense_goo_warehouse', $oure_ware_id)
                ->where('ense_goo_waretype', $oure_waon_class)
                ->orderBy('ense_id', 'desc')
                ->select('ense_end_price', 'ense_end_amount', 'ense_end_inventory')
                ->first();
            if ($newprice) {
                $new_nums = empty($newprice->ense_end_inventory) ? 0 : $newprice->ense_end_inventory;
                $ense_end_price = empty($newprice->ense_end_price) ? 0 : $newprice->ense_end_price;
                //当前总金额
                $ense_new_amount = empty($newprice->ense_end_amount) ? 0 : $newprice->ense_end_amount;
            } else {
                $new_nums = 0;
                $ense_end_price = '0';
                $ense_new_amount = '0';
            }
            // 商品信息
            $goods = DB::table('goods')
                ->where('goo_id', $value)
                ->select('goo_name', 'goo_goods_encode', 'goo_ampere_hour', 'goo_attribute', 'goo_recycle_price', 'goo_unit', 'goo_purchase_price', 'goo_unta_id', 'goo_unit_conversion')
                ->first();
            if ($goods->goo_attribute == '') {
                $unit = "";
            } else {
                $units = json_decode($goods->goo_attribute, true);
                foreach ($units as $k => $v) {
                    if ($v['key'] == '单位') {
                        $unit = $v['value'];
                    } else {
                        $unit = '';
                    }
                }
            }
            $dh = substr($oure_original_correlation_number, 0, 2);
            if (($oure_type == '1' || $oure_type == '7') && $dh != 'DB') { //oure_type：类型1.入库单7.部分入库
                // 获取入库价
                if ($dh == 'CG') {
                    $procurement_goodsres = DB::table('storage_goods')
                        ->where('relation_number', $oure_original_correlation_number)
                        ->where('goods_id', $value)
                        ->select('univalence')
                        ->first();
                    // 入库价
                    $goods_price = $procurement_goodsres->univalence;
                    //如果单位是卷，要换算单价
                }
                // 判断期末库存是否小于0
                if ($new_nums < 0) {
                    // 期末平均价
                    $price = $goods_price;
                    // 期末总价
                    $ense_end_amount = ($goo_quantity[$key] * $goods_price) + ($price * $new_nums);
                } else {
                    // 期末总价
                    $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$key];
                    // 期末平均价
                    if ($new_nums + $goo_quantity[$key] == '0') {
                        $price = 0;
                    } else {
                        $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity[$key]));
                    }
                }
                // 添加信息
                $enters_sellsarray['ense_goo_id'] = $value; //商品id
                $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                $enters_sellsarray['ense_goo_unit'] = $goods->goo_unit; //商品单位
                $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                $enters_sellsarray['ense_in_num'] = $goo_quantity[$key]; //入库数量
                $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                $enters_sellsarray['ense_in_amount'] = $goo_quantity[$key] * $goods_price; //入库总金额
                $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //
                $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
            } elseif ($oure_type == '4') { //oure_type：类型4.旧货回收
                // 获取回收金额
                $shop_setres = DB::table('shop_set')
                    ->where('shse_shop_id', $user_info->adm_shop_id)
                    ->select('shse_recycle_type', 'shse_ampere_hour_price')
                    ->first();
                if ($shop_setres->shse_recycle_type == '1') {
                    $goods_price = $shop_setres->shse_ampere_hour_price * $goods->goo_ampere_hour / 100;
                } else {
                    $goods_price = $goods->goo_recycle_price / 100;
                }
                // 同步工单商品表
                $workgoodprice['wogo_goo_price'] = $goods_price * 100;
                $ordergoodprice['orgo_goo_price'] = $goods_price * 100;

                $workid = DB::table('work_order')
                    ->where('wor_order_number', $oure_original_correlation_number)
                    ->select('wor_id')
                    ->orderBy('wor_id', 'desc')
                    ->first();
                $workgood = DB::table('work_good')
                    ->where('wogo_wor_id', $workid->wor_id)
                    ->where('wogo_goo_id', $value)
                    ->update($workgoodprice);
                $order_good = DB::table('order_goods')
                    ->where('orgo_ord_id', $oure_original_correlation_id)
                    ->where('orgo_order_number', $oure_original_correlation_number)
                    ->where('orgo_goo_id', $value)
                    ->update($ordergoodprice);
                if ($new_nums < 0) {
                    // 期末平均价
                    $price = $goods_price;
                    // 期末总价
                    if ($oure_out_in_type == 1) { //出入库类型：1出库
                        $ense_end_amount = ($goo_quantity[$key] * $goods_price) - ($price * $new_nums);
                    } else {
                        $ense_end_amount = ($goo_quantity[$key] * $goods_price) + ($price * $new_nums);
                    }
                } else {
                    // 期末总价
                    if ($oure_out_in_type == 1) { //出入库类型：1出库
                        $ense_end_amount = $ense_new_amount - $goods_price * $goo_quantity[$key];
                    } else {
                        $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$key];
                    }
                    // 期末平均价
                    if ($new_nums + $goo_quantity[$key] == '0') {
                        $price = 0;
                    } else {
                        if ($oure_out_in_type == 1) { //出入库类型：1出库
                            if ($new_nums - $goo_quantity[$key] == 0) {
                                $price = 0;
                            } else {
                                $price = sprintf("%.4f", $ense_end_amount / ($new_nums - $goo_quantity[$key]));
                            }
                        } else {
                            $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity[$key]));
                        }
                    }
                }
                // 添加信息
                $enters_sellsarray['ense_goo_id'] = $value; //商品id
                $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                $enters_sellsarray['ense_goo_unit'] = $goods->goo_unit; //商品单位
                $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                if ($oure_out_in_type == 1) { //出入库类型：1出库
                    $enters_sellsarray['ense_end_inventory'] = $new_nums - $goo_quantity[$key]; //期末库存
                    $enters_sellsarray['ense_in_num'] = '-' . $goo_quantity[$key]; //入库数量
                    $enters_sellsarray['ense_in_amount'] = "-" . abs($goo_quantity[$key] * $goods_price); //入库总金额
                } else {
                    $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                    $enters_sellsarray['ense_in_num'] = $goo_quantity[$key]; //入库数量
                    $enters_sellsarray['ense_in_amount'] = $goo_quantity[$key] * $goods_price; //入库总金额
                }
                $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
            } elseif ($oure_type == '5') { //类型5.退换回收单（技师拒单、技师退回、技师终止）
                $order_wareid = DB::table('order')
                    ->where('ord_order_number', $oure_original_correlation_number)
                    ->select('ord_ware_id')
                    ->first();
                if ($order_wareid->ord_ware_id == '0') {
                    $order_wareid = DB::table('recede_recycle')
                        ->where('rec_number', $oure_original_number)
                        ->select('rec_ware_id')
                        ->first();
                    $ord_ware_id = $order_wareid->rec_ware_id;
                } else {
                    $ord_ware_id = $order_wareid->ord_ware_id;
                }
                $enters_sells_savesres = DB::table('enters_sells_saves')
                    ->where('ense_out_in', '1')
                    ->where('ense_type', '9')
                    ->where('ense_goo_id', $value)
                    ->where('ense_goo_warehouse', $ord_ware_id)
                    ->where('ense_order_number', $oure_original_correlation_number)
                    ->orderBy('ense_id', 'desc')
                    ->value('ense_end_price');
                if ($enters_sells_savesres) {
                    //入库金额
                    $goods_price = $enters_sells_savesres;
                } else {
                    $goods_price = 0;
                }
                // 期末总价
                $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$key];
                $price = $ense_end_price;
                // 添加信息
                $enters_sellsarray['ense_goo_id'] = $value; //商品id
                $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                $enters_sellsarray['ense_goo_unit'] = $goods->goo_unit; //商品单位
                $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                $enters_sellsarray['ense_out_num'] = "-" . abs($goo_quantity[$key]); //入库数量
                $enters_sellsarray['ense_out_price'] = $goods_price; //入库单价
                $enters_sellsarray['ense_out_amount'] = "-" . abs($goo_quantity[$key] * $goods_price); //入库总金额
                $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
            } elseif ($oure_type == '12' || $oure_type == '13') { //oure_type：类型12换货入库13退货入库//退货单
                $goods_price = $ense_end_price;
                $price = $ense_end_price;
                // 添加信息
                $enters_sellsarray['ense_goo_id'] = $value; //商品id
                $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                $enters_sellsarray['ense_goo_unit'] = $goods->goo_unit; //商品单位
                $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                if ($oure_waon_class == 1) { //货物仓
                    // 期末总额 = 原来的期末总额 + （退回入库单价 【查询的期末平均价】* 退回入库数量）
                    $ense_end_amount = $ense_new_amount + $goo_quantity[$key] * $goods_price;
                    $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                    $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                    $enters_sellsarray['ense_out_num'] = "-" . $goo_quantity[$key]; //入库数量
                    $enters_sellsarray['ense_out_price'] = $goods_price; //入库单价
                    $enters_sellsarray['ense_out_amount'] = "-" . abs($goo_quantity[$key] * $goods_price); //入库总金额
                } elseif ($oure_waon_class == 3) { //旧货仓
                    // 期末总额 = 原来的期末总额 + （旧货退回入库单价 * 退回入库数量）
                    $ense_end_amount = $ense_new_amount + $goo_quantity[$key] * $request_goo_price[$key];
                    $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                    // 4. 期末平均价 = 期末总额 / (原来的期末库存 + 退回入库数量）
                    $ense_end_price = sprintf("%.4f", $ense_end_amount / $enters_sellsarray['ense_end_inventory']);
                    $enters_sellsarray['ense_end_price'] = $ense_end_price; //期末成本价

                    $enters_sellsarray['ense_in_num'] = $goo_quantity[$key]; //入库数量
                    $enters_sellsarray['ense_in_price'] = $request_goo_price[$key]; //入库单价（前端传入的金额）
                    $enters_sellsarray['ense_in_amount'] = abs($goo_quantity[$key] * $request_goo_price[$key]); //入库总金额
                }
                $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
            } elseif ($dh == 'DB') {
                // 调拨单进销存处理
                // 调拨入库进销存
                if ($oure_type == 1) {
                    // 查询调拨单的出库仓库id
                    $transferring_orderres = DB::table('transferring_order')
                        ->where('tror_number', $oure_original_correlation_number)
                        ->select('tror_id', 'tror_out_ware_id')
                        ->first();
                    // 查询调出仓库的商品的成本金额
                    $enters_sells_savesres = DB::table('enters_sells_saves')
                        ->where('ense_goo_id', $value)
                        ->where('ense_goo_warehouse', $transferring_orderres->tror_out_ware_id)
                        ->where('ense_goo_waretype', $oure_waon_class)
                        ->where('ense_order_number', $oure_original_correlation_number)
                        ->orderBy('ense_id', 'desc')
                        ->select('ense_out_price')
                        ->first();
                    // 入库价
                    if ($enters_sells_savesres) {
                        $goods_price = $enters_sells_savesres->ense_out_price;
                    } else {
                        // $goods_price = '0';
                        $goods_price = $goods->goo_purchase_price;
                    }

                    // 判断期末库存是否小于0
                    if ($new_nums < 0) {
                        // 期末平均价
                        $price = $goods_price;
                        // 期末总价
                        $ense_end_amount = ($goo_quantity[$key] * $goods_price) + ($price * $new_nums);
                    } else {
                        // 期末总价
                        $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$key];
                        // 期末平均价
                        if ($new_nums + $goo_quantity[$key] == '0') {
                            $price = 0;
                        } else {
                            $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity[$key]));
                        }
                    }
                    // 添加信息
                    $enters_sellsarray['ense_goo_id'] = $value; //商品id
                    $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                    $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                    $enters_sellsarray['ense_goo_unit'] = $goods->goo_unit; //商品单位
                    $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                    $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                    $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                    $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                    $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                    $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                    $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                    $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                    $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                    $enters_sellsarray['ense_in_num'] = $goo_quantity[$key]; //入库数量
                    $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                    $enters_sellsarray['ense_in_amount'] = $goo_quantity[$key] * $goods_price; //入库总金额
                    $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //
                    $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                    $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                    $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                    $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
                } elseif ($oure_type == 2) {
                    // 调拨出库进销存处理
                    if ($goo_inventory[$key] != '3') {
                        $enters_sellsarray['ense_goo_id'] = $value; //商品id
                        $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                        $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                        $enters_sellsarray['ense_goo_unit'] = $goods->goo_unit; //商品单位
                        $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                        $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                        $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                        $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                        $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                        $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                        $enters_sellsarray['ense_end_inventory'] = $new_nums - $goo_quantity[$key]; //期末库存
                        $enters_sellsarray['ense_end_price'] = $ense_end_price; //期末成本价
                        $enters_sellsarray['ense_end_amount'] = $ense_new_amount - sprintf("%.4f", $goo_quantity[$key] * $ense_end_price); //期末总金额
                        $enters_sellsarray['ense_out_num'] = $goo_quantity[$key]; //出库数量
                        $enters_sellsarray['ense_out_price'] = $ense_end_price; //出库单价
                        $enters_sellsarray['ense_out_amount'] = sprintf("%.4f", $goo_quantity[$key] * $ense_end_price); //出库总金额
                        $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                        $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                        $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                        $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                        $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
                    }
                }
            } elseif ($oure_type == '18') { //oure_type：类型18基础版入库单
                // 添加信息
                $enters_sellsarray['ense_goo_id'] = $value; //商品id
                $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                $enters_sellsarray['ense_goo_unit'] = $goods->goo_unit; //商品单位
                $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                $enters_sellsarray['ense_in_num'] = $goo_quantity[$key]; //入库数量
                $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                $enters_sellsarray['ense_in_amount'] = $goo_quantity[$key] * $goods_price; //入库总金额
                $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //
                $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
            } elseif ($oure_type == '19') { //oure_type：类型19仓库商品导入
                $goods_price = $goods->goo_purchase_price;
                //如果导入有写价格
                if(isset($request_goo_price[0]) && !empty($request_goo_price[0]) && $request_goo_price[0] > 0){
                    $goods_price = $request_goo_price[0];
                }
                if ($new_nums < 0) {
                    // 期末平均价
                    $price = $goods_price;
                    // 期末总价
                    $ense_end_amount = ($goo_quantity[$value] * $goods_price) + ($price * $new_nums);
                } else {
                    // 期末总价
                    $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$value];
                    // 期末平均价
                    if ($new_nums + $goo_quantity[$value] == '0') {
                        $price = 0;
                    } else {
                        $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity[$value]));
                    }
                }
                // 添加信息
                $enters_sellsarray['ense_goo_id'] = $value; //商品id
                $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                $enters_sellsarray['ense_goo_unit'] = $goods->goo_unit; //商品单位
                $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$value]; //期末库存
                $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                $enters_sellsarray['ense_in_num'] = $goo_quantity[$value]; //入库数量
                $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                $enters_sellsarray['ense_in_amount'] = $goo_quantity[$value] * $goods_price; //入库总金额
                $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //
                $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                // dump($enters_sellsarray);
                // exit;
                $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
                // $enters_saves = true;
            } else {
                // 采购退货单
                if ($oure_type == '2' && $dh == 'TH') {
                    $procurement_goodsres = DB::table('storage_goods')
                        ->where('relation_number', $oure_original_correlation_number)
                        ->where('goods_id', $value)
                        ->select('univalence')
                        ->first();
                    // 入库价
                    $goods_price = $procurement_goodsres->univalence;
                    if ($new_nums < 0) {
                        //期末平均价
                        $price = $goods_price;
                        //期末总价
                        $ense_end_amount = ($price * $new_nums) - ($goo_quantity[$key] * $goods_price);
                    } else {
                        // 期末总价
                        $ense_end_amount = $ense_new_amount - $goods_price * $goo_quantity[$key];
                        // 期末平均价
                        if ($new_nums - $goo_quantity[$key] == '0') {
                            $price = 0;
                        } else {
                            $price = sprintf("%.4f", $ense_end_amount / ($new_nums - abs($goo_quantity[$key])));
                        }
                    }
                    // 添加信息
                    $enters_sellsarray['ense_goo_id'] = $value; //商品id
                    $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                    $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                    $enters_sellsarray['ense_goo_unit'] = $goods->goo_unit; //商品单位
                    $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                    $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                    $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                    $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                    $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                    $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                    $enters_sellsarray['ense_end_inventory'] = $new_nums - $goo_quantity[$key]; //期末库存
                    $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                    $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                    $enters_sellsarray['ense_in_num'] = "-" . $goo_quantity[$key]; //入库数量
                    $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                    $enters_sellsarray['ense_in_amount'] = "-" . abs($goo_quantity[$key] * $goods_price); //入库总金额
                    $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                    $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                    $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                    $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                    $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
                } else {
                    if ($oure_type == '9' && $oure_out_in_type == '2') { //oure_type：类型2.出库单9.发货单
                        $order_wareid = DB::table('order')
                            ->where('ord_order_number', $oure_original_correlation_number)
                            ->select('ord_ware_id')
                            ->first();
                        $enters_sells_savesres = DB::table('enters_sells_saves')
                            ->where('ense_goo_id', $value)
                            ->where('ense_goo_warehouse', $order_wareid->ord_ware_id)
                            ->orderBy('ense_id', 'desc')
                            ->select('ense_end_price')
                            ->first();
                        if ($enters_sells_savesres) {
                            $goods_price = $enters_sells_savesres->ense_end_price;
                        } else {
                            $goods_price = '0';
                        }
                        if ($new_nums < 0) {
                            // 期末平均价
                            $price = $goods_price;
                            // 期末总价
                            $ense_end_amount = ($goo_quantity[$key] * $goods_price) + ($price * $new_nums);
                        } else {
                            // 期末总价
                            $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$key];
                            // 期末平均价
                            if ($new_nums + $goo_quantity[$key] == '0') {
                                $price = 0;
                            } else {
                                $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity[$key]));
                            }
                        }
                        // 添加信息
                        $enters_sellsarray['ense_goo_id'] = $value; //商品id
                        $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                        $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                        $enters_sellsarray['ense_goo_unit'] = $goods->goo_unit; //商品单位
                        $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                        $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                        $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                        $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                        $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                        $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                        $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                        $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                        $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                        $enters_sellsarray['ense_out_num'] = "-" . $goo_quantity[$key]; //入库数量
                        $enters_sellsarray['ense_out_price'] = $goods_price; //入库单价
                        $enters_sellsarray['ense_out_amount'] = "-" . abs($goo_quantity[$key] * $goods_price); //入库总金额
                        $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                        $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                        $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                        $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                        $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
                    } elseif ($oure_type == '15' && $oure_out_in_type == '2') { //oure_type：15盘库单；oure_out_in_type出入库类型：1出库，2入库
                        if ($goo_inventory[$key] != '3') {//不是待检测的
                            $enters_sells_savesres = DB::table('enters_sells_saves')
                                ->where('ense_goo_id', $value)
                                ->where('ense_goo_warehouse', $oure_ware_id)
                                ->orderBy('ense_id', 'desc')
                                ->select('ense_end_price')
                                ->first();
                            if ($enters_sells_savesres) {
                                $goods_price = $enters_sells_savesres->ense_end_price;
                            } else {
                                // $goods_price = '0';
                                $goods_price = $goods->goo_purchase_price/100;
                            }
                            // 期末总价
                            $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$key];
                            if ($new_nums + $goo_quantity[$key] == '0') {
                                $price = 0;
                            } else {
                                $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity[$key]));
                            }
                            // 添加信息
                            $enters_sellsarray['ense_goo_id'] = $value; //商品id
                            $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                            $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                            $enters_sellsarray['ense_goo_unit'] = $goods->goo_unit; //商品单位
                            $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                            $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                            $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                            $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                            $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                            $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                            $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                            $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                            $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                            $enters_sellsarray['ense_in_num'] = $goo_quantity[$key]; //入库数量
                            $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                            $enters_sellsarray['ense_in_amount'] = $goo_quantity[$key] * $goods_price; //入库总金额
                            $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                            $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                            $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                            $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                            $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
                        }
                    } else {
                        // 添加信息
                        if ($goo_inventory[$key] != '3') {
                            $enters_sellsarray['ense_goo_id'] = $value; //商品id
                            $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                            $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                            $enters_sellsarray['ense_goo_unit'] = $goods->goo_unit; //商品单位
                            $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                            $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                            $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                            $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                            $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                            $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                            $enters_sellsarray['ense_end_inventory'] = $new_nums - $goo_quantity[$key]; //期末库存
                            $enters_sellsarray['ense_end_price'] = $ense_end_price; //期末成本价
                            $enters_sellsarray['ense_end_amount'] = $ense_new_amount - sprintf("%.4f", $goo_quantity[$key] * $ense_end_price); //期末总金额
                            $enters_sellsarray['ense_out_num'] = $goo_quantity[$key]; //出库数量
                            $enters_sellsarray['ense_out_price'] = $ense_end_price; //出库单价
                            $enters_sellsarray['ense_out_amount'] = sprintf("%.4f", $goo_quantity[$key] * $ense_end_price); //出库总金额
                            $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                            $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                            $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                            $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                            $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
                        } else {
                            $enters_saves = true;
                        }
                    }
                }
            }

            $oude_data[$n]['oude_oure_id'] = $record_add;
            $oude_data[$n]['oude_update_time'] = date('Y-m-d H:i:s');
            $oude_data[$n]['oude_goo_id'] = $value;
            $oude_data[$n]['oude_goo_number'] = $goo_quantity[$key]; //实际出入库数量
            $oude_data[$n]['oude_goo_oldnum'] = $enters_sellsarray['ense_new_inventory']; //期初数量
            $oude_data[$n]['oude_goo_newnum'] = $enters_sellsarray['ense_end_inventory']; //结存数量
            $oude_data[$n]['oude_type'] = $goo_inventory[$key]; //类型1良品2优先
            $oude_data[$n]['oude_wafr_id'] = isset($oure_wafr_id[$key]) ? $oure_wafr_id[$key] : ''; //仓位id
            $n++;
        }
        // dump($oude_data);
        // exit;
        $record_details_add = DB::table('outin_details')->insert($oude_data);
        if ($record_details_add && $record_add) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * [addition 添加出入库记录]
     * @param  [type] $user_info                        [用户信息]
     * @param  [type] $oure_original_correlation_id     [原始单的关联id]
     * @param  [type] $oure_original_correlation_number [原始单的关联单号]
     * @param  [type] $oure_original_correlation_type   [原始单的关联类型1订单2调拨单3采购单4销售单5旧货回收6退货入库7售后]
     * @param  [type] $oure_client_type                 [买家类型：1会员零售2客户单位3速电派单4第三方派单]
     * @param  [type] $oure_client_id                   [选择的客户id,会员id/单位id]
     * @param  [type] $oure_original_number             [原始单号]
     * @param  [type] $oure_in_ware_id                  [入库仓库id]
     * @param  [type] $oure_out_ware_id                 [出库仓库id]
     * @param  [type] $oure_count                       [出库的商品总量]
     * @param  [type] $oure_type                        [类型1入库单2出库单3调货单4旧货回收单5退换回收单6订单出库7部分入库8部分出库9发货单]
     * @param  [type] $oure_operation_type              [操作类型：1锁定库存2出库3入库4调货5发货]
     * @param  [type] $oure_all_stock                   [良品总库存]
     * @param  [type] $oure_lock_quantity               [良品锁定数量]
     * @param  [type] $oure_priority_all_stock          [优先总库存]
     * @param  [type] $oure_priority_lock_quantity      [优先锁定数量]
     * @param  [type] $oure_unchecked_all_stock         [待检测总库存]
     * @param  [type] $oure_out_in_type                 [出入库类型：1出库，2入库]
     * @param  [type] $oure_waon_class                  [仓库类别：1货物仓2非货物仓3旧货仓4临时仓]
     * @param  [type] $goo_id                           [商品id]
     * @param  [type] $goo_quantity                     [商品数量]
     * @param  [type] $goo_inventory                    [商品出入库类型]
     * @param  [type] $oure_wafr_id                     [仓位id]
     * @param  [type] $oure_class_goo_id                [仓库类别商品id]
     * @param  [type] $request_goo_price                        [退货入库金额]
     * @return [type]                                   [description]
     */
    public static function rkAddition(
        $user_info,
        $oure_original_correlation_id,
        $oure_original_correlation_number,
        $oure_original_correlation_type,
        $oure_client_type,
        $oure_client_id,
        $oure_original_number,
        $oure_in_ware_id,
        $oure_out_ware_id,
        $oure_count,
        $oure_type,
        $oure_operation_type,
        $oure_all_stock,
        $oure_lock_quantity,
        $oure_priority_all_stock,
        $oure_priority_lock_quantity,
        $oure_unchecked_all_stock,
        $oure_out_in_type,
        $oure_waon_class,
        $goods_data,
        $goo_quantity,
        $goo_inventory,
        $oure_wafr_id = [],
        $oure_class_goo_id = [],
        $request_goo_price = []
    ) {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 生成出入库记录
        $number = time() . rand(10000, 99999); //共15位
        // 出入库记录表新增数据
        $record['oure_cid'] = $user_info->adm_cid; //公司id
        $record['oure_shop_id'] = $user_info->adm_shop_id; //门店id
        $record['oure_superior_shop_id'] = $shop_id; //门店id
        $record['oure_adm_id'] = $user_info->adm_id; //操作人
        $record['oure_number'] = $number; //单号
        $record['oure_original_correlation_id'] = $oure_original_correlation_id; //原始单的关联id
        $record['oure_original_correlation_number'] = $oure_original_correlation_number; //原始单的关联单号
        $record['oure_original_correlation_type'] = $oure_original_correlation_type; //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
        $record['oure_client_type'] = $oure_client_type; //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
        $record['oure_client_id'] = $oure_client_id; //选择的客户id,会员id/单位id
        $record['oure_original_number'] = $oure_original_number; //原始单号
        $record['oure_in_ware_id'] = $oure_in_ware_id; //入库仓库id
        $record['oure_out_ware_id'] = $oure_out_ware_id; //出库仓库id
        $record['oure_count'] = $oure_count; //出库的商品总量
        $record['oure_type'] = $oure_type; //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库
        $record['oure_operation_type'] = $oure_operation_type; //操作类型：1锁定库存2出库3入库4调货5发货
        $record['oure_all_stock'] = $oure_all_stock; //良品总库存
        $record['oure_priority_all_stock'] = $oure_priority_all_stock; //优先总库存
        $record['oure_unchecked_all_stock'] = $oure_unchecked_all_stock; //待检测总库存
        $record['oure_update_time'] = date('Y-m-d H:i:s');
        $record['oure_out_in_type'] = $oure_out_in_type; //出入库类型：1出库，2入库
        $record['oure_waon_class'] = $oure_waon_class; //仓库类别
        $record_add = DB::table('outin_record')->insertGetId($record);

        $n = 0;
        if ($oure_waon_class == '2') {
            $oure_waon_class = '1';
        }
        foreach ($goods_data as $key => $value) {
            if (!empty($oure_class_goo_id) && !in_array($value['goods_id'], $oure_class_goo_id)) {
                continue;
            }
            // 出入库类型：1出库，2入库
            if ($oure_out_in_type == '2') {
                $oure_ware_id = $oure_in_ware_id; //入库仓库id
                // 出库
            } else {
                $oure_ware_id = $oure_out_ware_id; //出库仓库id
            }
            // 当前成本价
            $newprice = DB::table('enters_sells_saves')
                ->where('ense_goo_id', $value['goods_id'])
                ->where('ense_goo_warehouse', $oure_ware_id)
                ->where('ense_goo_waretype', $oure_waon_class)
                ->orderBy('ense_id', 'desc')
                ->select('ense_end_price', 'ense_end_amount', 'ense_end_inventory')
                ->first();
            if ($newprice) {
                $new_nums = empty($newprice->ense_end_inventory) ? 0 : $newprice->ense_end_inventory;
                $ense_end_price = empty($newprice->ense_end_price) ? 0 : $newprice->ense_end_price;
                // 当前总金额
                $ense_new_amount = empty($newprice->ense_end_amount) ? 0 : $newprice->ense_end_amount;
            } else {
                $new_nums = 0;
                $ense_end_price = '0';
                $ense_new_amount = '0';
            }
            // 商品信息
            $goods = DB::table('goods')
                ->where('goo_id', $value['goods_id'])
                ->select('goo_name', 'goo_goods_encode', 'goo_ampere_hour', 'goo_attribute', 'goo_recycle_price', 'goo_unit', 'goo_unta_id', 'goo_unit_conversion')
                ->first();
            if ($goods->goo_attribute == '') {
                $unit = "";
            } else {
                $units = json_decode($goods->goo_attribute, true);
                foreach ($units as $k => $v) {
                    if ($v['key'] == '单位') {
                        $unit = $v['value'];
                    } else {
                        $unit = '';
                    }
                }
            }
            $dh = substr($oure_original_correlation_number, 0, 2);
            if ($oure_type == '18') { //oure_type：类型18基础版入库单
                $goods_price = $value['goods_price'];
                if ($new_nums < 0) {
                    // 期末平均价
                    $price = $goods_price;
                    // 期末总价
                    $ense_end_amount = ($goo_quantity[$value['goods_id']] * $goods_price) + ($price * $new_nums);
                } else {
                    // 期末总价
                    $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$value['goods_id']];
                    // 期末平均价
                    if ($new_nums + $goo_quantity[$value['goods_id']] == '0') {
                        $price = 0;
                    } else {
                        $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity[$value['goods_id']]));
                    }
                }
                // 添加信息
                $enters_sellsarray['ense_goo_id'] = $value['goods_id']; //商品id
                $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                $enters_sellsarray['ense_goo_unit'] = $goods->goo_unit; //商品单位
                $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$value['goods_id']]; //期末库存
                $enters_sellsarray['ense_end_price'] = $goods_price; //期末成本价
                $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                $enters_sellsarray['ense_in_num'] = $goo_quantity[$value['goods_id']]; //入库数量
                $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                $enters_sellsarray['ense_in_amount'] = $goo_quantity[$value['goods_id']] * $goods_price; //入库总金额
                $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //
                $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
            }

            $oude_data[$n]['oude_oure_id'] = $record_add;
            $oude_data[$n]['oude_update_time'] = date('Y-m-d H:i:s');
            $oude_data[$n]['oude_goo_id'] = $value['goods_id'];
            // $goo_data = DB::table('goods')
            //     ->where('goo_id', $value)
            //     ->select('goo_id', 'goo_name', 'goo_unit', 'goo_unta_id', 'goo_unit_conversion')
            //     ->first();
            // if ($goo_data) {
            //     if ($goo_data->goo_unta_id == 1) {
            //         $oude_data[$n]['oude_goo_number'] = $goo_quantity[$key]/$goo_data->goo_unit_conversion;//实际出入库数量
            //     } else {
            //     }
            // } else {
            //     return false;
            // }
            $oude_data[$n]['oude_goo_number'] = $goo_quantity[$value['goods_id']]; //实际出入库数量
            $oude_data[$n]['oude_goo_oldnum'] = $enters_sellsarray['ense_new_inventory']; //期初数量
            $oude_data[$n]['oude_goo_newnum'] = $enters_sellsarray['ense_end_inventory']; //结存数量
            $oude_data[$n]['oude_type'] = $goo_inventory[$value['goods_id']]; //类型1良品2优先
            $oude_data[$n]['oude_wafr_id'] = isset($oure_wafr_id[$value['goods_id']]) ? $oure_wafr_id[$value['goods_id']] : ''; //仓位id
            $n++;
        }
        $record_details_add = DB::table('outin_details')->insert($oude_data);
        if ($record_details_add && $record_add) {
            return true;
        } else {
            return false;
        }
    }
}

