<?php
namespace App\Http\Models\Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Models\Api\Warehouse;

class DispatchBill extends Model
{
    /**
     * [add 生成发货单]
     * @param [type] $user_info             [用户信息]
     * @param [type] $request               [订单提交数据]
     * @param [type] $dego_order_type       [类型：1.订单发货 2.工单发货]
     * @param [type] $dego_out_ware_id      [出库仓库id]
     * @param [type] $dego_original_number  [原始单号，订单号/工单号]
     * @param [type] $dego_wor_id           [发货单关联的工单/订单id]
     * @param [type] $dego_superior_shop_id [所属总店id]
     * @param [type] $dego_client_type [买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单]
     * @param [type] $dego_client_id [选择的客户id,会员id/单位id]
     * @param [type] $dego_count            [发货总数量]
     */
    public static  function add(
        $user_info,
        $request,
        $dego_order_type,
        $dego_out_ware_id,
        $dego_original_number,
        $dego_wor_id,
        $dego_superior_shop_id,
        $dego_client_type,
        $dego_client_id,
        $dego_count
    ) {
		foreach($request['goo_id'] as $k=>$v){
			if(isset($goodsarray[$v])){
				$goodsarray[$v]=$goodsarray[$v]+$request['goo_quantity'][$k];	
			}else{
				$goodsarray[$v]=$request['goo_quantity'][$k];
			}
			
		}
        // 6.1 发货单表添加数据
        $dego_number = 'FH'.time().rand(100,999);
        $bill_data['dego_cid'] = $user_info->adm_cid; //公司id
        $bill_data['dego_shop_id'] = $user_info->adm_shop_id; //门店id
        $bill_data['dego_superior_shop_id'] = $dego_superior_shop_id; //所属总店id
        $bill_data['dego_number'] = $dego_number; //发货单号
        $bill_data['dego_order_type'] = $dego_order_type; //类型：1.订单生成 2.工单生成
        $bill_data['dego_original_number'] = $dego_original_number; //原始单号,发货单的关联单号(订单号)
        $bill_data['dego_wor_id'] = $dego_wor_id; //发货单关联的订单id
        $bill_data['dego_client_type'] = $dego_client_type; //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
        $bill_data['dego_client_id'] = $dego_client_id; //选择的客户id,会员id/单位id
        $bill_data['dego_count'] = $dego_count; //发货总数量
        $bill_data['dego_out_ware_id'] = $dego_out_ware_id; //出库仓库id
        // 服务门店为0的话 是当前门店id
        if($request['service_shop_id'] == 0){
            $bill_data['dego_service_shop_id'] = $user_info->adm_shop_id; //服务门店id
        }else{
            $bill_data['dego_service_shop_id'] = $request['service_shop_id']; //服务门店id
        }
        $bill_data['dego_service_adm_id'] = $request['service_adm_id'] ? $request['service_adm_id'] : 0; //服务技师id
        $bill_data['dego_type'] = 1; //类型：1未出库2已出库
        $bill_data['dego_create_adm_id'] = $user_info->adm_id; //创建人id
        $bill_data['dego_remark'] = isset($request['ord_remark']) ? $request['ord_remark'] : ''; //订单备注
        $dispatch_bill = DB::table('dispatch_bill')->insertGetId($bill_data);

        $goo_all_fine = 0;
        $goo_all_priority = 0;
        // 6.2 发货单商品表添加数据
        foreach ($request['goo_id'] as $key => $value) {
            // 商品状态：1.正常3回收的商品4换货商品 5赠品
            if ($request['goo_state'][$key] == 4) {
                continue;
            }
            // 搜索商品id对应的商品名称、商品编号
            $find_goods_data = DB::table('goods')
                ->where('goo_id', $value)
                ->first(['goo_name', 'goo_goods_encode', 'goo_type','goo_fid', 'goo_class']);
            $warehouse_goods = DB::table('warehouse_goods as wg')
                ->where('wago_ware_id', $request['ware_id'])
                ->where('wago_class', $request['goo_waon_class'][$key])
                ->where('wago_goo_id',$value)
                ->first(['wago_stock_number','wago_priority_stock_number']);
            if($request['goo_inventory'][$key] == 1 && $request['goo_state'][$key] == 5){
                $num = $warehouse_goods->wago_stock_number - $goodsarray[$value];
                if($num < 0){
                    $give_warehouse_goods = DB::table('warehouse_goods as wg')
                        ->join('goods as g','g.goo_id','=','wg.wago_goo_id')
                        ->where('wago_ware_id', $request['ware_id'])
                        ->where('wago_class', 1)
                        ->where('goo_id',$find_goods_data->goo_fid)
                        ->first(['wago_stock_number','goo_id','goo_price','goo_type']);
                    if(empty($give_warehouse_goods)){
                        return ['code'=>500,'msg'=>'error','data'=>'仓库内商品数量不足'];
                    }
                    $num = $give_warehouse_goods->wago_stock_number - $goodsarray[$value];
                    if($num < 0){
                        return ['code'=>500,'msg'=>'error','data'=>'仓库内商品数量不足'];
                    }
                    $request['goo_price'][$key] = 0;
                    $request['goo_waon_class'][$key] = 1;
                    if($value == $give_warehouse_goods->goo_id){
                        return ['code' => 500, 'msg' => 'error', 'data' => '仓库内商品数量不足']; 
                    }
                    $value = $give_warehouse_goods->goo_id;
                }
            }else if($request['goo_inventory'][$key] == 2 && $request['goo_state'][$key] == 5){
                $num = $warehouse_goods->wago_priority_stock_number - $goodsarray[$value];
                if($num < 0){
                    $give_warehouse_goods = DB::table('warehouse_goods as wg')
                        ->join('goods as g','g.goo_id','=','wg.wago_goo_id')
                        ->where('wago_ware_id', $request['ware_id'])
                        ->where('wago_class', 1)
                        ->where('goo_id',$find_goods_data->goo_fid)
                        ->first(['wago_priority_stock_number','goo_price','goo_name','goo_goods_encode','goo_id','goo_type']);
                    if(empty($give_warehouse_goods)){
                        return ['code'=>500,'msg'=>'error','data'=>'仓库内商品数量不足'];
                    }
                    $num = $give_warehouse_goods->wago_priority_stock_number - $goodsarray[$value];
                    if($num < 0){
                        return ['code'=>500,'msg'=>'error','data'=>'仓库内商品数量不足'];
                    }
                    $request['goo_price'][$key] = 0;
                    $request['goo_waon_class'][$key] = 1;
                    if($value == $give_warehouse_goods->goo_id){
                        return ['code' => 500, 'msg' => 'error', 'data' => '仓库内商品数量不足']; 
                    }
                    $value = $give_warehouse_goods->goo_id;
                }
            }
            $goo_id[] = $value;
            $goo_quantity[] = $request['goo_quantity'][$key];
            $goo_inventory[] = $request['goo_inventory'][$key];

            // 发货商品表数据
            $digo_data[$key]['digo_dego_id'] = $dispatch_bill;
            $digo_data[$key]['digo_wago_class'] = $request['goo_waon_class'][$key];
            $digo_data[$key]['digo_goo_id'] = $value;
            $digo_data[$key]['digo_goo_price'] = $request['goo_price'][$key] * 100;
            $digo_data[$key]['digo_goo_quantity'] = $request['goo_quantity'][$key];
            $digo_data[$key]['digo_is_recycle'] = $request['goo_recycle'][$key];
            $digo_data[$key]['digo_state'] = $request['goo_state'][$key];
            $digo_data[$key]['digo_goo_inventory'] = $request['goo_inventory'][$key];
            $digo_data[$key]['digo_goo_type'] = isset($request['goo_type'][$key]) ? $request['goo_type'][$key] : $find_goods_data->goo_type;
            if(!empty($request['tem_goo_name'][$key])){
                $tem_goo_name = $request['tem_goo_name'][$key];
            }else{
                $tem_goo_name = '';
            }
            $digo_data[$key]['digo_tem_goo_name'] = $tem_goo_name;
            $digo_data[$key]['digo_goo_name'] = $find_goods_data->goo_name;
            $digo_data[$key]['digo_goo_goods_encode'] = $find_goods_data->goo_goods_encode;

            if($request['goo_inventory'][$key] == 1){
                $goo_all_fine += $request['goo_quantity'][$key]; //1.良品
            }else{
                $goo_all_priority += $request['goo_quantity'][$key]; //2.优先
            }

            // 商品id和所对应的商品数量
            $subtract[$value] = $request['goo_quantity'][$key];
            // 每个商品对应的出库方式
            $goo_inventory_type[$value] = $request['goo_inventory'][$key];
            $goo_waon_class[$value] = $request['goo_waon_class'][$key];//仓库类别

            $class_goods['goo_inventory'] = $request['goo_inventory'][$key];
            $class_goods['goo_quantity'] = $request['goo_quantity'][$key];
            $wago_class_goods[$request['goo_waon_class'][$key]][$value] = $class_goods;//仓库类型对应的出库商品数据
            if (isset($wago_class_goods[$request['goo_waon_class'][$key]])) {
                $wago_class_goods[$request['goo_waon_class'][$key]][$value]['goo_quantity'] += $request['goo_quantity'][$key];
            }else{
                $wago_class_goods[$request['goo_waon_class'][$key]][$value] = $class_goods;//仓库类型对应的出库商品数据
            }
        }
        if(empty($digo_data)){
            return ['code'=>500,'msg'=>'error','data'=>'换货单不能没有换新商品'];
        }
        $dispatch_goods = DB::table('dispatch_goods')->insert($digo_data);
        // 查询出仓库这些商品数量是否够减
        $goo_waon_class = array_unique($request['goo_waon_class']);
        $warehouse_goods = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $request['ware_id'])
                    ->whereIn('wago_class', $goo_waon_class)
                    ->whereIn('wago_goo_id', $goo_id)
                    ->get(['wago_id', 'wago_goo_id', 'wago_class', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity'])
                    ->toArray();
        //  处理要出库的商品库存数量
        if (empty($warehouse_goods)) {
            return ['code'=>500,'msg'=>'error','data'=>'当前仓库未找到出库商品，无法出库'];
        }

        // 将数据组合成新的数组
        foreach ($warehouse_goods as $key => $value) {
            $warehouse_class_goods[$value->wago_class][$value->wago_goo_id] = (array)$value;
        }
        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $stock_fine_sql = '';
        $stock_priority_sql = '';
        $lock_fine_sql = '';
        $lock_priority_sql = '';
        $time_sql = '';
        $ids = '';

        $waon_class_fine_quantity = [];//仓库类别对应良品库存总数量
        $waon_class_priority_quantity = [];//仓库类别对应优先库存总数量
        // 发货单要出库的商品
        foreach ($wago_class_goods as $waon_class_key => $goods_data) {
            foreach ($goods_data as $goo_id_key => $value) {
                // 商品出库类型，良品出库
                if ($value['goo_inventory'] == 1) {
                    // 良品剩余库存数量
                    $surplus_quantity = $warehouse_class_goods[$waon_class_key][$goo_id_key]['wago_stock_number'] - $goodsarray[$goo_id_key];
                    if ($surplus_quantity < 0) {
                        return ['code'=> 500, 'msg'=>'error', 'data'=>'仓库内商品数量不足'];
                    }
                    // 更改库存数量
                    $stock_fine_sql = $stock_fine_sql.' WHEN '.$warehouse_class_goods[$waon_class_key][$goo_id_key]['wago_id'].' THEN `wago_stock_number` - '.$goodsarray[$goo_id_key];
                    // 更改锁定数量
                    $lock_fine_sql = $lock_fine_sql.' WHEN '.$warehouse_class_goods[$waon_class_key][$goo_id_key]['wago_id'].' THEN `wago_lock_quantity` + '.$goodsarray[$goo_id_key];

                    // 更改库存数量
                    $stock_priority_sql = $stock_priority_sql.' WHEN '.$warehouse_class_goods[$waon_class_key][$goo_id_key]['wago_id'].' THEN `wago_priority_stock_number` - 0';
                    // 更改锁定数量
                    $lock_priority_sql = $lock_priority_sql.' WHEN '.$warehouse_class_goods[$waon_class_key][$goo_id_key]['wago_id'].' THEN `wago_priority_lock_quantity` + 0';

                    if (isset($waon_class_fine_quantity[$waon_class_key])) {
                        $waon_class_fine_quantity[$waon_class_key] += $value['goo_quantity'];//仓库类别对应良品库存总数量
                    }else{
                        $waon_class_fine_quantity[$waon_class_key] = $value['goo_quantity'];//仓库类别对应良品库存总数量
                    }
                // 商品出库类型，优先出库
                } else {
                    // 优先剩余库存数量
                    $surplus_quantity = $warehouse_class_goods[$waon_class_key][$goo_id_key]['wago_priority_stock_number'] - $goodsarray[$goo_id_key];
                    if ($surplus_quantity < 0) {
                        return ['code'=> 500, 'msg'=>'error', 'data'=>'仓库内商品数量不足'];
                    }

                    // 更改库存数量
                    $stock_priority_sql = $stock_priority_sql.' WHEN '.$warehouse_class_goods[$waon_class_key][$goo_id_key]['wago_id'].' THEN `wago_priority_stock_number` - '.$goodsarray[$goo_id_key];
                    // 更改锁定数量
                    $lock_priority_sql = $lock_priority_sql.' WHEN '.$warehouse_class_goods[$waon_class_key][$goo_id_key]['wago_id'].' THEN `wago_priority_lock_quantity` + '.$goodsarray[$goo_id_key];

                    // 更改库存数量
                    $stock_fine_sql = $stock_fine_sql.' WHEN '.$warehouse_class_goods[$waon_class_key][$goo_id_key]['wago_id'].' THEN `wago_stock_number` - 0';
                    // 更改锁定数量
                    $lock_fine_sql = $lock_fine_sql.' WHEN '.$warehouse_class_goods[$waon_class_key][$goo_id_key]['wago_id'].' THEN `wago_lock_quantity`  + 0';

                    if (isset($waon_class_priority_quantity[$waon_class_key])) {
                        $waon_class_priority_quantity[$waon_class_key] += $value['goo_quantity'];//仓库类别对应优先库存总数量
                    }else{
                        $waon_class_priority_quantity[$waon_class_key] = $value['goo_quantity'];//仓库类别对应优先库存总数量
                    }
                }

                $time_sql = $time_sql.' WHEN '.$warehouse_class_goods[$waon_class_key][$goo_id_key]['wago_id'].' THEN "'.date('Y-m-d H:i:s').'"'; // 更改时间
                $ids = $ids . $warehouse_class_goods[$waon_class_key][$goo_id_key]['wago_id'].',';
            }
        }

        // 2.1 固定仓商品表减锁定库存
        $sql = $sql .' `wago_stock_number`=  CASE `wago_id` '.$stock_fine_sql.' END,'; //修改库存数量
        $sql = $sql .' `wago_lock_quantity`=  CASE `wago_id` '.$lock_fine_sql.' END,'; //修改库存数量
        $sql = $sql .' `wago_priority_stock_number`=  CASE `wago_id` '.$stock_priority_sql.' END,'; //修改锁定数量
        $sql = $sql .' `wago_priority_lock_quantity`=  CASE `wago_id` '.$lock_priority_sql.' END,'; //修改锁定数量
        $sql = $sql .' `wago_update_time`=  CASE `wago_id` '.$time_sql.' END'; //修改时间
        $sql = $sql . ' WHERE `wago_id` IN ('.trim($ids,',').')';
        $wago_edit_res = DB::update($sql);
        
        // 查询仓库总数量仓库的类别对应的id
        $find_waon_data = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', '=', $request['ware_id'])
                        ->whereIn('waon_class', $goo_waon_class)
                        ->pluck('waon_id', 'waon_class')->toArray();

        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_fine_quantity as $key => $value) {
                $stock_fine_sql = $stock_fine_sql.' WHEN '.$find_waon_data[$key].' THEN `waon_stock_fine_amount` - '.$value;
                $lock_fine_sql = $lock_fine_sql.' WHEN '.$find_waon_data[$key].' THEN `waon_lock_fine_amount` + '.$value;
                $time_sql = $time_sql.' WHEN '.$find_waon_data[$key].' THEN "'.date('Y-m-d H:i:s').'"';

                $ids = $ids . $find_waon_data[$key].',';
            }
            $sql = $sql .' `waon_stock_fine_amount`=  CASE `waon_id` '.$stock_fine_sql.' END,';
            $sql = $sql .' `waon_lock_fine_amount`=  CASE `waon_id` '.$lock_fine_sql.' END,';
            $sql = $sql .' `waon_update_time`=  CASE `waon_id` '.$time_sql.' END';
            $sql = $sql . ' WHERE `waon_id` IN ('.trim($ids,',').')';
            $waon_fine_res = DB::update($sql);
        } else {
            $waon_fine_res = true;
        }
        
        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_priority_quantity as $key => $value) {
                $stock_fine_sql = $stock_fine_sql.' WHEN '.$find_waon_data[$key].' THEN `waon_stock_priority_amount` - '.$value;
                $lock_fine_sql = $lock_fine_sql.' WHEN '.$find_waon_data[$key].' THEN `waon_lock_priority_amount` + '.$value;
                $time_sql = $time_sql.' WHEN '.$find_waon_data[$key].' THEN "'.date('Y-m-d H:i:s').'"';

                $ids = $ids . $find_waon_data[$key].',';
            }
            $sql = $sql .' `waon_stock_priority_amount`=  CASE `waon_id` '.$stock_fine_sql.' END,';
            $sql = $sql .' `waon_lock_priority_amount`=  CASE `waon_id` '.$lock_fine_sql.' END,';
            $sql = $sql .' `waon_update_time`=  CASE `waon_id` '.$time_sql.' END';
            $sql = $sql . ' WHERE `waon_id` IN ('.trim($ids,',').')';
            $waon_priority_res = DB::update($sql);
        } else {
            $waon_priority_res = true;
        }

        if ($dispatch_bill && $dispatch_goods && $wago_edit_res && $waon_fine_res && $waon_priority_res) {
            return ['code'=>200,'msg'=>'success','data'=>'生成发货单成功', 'dego_id'=>$dispatch_bill];
        } else {
            return ['code'=>500,'msg'=>'success','data'=>'生成发货单失败'];
        }
    }

    /**
     * [create 生成发货单]
     * @param [type] $user_info             [用户信息]
     * @param [type] $request               [订单提交数据]
     * @param [type] $goods_data            [提交的商品数据]
     * @param [type] $dego_order_type       [类型：1.订单发货 2.工单发货]
     * @param [type] $dego_out_ware_id      [出库仓库id]
     * @param [type] $dego_original_number  [原始单号，订单号/工单号]
     * @param [type] $dego_wor_id           [发货单关联的工单/订单id]
     * @param [type] $dego_superior_shop_id [所属总店id]
     * @param [type] $dego_client_type [买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单]
     * @param [type] $dego_client_id [选择的客户id,会员id/单位id]
     * @param [type] $dego_count            [发货总数量]
     */
    public static  function create(
        $user_info,
        $request,
        $goods_data,
        $dego_order_type,
        $dego_out_ware_id,
        $dego_original_number,
        $dego_wor_id,
        $dego_superior_shop_id,
        $dego_client_type,
        $dego_client_id,
        $dego_count
    ) {
        // 6.1 发货单表添加数据
        $dego_number = 'FH'.time().rand(100,999);
        $bill_data['dego_cid'] = $user_info->adm_cid; //公司id
        $bill_data['dego_shop_id'] = $user_info->adm_shop_id; //门店id
        $bill_data['dego_superior_shop_id'] = $dego_superior_shop_id; //所属总店id
        $bill_data['dego_number'] = $dego_number; //发货单号
        $bill_data['dego_order_type'] = $dego_order_type; //类型：1.订单生成 2.工单生成
        $bill_data['dego_original_number'] = $dego_original_number; //原始单号,发货单的关联单号(订单号)
        $bill_data['dego_wor_id'] = $dego_wor_id; //发货单关联的订单id
        $bill_data['dego_client_type'] = $dego_client_type; //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
        $bill_data['dego_client_id'] = $dego_client_id; //选择的客户id,会员id/单位id
        // $bill_data['dego_count'] = $dego_count; //发货总数量
        $bill_data['dego_out_ware_id'] = $dego_out_ware_id; //出库仓库id
        // 服务门店为0的话 是当前门店id
        if($request['service_shop_id'] == 0){
            $bill_data['dego_service_shop_id'] = $user_info->adm_shop_id; //服务门店id
        }else{
            $bill_data['dego_service_shop_id'] = $request['service_shop_id']; //服务门店id
        }
        $bill_data['dego_service_adm_id'] = isset($request['service_adm_id']) ? $request['service_adm_id'] : 0; //服务技师id
        $bill_data['dego_type'] = 1; //类型：1未出库2已出库
        $bill_data['dego_create_adm_id'] = $user_info->adm_id; //创建人id
        $bill_data['dego_remark'] = isset($request['ord_remark']) ? $request['ord_remark'] : ''; //订单备注
        $dego_id = DB::table('dispatch_bill')->insertGetId($bill_data);
        // 6.2 发货单商品表添加数据
        foreach ($goods_data as $key => $value) {
            // 商品状态：1.正常3回收的商品4换货商品5赠品
            if ($value['goo_state'] == 4) {
                continue;
            }
            // 搜索商品id对应的商品名称、商品编号
            $find_goods_data = DB::table('goods')
                ->where('goo_id', $value['goo_id'])
                ->first(['goo_name', 'goo_goods_encode', 'goo_type', 'goo_class']);
            // 发货商品表数据
            $digo_data[$key]['digo_dego_id'] = $dego_id;
            $digo_data[$key]['digo_orgo_id'] = isset($value['orgo_id']) ? $value['orgo_id'] : 0;//订单商品主键id
            $digo_data[$key]['digo_wago_id'] = $value['wago_id'];
            $digo_data[$key]['digo_wafr_id'] = isset($value['wafr_id']) ? $value['wafr_id'] : 0;//仓位id
            $digo_data[$key]['digo_wafg_id'] = isset($value['wafg_id']) ? $value['wafg_id'] : 0;//仓位商品id
            // $digo_data[$key]['digo_wago_class'] = $value['goo_waon_class'];
            $digo_data[$key]['digo_wago_class'] = 1;
            $digo_data[$key]['digo_goo_id'] = $value['goo_id'];
            // $digo_data[$key]['digo_goo_price'] = $value['goo_price'] * 100;
            $digo_data[$key]['digo_goo_quantity'] = $value['goo_quantity'];
            $digo_data[$key]['digo_state'] = $value['goo_state'];
            $digo_data[$key]['digo_goo_inventory'] = 1;
            // $digo_data[$key]['digo_goo_inventory'] = $value['goo_inventory'];
            $digo_data[$key]['digo_goo_name'] = $find_goods_data->goo_name;
            $digo_data[$key]['digo_goo_goods_encode'] = $find_goods_data->goo_goods_encode;
            $digo_data[$key]['digo_goo_type'] = isset($value['goo_type']) ? $value['goo_type'] : $find_goods_data->goo_type;
            $digo_data[$key]['digo_tem_goo_name'] = empty($value['tem_goo_name']) ? '' : $value['tem_goo_name'];
            if (empty($value['goo_unit']) || empty($value['goo_unta_id'])) {
                return ['code'=>500,'msg'=>'请选择单位','data'=>'请选择单位'];
            }
            $digo_data[$key]['digo_goo_unit'] = empty($value['goo_unit']) ? '' : $value['goo_unit'];
            $digo_data[$key]['digo_goo_unta_id'] = empty($value['goo_unta_id']) ? '' : $value['goo_unta_id'];
            
        }
        $dispatch_goods = DB::table('dispatch_goods')->insert($digo_data);
        if ($dego_id && $dispatch_goods) {
            return ['code'=>200,'msg'=>'success','data'=>'生成发货单成功', 'dego_id'=>$dego_id];
        } else {
            return ['code'=>500,'msg'=>'success','data'=>'生成发货单失败'];
        }
    }

    
    
    public static function shipments () {
        // 验证已经发货的不能再次发货
        if (empty($dis_data)) {
            return ['code'=>500, 'msg'=>'当前发货单不存在!', 'data'=>''];
        }
        
        if ($dis_data->dego_type == 3) {
            return ['code'=>500, 'msg'=>'当前发货单已作废!', 'data'=>''];
        }
        if ($dis_data->dego_type == 4) {
            return ['code'=>500, 'msg'=>'当前发货单已锁定，无法发货！', 'data'=>''];
        }

        // dego_order_type类型：1.订单发货 2.工单发货3售后单发货
        if ($dis_data->dego_order_type == 2) {
            // 查询当前工单技师的服务状态
            $wor_service_state = DB::table('work_order')
                ->where('wor_id', $dis_data->dego_wor_id)
                ->value('wor_service_state');
            // 如果技师尚未接单，不允许发货
            // 服务状态：1待接单2已接单3预约4出发5抵达6完成待审核7完成已驳回8完成通过9终止10锁定11速电撤销回收
            if ($wor_service_state < 2) {
                return ['code'=>500, 'msg'=>'当前技师尚未接单！', 'data'=>''];
            }
        } elseif ($dis_data->dego_order_type == 3) {
            // 售后单发货验证
            return ['code'=>500, 'msg'=>'售后单发货功能暂未开通！', 'data'=>''];
        }
        
        // 判断出库仓库类型，pc端不能发移动仓库的商品，只能发固定仓的，有权限的商品
        //ware_type类型：1固定仓2技师库3移动仓
        $dego_out_ware_type = DB::table('warehouse')
            ->where('ware_id', $dis_data->dego_out_ware_id)
            ->value('ware_type');
        if ($dego_out_ware_type != 1) {
            return ['code'=>500, 'msg'=>'当前供货仓库不是固定仓库，没有发货权限！', 'data'=>''];
        }

        // 1.修改发货单表的状态
        $update_send_data['dego_type'] = 2; //类型：1未出库2已出库
        $update_send_data['dego_update_time'] = date('Y-m-d H:i:s', time()); //更新时间
        $update_send_res = DB::table('dispatch_bill')
            ->where('dego_id', $dis_data->dego_id)
            ->update($update_send_data);

        // 查询出该发货单的商品
        $goods_data = DB::table('dispatch_goods')
            ->where('digo_dego_id', $dis_data->dego_id)
            ->get(['digo_goo_id', 'digo_wago_id', 'digo_wago_class', 'digo_goo_quantity', 'digo_goo_inventory', 'digo_wafr_id', 'digo_wafg_id'])
            ->toArray();
        $neaten_goods_data = [];//仓库商品数据
        $freight_goods_data = [];//仓位商品数据
        $neaten_wago_id = [];//仓库商品id
        $freight_wafg_id = [];//仓位商品id
        $goo_all_fine = 0;//良品总数量
        $goo_all_priority = 0;//优先总数量
        foreach ($goods_data as $key => $value) {
            // 仓位id不为空的情况下
            if (!empty($value->digo_wafg_id)) {
                // [仓位商品id商品id][出库类型：良品/优先]，用于判断仓位是否有库存
                if (isset($freight_goods_data[$value->digo_wafg_id][$value->digo_goo_inventory])) {
                    $freight_goods_data[$value->digo_wafg_id][$value->digo_goo_inventory]['digo_goo_quantity'] += $value->digo_goo_quantity;
                } else {
                    $freight_goods_data[$value->digo_wafg_id][$value->digo_goo_inventory] = (array)$value;
                }
            } else {
                // [仓库商品id][出库类型：良品/优先]，用于判断仓库是否有库存
                if (isset($neaten_goods_data[$value->digo_wago_id][$value->digo_goo_inventory])) {
                    $neaten_goods_data[$value->digo_wago_id][$value->digo_goo_inventory]['digo_goo_quantity'] += $value->digo_goo_quantity;
                } else {
                    $neaten_goods_data[$value->digo_wago_id][$value->digo_goo_inventory] = (array)$value;
                }
            }
            $neaten_wago_id[] = $value->digo_wago_id;//仓库商品id
            $freight_wafg_id[] = $value->digo_wafg_id;//仓位商品id
            // digo_goo_inventory 库存扣除方式1.良品 2.优先
            if ($value->digo_goo_inventory == 1) {
                $goo_all_fine += $value->digo_goo_quantity;
            } else {
                $goo_all_priority += $value->digo_goo_quantity;
            }
            $digo_goo_id[] = $value->digo_goo_id;
            $digo_wago_class[] = $value->digo_wago_class;

            if (isset($wago_class_goods[$value->digo_wago_class][$value->digo_goo_id])) {
                $wago_class_goods[$value->digo_wago_class][$value->digo_goo_id]['digo_goo_quantity'] = $wago_class_goods[$value->digo_wago_class][$value->digo_goo_id]['digo_goo_quantity']+$value->digo_goo_quantity;//仓库类型对应的商品，出入库记录
            } else {
                $wago_class_goods[$value->digo_wago_class][$value->digo_goo_id] = (array)$value;//仓库类型对应的商品，出入库记录
            }
        }

        $neaten_wago_id = array_unique($neaten_wago_id);//仓库商品id
        $freight_wafg_id = array_unique($freight_wafg_id);//仓位商品id

        if ($dis_data->dego_order_type == '2') {//2工单发货
            $find_order_data = DB::table('work_order as wor')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->where('wor_id', $dis_data->dego_wor_id)
                ->select('wor_type', 'wocl_client_id', 'wor_order_id', 'wor_order_number')
                ->first();
            $oure_original_correlation_id = $find_order_data->wor_order_id;
            $oure_original_correlation_number = $find_order_data->wor_order_number;
            $oure_client_type = $find_order_data->wor_type;
            $oure_client_id = $find_order_data->wocl_client_id;

            $find_ord_id = $find_order_data->wor_order_id;//订单id
            $find_order_number = $find_order_data->wor_order_number;//订单编号
        }

        // 更新订单商品表的商品成本，根据订单id,查询商品
        $find_orgo_data = DB::table('order_goods')
            ->where('orgo_ord_id', $find_ord_id)
            ->where('orgo_state', '!=', 2)
            ->select('orgo_id', 'orgo_state', 'orgo_ord_id', 'orgo_ware_id', 'orgo_waon_class', 'orgo_goo_id', 'orgo_goo_price', 'orgo_goo_quantity')
            ->get()->toArray();
        $cost_price = 0;//总成本金额
        $recycle_amount = 0;//回收商品总成本
        $now_date = date('Y-m-d H:i:s');//当前时间
        foreach ($find_orgo_data as $kkkk => $vvvv) {
            // 修改订单商品成本
            $orgo_edit_data['orgo_goo_cost'] = $find_ense_end_price * 100;
            $orgo_edit_data['orgo_update_time'] = $now_date;
            // 修改订单表的更新时间
            $orgo_edit_res = DB::table('order_goods')
                ->where('orgo_id', $vvvv->orgo_id)
                ->where('orgo_ord_id', $find_ord_id)
                ->where('orgo_order_number', $find_order_number)
                ->update($orgo_edit_data);
            unset($orgo_edit_data);
        }
        $ord_edit_data['ord_update_time'] = $now_date;
        $ord_edit_res = DB::table('order')->where('ord_id', $find_ord_id)->update($ord_edit_data);

        if (!empty($neaten_goods_data)) {//仓库库存数量调整
            // 2.选中的固定仓减锁定库存
            $warehouse_goods = DB::table('warehouse_goods')
                ->where('wago_ware_id', $dis_data->dego_out_ware_id)
                ->whereIn('wago_id', $neaten_wago_id)
                ->get(['wago_id', 'wago_class', 'wago_goo_id', 'wago_lock_quantity', 'wago_priority_lock_quantity'])
                ->toArray();
            $warehouse_goods = array_column($warehouse_goods, null, 'wago_id');
            foreach ($neaten_goods_data as $wago_id => $wago_value) {
                foreach ($wago_value as $goo_inventory => $goo_value) {
                    if (isset($warehouse_goods[$wago_id])) {
                        // 良品库存
                        if ($goo_inventory == 1) {
                            $surplus_quantity = $warehouse_goods[$wago_id]->wago_lock_quantity - $goo_value['digo_goo_quantity'];
                            if ($surplus_quantity < 0) {
                                return ['code'=>500, 'msg'=>'商品库存锁定数量不足！', 'data'=>''];
                            }
                            $wago_edit_res = DB::table('warehouse_goods')
                                ->where('wago_id', $wago_id)
                                ->update(['wago_lock_quantity'=>$surplus_quantity]);
                            $waon_stock_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                ->where('waon_class', $goo_value['digo_wago_class'])
                                ->decrement('waon_lock_fine_amount', $goo_value['digo_goo_quantity']);
                            $waon_all_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                ->where('waon_class', $goo_value['digo_wago_class'])
                                ->decrement('waon_all_amount', $goo_value['digo_goo_quantity']);
                            if (!$wago_edit_res || !$waon_stock_res || !$waon_all_res) {
                                return ['code'=> 500, 'msg'=>'发货失败！', 'data'=>''];
                            }
                        } else {
                            // 优先库存
                            $surplus_quantity = $warehouse_goods[$wago_id]->wago_priority_lock_quantity - $goo_value['digo_goo_quantity'];
                            if ($surplus_quantity < 0) {
                                return ['code'=>500, 'msg'=>'商品库存锁定数量不足！', 'data'=>''];
                            }
                            // 更改商品库存数量
                            $wago_edit_res = DB::table('warehouse_goods')
                                ->where('wago_id', $wago_id)
                                ->update(['wago_priority_lock_quantity'=>$surplus_quantity]);
                            // 更改库存总数量
                            $waon_stock_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                ->where('waon_class', $goo_value['digo_wago_class'])
                                ->decrement('waon_lock_priority_amount', $goo_value['digo_goo_quantity']);
                            $waon_all_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                ->where('waon_class', $goo_value['digo_wago_class'])
                                ->decrement('waon_all_amount', $goo_value['digo_goo_quantity']);
                            if (!$wago_edit_res || !$waon_stock_res || !$waon_all_res) {
                                return ['code'=> 500, 'msg'=>'发货失败！', 'data'=>''];
                            }
                        }
                    } else {
                        return ['code'=>500, 'msg'=>'仓库商品锁定数量不足！', 'data'=>''];
                    }
                }
            }
        }
        if (!empty($freight_goods_data)) {//仓位库存数量调整
            // 2.选中的固定仓减锁定库存
            $warehouse_freight_goods = DB::table('warehouse_freight_goods')
                ->where('wafg_ware_id', $dis_data->dego_out_ware_id)
                ->whereIn('wafg_id', $freight_wafg_id)
                ->get(['wafg_id', 'wafg_wafr_id', 'wafg_class', 'wafg_goo_id', 'wafg_lock_quantity', 'wafg_priority_lock_quantity'])
                ->toArray();
            $warehouse_freight_goods = array_column($warehouse_freight_goods, null, 'wafg_id');
            foreach ($freight_goods_data as $wafg_id => $wafg_value) {
                foreach ($wafg_value as $goo_inventory => $goo_value) {
                    if (isset($warehouse_freight_goods[$wafg_id])) {
                        // 良品库存
                        if ($goo_inventory == 1) {
                            $surplus_quantity = $warehouse_freight_goods[$wafg_id]->wafg_lock_quantity - $goo_value['digo_goo_quantity'];
                            if ($surplus_quantity < 0) {
                                return ['code'=>500, 'msg'=>'仓位商品库存锁定数量不足1！', 'data'=>''];
                            }
                            // 仓位商品表锁定库存调整
                            $wafg_edit_res = DB::table('warehouse_freight_goods')
                                ->where('wafg_id', $wafg_id)
                                ->update(['wafg_lock_quantity'=>$surplus_quantity]);
                            // 仓库商品表仓位锁定库存调整
                            $wago_freight_lock_res = DB::table('warehouse_goods')
                                ->where('wago_id', $goo_value['digo_wago_id'])
                                ->where('wago_ware_id', $dis_data->dego_out_ware_id)
                                ->where('wago_class', $goo_value['digo_wago_class'])
                                ->decrement('wago_freight_lock_quantity', $goo_value['digo_goo_quantity']);
                            // 仓库良品锁定库存调整
                            $waon_stock_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                ->where('waon_class', $goo_value['digo_wago_class'])
                                ->decrement('waon_lock_fine_amount', $goo_value['digo_goo_quantity']);
                            // 仓库总库存数量调整
                            $waon_all_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                ->where('waon_class', $goo_value['digo_wago_class'])
                                ->decrement('waon_all_amount', $goo_value['digo_goo_quantity']);
                            // 仓位良品锁定库存调整
                            $wafr_lock_res = DB::table('warehouse_freight')
                                ->where('wafr_id', $warehouse_freight_goods[$wafg_id]->wafg_wafr_id)
                                ->where('wafr_ware_id', $dis_data->dego_out_ware_id)
                                ->decrement('wafr_lock_quantity', $goo_value['digo_goo_quantity']);
                            if (!$wafg_edit_res || !$wago_freight_lock_res || !$waon_stock_res || !$waon_all_res || !$wafr_lock_res) {
                                return ['code'=> 500, 'msg'=>'发货失败！', 'data'=>''];
                            }
                        } else {
                            // 优先库存
                            $surplus_quantity = $warehouse_freight_goods[$wafg_id]->wafg_priority_lock_quantity - $goo_value['digo_goo_quantity'];
                            if ($surplus_quantity < 0) {
                                return ['code'=>500, 'msg'=>'仓位商品库存锁定数量不足！', 'data'=>''];
                            }
                            // 更改仓位商品表商品库存数量
                            $wafg_edit_res = DB::table('warehouse_freight_goods')
                                ->where('wafg_id', $wafg_id)
                                ->update(['wafg_priority_lock_quantity'=>$surplus_quantity]);
                            // 仓库商品表仓位优先锁定库存调整
                            $wago_freight_lock_res = DB::table('warehouse_goods')
                                ->where('wago_id', $goo_value['digo_wago_id'])
                                ->where('wago_ware_id', $dis_data->dego_out_ware_id)
                                ->where('wago_class', $goo_value['digo_wago_class'])
                                ->decrement('wago_freight_priority_lock_quantity', $goo_value['digo_goo_quantity']);
                            // 仓库优先锁定库存调整
                            $waon_stock_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                ->where('waon_class', $goo_value['digo_wago_class'])
                                ->decrement('waon_lock_priority_amount', $goo_value['digo_goo_quantity']);
                            // 仓库总库存数量调整
                            $waon_all_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                ->where('waon_class', $goo_value['digo_wago_class'])
                                ->decrement('waon_all_amount', $goo_value['digo_goo_quantity']);
                            // 仓位良品锁定库存调整
                            $wafr_lock_res = DB::table('warehouse_freight')
                                ->where('wafr_id', $warehouse_freight_goods[$wafg_id]->wafg_wafr_id)
                                ->where('wafr_ware_id', $dis_data->dego_out_ware_id)
                                ->decrement('wafg_priority_lock_quantity', $goo_value['digo_goo_quantity']);
                            if (!$wafg_edit_res || !$wago_freight_lock_res || !$waon_stock_res || !$waon_all_res || !$wafr_lock_res) {
                                return ['code'=>500, 'msg'=>'发货失败！', 'data'=>''];
                            }
                        }
                    } else {
                        return ['code'=>500, 'msg'=>'仓位商品锁定数量不足！', 'data'=>''];
                    }
                }
            }
        }
        // 遍历仓库类型数据，处理固定仓库对应仓库类型的出入库记录
        foreach ($wago_class_goods as $waon_class_key => $class_goods_data) {
            // 查询仓库类别的进销存计算方式
            $goo_all_amount = 0;
            foreach ($class_goods_data as $goo_id_key => $value) {
                // 出入库记录需要的的商品数组
                $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_quantity'] = $value['digo_goo_quantity'];//出入库商品数量
                $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_inventory'] = $value['digo_goo_inventory'];//出入库商品类型，类型1良品2优先
                $goo_all_amount += $value['digo_goo_quantity'];

                // 出入库记录需要
                $oure_goods_id[$goo_id_key] = $value['digo_goo_id'];//出入库商品id
                $oure_goods_quantity[$goo_id_key] = $value['digo_goo_quantity'];//出入库商品数量
                $oure_goods_inventory[$goo_id_key] = $value['digo_goo_inventory'];//出入库商品类型，类型1良品2优先
            }

            $find_ware = DB::table('warehouse_onhand')
                ->where('waon_ware_id', '=', $dis_data->dego_out_ware_id)
                ->where('waon_class', $waon_class_key)
                ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                ->first();
            $oure_goods_data=$oure_goods_dataarray[$waon_class_key];
            $oure_class_goo_id = array_keys($oure_goods_data);
            $oure_res = OutinRecord::addition(
                $user_info,//用户信息
                $oure_original_correlation_id,//原始单的关联id
                $oure_original_correlation_number,//原始单的关联单号
                1,//原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                $oure_client_type,//买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                $oure_client_id,//选择的客户id,会员id/单位id
                $dis_data->dego_number,//原始单号，旧货回收单单号
                0,//入库仓库id
                $dis_data->dego_out_ware_id,//出库仓库id
                $goo_all_amount,//出库的商品总数量
                9,//类型 5.退换回收单 9发货单 11换货出库12换货入库13退货入库14退货出库
                2,//操作类型：1锁定库存2出库3入库4调货5发货
                $find_ware->waon_stock_fine_amount,//良品总库存
                $find_ware->waon_lock_fine_amount,//良品锁定数量
                $find_ware->waon_stock_priority_amount,//优先总库存
                $find_ware->waon_lock_priority_amount,//优先锁定数量
                $find_ware->waon_stock_unchecked_amount,//待检测总库存
                1, //出入库类型：1出库，2入库
                $waon_class_key,//仓库类别
                $oure_goods_id, //商品id
                $oure_goods_quantity, //商品数量
                $oure_goods_inventory, //出库类型1良品2优先
                $oure_class_goo_id //仓库类别下的商品id
            );
        }
        
        if ($update_send_res && $update_state && $ord_bill) {
            $change_suo = true;
        } else {
            $change_suo = false;
        }
    }
}
