<?php

namespace App\Http\Models\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
class CancelAccountSubject extends Model
{
    /**
     * 科目管理
     * @param  $user_info       array   用户信息
     * @param  $type            int     类型：1借2贷
     * @param  $money           int     金额
     * @param  $acti_id         int     科目id
     * @return boolean
     */
    public static function Subject($user_info,$type,$money,$acti_id)
    {
        $year = date('Y');//年
        $month = date('m');//月
        $time = date('Y-m-d H:i:s');//当前时间
        //判断是否有此科目
        $acc_info = DB::table('account_title')
                    ->where('acti_id',$acti_id)
                    ->first(['acti_course_title','acti_subject_code','acti_initial_count','acti_lend','acti_loan']);

        if (empty($acc_info)) {
            return false;
        }
        // 科目查询表
        $acse_info = DB::table('account_select')
                        ->where('acse_acti_id',$acti_id)
                        ->where('acse_year',$year)
                        ->where('acse_month',$month)
                        ->first(['acse_id','acse_initial_count','acse_lend','acse_loan']);
        $last_month = $month -1;
        //如果上个月是一月份
        if($last_month == 0){
            $last_month = 12;
            $last_year = $year - 1;
        }else{
            $last_year = $year;
        }
        //期末余额
        if(empty($acse_info)){
            //获取上个月期末余额
            $closing_account = DB::table('account_select')
                        ->where('acse_year',$last_year)
                        ->where('acse_month',$last_month)
                        ->where('acse_acti_id',$acti_id)
                        ->value('acse_closing_account');
            $select['acse_acti_id'] = $acti_id;//科目id
            $select['acti_adm_cid'] = $user_info->adm_cid;//公司id
            $select['acti_shop_id'] = $user_info->adm_shop_id;//门店id
            $select['acse_year'] = $year;//年份
            $select['acse_month'] = $month;//月份
            $select['acse_subject_code'] = $acc_info->acti_subject_code;//科目代码
            $select['acse_course_title'] = $acc_info->acti_course_title;//科目名称
            $select['acse_initial_count'] = $closing_account ? $closing_account :0;//期初余额
            if ($type == 1) {
                $select['acse_lend'] = $money;//借
                $select['acse_loan'] = 0;//贷
                $acse_closing_account = $closing_account - $money;//期末余额
            }else{
                $select['acse_lend'] = 0;//借
                $select['acse_loan'] = $money;//贷
                $acse_closing_account = $closing_account + $money;
            }
            $select['acse_closing_account'] = $acse_closing_account;//期末余额
            $select['acse_create_time'] = $time;//添加时间
            $res = DB::table('account_select')->insert($select);
            if (empty($res)) {
                return false;
            }
        }else{
            // 期末余额
            if ($type == 1) {
                $closing_account = $acse_info->acse_initial_count + $acse_info->acse_lend - $money - $acse_info->acse_loan;
                $data['acse_lend'] = $acse_info->acse_lend - $money;
                $data['acse_closing_account'] = $closing_account;
            }else{
                 $closing_account = $acse_info->acse_initial_count + $acse_info->acse_lend + $money - $acse_info->acse_loan;
                $data['acse_loan'] = $acse_info->acse_loan - $money;
                $data['acse_closing_account'] = $closing_account;
            }
            $data['acse_update_time'] = $time;
            $res = DB::table('account_select')
                        ->where('acse_id',$acse_info->acse_id)
                        ->update($data);
            if(empty($res)){
                return false;
            }
        }

        // 科目管理表
        if ($type == 1) {
            $acti_balance = $acc_info->acti_initial_count + $acc_info->acti_lend - $money - $acc_info->acti_loan;
            $acti_data['acti_lend'] = $acc_info->acti_lend - $money;
            $acti_data['acti_closing_account'] = $acti_balance;//期末余额
        }else{
            $acti_balance = $acc_info->acti_initial_count + $acc_info->acti_lend + $money - $acc_info->acti_loan;
            $acti_data['acti_loan'] = $acc_info->acti_loan - $money;
            $acti_data['acti_closing_account'] = $acti_balance;
        }
        $acti_data['acti_update_time'] = $time;
        $res = DB::table('account_title')
                    ->where('acti_id',$acti_id)
                    ->update($acti_data);
        if(empty($res)){
            return false;
        }
        return true;
    }
}
