<?php

namespace App\Http\Enum\Business;

use Illuminate\Database\Eloquent\Model;

class WorkOrderEnum
{
    // 工单类型：1门店工单2智配工单
    public $wor_work_type_enum = [
        ['state' => 1, 'state_show' => '门店工单'],
        ['state' => 2, 'state_show'=> '智配工单'],
    ];

    // 智配审核结果：1未审核2通过3驳回
    public $wor_other_audit_enum = [
        ['state' => 1, 'state_show' => '未审核'],
        ['state' => 2, 'state_show'=> '通过'],
        ['state' => 3, 'state_show'=> '驳回'],
    ];

    // 返回key=>value格式数据
    public function keyValueEnum($data)
    {
        return array_column($data, 'state_show', 'state');
    }
}
