<?php

namespace App\Http\Enum\Business;

use Illuminate\Database\Eloquent\Model;

// 订单表字段枚举数据
class TransferringOrdersEnum
{
    // 下单来源：1pc端2车主小程序3技师端4智配贴装
    public $trans_ord_status_enum = [
        ['state' => 1, 'state_show' => '待审核'],
        ['state' => 2, 'state_show' => '待出库'],
        ['state' => 3, 'state_show' => '待入库'],
        ['state' => 4, 'state_show' => '已入库'],
        ['state' => 5, 'state_show' => '已驳回'],
        ['state' => 6, 'state_show' => '已撤销'],
    ];

    // 返回key=>value格式数据
    public function keyValueEnum($ord_status)
    {
        return array_column($ord_status, 'state_show', 'state');
    }
}
