<?php
namespace App\Http\Controllers\WeChatApplet\Verify;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\Rule;
use Validator;

class VerifyLoginController extends Controller
{
    // 登录验证器
    public function loginValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'username.required' => '请输入手机号',
            // 'username.regex' => '手机号格式不正确',
            'password.required' => '请输入密码',//为给定属性指定自定义消息
            'js_code.required' => '请输入js_code',//为给定属性指定自定义消息
            'password.regex' => '密码由6-15位数字或字母,或下划线组成！',//为给定属性指定自定义消息
        ];

        // 数据验证
        $validator = Validator::make($data, [
            // 'username' => ['required','regex:/^1[3456789]\d{9}$/'],
            'password' => ['required','regex:/^[\w\_]{6,15}$/u'],
            // 'js_code' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 选择门店登录验证器
    public function switchShopLogin($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请输入手机号',
        ];

        // 数据验证
        $validator = Validator::make($data, [
             'shop_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 获取验证码验证器
    public function getCodeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_phone.required' => '请输入手机号',
            'adm_phone.regex' => '手机号格式不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_phone' => ['required', 'regex:/^1[3456789]\d{9}$/'],
        ], $messages);

        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 忘记密码提交验证器
    public function forgetPwdValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_phone.required' => '请输入手机号',
            'adm_phone.regex' => '手机号格式不正确',
            'code.required' => '请输入验证码',
            'code.numeric' => '请输入正确格式的验证码',
            'pwd.required' => '请输入密码',
            'pwd.regex' => '密码由6-15位数字或字母,或下划线组成！',
            'renew_pwd.required' => '请输入确认密码',
            'renew_pwd.same'=>'密码与确认密码不一致',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            'code' => 'required|numeric',
            'pwd' => ['required','regex:/^[\w\_]{6,15}$/u'],
            'renew_pwd'=>['required',"same:pwd"], //不为空,两次密码是否相同
        ], $messages);

        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
