<?php
namespace App\Http\Controllers\WeChatApplet\Verify\AppletWarehouseManage;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyAppletDispatchController extends Controller
{
    // 发货验证器
    public function shipmentsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dego_id.required' => '参数错误',
            'dego_id.integer' => '数据类型不正确',
            'dego_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dego_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dego_id.required' => '参数错误',
            'dego_id.integer' => '数据类型不正确',
            'dego_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dego_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
