<?php
namespace App\Http\Controllers\Api\Verify\Storage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyWareInorderController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 入库前验证器
    public function warehousingShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cg_number.required' => '参数错误',
            'cg_number.max' => '采购单号长度超过最大限制',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cg_number' => 'required|max:20',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 入库验证器
    public function warehousingValidator($data)
    {
        // 自定义错误消息
        $messages = [
            // 商品信息
            'goods.required' => '参数错误',
            'goods.json' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            // 基本信息
            'goods' => 'required|json',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
