<?php
namespace App\Http\Controllers\WeChatApplet\Verify\AppletStorage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyAppletWareInorderController extends Controller
{
    // 入库前验证器
    public function warehousingShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cg_number.required' => '参数错误',
            'cg_number.max' => '采购单号长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cg_number' => 'required|max:20',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 入库验证器
    public function warehousingValidator($data)
    {
        // 自定义错误消息
        $messages = [
            // 商品信息
            'goods.required' => '参数错误',
            'goods.json' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            // 基本信息
            'goods' => 'required|json',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
