<?php
namespace App\Http\Controllers\WeChatApplet\Verify\AppletOrderManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyAppletWorkOrderController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请填写工单id',
            'wor_id.integer' => '数据类型不正确',
            'wor_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 派单显示验证器
    public function assignShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请填写工单id',
            'wor_id.integer' => '数据类型不正确',
            'wor_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 派单验证器
    public function assignValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_service_adm_id.required' => '请选择服务技师',
            'wor_service_adm_id.integer' => '数据类型不正确',
            'wor_service_adm_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_service_adm_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 驳回
    public function rejectValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请填写工单id',
            'wor_id.integer' => '数据类型不正确',
            'wor_id.min' => '参数错误',
            'remark.required' => '请输入备注',
            'remark.min' => '参数错误',
            'remark.max' => '备注长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'remark' => 'required|min:1|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
