<?php
namespace App\Http\Controllers\WeChatApplet\Verify\AppletAccountManage;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyAppletOrderBillController extends Controller
{
    // 单量验证器
    public function billNumberValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'orbi_id.required' => '参数错误',
            'orbi_id.integer' => '数据类型不正确',
            'orbi_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'orbi_id' => 'required|integer|min:1',
            'type' => [
                'required',
                    Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 删除验证器
    public function delValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'orbi_id.required' => '参数错误',
            'orbi_id.integer' => '数据类型不正确',
            'orbi_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'orbi_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
