<?php

namespace App\Http\Controllers\WeChatApplet\User;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\WeChatApplet\User\UserShopService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;

// 用户小程序-门店列表
class UserShopController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new UserShopService();
        $this->bootWithService($service);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['ip'] = getRealIp($request);
        $log_record['request'] = $request->all();
		$log_record['time'] = date('Y-m-d H:i:s');
		$log_record['function'] = 'index';
		logFileRecord($log_record, 'wash/WashShop', 2);

        // $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->searchPage($request->all(), 1);

        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 详情
    public function info(Request $request)
    {
        // // 验证参数
        // $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        // if (!empty($error_message)) {
        //     return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        // }
        // 记录日志
        $log_record['request'] = $request->all();
		$log_record['time'] = date('Y-m-d H:i:s');
		$log_record['function'] = 'info';
		logFileRecord($log_record, 'wash/WashShop', 2);

        // 按技师类型查询
        $return_data = UserShopService::info($request->all());
        return response()->json($return_data);
    }

    public function getClassification(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getClassificationValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getClassification';
        logFileRecord($log_record, 'wash/WashShop', 2);

        // 首页获取分类
        $return_data = UserShopService::getClassification($request->all());
        if (empty($return_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        }
    }

    // 获取商品
    public function getGoods(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getGoodsValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getGoods';
        logFileRecord($log_record, 'wash/WashShop', 2);

        // 首页获取商品
        $return_data = UserShopService::getGoods($request->all(),$request['type'],10);
        if (empty($return_data)) {
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        }
    }

    // 获取会员卡
    public function getVip(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getVipValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getVip';
        logFileRecord($log_record, 'wash/WashShop', 2);

        // 首页获取商品
        $return_data = UserShopService::getVip($request->all(),$request['type'],10);
        if (empty($return_data)) {
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        }
    }

    // 获取推荐商品
    public function getRecommendGoods(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getRecommendGoodsValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 首页获取商品
        $return_data = UserShopService::getRecommendGoods($request->all(),$request['type'],10);
        if (empty($return_data)) {
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        }
    }

    // 获取公司信息
    public function companyProfile(Request $request)
    {
        // 首页获取商品
        $return_data = UserShopService::companyProfile($request->all());
        if (empty($return_data)) {
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        }
    }

    // 获取案例
    public function getOrderWork(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getOrderWorkValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        // 首页获取案例
        $return_data = UserShopService::getOrderWork($request->all(),$request['type'],10);
        if (empty($return_data)) {
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        }
    }

    // 商品详情
    public function goodsInfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->goodsInfoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $list_data = DB::table('package_items')
            ->where('pait_id', $request['pait_id'])
            ->select('pait_id', 'pait_state')
            ->first();
        // if ($list_data->pait_state == 2) {
        //     return $this->error('商品已下架', ErrorInc::INVALID_PARAM);
        // }
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $return_data = UserShopService::goodsInfo($request->all(),$user_info);
        if (empty($return_data)) {
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        }
    }

    // 会员卡详情
    public function vipCardInfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->vipCardInfoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        $list_data = DB::table('vip_card')
            ->where('vica_id', $request['vica_id'])
            ->select('vica_state', 'vica_id')
            ->first();
        if ($list_data->vica_state == 2) {
            return $this->error('商品已下架', ErrorInc::INVALID_PARAM);
        }
        $return_data = UserShopService::vipCardInfo($request->all());
        if (empty($return_data)) {
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        }
    }

    // 商品案例
    public function goodsOrderWork(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->goodsOrderWorkValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        $return_data = UserShopService::goodsOrderWork($request->all());
        if (empty($return_data)) {
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        }
    }

    // 数据验证
    public function dataValidation(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->dataValidationValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }

        $return_data = UserShopService::dataValidation($request->all());
        return response()->json($return_data);
    }

    /**
     * 积分商城
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-19
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function pointGoods(Request $request)
    {
        // // 验证参数
        // $error_message = $this->dataService->mainValidator->pointGoodsValidator($request->all());
        // if (!empty($error_message)) {
        //     return $this->error($error_message, ErrorInc::INVALID_PARAM);
        // }
        if (empty($request['show_count'])) {
            $request['show_count'] = 10;
        }
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $return_data = UserShopService::index($user_info,$request,$request['show_count']);
        if (empty($return_data)) {
            return $this->error('暂无数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        }
    }

    /**
     * 积分商品详情
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-09-19
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function pointGoodsInfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->pointGoodsInfoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $return_data = UserShopService::pointGoodsInfo($user_info,$request,$request['show_count']);
        if (empty($return_data)) {
            return response()->json(['code'=>200, 'msg'=>'暂无数据', 'data'=>$return_data]);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
        }
    }


    /**|---------------------------------------------------------------------------------
     * @name 获取可预约数量
     * @param string pait_id 套餐数据id
     * @param string day_time 套餐数据id
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2023/9/26 15:00
     * |---------------------------------------------------------------------------------
     */
    public function getAppointNum ( Request $request ){
        $error_message = $this->dataService->mainValidator->getAppointNumValidator($request->all());
        if (!empty($error_message)) {
            return $this->error($error_message, ErrorInc::INVALID_PARAM);
        }
        request()->offsetSet('rt', 'wechatWash');//微信用户信息
        $user_info = LoginUserService::getUser();
        $return_data = UserShopService::getAppointNum($user_info,$request);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }
}
