<?php

namespace App\Http\Controllers\WeChatApplet\User;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\BasicManagement\ProductionManageService;
use App\Services\BasicManagement\ProductionContentService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;

class ProductionManageController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new ProductionManageService();
        $this->contentService = new ProductionContentService();
        $this->bootWithService($service);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexUserValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'index';
        logFileRecord($log_record, 'wash/ProductionManage', 2);
        
        request()->offsetSet('state', 1);//状态1启用2停用
        // $user_info = LoginUserService::getUser();
        $user_info['adm_shop_id'] = $request['shop_id'];
        if (in_array($request['type'], [1, 2])) {
            // 作品管理数据表，作品分类，作品模块
            if ($request['type'] == 1) {
                $search_data = $this->dataService->searchPage((object)$user_info, $request->all(), 10);
            } else {
                if (empty($request['show_count'])) {
                    $request['show_count'] = 20;
                }
                $search_data = $this->dataService->searchPage((object)$user_info, $request->all(), $request['show_count']);
            }
        } else {
            // 类型：1作品分类2作品模块3视频4图文
            if ($request['type'] == '3') {
                $request['type'] = '1';//类型：1视频2图文
            } else if ($request['type'] == '4'){
                $request['type'] = '2';
            } else if ($request['type'] == '5'){
                $request['type'] = 0;
            }
            // 作品内容数据表，视频，图文
            $search_data = $this->contentService->searchPage((object)$user_info, $request->all(), $request['show_count']);
        }
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 详情
    public function info(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'info';
        logFileRecord($log_record, 'wash/ProductionManage', 2);
        
        // $user_info = LoginUserService::getUser();
        $user_info['adm_shop_id'] = $request['shop_id'];

        // 类型：1作品分类2作品模块3视频4图文
        // if ($request['type'] == '4'){
        //     $request['type'] = '2';
        // }
        $fields = ['prco_id', 'prco_content', 'prco_create_time as prma_create_time', 'prma_name', 'prco_path', 'prco_type', 'prco_covor'];
        // 作品内容数据表，视频，图文
        $search_data = $this->contentService->getFieldsById((object)$user_info, $request->all(), $fields);
        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }
}
