<?php

namespace App\Http\Controllers\WeChatApplet\User;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\Business\EvaluatePartService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;

// 用户评价
class EvaluatePartController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new EvaluatePartService();
        $this->bootWithService($service);
    }

    // 评价列表
    public function index(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->indexValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'index';
        logFileRecord($log_record, 'user/EvaluatePart', 2);


        // $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->searchPage($request->all(), 10);

        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 新增订单评价
    public function add(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->addValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'add';
        logFileRecord($log_record, 'user/EvaluatePart', 2);

        // 评价
        $return_data = EvaluatePartService::add($request->all());
        return response()->json($return_data);
    }
}
