<?php

namespace App\Http\Controllers\WeChatApplet\Technician;

use Illuminate\Http\Request;
use BlueCity\Core\Controllers\MountingCoreController as Controller;
use BlueCity\Core\Traits\ResourceControllerMethod;
use App\Services\Business\WashServiceService;
use App\Services\Business\WashOrderService;
use BlueCity\Core\Inc\ErrorInc;
use App\Services\LoginUserService;
use App\Models\OperationLog;
use Illuminate\Support\Facades\DB;

// 技师小程序合作商服务
class WashServiceController extends Controller
{
    public $dataService = null;

    public function __construct()
    {
        $this->dataService = $service = new WashServiceService();
        $this->orderdataService = $orderservice = new WashOrderService();
        $this->bootWithService($service);
    }

    // 服务列表
    public function index(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'index';
        logFileRecord($log_record, 'wash/WashService', 2);

        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->searchPage($user_info, $request->all(), 10);

        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    // 待派单
    public function dispatchList(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'dispatchList';
        logFileRecord($log_record, 'wash/WashWork', 2);
        // 验证参数
        $error_message = $this->dataService->mainValidator->dispatchListValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        $search_data = $this->dataService->dispatchList($user_info, $request->all());

        if (empty($search_data)) {
            return $this->error('未找到数据', ErrorInc::DATA_EMPTY);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$search_data]);
        }
    }

    public function orderInfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->orderInfoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'orderInfo';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashWorkService::orderInfo($user_info, $request->all());
        return response()->json($return_data);
    }


    // 详情
    public function info(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'info';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashWorkService::info($user_info, $request->all());
        return response()->json($return_data);
    }

    // 拒单
    public function refuse(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'refuse';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $return_data = WashWorkService::refuse($user_info, $request->all());
        if ($return_data['code'] != 200) {
            return response()->json($return_data);
        }
        // 生成操作记录
        $orlo_res = orderLog($user_info, 0, $request['wor_id'], '技师拒单');
        if ($request['remark']) {
            // 添加备注
            $orre_res = orderRemark($user_info, 0, $request['wor_id'], $request['remark'], '技师拒单');
        } else {
            $orre_res = true;
        }
        if ($orlo_res && $orre_res) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '工单列表小程序', '技师拒单', $return_data['data']['wor_number'] . '拒单成功');
        } else {
            DB::rollBack();
        }
        return response()->json($return_data);
    }

    // 验车
    public function validateCar(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->validateCarValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'validateCar';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        if ($request['type'] == '1' || $request['type'] == '3') {
            // 查看验车结果
            $return_data = WashWorkService::validateCar($user_info, $request->all());
            if ($return_data['code'] != 200) {
                DB::rollBack();
            } else {
                DB::commit();
            }
            return response()->json($return_data);
        }

        // 提交订单编辑数据
        $return_data = WashWorkService::validateCar($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }
        // 生成操作记录
        $orlo_res = orderLog($user_info, $return_data['data']['wor_order_id'], $request['wor_id'], '技师验车');
        // 工单信息
        $find_wor_data = DB::table('work_order as wo')
            ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
            ->leftJoin('order as o', 'wo.wor_order_id', '=', 'o.ord_id')
            ->where('wor_id', $request['wor_id'])
            ->select('wocl_client_id', 'wor_shop_id', 'wor_order_id', 'ord_order_number', 'wocl_car_num')
            ->first();
        // 客户小程序-微信用户id
        $weus_id = DB::table('user_shop')
            ->where('ussh_shop_id', $find_wor_data->wor_shop_id)
            ->where('ussh_user_id', $find_wor_data->wocl_client_id)
            ->value('ussh_weus_id');

        if ($weus_id) {
            // 添加客户消息
            $add_data['weus_id'] = $weus_id;
            $add_data['shop_id'] = $find_wor_data->wor_shop_id;
            $add_data['primary_id'] = $find_wor_data->wor_order_id;//单据的主键id
            $add_data['primary_type'] = 1;//单据类型：1订单2工单3预约单4售后单
            $add_data['read_state'] = 1;//阅读状态：1未读2已读
            $add_data['title'] = '验车确认通知';//消息标题
            $add_data['content'] = '您的爱车（'.$find_wor_data->wocl_car_num.'）已完成验车，请您签字确认';//操作内容
            $add_data['create_adm_name'] = $user_info->adm_name;//操作人姓名
            $add_data['create_adm_id'] = $user_info->adm_id;//操作人id
            $addUserMessage_res = addUserMessage($add_data);
            unset($add_data);
        } else {
            $addUserMessage_res['code'] = 200;
        }
        if ($orlo_res && $addUserMessage_res['code'] == 200) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '工单列表', '技师验车', $return_data['data']['wor_number'] . '验车成功');
            return $this->success('验车成功');
        } else {
            DB::rollBack();
            return $this->error('验车失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 工单签字
    public function signatureSubmit(Request $request)
    {
         // 验证参数
        $error_message = $this->dataService->mainValidator->signatureSubmitValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'validateCar';
        logFileRecord($log_record, 'wash/WashWork', 2);
    }

    // 施工-开始施工
    public function construction(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'construction';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $return_data = WashWorkService::construction($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }

        // // 工单信息
        // $find_wor_data = DB::table('work_order as wo')
        //     ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
        //     ->leftJoin('order as o', 'wo.wor_order_id', '=', 'o.ord_id')
        //     ->where('wor_id', $request['wor_id'])
        //     ->select('wocl_client_id', 'wor_shop_id', 'wor_order_id', 'ord_order_number')
        //     ->first();
        // // 客户小程序-微信用户id
        // $weus_id = DB::table('user_shop')
        //     ->where('ussh_shop_id', $find_wor_data->wor_shop_id)
        //     ->where('ussh_user_id', $find_wor_data->wocl_client_id)
        //     ->value('ussh_weus_id');

        // if ($weus_id) {
        //     // 添加客户消息
        //     $add_data['weus_id'] = $weus_id;
        //     $add_data['shop_id'] = $find_wor_data->wor_shop_id;
        //     $add_data['primary_id'] = $find_wor_data->wor_order_id;//单据的主键id
        //     $add_data['primary_type'] = 1;//单据类型：1订单2工单3预约单4售后单
        //     $add_data['read_state'] = 1;//阅读状态：1未读2已读
        //     $add_data['content'] = '您的订单：'.$find_wor_data->ord_order_number.'工单开始施工,操作人：'.$user_info->adm_name;//操作内容
        //     $add_data['create_adm_name'] = $user_info->adm_name;//操作人姓名
        //     $add_data['create_adm_id'] = $user_info->adm_id;//操作人id
        //     $addUserMessage_res = addUserMessage($add_data);
        //     unset($add_data);
        // } else {
        //     $addUserMessage_res['code'] = 200;
        // }
        // 生成操作记录
        $orlo_res = orderLog($user_info, 0, $request['wor_id'], '开始施工');
        if ($orlo_res/* && $addUserMessage_res['code'] == 200*/) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '工单列表', '开始施工', $return_data['data']['wor_number'] . '开始施工成功');
            return $this->success('开始施工成功');
        } else {
            DB::rollBack();
            return $this->error('开始施工失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 施工-施工单信息
    public function constructionInfo(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'constructionInfo';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();

        $return_data = WashWorkService::constructionInfo($user_info, $request->all());
        return response()->json($return_data);
    }

    // 施工-完成提交工单
    public function accomplish(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->infoValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        if ($request['type'] == 1) {
            $find_data = DB::table('wash_work_items as woit')
                ->leftJoin('service_project as sepr', 'sepr.sepr_id', '=', 'woit.woit_sepr_id')
                ->where('woit_wor_id', $request['wor_id'])
                ->value('sepr_pic_conf');
            $wotp_service_start_time = DB::table('wash_work_technician_part')
                ->where('wotp_wor_id', $request['wor_id'])
                ->where('wotp_service_adm_id', $user_info->adm_id)
                ->value('wotp_service_start_time');
            $data['sepr_pic_conf'] = $find_data;
            $data['wotp_service_start_time'] = $wotp_service_start_time;
            $goo_data = DB::table('work_good as wogo')
                ->leftJoin('goods as g', 'g.goo_id', '=', 'wogo.wogo_goo_id')
                ->where('wogo_wor_id', $request['wor_id'])
                ->select('wogo_goo_unit', 'wogo_goo_unta_id', 'wogo_goo_amount', 'goo_unit_conversion', 'wogo_goo_id')
                ->first();
            if ($goo_data) {
                $goo_data->wogo_goo_amounts = $goo_data->wogo_goo_amount;
                $goo_data->wogo_goo_amount = $goo_data->wogo_goo_amount.$goo_data->wogo_goo_unit;
            }
            $data['goo_data'] = $goo_data;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
        }
        // 验证参数
        $error_message = $this->dataService->mainValidator->accomplishValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'accomplish';
        logFileRecord($log_record, 'wash/WashWork', 2);

        DB::beginTransaction();
        $return_data = WashWorkService::accomplish($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }
        // 工单信息
        $find_wor_data = DB::table('work_order as wo')
            ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
            ->leftJoin('order as o', 'wo.wor_order_id', '=', 'o.ord_id')
            ->where('wor_id', $request['wor_id'])
            ->select('wocl_client_id', 'wor_shop_id', 'wor_order_id', 'ord_order_number')
            ->first();
        // 客户小程序-微信用户id
        $weus_id = DB::table('user_shop')
            ->where('ussh_shop_id', $find_wor_data->wor_shop_id)
            ->where('ussh_user_id', $find_wor_data->wocl_client_id)
            ->value('ussh_weus_id');
        if ($weus_id) {
            // 添加客户消息
            $add_data['weus_id'] = $weus_id;
            $add_data['shop_id'] = $find_wor_data->wor_shop_id;
            $add_data['primary_id'] = $find_wor_data->wor_order_id;//单据的主键id
            $add_data['primary_type'] = 1;//单据类型：1订单2工单3预约单4售后单
            $add_data['title'] = '施工完成通知';//单据类型：1订单2工单3预约单4售后单
            $add_data['read_state'] = 1;//阅读状态：1未读2已读
            $add_data['content'] = '您的爱车（'.$return_data['data']['wocl_car_num'].'）已服务完成，请您为我们的服务做出评价';//操作内容
            // $add_data['content'] = '您的订单：'.$find_wor_data->ord_order_number.'工单审核成功,审核人：'.$user_info->adm_name;//操作内容
            $add_data['create_adm_name'] = $user_info->adm_name;//操作人姓名
            $add_data['create_adm_id'] = $user_info->adm_id;//操作人id
            $addUserMessage_res = addUserMessage($add_data);
            unset($add_data);
        } else {
            $addUserMessage_res['code'] = 200;
        }

        // 生成操作记录
        $orlo_res = orderLog($user_info, 0, $request['wor_id'], '完成提交');
        if ($orlo_res) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '工单列表', '完成提交', $return_data['data']['wor_number'] . '完成提交成功');
            return $this->success('完成提交成功');
        } else {
            DB::rollBack();
            return $this->error('完成提交失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 提交施工
    public function submitConstruction(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->submitConstructionValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'submitConstruction';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();
        if ($request['type'] == 1) {
            $find_data = DB::table('wash_work_check_history')
                ->where('woch_adm_id', $user_info->adm_id)
                ->where('woch_wor_id', $request['wor_id'])
                ->where('woch_check_res', 3)
                ->select('woch_part_data', 'woch_check_res', 'woch_check', 'woch_wor_id', 'woch_adm_id')
                ->orderBy('woch_create_time', 'desc')
                ->first();
            $wor_service_adm_id = DB::table('work_order')
                ->where('wor_id', $request['wor_id'])
                ->value('wor_service_adm_id');
            if ($wor_service_adm_id == $user_info->adm_id) {
                $find_data = DB::table('wash_work_check_history')
                    ->where('woch_adm_id', $user_info->adm_id)
                    ->where('woch_wor_id', $request['wor_id'])
                    ->where('woch_check_res', 2)
                    ->select('woch_part_data', 'woch_check_res', 'woch_check', 'woch_wor_id', 'woch_adm_id')
                    ->orderBy('woch_create_time', 'desc')
                    ->first();
            }
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_data]);
        }

        DB::beginTransaction();
        $return_data = WashWorkService::submitConstruction($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }
        // 生成操作记录
        $orlo_res = orderLog($user_info, 0, $request['wor_id'], '提交施工');
        if ($orlo_res) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '工单列表', '提交施工', $request['wor_number'] . '提交施工成功');
            return $this->success('提交施工成功');
        } else {
            DB::rollBack();
            return $this->error('提交施工失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 质检
    public function qualityTesting(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->qualityTestingValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'qualityTesting';
        logFileRecord($log_record, 'wash/WashWork', 2);
        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $return_data = WashWorkService::qualityTesting($user_info, $request->all());
        if ($request['type'] == 1 || $request['type'] == 3) {
            return response()->json($return_data);
        }
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }
        // 生成操作记录
        $orlo_res = orderLog($user_info, 0, $request['wor_id'], '质检');
        if ($orlo_res) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '工单列表', '质检', '质检成功');
            return $this->success('质检成功');
        } else {
            DB::rollBack();
            return $this->error('质检失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 生成工单
    public function createWork(Request $request)
    {
        // 验证参数
        $error_message = $this->orderdataService->mainValidator->editShowValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'createWork';
        logFileRecord($log_record, 'wash/WashWork', 2);
        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        // 获取生成订单数据
        if ($request['type'] == 1) {
            $return_data = WashOrderService::editShow($user_info, $request->all());
            return response()->json($return_data);
        }

        DB::beginTransaction();
        request()->offsetSet('ord_service_type', 1);
        // 生成工单
        $order_data = WashOrderService::createWork($user_info, $request->all());
        if ($order_data['code'] != 200) {
            DB::rollBack();
            return response()->json($order_data);
        }
        $find_wor_data = DB::table('work_order')
            ->where('wor_id', $order_data['data']['wor_id'])
            ->select('wor_service_adm_id')
            ->first();
        // 添加技师消息
        $add_data['adm_id'] = $find_wor_data->wor_service_adm_id;
        $add_data['shop_id'] = $user_info->adm_shop_id;
        $add_data['primary_id'] = $order_data['data']['wor_id']; //单据的主键id
        $add_data['primary_type'] = 2; //单据类型：1订单2工单3预约单4售后单
        $add_data['message_type'] = 1;
        // $add_data['message_type'] = $data['message_type'];
        $add_data['title'] = '派单通知'; //操作内容
        $add_data['content'] = '您有新的工单，请及时处理'; //操作内容
        $add_data['read_state'] = 1; //阅读状态：1未读2已读
        $add_data['create_adm_name'] = $user_info->adm_name; //操作人姓名
        $add_data['create_adm_id'] = $user_info->adm_id; //操作人id
        $addAdminMessage_res = addAdminMessage($add_data);
        if ($addAdminMessage_res['code'] != 200) {
            DB::rollBack();
            return response()->json($addAdminMessage_res);
        }
        // 生成操作记录
        $orlo_res = orderLog($user_info, $request['ord_id'], 0, '生成工单');
        if ($orlo_res) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '生成工单', '生成工单' . $order_data['data']['wor_order_number'] . '成功');
            return $this->success('生成工单成功');
        } else {
            DB::rollBack();
            return $this->error('生成工单失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 工单-重新派单
    public function assign(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->assignValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'assign';
        logFileRecord($log_record, 'wash/WashWork', 2);
        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        DB::beginTransaction();
        request()->offsetSet('wor_service_adm_id', $request['adm_id']);
        // 提交重新派单数据
        $return_data = WashWorkService::assign($user_info, $request->all());
        if ($return_data['code'] == 500) {
            return $return_data;
        }
        if ($return_data['code'] == 200) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '工单列表', '重新派单', '重新派单成功');
            return $this->success('重新派单成功');
        } else {
            DB::rollBack();
            return $this->error('重新派单失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 接单提交
    public function receiveSubmit(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->receiveSubmitValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'receiveSubmit';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $return_data = WashWorkService::receiveSubmit($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }

        // 生成操作记录
        $orlo_res = orderLog($user_info, 0, $request['wor_id'], '接单');
        if ($orlo_res) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '工单列表', '接单', $return_data['data']['wor_number'] . '接单成功');
            return $this->success('接单成功');
        } else {
            DB::rollBack();
            return $this->error('接单失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 预约时间设置
    public function appointmentSet(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->appointmentSetValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'appointmentSet';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        request()->offsetSet('ip', getRealIp($request));
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $return_data = $this->dataService->appointmentSet($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }

        // 生成操作记录
        $orlo_res = orderLog($user_info, $return_data['data']['wor_order_id'], $request['wor_id'], '技师预约');
        // 预约备注内容
        $remark_data = '预约时间：' . $request['appoint_time'];
        if (isset($request['appoint_remark']) && !empty($request['appoint_remark'])) {
            $remark_data .= ' ' . $request['appoint_remark'];
        }
        $orre_res = orderRemark($user_info, $return_data['data']['wor_order_id'], $request['wor_id'], $remark_data, '工单列表-技师预约');
        // 工单信息
        $find_wor_data = DB::table('work_order as wo')
            ->leftJoin('work_client as wc', 'wo.wor_id', '=', 'wc.wocl_wor_id')
            ->leftJoin('order as o', 'wo.wor_order_id', '=', 'o.ord_id')
            ->where('wor_id', $request['wor_id'])
            ->select('wocl_client_id', 'wor_shop_id', 'wor_order_id', 'ord_order_number')
            ->first();
        // 客户小程序-微信用户id
        $weus_id = DB::table('user_shop')
            ->where('ussh_shop_id', $find_wor_data->wor_shop_id)
            ->where('ussh_user_id', $find_wor_data->wocl_client_id)
            ->value('ussh_weus_id');

        // if ($weus_id) {
        //     // 添加客户消息
        //     $add_data['weus_id'] = $weus_id;
        //     $add_data['shop_id'] = $find_wor_data->wor_shop_id;
        //     $add_data['primary_id'] = $find_wor_data->wor_order_id;//单据的主键id
        //     $add_data['primary_type'] = 1;//单据类型：1订单2工单3预约单4售后单
        //     $add_data['read_state'] = 1;//阅读状态：1未读2已读
        //     $add_data['content'] = '您的订单：'.$find_wor_data->ord_order_number.'工单预约成功,操作人：'.$user_info->adm_name;//操作内容
        //     $add_data['create_adm_name'] = $user_info->adm_name;//操作人姓名
        //     $add_data['create_adm_id'] = $user_info->adm_id;//操作人id
        //     $addUserMessage_res = addUserMessage($add_data);
        //     unset($add_data);
        // } else {
        //     $addUserMessage_res['code'] = 200;
        // }

        if ($orlo_res && $orre_res/* && $addUserMessage_res['code'] == 200*/) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '工单列表', '预约', $return_data['data']['wor_number'] . '预约成功');
            return $this->success('预约成功');
        } else {
            DB::rollBack();
            return $this->error('预约失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 待派订单修改预约时间
    public function appointmentOrderSet(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->appointmentOrderSetValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'appointmentOrderSet';
        logFileRecord($log_record, 'wash/WashWork', 2);

        // 获取用户信息
        request()->offsetSet('rt', 'wechat');
        $user_info = LoginUserService::getUser();

        DB::beginTransaction();
        $return_data = $this->dataService->appointmentOrderSet($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }

        // 生成操作记录
        $orlo_res = orderLog($user_info, $request['ord_id'], 0, '订单修改预约时间');
        // 预约备注内容
        $remark_data = '预约时间：' . $request['appoint_time'];
        if (isset($request['appoint_remark']) && !empty($request['appoint_remark'])) {
            $remark_data .= ' ' . $request['appoint_remark'];
        }
        $orre_res = orderRemark($user_info, $request['ord_id'], 0, $remark_data, '订单列表-修改预约时间');
        // 订单单信息
        $find_order_data = DB::table('order as o')
            ->leftJoin('order_client as oc', 'o.ord_id', '=', 'oc.orcl_ord_id')
            ->where('ord_id', $request['ord_id'])
            ->select('orcl_client_id', 'ord_shop_id', 'ord_id', 'ord_order_number')
            ->first();
        // 客户小程序-微信用户id
        $weus_id = DB::table('user_shop')
            ->where('ussh_shop_id', $find_order_data->ord_shop_id)
            ->where('ussh_user_id', $find_order_data->orcl_client_id)
            ->value('ussh_weus_id');

        // if ($weus_id) {
        //     // 添加客户消息
        //     $add_data['weus_id'] = $weus_id;
        //     $add_data['shop_id'] = $find_order_data->ord_shop_id;
        //     $add_data['primary_id'] = $find_order_data->ord_id;//单据的主键id
        //     $add_data['primary_type'] = 1;//单据类型：1订单2工单3预约单4售后单
        //     $add_data['read_state'] = 1;//阅读状态：1未读2已读
        //     $add_data['content'] = '您的订单：'.$find_order_data->ord_order_number.'订单预约时间修改成功,操作人：'.$user_info->adm_name;//操作内容
        //     $add_data['create_adm_name'] = $user_info->adm_name;//操作人姓名
        //     $add_data['create_adm_id'] = $user_info->adm_id;//操作人id
        //     $addUserMessage_res = addUserMessage($add_data);
        //     unset($add_data);
        // } else {
        //     $addUserMessage_res['code'] = 200;
        // }

        if ($orlo_res && $orre_res/* && $addUserMessage_res['code'] == 200*/) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '订单列表', '预约', $find_order_data->ord_order_number . '预约修改成功');
            return $this->success('预约修改成功');
        } else {
            DB::rollBack();
            return $this->error('预约修改失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 工单历史
    public function getWorkHistory(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->getWorkHistoryValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getWorkHistory';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashWorkService::getWorkHistory($user_info, $request->all());
        return response()->json($return_data);
    }

    // 编辑技师
    public function editTechnician(Request $request)
    {
        // 验证参数
        $error_message = $this->dataService->mainValidator->editTechnicianValidator($request->all());
        if (!empty($error_message)) {
            return $this->error('请求参数错误！', ErrorInc::INVALID_PARAM, $error_message);
        }

        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'editTechnician';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashWorkService::editTechnician($user_info, $request->all());
        if ($return_data['code'] != 200) {
            DB::rollBack();
            return response()->json($return_data);
        }

        // 生成操作记录
        $orlo_res = orderLog($user_info, 0, $request['wor_id'], '修改技师');
        if ($orlo_res) {
            DB::commit();
            OperationLog::addLog($user_info, getRealIp($request), '工单列表', '修改技师', '修改技师成功');
            return $this->success('修改技师成功');
        } else {
            DB::rollBack();
            return $this->error('修改技师失败', ErrorInc::MYSQL_FAILED);
        }
    }

    // 获取工单状态数量
    public function getMessage(Request $request)
    {
        // 记录日志
        $log_record['request'] = $request->all();
        $log_record['time'] = date('Y-m-d H:i:s');
        $log_record['function'] = 'getMessage';
        logFileRecord($log_record, 'wash/WashWork', 2);

        request()->offsetSet('rt', 'wechat');
        // 获取用户信息
        $user_info = LoginUserService::getUser();
        $return_data = WashWorkService::getMessage($user_info, $request->all());
        return response()->json($return_data);
    }
}
